/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.graphics.Rect;
import android.os.StrictMode;
import android.view.SurfaceControl;
import com.android.server.wm.RemoteEventTrace;
import com.android.server.wm.WindowManagerService;
import com.android.server.wm.WindowState;
import java.io.DataOutputStream;
import java.io.FileDescriptor;
import java.io.FileOutputStream;

class RemoteSurfaceTrace
extends SurfaceControl {
    static final String TAG = "RemoteSurfaceTrace";
    final FileDescriptor mWriteFd;
    final DataOutputStream mOut;
    final WindowManagerService mService;
    final WindowState mWindow;

    RemoteSurfaceTrace(FileDescriptor fd, SurfaceControl wrapped, WindowState window) {
        super(wrapped);
        this.mWriteFd = fd;
        this.mOut = new DataOutputStream(new FileOutputStream(fd, false));
        this.mWindow = window;
        this.mService = this.mWindow.mService;
    }

    @Override
    public void setAlpha(float alpha) {
        StrictMode.ThreadPolicy oldPolicy = StrictMode.allowThreadDiskWrites();
        try {
            this.writeFloatEvent("Alpha", alpha);
        }
        finally {
            StrictMode.setThreadPolicy(oldPolicy);
        }
        super.setAlpha(alpha);
    }

    @Override
    public void setLayer(int zorder) {
        StrictMode.ThreadPolicy oldPolicy = StrictMode.allowThreadDiskWrites();
        try {
            this.writeIntEvent("Layer", zorder);
        }
        finally {
            StrictMode.setThreadPolicy(oldPolicy);
        }
        super.setLayer(zorder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPosition(float x, float y) {
        StrictMode.ThreadPolicy oldPolicy = StrictMode.allowThreadDiskWrites();
        try {
            this.writeFloatEvent("Position", x, y);
        }
        finally {
            StrictMode.setThreadPolicy(oldPolicy);
        }
        super.setPosition(x, y);
    }

    @Override
    public void setGeometryAppliesWithResize() {
        StrictMode.ThreadPolicy oldPolicy = StrictMode.allowThreadDiskWrites();
        try {
            this.writeEvent("GeometryAppliesWithResize");
        }
        finally {
            StrictMode.setThreadPolicy(oldPolicy);
        }
        super.setGeometryAppliesWithResize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSize(int w, int h) {
        StrictMode.ThreadPolicy oldPolicy = StrictMode.allowThreadDiskWrites();
        try {
            this.writeIntEvent("Size", w, h);
        }
        finally {
            StrictMode.setThreadPolicy(oldPolicy);
        }
        super.setSize(w, h);
    }

    @Override
    public void setWindowCrop(Rect crop) {
        StrictMode.ThreadPolicy oldPolicy = StrictMode.allowThreadDiskWrites();
        try {
            this.writeRectEvent("Crop", crop);
        }
        finally {
            StrictMode.setThreadPolicy(oldPolicy);
        }
        super.setWindowCrop(crop);
    }

    @Override
    public void setFinalCrop(Rect crop) {
        StrictMode.ThreadPolicy oldPolicy = StrictMode.allowThreadDiskWrites();
        try {
            this.writeRectEvent("FinalCrop", crop);
        }
        finally {
            StrictMode.setThreadPolicy(oldPolicy);
        }
        super.setFinalCrop(crop);
    }

    @Override
    public void setLayerStack(int layerStack) {
        StrictMode.ThreadPolicy oldPolicy = StrictMode.allowThreadDiskWrites();
        try {
            this.writeIntEvent("LayerStack", layerStack);
        }
        finally {
            StrictMode.setThreadPolicy(oldPolicy);
        }
        super.setLayerStack(layerStack);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMatrix(float dsdx, float dtdx, float dsdy, float dtdy) {
        StrictMode.ThreadPolicy oldPolicy = StrictMode.allowThreadDiskWrites();
        try {
            this.writeFloatEvent("Matrix", dsdx, dtdx, dsdy, dtdy);
        }
        finally {
            StrictMode.setThreadPolicy(oldPolicy);
        }
        super.setMatrix(dsdx, dtdx, dsdy, dtdy);
    }

    @Override
    public void hide() {
        StrictMode.ThreadPolicy oldPolicy = StrictMode.allowThreadDiskWrites();
        try {
            this.writeEvent("Hide");
        }
        finally {
            StrictMode.setThreadPolicy(oldPolicy);
        }
        super.hide();
    }

    @Override
    public void show() {
        StrictMode.ThreadPolicy oldPolicy = StrictMode.allowThreadDiskWrites();
        try {
            this.writeEvent("Show");
        }
        finally {
            StrictMode.setThreadPolicy(oldPolicy);
        }
        super.show();
    }

    private void writeEvent(String tag) {
        try {
            this.mOut.writeUTF(tag);
            this.mOut.writeUTF(this.mWindow.getWindowTag().toString());
            this.writeSigil();
        }
        catch (Exception e) {
            RemoteEventTrace.logException(e);
            this.mService.disableSurfaceTrace();
        }
    }

    private void writeIntEvent(String tag, int ... values) {
        try {
            this.mOut.writeUTF(tag);
            this.mOut.writeUTF(this.mWindow.getWindowTag().toString());
            for (int value : values) {
                this.mOut.writeInt(value);
            }
            this.writeSigil();
        }
        catch (Exception e) {
            RemoteEventTrace.logException(e);
            this.mService.disableSurfaceTrace();
        }
    }

    private void writeFloatEvent(String tag, float ... values) {
        try {
            this.mOut.writeUTF(tag);
            this.mOut.writeUTF(this.mWindow.getWindowTag().toString());
            for (float value : values) {
                this.mOut.writeFloat(value);
            }
            this.writeSigil();
        }
        catch (Exception e) {
            RemoteEventTrace.logException(e);
            this.mService.disableSurfaceTrace();
        }
    }

    private void writeRectEvent(String tag, Rect value) {
        this.writeFloatEvent(tag, value.left, value.top, value.right, value.bottom);
    }

    private void writeSigil() throws Exception {
        this.mOut.write(RemoteEventTrace.sigil, 0, 4);
    }
}

