/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.util.Slog;
import android.util.proto.ProtoOutputStream;
import android.view.SurfaceControl;
import com.android.internal.annotations.VisibleForTesting;
import com.android.server.wm.AnimationAdapter;
import com.android.server.wm.WindowHashMap;
import com.android.server.wm.WindowManagerService;
import java.io.PrintWriter;
import java.util.function.Consumer;

class SurfaceAnimator {
    private static final String TAG = "WindowManager";
    private final WindowManagerService mService;
    private AnimationAdapter mAnimation;
    @VisibleForTesting
    SurfaceControl mLeash;
    private final Animatable mAnimatable;
    private final OnAnimationFinishedCallback mInnerAnimationFinishedCallback;
    @VisibleForTesting
    final Runnable mAnimationFinishedCallback;
    private boolean mAnimationStartDelayed;

    SurfaceAnimator(Animatable animatable, Runnable animationFinishedCallback, Consumer<Runnable> addAfterPrepareSurfaces, WindowManagerService service) {
        this.mAnimatable = animatable;
        this.mService = service;
        this.mAnimationFinishedCallback = animationFinishedCallback;
        this.mInnerAnimationFinishedCallback = this.getFinishedCallback(animationFinishedCallback, addAfterPrepareSurfaces);
    }

    private OnAnimationFinishedCallback getFinishedCallback(Runnable animationFinishedCallback, Consumer<Runnable> addAfterPrepareSurfaces) {
        return anim2 -> {
            block4: {
                WindowHashMap windowHashMap = this.mService.mWindowMap;
                // MONITORENTER : windowHashMap
                try {
                    WindowManagerService.boostPriorityForLockedSection();
                    SurfaceAnimator target = this.mService.mAnimationTransferMap.remove(anim2);
                    if (target == null) break block4;
                    target.mInnerAnimationFinishedCallback.onAnimationFinished(anim2);
                    // MONITOREXIT : windowHashMap
                }
                catch (Throwable throwable) {
                    // MONITOREXIT : windowHashMap
                    WindowManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
                WindowManagerService.resetPriorityAfterLockedSection();
                return;
            }
            addAfterPrepareSurfaces.accept(() -> {
                if (anim2 != this.mAnimation) {
                    return;
                }
                SurfaceControl.Transaction t = new SurfaceControl.Transaction();
                SurfaceControl.openTransaction();
                try {
                    this.reset(t, true);
                    if (animationFinishedCallback != null) {
                        animationFinishedCallback.run();
                    }
                }
                finally {
                    SurfaceControl.mergeToGlobalTransaction(t);
                    SurfaceControl.closeTransaction();
                }
            });
            // MONITOREXIT : windowHashMap
            WindowManagerService.resetPriorityAfterLockedSection();
        };
    }

    void startAnimation(SurfaceControl.Transaction t, AnimationAdapter anim2, boolean hidden) {
        this.cancelAnimation(t, true, true);
        this.mAnimation = anim2;
        SurfaceControl surface = this.mAnimatable.getSurfaceControl();
        if (surface == null) {
            Slog.w(TAG, "Unable to start animation, surface is null or no children.");
            this.cancelAnimation();
            return;
        }
        this.mLeash = this.createAnimationLeash(surface, t, this.mAnimatable.getSurfaceWidth(), this.mAnimatable.getSurfaceHeight(), hidden);
        this.mAnimatable.onAnimationLeashCreated(t, this.mLeash);
        if (this.mAnimationStartDelayed) {
            return;
        }
        this.mAnimation.startAnimation(this.mLeash, t, this.mInnerAnimationFinishedCallback);
    }

    void startDelayingAnimationStart() {
        if (!this.isAnimating()) {
            this.mAnimationStartDelayed = true;
        }
    }

    void endDelayingAnimationStart() {
        boolean delayed = this.mAnimationStartDelayed;
        this.mAnimationStartDelayed = false;
        if (delayed && this.mAnimation != null) {
            this.mAnimation.startAnimation(this.mLeash, this.mAnimatable.getPendingTransaction(), this.mInnerAnimationFinishedCallback);
            this.mAnimatable.commitPendingTransaction();
        }
    }

    boolean isAnimating() {
        return this.mAnimation != null;
    }

    AnimationAdapter getAnimation() {
        return this.mAnimation;
    }

    void cancelAnimation() {
        this.cancelAnimation(this.mAnimatable.getPendingTransaction(), false, true);
        this.mAnimatable.commitPendingTransaction();
    }

    void setLayer(SurfaceControl.Transaction t, int layer) {
        t.setLayer(this.mLeash != null ? this.mLeash : this.mAnimatable.getSurfaceControl(), layer);
    }

    void setRelativeLayer(SurfaceControl.Transaction t, SurfaceControl relativeTo, int layer) {
        t.setRelativeLayer(this.mLeash != null ? this.mLeash : this.mAnimatable.getSurfaceControl(), relativeTo, layer);
    }

    void reparent(SurfaceControl.Transaction t, SurfaceControl newParent) {
        t.reparent(this.mLeash != null ? this.mLeash : this.mAnimatable.getSurfaceControl(), newParent.getHandle());
    }

    boolean hasLeash() {
        return this.mLeash != null;
    }

    void transferAnimation(SurfaceAnimator from) {
        if (from.mLeash == null) {
            return;
        }
        SurfaceControl surface = this.mAnimatable.getSurfaceControl();
        SurfaceControl parent = this.mAnimatable.getAnimationLeashParent();
        if (surface == null || parent == null) {
            Slog.w(TAG, "Unable to transfer animation, surface or parent is null");
            this.cancelAnimation();
            return;
        }
        this.endDelayingAnimationStart();
        SurfaceControl.Transaction t = this.mAnimatable.getPendingTransaction();
        this.cancelAnimation(t, true, true);
        this.mLeash = from.mLeash;
        this.mAnimation = from.mAnimation;
        from.cancelAnimation(t, false, false);
        t.reparent(surface, this.mLeash.getHandle());
        t.reparent(this.mLeash, parent.getHandle());
        this.mAnimatable.onAnimationLeashCreated(t, this.mLeash);
        this.mService.mAnimationTransferMap.put(this.mAnimation, this);
    }

    private void cancelAnimation(SurfaceControl.Transaction t, boolean restarting, boolean forwardCancel) {
        SurfaceControl leash = this.mLeash;
        AnimationAdapter animation = this.mAnimation;
        this.reset(t, forwardCancel);
        if (animation != null) {
            if (!this.mAnimationStartDelayed && forwardCancel) {
                animation.onAnimationCancelled(leash);
            }
            if (!restarting) {
                this.mAnimationFinishedCallback.run();
            }
        }
        if (!restarting) {
            this.mAnimationStartDelayed = false;
        }
    }

    private void reset(SurfaceControl.Transaction t, boolean destroyLeash) {
        boolean destroy;
        SurfaceControl surface = this.mAnimatable.getSurfaceControl();
        SurfaceControl parent = this.mAnimatable.getParentSurfaceControl();
        boolean bl = destroy = this.mLeash != null && surface != null && parent != null;
        if (destroy) {
            t.reparent(surface, parent.getHandle());
        }
        this.mService.mAnimationTransferMap.remove(this.mAnimation);
        if (this.mLeash != null && destroyLeash) {
            this.mAnimatable.destroyAfterPendingTransaction(this.mLeash);
        }
        this.mLeash = null;
        this.mAnimation = null;
        if (destroy) {
            this.mAnimatable.onAnimationLeashDestroyed(t);
        }
    }

    private SurfaceControl createAnimationLeash(SurfaceControl surface, SurfaceControl.Transaction t, int width, int height, boolean hidden) {
        SurfaceControl.Builder builder = this.mAnimatable.makeAnimationLeash().setParent(this.mAnimatable.getAnimationLeashParent()).setName(surface + " - animation-leash").setSize(width, height);
        SurfaceControl leash = builder.build();
        if (!hidden) {
            t.show(leash);
        }
        t.reparent(surface, leash.getHandle());
        return leash;
    }

    void writeToProto(ProtoOutputStream proto, long fieldId) {
        long token = proto.start(fieldId);
        proto.write(0x10900000001L, this.mAnimation != null ? this.mAnimation.toString() : "null");
        if (this.mLeash != null) {
            this.mLeash.writeToProto(proto, 1146756268034L);
        }
        proto.write(1133871366147L, this.mAnimationStartDelayed);
        proto.end(token);
    }

    void dump(PrintWriter pw, String prefix) {
        pw.print(prefix);
        pw.print("mAnimation=");
        pw.print(this.mAnimation);
        pw.print(" mLeash=");
        pw.println(this.mLeash);
    }

    static interface Animatable {
        public SurfaceControl.Transaction getPendingTransaction();

        public void commitPendingTransaction();

        public void onAnimationLeashCreated(SurfaceControl.Transaction var1, SurfaceControl var2);

        public void onAnimationLeashDestroyed(SurfaceControl.Transaction var1);

        public void destroyAfterPendingTransaction(SurfaceControl var1);

        public SurfaceControl.Builder makeAnimationLeash();

        public SurfaceControl getAnimationLeashParent();

        public SurfaceControl getSurfaceControl();

        public SurfaceControl getParentSurfaceControl();

        public int getSurfaceWidth();

        public int getSurfaceHeight();
    }

    static interface OnAnimationFinishedCallback {
        public void onAnimationFinished(AnimationAdapter var1);
    }
}

