/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.app.ActivityManager;
import android.content.pm.ActivityInfo;
import android.content.res.Configuration;
import android.graphics.Rect;
import android.util.EventLog;
import android.util.Slog;
import android.util.proto.ProtoOutputStream;
import com.android.internal.annotations.VisibleForTesting;
import com.android.server.wm.AppWindowToken;
import com.android.server.wm.Dimmer;
import com.android.server.wm.DisplayContent;
import com.android.server.wm.DragResizeMode;
import com.android.server.wm.TaskStack;
import com.android.server.wm.TaskWindowContainerController;
import com.android.server.wm.WindowContainer;
import com.android.server.wm.WindowManagerService;
import com.android.server.wm.WindowState;
import java.io.PrintWriter;
import java.util.function.Consumer;

class Task
extends WindowContainer<AppWindowToken> {
    static final String TAG = "WindowManager";
    TaskStack mStack;
    final int mTaskId;
    final int mUserId;
    private boolean mDeferRemoval = false;
    final Rect mPreparedFrozenBounds = new Rect();
    final Configuration mPreparedFrozenMergedConfig = new Configuration();
    private final Rect mTempInsetBounds = new Rect();
    private int mRotation;
    private Rect mTmpRect = new Rect();
    private Rect mTmpRect2 = new Rect();
    private Rect mTmpRect3 = new Rect();
    private int mResizeMode;
    private boolean mSupportsPictureInPicture;
    private boolean mDragResizing;
    private int mDragResizeMode;
    private ActivityManager.TaskDescription mTaskDescription;
    private boolean mPreserveNonFloatingState = false;
    private Dimmer mDimmer = new Dimmer(this);
    private final Rect mTmpDimBoundsRect = new Rect();

    Task(int taskId, TaskStack stack, int userId, WindowManagerService service, int resizeMode, boolean supportsPictureInPicture, ActivityManager.TaskDescription taskDescription, TaskWindowContainerController controller) {
        super(service);
        this.mTaskId = taskId;
        this.mStack = stack;
        this.mUserId = userId;
        this.mResizeMode = resizeMode;
        this.mSupportsPictureInPicture = supportsPictureInPicture;
        this.setController(controller);
        this.setBounds(this.getOverrideBounds());
        this.mTaskDescription = taskDescription;
        this.setOrientation(-2);
    }

    DisplayContent getDisplayContent() {
        return this.mStack != null ? this.mStack.getDisplayContent() : null;
    }

    private int getAdjustedAddPosition(int suggestedPosition) {
        int size = this.mChildren.size();
        if (suggestedPosition >= size) {
            return Math.min(size, suggestedPosition);
        }
        for (int pos = 0; pos < size && pos < suggestedPosition; ++pos) {
            if (!((AppWindowToken)this.mChildren.get((int)pos)).removed) continue;
            ++suggestedPosition;
        }
        return Math.min(size, suggestedPosition);
    }

    @Override
    void addChild(AppWindowToken wtoken, int position) {
        position = this.getAdjustedAddPosition(position);
        super.addChild(wtoken, position);
        this.mDeferRemoval = false;
    }

    @Override
    void positionChildAt(int position, AppWindowToken child, boolean includingParents) {
        position = this.getAdjustedAddPosition(position);
        super.positionChildAt(position, child, includingParents);
        this.mDeferRemoval = false;
    }

    private boolean hasWindowsAlive() {
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            if (!((AppWindowToken)this.mChildren.get(i)).hasWindowsAlive()) continue;
            return true;
        }
        return false;
    }

    @VisibleForTesting
    boolean shouldDeferRemoval() {
        return this.hasWindowsAlive() && this.mStack.isSelfOrChildAnimating();
    }

    @Override
    void removeIfPossible() {
        if (this.shouldDeferRemoval()) {
            this.mDeferRemoval = true;
            return;
        }
        this.removeImmediately();
    }

    @Override
    void removeImmediately() {
        EventLog.writeEvent(31003, this.mTaskId, "removeTask");
        this.mDeferRemoval = false;
        super.removeImmediately();
    }

    void reparent(TaskStack stack, int position, boolean moveParents) {
        if (stack == this.mStack) {
            throw new IllegalArgumentException("task=" + this + " already child of stack=" + this.mStack);
        }
        EventLog.writeEvent(31003, this.mTaskId, "reParentTask");
        DisplayContent prevDisplayContent = this.getDisplayContent();
        this.mPreserveNonFloatingState = stack.inPinnedWindowingMode();
        this.getParent().removeChild(this);
        stack.addTask(this, position, this.showForAllUsers(), moveParents);
        DisplayContent displayContent = stack.getDisplayContent();
        displayContent.setLayoutNeeded();
        if (prevDisplayContent != displayContent) {
            this.onDisplayChanged(displayContent);
            prevDisplayContent.setLayoutNeeded();
        }
    }

    void positionAt(int position) {
        this.mStack.positionChildAt(position, this, false);
    }

    @Override
    void onParentSet() {
        super.onParentSet();
        this.updateDisplayInfo(this.getDisplayContent());
        if (this.getWindowConfiguration().windowsAreScaleable()) {
            this.forceWindowsScaleable(true);
        } else {
            this.forceWindowsScaleable(false);
        }
    }

    @Override
    void removeChild(AppWindowToken token) {
        if (!this.mChildren.contains(token)) {
            Slog.e(TAG, "removeChild: token=" + this + " not found.");
            return;
        }
        super.removeChild(token);
        if (this.mChildren.isEmpty()) {
            EventLog.writeEvent(31003, this.mTaskId, "removeAppToken: last token");
            if (this.mDeferRemoval) {
                this.removeIfPossible();
            }
        }
    }

    void setSendingToBottom(boolean toBottom) {
        for (int appTokenNdx = 0; appTokenNdx < this.mChildren.size(); ++appTokenNdx) {
            ((AppWindowToken)this.mChildren.get((int)appTokenNdx)).sendingToBottom = toBottom;
        }
    }

    public int setBounds(Rect bounds, boolean forceResize) {
        int boundsChanged = this.setBounds(bounds);
        if (forceResize && (boundsChanged & 2) != 2) {
            this.onResize();
            return 2 | boundsChanged;
        }
        return boundsChanged;
    }

    @Override
    public int setBounds(Rect bounds) {
        int rotation = 0;
        DisplayContent displayContent = this.mStack.getDisplayContent();
        if (displayContent != null) {
            rotation = displayContent.getDisplayInfo().rotation;
        } else if (bounds == null) {
            return 0;
        }
        if (this.equivalentOverrideBounds(bounds)) {
            return 0;
        }
        int boundsChange = super.setBounds(bounds);
        this.mRotation = rotation;
        return boundsChange;
    }

    void setTempInsetBounds(Rect tempInsetBounds) {
        if (tempInsetBounds != null) {
            this.mTempInsetBounds.set(tempInsetBounds);
        } else {
            this.mTempInsetBounds.setEmpty();
        }
    }

    void getTempInsetBounds(Rect out) {
        out.set(this.mTempInsetBounds);
    }

    void setResizeable(int resizeMode) {
        this.mResizeMode = resizeMode;
    }

    boolean isResizeable() {
        return ActivityInfo.isResizeableMode(this.mResizeMode) || this.mSupportsPictureInPicture || this.mService.mForceResizableTasks;
    }

    boolean preserveOrientationOnResize() {
        return this.mResizeMode == 6 || this.mResizeMode == 5 || this.mResizeMode == 7;
    }

    boolean cropWindowsToStackBounds() {
        return this.isResizeable();
    }

    void prepareFreezingBounds() {
        this.mPreparedFrozenBounds.set(this.getBounds());
        this.mPreparedFrozenMergedConfig.setTo(this.getConfiguration());
    }

    void alignToAdjustedBounds(Rect adjustedBounds, Rect tempInsetBounds, boolean alignBottom) {
        if (!this.isResizeable() || Configuration.EMPTY.equals(this.getOverrideConfiguration())) {
            return;
        }
        this.getBounds(this.mTmpRect2);
        if (alignBottom) {
            int offsetY = adjustedBounds.bottom - this.mTmpRect2.bottom;
            this.mTmpRect2.offset(0, offsetY);
        } else {
            this.mTmpRect2.offsetTo(adjustedBounds.left, adjustedBounds.top);
        }
        this.setTempInsetBounds(tempInsetBounds);
        this.setBounds(this.mTmpRect2, false);
    }

    private boolean useCurrentBounds() {
        DisplayContent displayContent = this.getDisplayContent();
        return this.matchParentBounds() || !this.inSplitScreenSecondaryWindowingMode() || displayContent == null || displayContent.getSplitScreenPrimaryStackIgnoringVisibility() != null;
    }

    @Override
    public void getBounds(Rect out) {
        if (this.useCurrentBounds()) {
            super.getBounds(out);
            return;
        }
        this.mStack.getDisplayContent().getBounds(out);
    }

    boolean getMaxVisibleBounds(Rect out) {
        boolean foundTop = false;
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            WindowState win;
            AppWindowToken token = (AppWindowToken)this.mChildren.get(i);
            if (token.mIsExiting || token.isClientHidden() || token.hiddenRequested || (win = token.findMainWindow()) == null) continue;
            if (!foundTop) {
                out.set(win.mVisibleFrame);
                foundTop = true;
                continue;
            }
            if (win.mVisibleFrame.left < out.left) {
                out.left = win.mVisibleFrame.left;
            }
            if (win.mVisibleFrame.top < out.top) {
                out.top = win.mVisibleFrame.top;
            }
            if (win.mVisibleFrame.right > out.right) {
                out.right = win.mVisibleFrame.right;
            }
            if (win.mVisibleFrame.bottom <= out.bottom) continue;
            out.bottom = win.mVisibleFrame.bottom;
        }
        return foundTop;
    }

    public void getDimBounds(Rect out) {
        boolean dockedResizing;
        DisplayContent displayContent = this.mStack.getDisplayContent();
        boolean bl = dockedResizing = displayContent != null && displayContent.mDividerControllerLocked.isResizing();
        if (this.useCurrentBounds()) {
            if (this.inFreeformWindowingMode() && this.getMaxVisibleBounds(out)) {
                return;
            }
            if (!this.matchParentBounds()) {
                if (dockedResizing) {
                    this.mStack.getBounds(out);
                } else {
                    this.mStack.getBounds(this.mTmpRect);
                    this.mTmpRect.intersect(this.getBounds());
                    out.set(this.mTmpRect);
                }
            } else {
                out.set(this.getBounds());
            }
            return;
        }
        if (displayContent != null) {
            displayContent.getBounds(out);
        }
    }

    void setDragResizing(boolean dragResizing, int dragResizeMode) {
        if (this.mDragResizing != dragResizing) {
            if (!DragResizeMode.isModeAllowedForStack(this.mStack, dragResizeMode)) {
                throw new IllegalArgumentException("Drag resize mode not allow for stack stackId=" + this.mStack.mStackId + " dragResizeMode=" + dragResizeMode);
            }
            this.mDragResizing = dragResizing;
            this.mDragResizeMode = dragResizeMode;
            this.resetDragResizingChangeReported();
        }
    }

    boolean isDragResizing() {
        return this.mDragResizing;
    }

    int getDragResizeMode() {
        return this.mDragResizeMode;
    }

    void updateDisplayInfo(DisplayContent displayContent) {
        TaskWindowContainerController controller;
        if (displayContent == null) {
            return;
        }
        if (this.matchParentBounds()) {
            this.setBounds(null);
            return;
        }
        int newRotation = displayContent.getDisplayInfo().rotation;
        if (this.mRotation == newRotation) {
            return;
        }
        this.mTmpRect2.set(this.getBounds());
        if (!this.getWindowConfiguration().canResizeTask()) {
            this.setBounds(this.mTmpRect2);
            return;
        }
        displayContent.rotateBounds(this.mRotation, newRotation, this.mTmpRect2);
        if (this.setBounds(this.mTmpRect2) != 0 && (controller = this.getController()) != null) {
            controller.requestResize(this.getBounds(), 1);
        }
    }

    void cancelTaskWindowTransition() {
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            ((AppWindowToken)this.mChildren.get(i)).cancelAnimation();
        }
    }

    boolean showForAllUsers() {
        int tokensCount = this.mChildren.size();
        return tokensCount != 0 && ((AppWindowToken)this.mChildren.get((int)(tokensCount - 1))).mShowForAllUsers;
    }

    boolean isFloating() {
        return this.getWindowConfiguration().tasksAreFloating() && !this.mStack.isAnimatingBoundsToFullscreen() && !this.mPreserveNonFloatingState;
    }

    WindowState getTopVisibleAppMainWindow() {
        AppWindowToken token = this.getTopVisibleAppToken();
        return token != null ? token.findMainWindow() : null;
    }

    AppWindowToken getTopFullscreenAppToken() {
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            AppWindowToken token = (AppWindowToken)this.mChildren.get(i);
            WindowState win = token.findMainWindow();
            if (win == null || !win.mAttrs.isFullscreen()) continue;
            return token;
        }
        return null;
    }

    AppWindowToken getTopVisibleAppToken() {
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            AppWindowToken token = (AppWindowToken)this.mChildren.get(i);
            if (token.mIsExiting || token.isClientHidden() || token.hiddenRequested) continue;
            return token;
        }
        return null;
    }

    boolean isFullscreen() {
        if (this.useCurrentBounds()) {
            return this.matchParentBounds();
        }
        return true;
    }

    void forceWindowsScaleable(boolean force) {
        this.mService.openSurfaceTransaction();
        try {
            for (int i = this.mChildren.size() - 1; i >= 0; --i) {
                ((AppWindowToken)this.mChildren.get(i)).forceWindowsScaleableInTransaction(force);
            }
        }
        finally {
            this.mService.closeSurfaceTransaction("forceWindowsScaleable");
        }
    }

    void setTaskDescription(ActivityManager.TaskDescription taskDescription) {
        this.mTaskDescription = taskDescription;
    }

    ActivityManager.TaskDescription getTaskDescription() {
        return this.mTaskDescription;
    }

    @Override
    boolean fillsParent() {
        return this.matchParentBounds() || !this.getWindowConfiguration().canResizeTask();
    }

    @Override
    TaskWindowContainerController getController() {
        return (TaskWindowContainerController)super.getController();
    }

    @Override
    void forAllTasks(Consumer<Task> callback) {
        callback.accept(this);
    }

    public String toString() {
        return "{taskId=" + this.mTaskId + " appTokens=" + this.mChildren + " mdr=" + this.mDeferRemoval + "}";
    }

    @Override
    String getName() {
        return this.toShortString();
    }

    void clearPreserveNonFloatingState() {
        this.mPreserveNonFloatingState = false;
    }

    @Override
    Dimmer getDimmer() {
        return this.mDimmer;
    }

    @Override
    void prepareSurfaces() {
        this.mDimmer.resetDimStates();
        super.prepareSurfaces();
        this.getDimBounds(this.mTmpDimBoundsRect);
        this.mTmpDimBoundsRect.offsetTo(0, 0);
        if (this.mDimmer.updateDims(this.getPendingTransaction(), this.mTmpDimBoundsRect)) {
            this.scheduleAnimation();
        }
    }

    @Override
    public void writeToProto(ProtoOutputStream proto, long fieldId, boolean trim) {
        long token = proto.start(fieldId);
        super.writeToProto(proto, 0x10B00000001L, trim);
        proto.write(1120986464258L, this.mTaskId);
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            AppWindowToken appWindowToken = (AppWindowToken)this.mChildren.get(i);
            appWindowToken.writeToProto(proto, 2246267895811L, trim);
        }
        proto.write(1133871366148L, this.matchParentBounds());
        this.getBounds().writeToProto(proto, 1146756268037L);
        this.mTempInsetBounds.writeToProto(proto, 1146756268038L);
        proto.write(1133871366151L, this.mDeferRemoval);
        proto.end(token);
    }

    @Override
    public void dump(PrintWriter pw, String prefix, boolean dumpAll) {
        super.dump(pw, prefix, dumpAll);
        String doublePrefix = prefix + "  ";
        pw.println(prefix + "taskId=" + this.mTaskId);
        pw.println(doublePrefix + "mBounds=" + this.getBounds().toShortString());
        pw.println(doublePrefix + "mdr=" + this.mDeferRemoval);
        pw.println(doublePrefix + "appTokens=" + this.mChildren);
        pw.println(doublePrefix + "mTempInsetBounds=" + this.mTempInsetBounds.toShortString());
        String triplePrefix = doublePrefix + "  ";
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            AppWindowToken wtoken = (AppWindowToken)this.mChildren.get(i);
            pw.println(triplePrefix + "Activity #" + i + " " + wtoken);
            wtoken.dump(pw, triplePrefix, dumpAll);
        }
    }

    String toShortString() {
        return "Task=" + this.mTaskId;
    }
}

