/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.app.ActivityManager;
import android.graphics.Rect;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.EventLog;
import android.util.Slog;
import com.android.internal.annotations.VisibleForTesting;
import com.android.server.wm.AppWindowContainerController;
import com.android.server.wm.AppWindowToken;
import com.android.server.wm.StackWindowController;
import com.android.server.wm.Task;
import com.android.server.wm.TaskStack;
import com.android.server.wm.TaskWindowContainerListener;
import com.android.server.wm.WindowContainerController;
import com.android.server.wm.WindowHashMap;
import com.android.server.wm.WindowManagerService;
import java.lang.ref.WeakReference;

public class TaskWindowContainerController
extends WindowContainerController<Task, TaskWindowContainerListener> {
    private final int mTaskId;
    private final H mHandler;

    public TaskWindowContainerController(int taskId, TaskWindowContainerListener listener, StackWindowController stackController, int userId, Rect bounds, int resizeMode, boolean supportsPictureInPicture, boolean toTop, boolean showForAllUsers, ActivityManager.TaskDescription taskDescription) {
        this(taskId, listener, stackController, userId, bounds, resizeMode, supportsPictureInPicture, toTop, showForAllUsers, taskDescription, WindowManagerService.getInstance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskWindowContainerController(int taskId, TaskWindowContainerListener listener, StackWindowController stackController, int userId, Rect bounds, int resizeMode, boolean supportsPictureInPicture, boolean toTop, boolean showForAllUsers, ActivityManager.TaskDescription taskDescription, WindowManagerService service) {
        super(listener, service);
        this.mTaskId = taskId;
        this.mHandler = new H(new WeakReference<TaskWindowContainerController>(this), service.mH.getLooper());
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                TaskStack stack = (TaskStack)stackController.mContainer;
                if (stack == null) {
                    throw new IllegalArgumentException("TaskWindowContainerController: invalid stack=" + stackController);
                }
                EventLog.writeEvent(31001, taskId, stack.mStackId);
                Task task = this.createTask(taskId, stack, userId, resizeMode, supportsPictureInPicture, taskDescription);
                int position = toTop ? Integer.MAX_VALUE : Integer.MIN_VALUE;
                stack.addTask(task, position, showForAllUsers, toTop);
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl19 : MonitorExitStatement: MONITOREXIT : var12_12
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    @VisibleForTesting
    Task createTask(int taskId, TaskStack stack, int userId, int resizeMode, boolean supportsPictureInPicture, ActivityManager.TaskDescription taskDescription) {
        return new Task(taskId, stack, userId, this.mService, resizeMode, supportsPictureInPicture, taskDescription, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void removeContainer() {
        block4: {
            WindowHashMap windowHashMap = this.mWindowMap;
            // MONITORENTER : windowHashMap
            try {
                WindowManagerService.boostPriorityForLockedSection();
                if (this.mContainer != null) break block4;
                // MONITOREXIT : windowHashMap
            }
            catch (Throwable throwable) {
                // MONITOREXIT : windowHashMap
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
            WindowManagerService.resetPriorityAfterLockedSection();
            return;
        }
        ((Task)this.mContainer).removeIfPossible();
        super.removeContainer();
        // MONITOREXIT : windowHashMap
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    public void positionChildAtTop(AppWindowContainerController childController) {
        this.positionChildAt(childController, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void positionChildAt(AppWindowContainerController childController, int position) {
        AppWindowToken aToken;
        block5: {
            WindowHashMap windowHashMap = this.mService.mWindowMap;
            // MONITORENTER : windowHashMap
            try {
                WindowManagerService.boostPriorityForLockedSection();
                aToken = (AppWindowToken)childController.mContainer;
                if (aToken != null) break block5;
                Slog.w("WindowManager", "Attempted to position of non-existing app : " + childController);
                // MONITOREXIT : windowHashMap
            }
            catch (Throwable throwable) {
                // MONITOREXIT : windowHashMap
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
            WindowManagerService.resetPriorityAfterLockedSection();
            return;
        }
        Task task = (Task)this.mContainer;
        if (task == null) {
            throw new IllegalArgumentException("positionChildAt: invalid task=" + this);
        }
        task.positionChildAt(position, aToken, false);
        // MONITOREXIT : windowHashMap
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void reparent(StackWindowController stackController, int position, boolean moveParents) {
        block5: {
            WindowHashMap windowHashMap = this.mWindowMap;
            // MONITORENTER : windowHashMap
            try {
                WindowManagerService.boostPriorityForLockedSection();
                if (this.mContainer != null) break block5;
                // MONITOREXIT : windowHashMap
            }
            catch (Throwable throwable) {
                // MONITOREXIT : windowHashMap
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
            WindowManagerService.resetPriorityAfterLockedSection();
            return;
        }
        TaskStack stack = (TaskStack)stackController.mContainer;
        if (stack == null) {
            throw new IllegalArgumentException("reparent: could not find stack=" + stackController);
        }
        ((Task)this.mContainer).reparent(stack, position, moveParents);
        ((Task)this.mContainer).getDisplayContent().layoutAndAssignWindowLayersIfNeeded();
        // MONITOREXIT : windowHashMap
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResizeable(int resizeMode) {
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                if (this.mContainer != null) {
                    ((Task)this.mContainer).setResizeable(resizeMode);
                }
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl10 : MonitorExitStatement: MONITOREXIT : var2_2
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resize(boolean relayout, boolean forced) {
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                if (this.mContainer == null) {
                    throw new IllegalArgumentException("resizeTask: taskId " + this.mTaskId + " not found.");
                }
                if (((Task)this.mContainer).setBounds(((Task)this.mContainer).getOverrideBounds(), forced) != 0 && relayout) {
                    ((Task)this.mContainer).getDisplayContent().layoutAndAssignWindowLayersIfNeeded();
                }
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl12 : MonitorExitStatement: MONITOREXIT : var3_3
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void getBounds(Rect bounds) {
        block4: {
            WindowHashMap windowHashMap = this.mWindowMap;
            // MONITORENTER : windowHashMap
            try {
                WindowManagerService.boostPriorityForLockedSection();
                if (this.mContainer == null) break block4;
                ((Task)this.mContainer).getBounds(bounds);
                // MONITOREXIT : windowHashMap
            }
            catch (Throwable throwable) {
                // MONITOREXIT : windowHashMap
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
            WindowManagerService.resetPriorityAfterLockedSection();
            return;
        }
        bounds.setEmpty();
        // MONITOREXIT : windowHashMap
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void setTaskDockedResizing(boolean resizing) {
        block4: {
            WindowHashMap windowHashMap = this.mWindowMap;
            // MONITORENTER : windowHashMap
            try {
                WindowManagerService.boostPriorityForLockedSection();
                if (this.mContainer != null) break block4;
                Slog.w("WindowManager", "setTaskDockedResizing: taskId " + this.mTaskId + " not found.");
                // MONITOREXIT : windowHashMap
            }
            catch (Throwable throwable) {
                // MONITOREXIT : windowHashMap
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
            WindowManagerService.resetPriorityAfterLockedSection();
            return;
        }
        ((Task)this.mContainer).setDragResizing(resizing, 1);
        // MONITOREXIT : windowHashMap
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void cancelWindowTransition() {
        block4: {
            WindowHashMap windowHashMap = this.mWindowMap;
            // MONITORENTER : windowHashMap
            try {
                WindowManagerService.boostPriorityForLockedSection();
                if (this.mContainer != null) break block4;
                Slog.w("WindowManager", "cancelWindowTransition: taskId " + this.mTaskId + " not found.");
                // MONITOREXIT : windowHashMap
            }
            catch (Throwable throwable) {
                // MONITOREXIT : windowHashMap
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
            WindowManagerService.resetPriorityAfterLockedSection();
            return;
        }
        ((Task)this.mContainer).cancelTaskWindowTransition();
        // MONITOREXIT : windowHashMap
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void setTaskDescription(ActivityManager.TaskDescription taskDescription) {
        block4: {
            WindowHashMap windowHashMap = this.mWindowMap;
            // MONITORENTER : windowHashMap
            try {
                WindowManagerService.boostPriorityForLockedSection();
                if (this.mContainer != null) break block4;
                Slog.w("WindowManager", "setTaskDescription: taskId " + this.mTaskId + " not found.");
                // MONITOREXIT : windowHashMap
            }
            catch (Throwable throwable) {
                // MONITOREXIT : windowHashMap
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
            WindowManagerService.resetPriorityAfterLockedSection();
            return;
        }
        ((Task)this.mContainer).setTaskDescription(taskDescription);
        // MONITOREXIT : windowHashMap
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    void reportSnapshotChanged(ActivityManager.TaskSnapshot snapshot) {
        this.mHandler.obtainMessage(0, snapshot).sendToTarget();
    }

    void requestResize(Rect bounds, int resizeMode) {
        this.mHandler.obtainMessage(1, resizeMode, 0, bounds).sendToTarget();
    }

    public String toString() {
        return "{TaskWindowContainerController taskId=" + this.mTaskId + "}";
    }

    private static final class H
    extends Handler {
        static final int REPORT_SNAPSHOT_CHANGED = 0;
        static final int REQUEST_RESIZE = 1;
        private final WeakReference<TaskWindowContainerController> mController;

        H(WeakReference<TaskWindowContainerController> controller, Looper looper) {
            super(looper);
            this.mController = controller;
        }

        @Override
        public void handleMessage(Message msg) {
            TaskWindowContainerListener listener;
            TaskWindowContainerController controller = (TaskWindowContainerController)this.mController.get();
            TaskWindowContainerListener taskWindowContainerListener = listener = controller != null ? (TaskWindowContainerListener)controller.mListener : null;
            if (listener == null) {
                return;
            }
            switch (msg.what) {
                case 0: {
                    listener.onSnapshotChanged((ActivityManager.TaskSnapshot)msg.obj);
                    break;
                }
                case 1: {
                    listener.requestResize((Rect)msg.obj, msg.arg1);
                }
            }
        }
    }
}

