/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.graphics.Point;
import android.graphics.Rect;
import android.os.SystemClock;
import android.view.SurfaceControl;
import android.view.animation.Animation;
import android.view.animation.AnimationSet;
import android.view.animation.Interpolator;
import android.view.animation.Transformation;
import android.view.animation.TranslateAnimation;
import com.android.server.wm.LocalAnimationAdapter;

public class WindowAnimationSpec
implements LocalAnimationAdapter.AnimationSpec {
    private Animation mAnimation;
    private final Point mPosition = new Point();
    private final ThreadLocal<TmpValues> mThreadLocalTmps = ThreadLocal.withInitial(() -> new TmpValues());
    private final boolean mCanSkipFirstFrame;
    private final Rect mStackBounds = new Rect();
    private int mStackClipMode;
    private final Rect mTmpRect = new Rect();

    public WindowAnimationSpec(Animation animation, Point position, boolean canSkipFirstFrame) {
        this(animation, position, null, canSkipFirstFrame, 2);
    }

    public WindowAnimationSpec(Animation animation, Point position, Rect stackBounds, boolean canSkipFirstFrame, int stackClipMode) {
        this.mAnimation = animation;
        if (position != null) {
            this.mPosition.set(position.x, position.y);
        }
        this.mCanSkipFirstFrame = canSkipFirstFrame;
        this.mStackClipMode = stackClipMode;
        if (stackBounds != null) {
            this.mStackBounds.set(stackBounds);
        }
    }

    @Override
    public boolean getDetachWallpaper() {
        return this.mAnimation.getDetachWallpaper();
    }

    @Override
    public int getBackgroundColor() {
        return this.mAnimation.getBackgroundColor();
    }

    @Override
    public long getDuration() {
        return this.mAnimation.computeDurationHint();
    }

    @Override
    public void apply(SurfaceControl.Transaction t, SurfaceControl leash, long currentPlayTime) {
        TmpValues tmp = this.mThreadLocalTmps.get();
        tmp.transformation.clear();
        this.mAnimation.getTransformation(currentPlayTime, tmp.transformation);
        tmp.transformation.getMatrix().postTranslate(this.mPosition.x, this.mPosition.y);
        t.setMatrix(leash, tmp.transformation.getMatrix(), tmp.floats);
        t.setAlpha(leash, tmp.transformation.getAlpha());
        if (this.mStackClipMode == 2) {
            t.setWindowCrop(leash, tmp.transformation.getClipRect());
        } else if (this.mStackClipMode == 0) {
            this.mTmpRect.set(this.mStackBounds);
            this.mTmpRect.offsetTo(this.mPosition.x, this.mPosition.y);
            t.setFinalCrop(leash, this.mTmpRect);
            t.setWindowCrop(leash, tmp.transformation.getClipRect());
        } else {
            this.mTmpRect.set(this.mStackBounds);
            this.mTmpRect.intersect(tmp.transformation.getClipRect());
            t.setWindowCrop(leash, this.mTmpRect);
        }
    }

    @Override
    public long calculateStatusBarTransitionStartTime() {
        TranslateAnimation openTranslateAnimation = WindowAnimationSpec.findTranslateAnimation(this.mAnimation);
        if (openTranslateAnimation != null) {
            float t = WindowAnimationSpec.findAlmostThereFraction(openTranslateAnimation.getInterpolator());
            return SystemClock.uptimeMillis() + openTranslateAnimation.getStartOffset() + (long)((float)openTranslateAnimation.getDuration() * t) - 120L;
        }
        return SystemClock.uptimeMillis();
    }

    @Override
    public boolean canSkipFirstFrame() {
        return this.mCanSkipFirstFrame;
    }

    private static TranslateAnimation findTranslateAnimation(Animation animation) {
        if (animation instanceof TranslateAnimation) {
            return (TranslateAnimation)animation;
        }
        if (animation instanceof AnimationSet) {
            AnimationSet set = (AnimationSet)animation;
            for (int i = 0; i < set.getAnimations().size(); ++i) {
                Animation a = set.getAnimations().get(i);
                if (!(a instanceof TranslateAnimation)) continue;
                return (TranslateAnimation)a;
            }
        }
        return null;
    }

    private static float findAlmostThereFraction(Interpolator interpolator2) {
        float val = 0.5f;
        for (float adj = 0.25f; adj >= 0.01f; adj /= 2.0f) {
            if (interpolator2.getInterpolation(val) < 0.99f) {
                val += adj;
                continue;
            }
            val -= adj;
        }
        return val;
    }

    private static class TmpValues {
        final Transformation transformation = new Transformation();
        final float[] floats = new float[9];

        private TmpValues() {
        }
    }
}

