/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.content.res.Configuration;
import android.graphics.Point;
import android.graphics.Rect;
import android.util.Pools;
import android.util.proto.ProtoOutputStream;
import android.view.MagnificationSpec;
import android.view.SurfaceControl;
import android.view.SurfaceSession;
import com.android.internal.util.ToBooleanFunction;
import com.android.server.wm.AnimationAdapter;
import com.android.server.wm.ConfigurationContainer;
import com.android.server.wm.Dimmer;
import com.android.server.wm.DisplayContent;
import com.android.server.wm.SurfaceAnimator;
import com.android.server.wm.Task;
import com.android.server.wm.WindowContainerController;
import com.android.server.wm.WindowList;
import com.android.server.wm.WindowManagerService;
import com.android.server.wm.WindowState;
import java.io.PrintWriter;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.function.Consumer;
import java.util.function.Predicate;

class WindowContainer<E extends WindowContainer>
extends ConfigurationContainer<E>
implements Comparable<WindowContainer>,
SurfaceAnimator.Animatable {
    private static final String TAG = "WindowManager";
    static final int POSITION_TOP = Integer.MAX_VALUE;
    static final int POSITION_BOTTOM = Integer.MIN_VALUE;
    private WindowContainer<WindowContainer> mParent = null;
    protected final WindowList<E> mChildren = new WindowList();
    protected int mOrientation = -1;
    private final Pools.SynchronizedPool<ForAllWindowsConsumerWrapper> mConsumerWrapperPool = new Pools.SynchronizedPool(3);
    WindowContainerController mController;
    protected SurfaceControl mSurfaceControl;
    private int mLastLayer = 0;
    private SurfaceControl mLastRelativeToLayer = null;
    protected final SurfaceControl.Transaction mPendingTransaction;
    protected final SurfaceAnimator mSurfaceAnimator;
    protected final WindowManagerService mService;
    private final Point mTmpPos = new Point();
    protected final Point mLastSurfacePosition = new Point();
    private int mTreeWeight = 1;
    private boolean mCommittedReparentToAnimationLeash;
    private final LinkedList<WindowContainer> mTmpChain1 = new LinkedList();
    private final LinkedList<WindowContainer> mTmpChain2 = new LinkedList();

    WindowContainer(WindowManagerService service) {
        this.mService = service;
        this.mPendingTransaction = service.mTransactionFactory.make();
        this.mSurfaceAnimator = new SurfaceAnimator(this, this::onAnimationFinished, service.mAnimator::addAfterPrepareSurfacesRunnable, service);
    }

    @Override
    protected final WindowContainer getParent() {
        return this.mParent;
    }

    @Override
    protected int getChildCount() {
        return this.mChildren.size();
    }

    @Override
    protected E getChildAt(int index) {
        return (E)((WindowContainer)this.mChildren.get(index));
    }

    @Override
    public void onConfigurationChanged(Configuration newParentConfig) {
        super.onConfigurationChanged(newParentConfig);
        this.updateSurfacePosition();
        this.scheduleAnimation();
    }

    protected final void setParent(WindowContainer<WindowContainer> parent) {
        this.mParent = parent;
        if (this.mParent != null) {
            this.onConfigurationChanged(this.mParent.getConfiguration());
            this.onMergedOverrideConfigurationChanged();
        }
        this.onParentSet();
    }

    void onParentSet() {
        if (this.mParent == null) {
            return;
        }
        if (this.mSurfaceControl == null) {
            this.mSurfaceControl = this.makeSurface().build();
            this.getPendingTransaction().show(this.mSurfaceControl);
        } else {
            this.reparentSurfaceControl(this.getPendingTransaction(), this.mParent.mSurfaceControl);
        }
        this.mParent.assignChildLayers();
        this.scheduleAnimation();
    }

    protected void addChild(E child, Comparator<E> comparator) {
        if (((WindowContainer)child).getParent() != null) {
            throw new IllegalArgumentException("addChild: container=" + ((ConfigurationContainer)child).getName() + " is already a child of container=" + ((WindowContainer)child).getParent().getName() + " can't add to container=" + this.getName());
        }
        int positionToAdd = -1;
        if (comparator != null) {
            int count = this.mChildren.size();
            for (int i = 0; i < count; ++i) {
                if (comparator.compare(child, (WindowContainer)this.mChildren.get(i)) >= 0) continue;
                positionToAdd = i;
                break;
            }
        }
        if (positionToAdd == -1) {
            this.mChildren.add(child);
        } else {
            this.mChildren.add(positionToAdd, child);
        }
        this.onChildAdded((WindowContainer)child);
        ((WindowContainer)child).setParent(this);
    }

    void addChild(E child, int index) {
        if (((WindowContainer)child).getParent() != null) {
            throw new IllegalArgumentException("addChild: container=" + ((ConfigurationContainer)child).getName() + " is already a child of container=" + ((WindowContainer)child).getParent().getName() + " can't add to container=" + this.getName());
        }
        this.mChildren.add(index, child);
        this.onChildAdded((WindowContainer)child);
        ((WindowContainer)child).setParent(this);
    }

    private void onChildAdded(WindowContainer child) {
        this.mTreeWeight += child.mTreeWeight;
        for (WindowContainer parent = this.getParent(); parent != null; parent = parent.getParent()) {
            parent.mTreeWeight += child.mTreeWeight;
        }
    }

    void removeChild(E child) {
        if (!this.mChildren.remove(child)) {
            throw new IllegalArgumentException("removeChild: container=" + ((ConfigurationContainer)child).getName() + " is not a child of container=" + this.getName());
        }
        this.onChildRemoved((WindowContainer)child);
        ((WindowContainer)child).setParent(null);
    }

    private void onChildRemoved(WindowContainer child) {
        this.mTreeWeight -= child.mTreeWeight;
        for (WindowContainer parent = this.getParent(); parent != null; parent = parent.getParent()) {
            parent.mTreeWeight -= child.mTreeWeight;
        }
    }

    void removeImmediately() {
        while (!this.mChildren.isEmpty()) {
            WindowContainer child = (WindowContainer)this.mChildren.peekLast();
            child.removeImmediately();
            if (!this.mChildren.remove(child)) continue;
            this.onChildRemoved(child);
        }
        if (this.mSurfaceControl != null) {
            this.destroyAfterPendingTransaction(this.mSurfaceControl);
            this.mSurfaceControl = null;
        }
        if (this.mParent != null) {
            this.mParent.removeChild(this);
        }
        if (this.mController != null) {
            this.setController(null);
        }
    }

    int getPrefixOrderIndex() {
        if (this.mParent == null) {
            return 0;
        }
        return super.getPrefixOrderIndex(this);
    }

    private int getPrefixOrderIndex(WindowContainer child) {
        WindowContainer childI;
        int order = 0;
        for (int i = 0; i < this.mChildren.size() && child != (childI = (WindowContainer)this.mChildren.get(i)); ++i) {
            order += childI.mTreeWeight;
        }
        if (this.mParent != null) {
            order += super.getPrefixOrderIndex(this);
        }
        return ++order;
    }

    void removeIfPossible() {
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            WindowContainer wc = (WindowContainer)this.mChildren.get(i);
            wc.removeIfPossible();
        }
    }

    boolean hasChild(E child) {
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            WindowContainer current = (WindowContainer)this.mChildren.get(i);
            if (current != child && !current.hasChild(child)) continue;
            return true;
        }
        return false;
    }

    void positionChildAt(int position, E child, boolean includingParents) {
        if (((WindowContainer)child).getParent() != this) {
            throw new IllegalArgumentException("removeChild: container=" + ((ConfigurationContainer)child).getName() + " is not a child of container=" + this.getName() + " current parent=" + ((WindowContainer)child).getParent());
        }
        if (position < 0 && position != Integer.MIN_VALUE || position > this.mChildren.size() && position != Integer.MAX_VALUE) {
            throw new IllegalArgumentException("positionAt: invalid position=" + position + ", children number=" + this.mChildren.size());
        }
        if (position >= this.mChildren.size() - 1) {
            position = Integer.MAX_VALUE;
        } else if (position == 0) {
            position = Integer.MIN_VALUE;
        }
        switch (position) {
            case 0x7FFFFFFF: {
                if (this.mChildren.peekLast() != child) {
                    this.mChildren.remove(child);
                    this.mChildren.add(child);
                }
                if (!includingParents || this.getParent() == null) break;
                this.getParent().positionChildAt(Integer.MAX_VALUE, this, true);
                break;
            }
            case -2147483648: {
                if (this.mChildren.peekFirst() != child) {
                    this.mChildren.remove(child);
                    this.mChildren.addFirst(child);
                }
                if (!includingParents || this.getParent() == null) break;
                this.getParent().positionChildAt(Integer.MIN_VALUE, this, true);
                break;
            }
            default: {
                this.mChildren.remove(child);
                this.mChildren.add(position, child);
            }
        }
    }

    @Override
    public void onOverrideConfigurationChanged(Configuration overrideConfiguration) {
        int diff = this.diffOverrideBounds(overrideConfiguration.windowConfiguration.getBounds());
        super.onOverrideConfigurationChanged(overrideConfiguration);
        if (this.mParent != null) {
            this.mParent.onDescendantOverrideConfigurationChanged();
        }
        if (diff == 0) {
            return;
        }
        if ((diff & 2) == 2) {
            this.onResize();
        } else {
            this.onMovedByResize();
        }
    }

    void onDescendantOverrideConfigurationChanged() {
        if (this.mParent != null) {
            this.mParent.onDescendantOverrideConfigurationChanged();
        }
    }

    void onDisplayChanged(DisplayContent dc) {
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            WindowContainer child = (WindowContainer)this.mChildren.get(i);
            child.onDisplayChanged(dc);
        }
    }

    void setWaitingForDrawnIfResizingChanged() {
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            WindowContainer wc = (WindowContainer)this.mChildren.get(i);
            wc.setWaitingForDrawnIfResizingChanged();
        }
    }

    void onResize() {
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            WindowContainer wc = (WindowContainer)this.mChildren.get(i);
            wc.onParentResize();
        }
    }

    void onParentResize() {
        if (this.hasOverrideBounds()) {
            return;
        }
        this.onResize();
    }

    void onMovedByResize() {
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            WindowContainer wc = (WindowContainer)this.mChildren.get(i);
            wc.onMovedByResize();
        }
    }

    void resetDragResizingChangeReported() {
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            WindowContainer wc = (WindowContainer)this.mChildren.get(i);
            wc.resetDragResizingChangeReported();
        }
    }

    void forceWindowsScaleableInTransaction(boolean force) {
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            WindowContainer wc = (WindowContainer)this.mChildren.get(i);
            wc.forceWindowsScaleableInTransaction(force);
        }
    }

    boolean isSelfOrChildAnimating() {
        if (this.isSelfAnimating()) {
            return true;
        }
        for (int j = this.mChildren.size() - 1; j >= 0; --j) {
            WindowContainer wc = (WindowContainer)this.mChildren.get(j);
            if (!wc.isSelfOrChildAnimating()) continue;
            return true;
        }
        return false;
    }

    boolean isAnimating() {
        return this.isSelfAnimating() || this.mParent != null && this.mParent.isAnimating();
    }

    boolean isAppAnimating() {
        for (int j = this.mChildren.size() - 1; j >= 0; --j) {
            WindowContainer wc = (WindowContainer)this.mChildren.get(j);
            if (!wc.isAppAnimating()) continue;
            return true;
        }
        return false;
    }

    boolean isSelfAnimating() {
        return this.mSurfaceAnimator.isAnimating();
    }

    void sendAppVisibilityToClients() {
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            WindowContainer wc = (WindowContainer)this.mChildren.get(i);
            wc.sendAppVisibilityToClients();
        }
    }

    boolean hasContentToDisplay() {
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            WindowContainer wc = (WindowContainer)this.mChildren.get(i);
            if (!wc.hasContentToDisplay()) continue;
            return true;
        }
        return false;
    }

    boolean isVisible() {
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            WindowContainer wc = (WindowContainer)this.mChildren.get(i);
            if (!wc.isVisible()) continue;
            return true;
        }
        return false;
    }

    boolean isOnTop() {
        return this.getParent().getTopChild() == this && this.getParent().isOnTop();
    }

    E getTopChild() {
        return (E)((WindowContainer)this.mChildren.peekLast());
    }

    boolean checkCompleteDeferredRemoval() {
        boolean stillDeferringRemoval = false;
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            WindowContainer wc = (WindowContainer)this.mChildren.get(i);
            stillDeferringRemoval |= wc.checkCompleteDeferredRemoval();
        }
        return stillDeferringRemoval;
    }

    void checkAppWindowsReadyToShow() {
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            WindowContainer wc = (WindowContainer)this.mChildren.get(i);
            wc.checkAppWindowsReadyToShow();
        }
    }

    void onAppTransitionDone() {
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            WindowContainer wc = (WindowContainer)this.mChildren.get(i);
            wc.onAppTransitionDone();
        }
    }

    void setOrientation(int orientation) {
        this.mOrientation = orientation;
    }

    int getOrientation() {
        return this.getOrientation(this.mOrientation);
    }

    int getOrientation(int candidate) {
        if (!this.fillsParent()) {
            return -2;
        }
        if (this.mOrientation != -2 && this.mOrientation != -1) {
            return this.mOrientation;
        }
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            WindowContainer wc = (WindowContainer)this.mChildren.get(i);
            int orientation = wc.getOrientation(candidate == 3 ? 3 : -2);
            if (orientation == 3) {
                candidate = orientation;
                continue;
            }
            if (orientation == -2 || !wc.fillsParent() && orientation == -1) continue;
            return orientation;
        }
        return candidate;
    }

    boolean fillsParent() {
        return false;
    }

    void switchUser() {
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            ((WindowContainer)this.mChildren.get(i)).switchUser();
        }
    }

    boolean forAllWindows(ToBooleanFunction<WindowState> callback, boolean traverseTopToBottom) {
        if (traverseTopToBottom) {
            for (int i = this.mChildren.size() - 1; i >= 0; --i) {
                if (!((WindowContainer)this.mChildren.get(i)).forAllWindows(callback, traverseTopToBottom)) continue;
                return true;
            }
        } else {
            int count = this.mChildren.size();
            for (int i = 0; i < count; ++i) {
                if (!((WindowContainer)this.mChildren.get(i)).forAllWindows(callback, traverseTopToBottom)) continue;
                return true;
            }
        }
        return false;
    }

    void forAllWindows(Consumer<WindowState> callback, boolean traverseTopToBottom) {
        ForAllWindowsConsumerWrapper wrapper = this.obtainConsumerWrapper(callback);
        this.forAllWindows(wrapper, traverseTopToBottom);
        wrapper.release();
    }

    void forAllTasks(Consumer<Task> callback) {
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            ((WindowContainer)this.mChildren.get(i)).forAllTasks(callback);
        }
    }

    WindowState getWindow(Predicate<WindowState> callback) {
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            WindowState w = ((WindowContainer)this.mChildren.get(i)).getWindow(callback);
            if (w == null) continue;
            return w;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int compareTo(WindowContainer other) {
        if (this == other) {
            return 0;
        }
        if (this.mParent != null && this.mParent == other.mParent) {
            WindowList<E> list = this.mParent.mChildren;
            return list.indexOf(this) > list.indexOf(other) ? 1 : -1;
        }
        LinkedList<WindowContainer> thisParentChain = this.mTmpChain1;
        LinkedList<WindowContainer> otherParentChain = this.mTmpChain2;
        try {
            this.getParents(thisParentChain);
            other.getParents(otherParentChain);
            WindowContainer commonAncestor = null;
            WindowContainer thisTop = thisParentChain.peekLast();
            WindowContainer otherTop = otherParentChain.peekLast();
            while (thisTop != null && otherTop != null && thisTop == otherTop) {
                commonAncestor = thisParentChain.removeLast();
                otherParentChain.removeLast();
                thisTop = thisParentChain.peekLast();
                otherTop = otherParentChain.peekLast();
            }
            if (commonAncestor == null) {
                throw new IllegalArgumentException("No in the same hierarchy this=" + thisParentChain + " other=" + otherParentChain);
            }
            if (commonAncestor == this) {
                int n = -1;
                return n;
            }
            if (commonAncestor == other) {
                int n = 1;
                return n;
            }
            WindowList<E> list = commonAncestor.mChildren;
            int n = list.indexOf(thisParentChain.peekLast()) > list.indexOf(otherParentChain.peekLast()) ? 1 : -1;
            return n;
        }
        finally {
            this.mTmpChain1.clear();
            this.mTmpChain2.clear();
        }
    }

    private void getParents(LinkedList<WindowContainer> parents) {
        parents.clear();
        WindowContainer<WindowContainer> current = this;
        do {
            parents.addLast(current);
        } while ((current = current.mParent) != null);
    }

    WindowContainerController getController() {
        return this.mController;
    }

    void setController(WindowContainerController controller) {
        if (this.mController != null && controller != null) {
            throw new IllegalArgumentException("Can't set controller=" + this.mController + " for container=" + this + " Already set to=" + this.mController);
        }
        if (controller != null) {
            controller.setContainer(this);
        } else if (this.mController != null) {
            this.mController.setContainer(null);
        }
        this.mController = controller;
    }

    SurfaceControl.Builder makeSurface() {
        WindowContainer p = this.getParent();
        return p.makeChildSurface(this);
    }

    SurfaceControl.Builder makeChildSurface(WindowContainer child) {
        WindowContainer p = this.getParent();
        return p.makeChildSurface(child).setParent(this.mSurfaceControl);
    }

    @Override
    public SurfaceControl getParentSurfaceControl() {
        WindowContainer parent = this.getParent();
        if (parent == null) {
            return null;
        }
        return parent.getSurfaceControl();
    }

    boolean shouldMagnify() {
        for (int i = 0; i < this.mChildren.size(); ++i) {
            if (((WindowContainer)this.mChildren.get(i)).shouldMagnify()) continue;
            return false;
        }
        return true;
    }

    SurfaceSession getSession() {
        if (this.getParent() != null) {
            return this.getParent().getSession();
        }
        return null;
    }

    void assignLayer(SurfaceControl.Transaction t, int layer) {
        boolean changed;
        boolean bl = changed = layer != this.mLastLayer || this.mLastRelativeToLayer != null;
        if (this.mSurfaceControl != null && changed) {
            this.setLayer(t, layer);
            this.mLastLayer = layer;
            this.mLastRelativeToLayer = null;
        }
    }

    void assignRelativeLayer(SurfaceControl.Transaction t, SurfaceControl relativeTo, int layer) {
        boolean changed;
        boolean bl = changed = layer != this.mLastLayer || this.mLastRelativeToLayer != relativeTo;
        if (this.mSurfaceControl != null && changed) {
            this.setRelativeLayer(t, relativeTo, layer);
            this.mLastLayer = layer;
            this.mLastRelativeToLayer = relativeTo;
        }
    }

    protected void setLayer(SurfaceControl.Transaction t, int layer) {
        this.mSurfaceAnimator.setLayer(t, layer);
    }

    protected void setRelativeLayer(SurfaceControl.Transaction t, SurfaceControl relativeTo, int layer) {
        this.mSurfaceAnimator.setRelativeLayer(t, relativeTo, layer);
    }

    protected void reparentSurfaceControl(SurfaceControl.Transaction t, SurfaceControl newParent) {
        this.mSurfaceAnimator.reparent(t, newParent);
    }

    void assignChildLayers(SurfaceControl.Transaction t) {
        WindowContainer wc;
        int j;
        int layer = 0;
        for (j = 0; j < this.mChildren.size(); ++j) {
            wc = (WindowContainer)this.mChildren.get(j);
            wc.assignChildLayers(t);
            if (wc.needsZBoost()) continue;
            wc.assignLayer(t, layer++);
        }
        for (j = 0; j < this.mChildren.size(); ++j) {
            wc = (WindowContainer)this.mChildren.get(j);
            if (!wc.needsZBoost()) continue;
            wc.assignLayer(t, layer++);
        }
    }

    void assignChildLayers() {
        this.assignChildLayers(this.getPendingTransaction());
        this.scheduleAnimation();
    }

    boolean needsZBoost() {
        for (int i = 0; i < this.mChildren.size(); ++i) {
            if (!((WindowContainer)this.mChildren.get(i)).needsZBoost()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void writeToProto(ProtoOutputStream proto, long fieldId, boolean trim) {
        long token = proto.start(fieldId);
        super.writeToProto(proto, 0x10B00000001L, trim);
        proto.write(1120986464258L, this.mOrientation);
        proto.write(1133871366147L, this.isVisible());
        this.mSurfaceAnimator.writeToProto(proto, 1146756268036L);
        proto.end(token);
    }

    private ForAllWindowsConsumerWrapper obtainConsumerWrapper(Consumer<WindowState> consumer) {
        ForAllWindowsConsumerWrapper wrapper = this.mConsumerWrapperPool.acquire();
        if (wrapper == null) {
            wrapper = new ForAllWindowsConsumerWrapper();
        }
        wrapper.setConsumer(consumer);
        return wrapper;
    }

    void applyMagnificationSpec(SurfaceControl.Transaction t, MagnificationSpec spec) {
        if (this.shouldMagnify()) {
            t.setMatrix(this.mSurfaceControl, spec.scale, 0.0f, 0.0f, spec.scale).setPosition(this.mSurfaceControl, spec.offsetX, spec.offsetY);
        } else {
            for (int i = 0; i < this.mChildren.size(); ++i) {
                ((WindowContainer)this.mChildren.get(i)).applyMagnificationSpec(t, spec);
            }
        }
    }

    void prepareSurfaces() {
        SurfaceControl.mergeToGlobalTransaction(this.getPendingTransaction());
        this.mCommittedReparentToAnimationLeash = this.mSurfaceAnimator.hasLeash();
        for (int i = 0; i < this.mChildren.size(); ++i) {
            ((WindowContainer)this.mChildren.get(i)).prepareSurfaces();
        }
    }

    boolean hasCommittedReparentToAnimationLeash() {
        return this.mCommittedReparentToAnimationLeash;
    }

    void scheduleAnimation() {
        if (this.mParent != null) {
            this.mParent.scheduleAnimation();
        }
    }

    @Override
    public SurfaceControl getSurfaceControl() {
        return this.mSurfaceControl;
    }

    @Override
    public void destroyAfterPendingTransaction(SurfaceControl surface) {
        if (this.mParent != null) {
            this.mParent.destroyAfterPendingTransaction(surface);
        }
    }

    @Override
    public SurfaceControl.Transaction getPendingTransaction() {
        return this.mPendingTransaction;
    }

    void startAnimation(SurfaceControl.Transaction t, AnimationAdapter anim2, boolean hidden) {
        this.mSurfaceAnimator.startAnimation(t, anim2, hidden);
    }

    void transferAnimation(WindowContainer from) {
        this.mSurfaceAnimator.transferAnimation(from.mSurfaceAnimator);
    }

    void cancelAnimation() {
        this.mSurfaceAnimator.cancelAnimation();
    }

    @Override
    public SurfaceControl.Builder makeAnimationLeash() {
        return this.makeSurface();
    }

    @Override
    public SurfaceControl getAnimationLeashParent() {
        return this.getParentSurfaceControl();
    }

    SurfaceControl getAppAnimationLayer() {
        WindowContainer parent = this.getParent();
        if (parent != null) {
            return parent.getAppAnimationLayer();
        }
        return null;
    }

    @Override
    public void commitPendingTransaction() {
        this.scheduleAnimation();
    }

    private void reassignLayer(SurfaceControl.Transaction t) {
        WindowContainer parent = this.getParent();
        if (parent != null) {
            parent.assignChildLayers(t);
        }
    }

    @Override
    public void onAnimationLeashCreated(SurfaceControl.Transaction t, SurfaceControl leash) {
        this.reassignLayer(t);
    }

    @Override
    public void onAnimationLeashDestroyed(SurfaceControl.Transaction t) {
        this.reassignLayer(t);
    }

    protected void onAnimationFinished() {
    }

    AnimationAdapter getAnimation() {
        return this.mSurfaceAnimator.getAnimation();
    }

    void startDelayingAnimationStart() {
        this.mSurfaceAnimator.startDelayingAnimationStart();
    }

    void endDelayingAnimationStart() {
        this.mSurfaceAnimator.endDelayingAnimationStart();
    }

    @Override
    public int getSurfaceWidth() {
        return this.mSurfaceControl.getWidth();
    }

    @Override
    public int getSurfaceHeight() {
        return this.mSurfaceControl.getHeight();
    }

    void dump(PrintWriter pw, String prefix, boolean dumpAll) {
        if (this.mSurfaceAnimator.isAnimating()) {
            pw.print(prefix);
            pw.println("ContainerAnimator:");
            this.mSurfaceAnimator.dump(pw, prefix + "  ");
        }
    }

    void updateSurfacePosition() {
        if (this.mSurfaceControl == null) {
            return;
        }
        this.getRelativePosition(this.mTmpPos);
        if (this.mTmpPos.equals(this.mLastSurfacePosition)) {
            return;
        }
        this.getPendingTransaction().setPosition(this.mSurfaceControl, this.mTmpPos.x, this.mTmpPos.y);
        this.mLastSurfacePosition.set(this.mTmpPos.x, this.mTmpPos.y);
    }

    void getRelativePosition(Point outPos) {
        Rect bounds = this.getBounds();
        outPos.set(bounds.left, bounds.top);
        WindowContainer parent = this.getParent();
        if (parent != null) {
            Rect parentBounds = parent.getBounds();
            outPos.offset(-parentBounds.left, -parentBounds.top);
        }
    }

    Dimmer getDimmer() {
        if (this.mParent == null) {
            return null;
        }
        return this.mParent.getDimmer();
    }

    private final class ForAllWindowsConsumerWrapper
    implements ToBooleanFunction<WindowState> {
        private Consumer<WindowState> mConsumer;

        private ForAllWindowsConsumerWrapper() {
        }

        void setConsumer(Consumer<WindowState> consumer) {
            this.mConsumer = consumer;
        }

        @Override
        public boolean apply(WindowState w) {
            this.mConsumer.accept(w);
            return false;
        }

        void release() {
            this.mConsumer = null;
            WindowContainer.this.mConsumerWrapperPool.release(this);
        }
    }
}

