/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.content.res.Configuration;
import com.android.server.wm.ConfigurationContainerListener;
import com.android.server.wm.RootWindowContainer;
import com.android.server.wm.WindowContainer;
import com.android.server.wm.WindowContainerListener;
import com.android.server.wm.WindowHashMap;
import com.android.server.wm.WindowManagerService;

class WindowContainerController<E extends WindowContainer, I extends WindowContainerListener>
implements ConfigurationContainerListener {
    final WindowManagerService mService;
    final RootWindowContainer mRoot;
    final WindowHashMap mWindowMap;
    E mContainer;
    final I mListener;

    WindowContainerController(I listener, WindowManagerService service) {
        this.mListener = listener;
        this.mService = service;
        this.mRoot = this.mService != null ? this.mService.mRoot : null;
        this.mWindowMap = this.mService != null ? this.mService.mWindowMap : null;
    }

    void setContainer(E container) {
        if (this.mContainer != null && container != null) {
            throw new IllegalArgumentException("Can't set container=" + container + " for controller=" + this + " Already set to=" + this.mContainer);
        }
        this.mContainer = container;
        if (this.mContainer != null && this.mListener != null) {
            this.mListener.registerConfigurationChangeListener(this);
        }
    }

    void removeContainer() {
        if (this.mContainer == null) {
            return;
        }
        ((WindowContainer)this.mContainer).setController(null);
        this.mContainer = null;
        if (this.mListener != null) {
            this.mListener.unregisterConfigurationChangeListener(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void onOverrideConfigurationChanged(Configuration overrideConfiguration) {
        block4: {
            WindowHashMap windowHashMap = this.mWindowMap;
            // MONITORENTER : windowHashMap
            try {
                WindowManagerService.boostPriorityForLockedSection();
                if (this.mContainer != null) break block4;
                // MONITOREXIT : windowHashMap
            }
            catch (Throwable throwable) {
                // MONITOREXIT : windowHashMap
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
            WindowManagerService.resetPriorityAfterLockedSection();
            return;
        }
        ((WindowContainer)this.mContainer).onOverrideConfigurationChanged(overrideConfiguration);
        // MONITOREXIT : windowHashMap
        WindowManagerService.resetPriorityAfterLockedSection();
    }
}

