/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.graphics.Rect;
import android.graphics.Region;
import android.os.IBinder;
import android.os.Trace;
import android.util.Slog;
import android.util.proto.ProtoOutputStream;
import android.view.Surface;
import android.view.SurfaceControl;
import android.view.SurfaceSession;
import android.view.WindowContentFrameStats;
import com.android.server.wm.RemoteSurfaceTrace;
import com.android.server.wm.Session;
import com.android.server.wm.WindowManagerService;
import com.android.server.wm.WindowState;
import com.android.server.wm.WindowStateAnimator;
import java.io.FileDescriptor;
import java.io.PrintWriter;

class WindowSurfaceController {
    static final String TAG = "WindowManager";
    final WindowStateAnimator mAnimator;
    SurfaceControl mSurfaceControl;
    private boolean mSurfaceShown = false;
    private float mSurfaceX = 0.0f;
    private float mSurfaceY = 0.0f;
    private int mSurfaceW = 0;
    private int mSurfaceH = 0;
    private float mLastDsdx = 1.0f;
    private float mLastDtdx = 0.0f;
    private float mLastDsdy = 0.0f;
    private float mLastDtdy = 1.0f;
    private float mSurfaceAlpha = 0.0f;
    private int mSurfaceLayer = 0;
    private boolean mHiddenForCrop = false;
    private boolean mHiddenForOtherReasons = true;
    private final String title;
    private final WindowManagerService mService;
    private final int mWindowType;
    private final Session mWindowSession;

    public WindowSurfaceController(SurfaceSession s, String name, int w, int h, int format, int flags, WindowStateAnimator animator2, int windowType, int ownerUid) {
        this.mAnimator = animator2;
        this.mSurfaceW = w;
        this.mSurfaceH = h;
        this.title = name;
        this.mService = animator2.mService;
        WindowState win = animator2.mWin;
        this.mWindowType = windowType;
        this.mWindowSession = win.mSession;
        Trace.traceBegin(32L, "new SurfaceControl");
        SurfaceControl.Builder b = win.makeSurface().setParent(win.getSurfaceControl()).setName(name).setSize(w, h).setFormat(format).setFlags(flags).setMetadata(windowType, ownerUid);
        this.mSurfaceControl = b.build();
        Trace.traceEnd(32L);
        if (this.mService.mRoot.mSurfaceTraceEnabled) {
            this.installRemoteTrace(this.mService.mRoot.mSurfaceTraceFd.getFileDescriptor());
        }
    }

    void installRemoteTrace(FileDescriptor fd) {
        this.mSurfaceControl = new RemoteSurfaceTrace(fd, this.mSurfaceControl, this.mAnimator.mWin);
    }

    void removeRemoteTrace() {
        this.mSurfaceControl = new SurfaceControl(this.mSurfaceControl);
    }

    private void logSurface(String msg, RuntimeException where) {
        String str = "  SURFACE " + msg + ": " + this.title;
        if (where != null) {
            Slog.i(TAG, str, where);
        } else {
            Slog.i(TAG, str);
        }
    }

    void reparentChildrenInTransaction(WindowSurfaceController other) {
        if (this.mSurfaceControl != null && other.mSurfaceControl != null) {
            this.mSurfaceControl.reparentChildren(other.getHandle());
        }
    }

    void detachChildren() {
        if (this.mSurfaceControl != null) {
            this.mSurfaceControl.detachChildren();
        }
    }

    void hideInTransaction(String reason) {
        this.mHiddenForOtherReasons = true;
        this.mAnimator.destroyPreservedSurfaceLocked();
        this.updateVisibility();
    }

    private void hideSurface() {
        if (this.mSurfaceControl == null) {
            return;
        }
        this.setShown(false);
        try {
            this.mSurfaceControl.hide();
        }
        catch (RuntimeException e) {
            Slog.w(TAG, "Exception hiding surface in " + this);
        }
    }

    void destroyNotInTransaction() {
        try {
            if (this.mSurfaceControl != null) {
                this.mSurfaceControl.destroy();
            }
        }
        catch (RuntimeException e) {
            Slog.w(TAG, "Error destroying surface in: " + this, e);
        }
        finally {
            this.setShown(false);
            this.mSurfaceControl = null;
        }
    }

    void disconnectInTransaction() {
        try {
            if (this.mSurfaceControl != null) {
                this.mSurfaceControl.disconnect();
            }
        }
        catch (RuntimeException e) {
            Slog.w(TAG, "Error disconnecting surface in: " + this, e);
        }
    }

    void setCropInTransaction(Rect clipRect, boolean recoveringMemory) {
        block4: {
            try {
                if (clipRect.width() > 0 && clipRect.height() > 0) {
                    this.mSurfaceControl.setWindowCrop(clipRect);
                    this.mHiddenForCrop = false;
                    this.updateVisibility();
                } else {
                    this.mHiddenForCrop = true;
                    this.mAnimator.destroyPreservedSurfaceLocked();
                    this.updateVisibility();
                }
            }
            catch (RuntimeException e) {
                Slog.w(TAG, "Error setting crop surface of " + this + " crop=" + clipRect.toShortString(), e);
                if (recoveringMemory) break block4;
                this.mAnimator.reclaimSomeSurfaceMemory("crop", true);
            }
        }
    }

    void clearCropInTransaction(boolean recoveringMemory) {
        block2: {
            try {
                Rect clipRect = new Rect(0, 0, -1, -1);
                this.mSurfaceControl.setWindowCrop(clipRect);
            }
            catch (RuntimeException e) {
                Slog.w(TAG, "Error setting clearing crop of " + this, e);
                if (recoveringMemory) break block2;
                this.mAnimator.reclaimSomeSurfaceMemory("crop", true);
            }
        }
    }

    void setFinalCropInTransaction(Rect clipRect) {
        try {
            this.mSurfaceControl.setFinalCrop(clipRect);
        }
        catch (RuntimeException e) {
            Slog.w(TAG, "Error disconnecting surface in: " + this, e);
        }
    }

    void setLayerStackInTransaction(int layerStack) {
        if (this.mSurfaceControl != null) {
            this.mSurfaceControl.setLayerStack(layerStack);
        }
    }

    void setPositionInTransaction(float left, float top, boolean recoveringMemory) {
        block3: {
            boolean surfaceMoved;
            boolean bl = surfaceMoved = this.mSurfaceX != left || this.mSurfaceY != top;
            if (surfaceMoved) {
                this.mSurfaceX = left;
                this.mSurfaceY = top;
                try {
                    this.mSurfaceControl.setPosition(left, top);
                }
                catch (RuntimeException e) {
                    Slog.w(TAG, "Error positioning surface of " + this + " pos=(" + left + "," + top + ")", e);
                    if (recoveringMemory) break block3;
                    this.mAnimator.reclaimSomeSurfaceMemory("position", true);
                }
            }
        }
    }

    void setGeometryAppliesWithResizeInTransaction(boolean recoveringMemory) {
        this.mSurfaceControl.setGeometryAppliesWithResize();
    }

    void setMatrixInTransaction(float dsdx, float dtdx, float dtdy, float dsdy, boolean recoveringMemory) {
        block3: {
            boolean matrixChanged;
            boolean bl = matrixChanged = this.mLastDsdx != dsdx || this.mLastDtdx != dtdx || this.mLastDtdy != dtdy || this.mLastDsdy != dsdy;
            if (!matrixChanged) {
                return;
            }
            this.mLastDsdx = dsdx;
            this.mLastDtdx = dtdx;
            this.mLastDtdy = dtdy;
            this.mLastDsdy = dsdy;
            try {
                this.mSurfaceControl.setMatrix(dsdx, dtdx, dtdy, dsdy);
            }
            catch (RuntimeException e) {
                Slog.e(TAG, "Error setting matrix on surface surface" + this.title + " MATRIX [" + dsdx + "," + dtdx + "," + dtdy + "," + dsdy + "]", null);
                if (recoveringMemory) break block3;
                this.mAnimator.reclaimSomeSurfaceMemory("matrix", true);
            }
        }
    }

    boolean setSizeInTransaction(int width, int height, boolean recoveringMemory) {
        boolean surfaceResized;
        boolean bl = surfaceResized = this.mSurfaceW != width || this.mSurfaceH != height;
        if (surfaceResized) {
            this.mSurfaceW = width;
            this.mSurfaceH = height;
            try {
                this.mSurfaceControl.setSize(width, height);
            }
            catch (RuntimeException e) {
                Slog.e(TAG, "Error resizing surface of " + this.title + " size=(" + width + "x" + height + ")", e);
                if (!recoveringMemory) {
                    this.mAnimator.reclaimSomeSurfaceMemory("size", true);
                }
                return false;
            }
            return true;
        }
        return false;
    }

    boolean prepareToShowInTransaction(float alpha, float dsdx, float dtdx, float dsdy, float dtdy, boolean recoveringMemory) {
        if (this.mSurfaceControl != null) {
            try {
                this.mSurfaceAlpha = alpha;
                this.mSurfaceControl.setAlpha(alpha);
                this.mLastDsdx = dsdx;
                this.mLastDtdx = dtdx;
                this.mLastDsdy = dsdy;
                this.mLastDtdy = dtdy;
                this.mSurfaceControl.setMatrix(dsdx, dtdx, dsdy, dtdy);
            }
            catch (RuntimeException e) {
                Slog.w(TAG, "Error updating surface in " + this.title, e);
                if (!recoveringMemory) {
                    this.mAnimator.reclaimSomeSurfaceMemory("update", true);
                }
                return false;
            }
        }
        return true;
    }

    void setTransparentRegionHint(Region region) {
        if (this.mSurfaceControl == null) {
            Slog.w(TAG, "setTransparentRegionHint: null mSurface after mHasSurface true");
            return;
        }
        this.mService.openSurfaceTransaction();
        try {
            this.mSurfaceControl.setTransparentRegionHint(region);
        }
        finally {
            this.mService.closeSurfaceTransaction("setTransparentRegion");
        }
    }

    void setOpaque(boolean isOpaque) {
        if (this.mSurfaceControl == null) {
            return;
        }
        this.mService.openSurfaceTransaction();
        try {
            this.mSurfaceControl.setOpaque(isOpaque);
        }
        finally {
            this.mService.closeSurfaceTransaction("setOpaqueLocked");
        }
    }

    void setSecure(boolean isSecure) {
        if (this.mSurfaceControl == null) {
            return;
        }
        this.mService.openSurfaceTransaction();
        try {
            this.mSurfaceControl.setSecure(isSecure);
        }
        finally {
            this.mService.closeSurfaceTransaction("setSecure");
        }
    }

    void getContainerRect(Rect rect) {
        this.mAnimator.getContainerRect(rect);
    }

    boolean showRobustlyInTransaction() {
        this.mHiddenForOtherReasons = false;
        return this.updateVisibility();
    }

    private boolean updateVisibility() {
        if (this.mHiddenForCrop || this.mHiddenForOtherReasons) {
            if (this.mSurfaceShown) {
                this.hideSurface();
            }
            return false;
        }
        if (!this.mSurfaceShown) {
            return this.showSurface();
        }
        return true;
    }

    private boolean showSurface() {
        try {
            this.setShown(true);
            this.mSurfaceControl.show();
            return true;
        }
        catch (RuntimeException e) {
            Slog.w(TAG, "Failure showing surface " + this.mSurfaceControl + " in " + this, e);
            this.mAnimator.reclaimSomeSurfaceMemory("show", true);
            return false;
        }
    }

    void deferTransactionUntil(IBinder handle, long frame) {
        this.mSurfaceControl.deferTransactionUntil(handle, frame);
    }

    void forceScaleableInTransaction(boolean force) {
        int scalingMode = force ? 1 : -1;
        this.mSurfaceControl.setOverrideScalingMode(scalingMode);
    }

    boolean clearWindowContentFrameStats() {
        if (this.mSurfaceControl == null) {
            return false;
        }
        return this.mSurfaceControl.clearContentFrameStats();
    }

    boolean getWindowContentFrameStats(WindowContentFrameStats outStats) {
        if (this.mSurfaceControl == null) {
            return false;
        }
        return this.mSurfaceControl.getContentFrameStats(outStats);
    }

    boolean hasSurface() {
        return this.mSurfaceControl != null;
    }

    IBinder getHandle() {
        if (this.mSurfaceControl == null) {
            return null;
        }
        return this.mSurfaceControl.getHandle();
    }

    void getSurface(Surface outSurface) {
        outSurface.copyFrom(this.mSurfaceControl);
    }

    int getLayer() {
        return this.mSurfaceLayer;
    }

    boolean getShown() {
        return this.mSurfaceShown;
    }

    void setShown(boolean surfaceShown) {
        this.mSurfaceShown = surfaceShown;
        this.mService.updateNonSystemOverlayWindowsVisibilityIfNeeded(this.mAnimator.mWin, surfaceShown);
        if (this.mWindowSession != null) {
            this.mWindowSession.onWindowSurfaceVisibilityChanged(this, this.mSurfaceShown, this.mWindowType);
        }
    }

    float getX() {
        return this.mSurfaceX;
    }

    float getY() {
        return this.mSurfaceY;
    }

    int getWidth() {
        return this.mSurfaceW;
    }

    int getHeight() {
        return this.mSurfaceH;
    }

    void writeToProto(ProtoOutputStream proto, long fieldId) {
        long token = proto.start(fieldId);
        proto.write(0x10800000001L, this.mSurfaceShown);
        proto.write(1120986464258L, this.mSurfaceLayer);
        proto.end(token);
    }

    public void dump(PrintWriter pw, String prefix, boolean dumpAll) {
        if (dumpAll) {
            pw.print(prefix);
            pw.print("mSurface=");
            pw.println(this.mSurfaceControl);
        }
        pw.print(prefix);
        pw.print("Surface: shown=");
        pw.print(this.mSurfaceShown);
        pw.print(" layer=");
        pw.print(this.mSurfaceLayer);
        pw.print(" alpha=");
        pw.print(this.mSurfaceAlpha);
        pw.print(" rect=(");
        pw.print(this.mSurfaceX);
        pw.print(",");
        pw.print(this.mSurfaceY);
        pw.print(") ");
        pw.print(this.mSurfaceW);
        pw.print(" x ");
        pw.print(this.mSurfaceH);
        pw.print(" transform=(");
        pw.print(this.mLastDsdx);
        pw.print(", ");
        pw.print(this.mLastDtdx);
        pw.print(", ");
        pw.print(this.mLastDsdy);
        pw.print(", ");
        pw.print(this.mLastDtdy);
        pw.println(")");
    }

    public String toString() {
        return this.mSurfaceControl.toString();
    }
}

