/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.os.IBinder;
import android.util.proto.ProtoOutputStream;
import com.android.server.wm.AppWindowToken;
import com.android.server.wm.DisplayContent;
import com.android.server.wm.WindowContainer;
import com.android.server.wm.WindowManagerService;
import com.android.server.wm.WindowState;
import java.io.PrintWriter;
import java.util.Comparator;

class WindowToken
extends WindowContainer<WindowState> {
    private static final String TAG = "WindowManager";
    final IBinder token;
    final int windowType;
    boolean mPersistOnEmpty;
    String stringName;
    boolean paused = false;
    private boolean mHidden;
    boolean hasVisible;
    boolean waitingToShow;
    boolean sendingToBottom;
    protected DisplayContent mDisplayContent;
    final boolean mOwnerCanManageAppTokens;
    private final Comparator<WindowState> mWindowComparator = (newWindow, existingWindow) -> {
        WindowToken token = this;
        if (newWindow.mToken != token) {
            throw new IllegalArgumentException("newWindow=" + newWindow + " is not a child of token=" + token);
        }
        if (existingWindow.mToken != token) {
            throw new IllegalArgumentException("existingWindow=" + existingWindow + " is not a child of token=" + token);
        }
        return this.isFirstChildWindowGreaterThanSecond((WindowState)newWindow, (WindowState)existingWindow) ? 1 : -1;
    };

    WindowToken(WindowManagerService service, IBinder _token, int type, boolean persistOnEmpty, DisplayContent dc, boolean ownerCanManageAppTokens) {
        super(service);
        this.token = _token;
        this.windowType = type;
        this.mPersistOnEmpty = persistOnEmpty;
        this.mOwnerCanManageAppTokens = ownerCanManageAppTokens;
        this.onDisplayChanged(dc);
    }

    void setHidden(boolean hidden) {
        if (hidden != this.mHidden) {
            this.mHidden = hidden;
        }
    }

    boolean isHidden() {
        return this.mHidden;
    }

    void removeAllWindowsIfPossible() {
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            WindowState win = (WindowState)this.mChildren.get(i);
            win.removeIfPossible();
        }
    }

    void setExiting() {
        if (this.mChildren.size() == 0) {
            super.removeImmediately();
            return;
        }
        this.mPersistOnEmpty = false;
        if (this.mHidden) {
            return;
        }
        int count = this.mChildren.size();
        boolean changed = false;
        boolean delayed = false;
        for (int i = 0; i < count; ++i) {
            WindowState win = (WindowState)this.mChildren.get(i);
            if (win.mWinAnimator.isAnimationSet()) {
                delayed = true;
            }
            changed |= win.onSetAppExiting();
        }
        this.setHidden(true);
        if (changed) {
            this.mService.mWindowPlacerLocked.performSurfacePlacement();
            this.mService.updateFocusedWindowLocked(0, false);
        }
        if (delayed) {
            this.mDisplayContent.mExitingTokens.add(this);
        }
    }

    protected boolean isFirstChildWindowGreaterThanSecond(WindowState newWindow, WindowState existingWindow) {
        return newWindow.mBaseLayer >= existingWindow.mBaseLayer;
    }

    void addWindow(WindowState win) {
        if (win.isChildWindow()) {
            return;
        }
        if (!this.mChildren.contains(win)) {
            this.addChild(win, this.mWindowComparator);
            this.mService.mWindowsChanged = true;
        }
    }

    boolean isEmpty() {
        return this.mChildren.isEmpty();
    }

    WindowState getReplacingWindow() {
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            WindowState win = (WindowState)this.mChildren.get(i);
            WindowState replacing = win.getReplacingWindow();
            if (replacing == null) continue;
            return replacing;
        }
        return null;
    }

    boolean windowsCanBeWallpaperTarget() {
        for (int j = this.mChildren.size() - 1; j >= 0; --j) {
            WindowState w = (WindowState)this.mChildren.get(j);
            if ((w.mAttrs.flags & 0x100000) == 0) continue;
            return true;
        }
        return false;
    }

    int getHighestAnimLayer() {
        int highest = -1;
        for (int j = 0; j < this.mChildren.size(); ++j) {
            WindowState w = (WindowState)this.mChildren.get(j);
            int wLayer = w.getHighestAnimLayer();
            if (wLayer <= highest) continue;
            highest = wLayer;
        }
        return highest;
    }

    AppWindowToken asAppWindowToken() {
        return null;
    }

    DisplayContent getDisplayContent() {
        return this.mDisplayContent;
    }

    @Override
    void removeImmediately() {
        if (this.mDisplayContent != null) {
            this.mDisplayContent.removeWindowToken(this.token);
        }
        super.removeImmediately();
    }

    @Override
    void onDisplayChanged(DisplayContent dc) {
        dc.reParentWindowToken(this);
        this.mDisplayContent = dc;
        super.onDisplayChanged(dc);
    }

    @Override
    public void writeToProto(ProtoOutputStream proto, long fieldId, boolean trim) {
        long token = proto.start(fieldId);
        super.writeToProto(proto, 0x10B00000001L, trim);
        proto.write(1120986464258L, System.identityHashCode(this));
        for (int i = 0; i < this.mChildren.size(); ++i) {
            WindowState w = (WindowState)this.mChildren.get(i);
            w.writeToProto(proto, 2246267895811L, trim);
        }
        proto.write(1133871366148L, this.mHidden);
        proto.write(1133871366149L, this.waitingToShow);
        proto.write(1133871366150L, this.paused);
        proto.end(token);
    }

    @Override
    void dump(PrintWriter pw, String prefix, boolean dumpAll) {
        super.dump(pw, prefix, dumpAll);
        pw.print(prefix);
        pw.print("windows=");
        pw.println(this.mChildren);
        pw.print(prefix);
        pw.print("windowType=");
        pw.print(this.windowType);
        pw.print(" hidden=");
        pw.print(this.mHidden);
        pw.print(" hasVisible=");
        pw.println(this.hasVisible);
        if (this.waitingToShow || this.sendingToBottom) {
            pw.print(prefix);
            pw.print("waitingToShow=");
            pw.print(this.waitingToShow);
            pw.print(" sendingToBottom=");
            pw.print(this.sendingToBottom);
        }
    }

    public String toString() {
        if (this.stringName == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("WindowToken{");
            sb.append(Integer.toHexString(System.identityHashCode(this)));
            sb.append(" ");
            sb.append(this.token);
            sb.append('}');
            this.stringName = sb.toString();
        }
        return this.stringName;
    }

    @Override
    String getName() {
        return this.toString();
    }

    boolean okToDisplay() {
        return this.mDisplayContent != null && this.mDisplayContent.okToDisplay();
    }

    boolean okToAnimate() {
        return this.mDisplayContent != null && this.mDisplayContent.okToAnimate();
    }
}

