/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.rappor;

import com.google.android.rappor.HmacDrbg;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.BitSet;
import java.util.Random;

public class Encoder {
    public static final long VERSION = 3L;
    public static final int MIN_USER_SECRET_BYTES = 48;
    public static final int MAX_BITS = 4096;
    public static final int MAX_BLOOM_HASHES = 8;
    public static final int MAX_COHORTS = 128;
    private static final byte HMAC_DRBG_TYPE_COHORT = 0;
    private static final byte HMAC_DRBG_TYPE_PRR = 1;
    private final byte[] encoderIdBytes;
    private final double probabilityF;
    private final double probabilityP;
    private final double probabilityQ;
    private final int numBits;
    private final int numBloomHashes;
    private final int numCohorts;
    private final int cohort;
    private final BitSet inputMask;
    private final MessageDigest sha256;
    private final MessageDigest md5;
    private final Random random;
    private final byte[] userSecret;

    public Encoder(byte[] userSecret, String encoderId, int numBits, double probabilityF, double probabilityP, double probabilityQ, int numCohorts, int numBloomHashes) {
        this(null, null, null, userSecret, encoderId, numBits, probabilityF, probabilityP, probabilityQ, numCohorts, numBloomHashes);
    }

    public Encoder(Random random, MessageDigest md5, MessageDigest sha256, byte[] userSecret, String encoderId, int numBits, double probabilityF, double probabilityP, double probabilityQ, int numCohorts, int numBloomHashes) {
        if (md5 != null) {
            this.md5 = md5;
        } else {
            try {
                this.md5 = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException impossible) {
                throw new AssertionError((Object)impossible);
            }
        }
        this.md5.reset();
        if (sha256 != null) {
            this.sha256 = sha256;
        } else {
            try {
                this.sha256 = MessageDigest.getInstance("SHA-256");
            }
            catch (NoSuchAlgorithmException impossible) {
                throw new AssertionError((Object)impossible);
            }
        }
        this.sha256.reset();
        this.encoderIdBytes = encoderId.getBytes(StandardCharsets.UTF_8);
        this.random = random != null ? random : new SecureRandom();
        Encoder.checkArgument(userSecret.length >= 48, "userSecret must be at least 48 bytes of high-quality entropy.");
        this.userSecret = userSecret;
        Encoder.checkArgument(probabilityF >= 0.0 && probabilityF <= 1.0, "probabilityF must be on range [0.0, 1.0]");
        this.probabilityF = (double)Math.round(probabilityF * 128.0) / 128.0;
        Encoder.checkArgument(probabilityP >= 0.0 && probabilityP <= 1.0, "probabilityP must be on range [0.0, 1.0]");
        this.probabilityP = probabilityP;
        Encoder.checkArgument(probabilityQ >= 0.0 && probabilityQ <= 1.0, "probabilityQ must be on range [0.0, 1.0]");
        this.probabilityQ = probabilityQ;
        Encoder.checkArgument(numBits >= 1 && numBits <= 4096, "numBits must be on range [1, 4096].");
        this.numBits = numBits;
        this.inputMask = new BitSet(numBits);
        this.inputMask.set(0, numBits, true);
        Encoder.checkArgument(numBloomHashes >= 1 && numBloomHashes <= numBits, "numBloomHashes must be on range [1, numBits).");
        this.numBloomHashes = numBloomHashes;
        Encoder.checkArgument(numCohorts >= 1 && numCohorts <= 128, "numCohorts must be on range [1, 128].");
        boolean numCohortsIsPowerOfTwo = (numCohorts & numCohorts - 1) == 0;
        Encoder.checkArgument(numCohortsIsPowerOfTwo, "numCohorts must be a power of 2.");
        this.numCohorts = numCohorts;
        HmacDrbg cohortDrbg = new HmacDrbg(userSecret, new byte[]{0});
        ByteBuffer cohortDrbgBytes = ByteBuffer.wrap(cohortDrbg.nextBytes(4));
        int cohortMasterAssignment = Math.abs(cohortDrbgBytes.getInt()) % 128;
        this.cohort = cohortMasterAssignment & numCohorts - 1;
    }

    public double getProbabilityF() {
        return this.probabilityF;
    }

    public double getProbabilityP() {
        return this.probabilityP;
    }

    public double getProbabilityQ() {
        return this.probabilityQ;
    }

    public int getNumBits() {
        return this.numBits;
    }

    public int getNumBloomHashes() {
        return this.numBloomHashes;
    }

    public int getNumCohorts() {
        return this.numCohorts;
    }

    public int getCohort() {
        return this.cohort;
    }

    public String getEncoderId() {
        return new String(this.encoderIdBytes, StandardCharsets.UTF_8);
    }

    public byte[] encodeBoolean(boolean bool2) {
        BitSet input = new BitSet(this.numBits);
        input.set(0, bool2);
        return this.encodeBits(input);
    }

    public byte[] encodeOrdinal(int ordinal) {
        Encoder.checkArgument(ordinal >= 0 && ordinal < this.numBits, "Ordinal value must be in range [0, numBits).");
        BitSet input = new BitSet(this.numBits);
        input.set(ordinal, true);
        return this.encodeBits(input);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] encodeString(String string2) {
        byte[] digest;
        byte[] stringInUtf8 = string2.getBytes(StandardCharsets.UTF_8);
        byte[] message = ByteBuffer.allocate(4 + stringInUtf8.length).putInt(this.cohort).put(stringInUtf8).array();
        Encoder encoder = this;
        synchronized (encoder) {
            this.md5.reset();
            digest = this.md5.digest(message);
        }
        Encoder.verify(digest.length == 16);
        Encoder.verify(this.numBloomHashes <= digest.length / 2);
        BitSet input = new BitSet(this.numBits);
        for (int i = 0; i < this.numBloomHashes; ++i) {
            int digestWord = (digest[i * 2] & 0xFF) * 256 + (digest[i * 2 + 1] & 0xFF);
            int chosenBit = digestWord % this.numBits;
            input.set(chosenBit, true);
        }
        return this.encodeBits(input);
    }

    public byte[] encodeBits(byte[] bits) {
        return this.encodeBits(BitSet.valueOf(bits));
    }

    private byte[] encodeBits(BitSet bits) {
        byte[] output;
        BitSet permanentRandomizedResponse = this.computePermanentRandomizedResponse(bits);
        BitSet encodedBitSet = this.computeInstantaneousRandomizedResponse(permanentRandomizedResponse);
        byte[] encodedBytes = encodedBitSet.toByteArray();
        Encoder.verify(encodedBytes.length <= (output = new byte[(this.numBits + 7) / 8]).length);
        System.arraycopy((byte[])encodedBytes, (int)0, (byte[])output, (int)0, (int)encodedBytes.length);
        return output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BitSet computePermanentRandomizedResponse(BitSet bits) {
        byte[] personalizationString;
        BitSet masked = new BitSet();
        masked.or(bits);
        masked.andNot(this.inputMask);
        Encoder.checkArgument(masked.isEmpty(), "Input bits had bits set past Encoder's numBits limit.");
        if (this.probabilityF == 0.0) {
            return bits;
        }
        Encoder encoder = this;
        synchronized (encoder) {
            int personalizationStringLength = Math.min(20, 1 + this.sha256.getDigestLength());
            personalizationString = new byte[personalizationStringLength];
            personalizationString[0] = 1;
            this.sha256.reset();
            this.sha256.update(this.encoderIdBytes);
            this.sha256.update(new byte[]{0});
            this.sha256.update(bits.toByteArray());
            byte[] digest = this.sha256.digest(personalizationString);
            System.arraycopy((byte[])digest, (int)0, (byte[])personalizationString, (int)1, (int)(personalizationString.length - 1));
        }
        HmacDrbg drbg = new HmacDrbg(this.userSecret, personalizationString);
        byte[] pseudorandomStream = drbg.nextBytes(this.numBits);
        Encoder.verify(this.numBits <= pseudorandomStream.length);
        int probabilityFTimes128 = (int)Math.round(this.probabilityF * 128.0);
        BitSet result = new BitSet(this.numBits);
        for (int i = 0; i < this.numBits; ++i) {
            boolean shouldUseNoise;
            int pseudorandomByte = pseudorandomStream[i] & 0xFF;
            int uniform0to127 = pseudorandomByte >> 1;
            boolean bl = shouldUseNoise = uniform0to127 < probabilityFTimes128;
            if (shouldUseNoise) {
                result.set(i, (pseudorandomByte & 1) > 0);
                continue;
            }
            result.set(i, bits.get(i));
        }
        return result;
    }

    private BitSet computeInstantaneousRandomizedResponse(BitSet bits) {
        BitSet masked = new BitSet();
        masked.or(bits);
        masked.andNot(this.inputMask);
        Encoder.checkArgument(masked.isEmpty(), "Input bits had bits set past Encoder's numBits limit.");
        if (this.probabilityP == 0.0 && this.probabilityQ == 1.0) {
            return bits;
        }
        BitSet response = new BitSet(this.numBits);
        for (int i = 0; i < this.numBits; ++i) {
            boolean bit = bits.get(i);
            double probability = bit ? this.probabilityQ : this.probabilityP;
            boolean responseBit = (double)this.random.nextFloat() < probability;
            response.set(i, responseBit);
        }
        return response;
    }

    private static void checkArgument(boolean expression, Object errorMessage) {
        if (!expression) {
            throw new IllegalArgumentException(String.valueOf(errorMessage));
        }
    }

    private static void verify(boolean expression) {
        if (!expression) {
            throw new IllegalStateException();
        }
    }
}

