/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.rappor;

import java.security.SecureRandom;
import java.util.Arrays;
import javax.annotation.concurrent.NotThreadSafe;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

@NotThreadSafe
public class HmacDrbg {
    private byte[] value;
    private Mac hmac;
    private int bytesGenerated;
    public static final int SECURITY_STRENGTH = 256;
    public static final int MAX_PERSONALIZATION_STRING_LENGTH_BYTES = 20;
    public static final int ENTROPY_INPUT_SIZE_BYTES = 48;
    public static final int MAX_BYTES_TOTAL = 10000;
    private static final int DIGEST_NUM_BYTES = 32;
    private static final int MAX_BYTES_PER_REQUEST = 937;
    private static final byte[] BYTE_ARRAY_0 = new byte[]{0};
    private static final byte[] BYTE_ARRAY_1 = new byte[]{1};

    public HmacDrbg(byte[] entropyInput, byte[] personalizationString) {
        byte[] seedMaterial = HmacDrbg.bytesConcat(entropyInput, HmacDrbg.emptyIfNull(personalizationString));
        this.setKey(new byte[32]);
        this.value = new byte[32];
        Arrays.fill(this.value, (byte)1);
        this.hmacDrbgUpdate(seedMaterial);
        this.bytesGenerated = 0;
    }

    private static byte[] emptyIfNull(byte[] b) {
        return b == null ? new byte[]{} : b;
    }

    private void setKey(byte[] key) {
        try {
            this.hmac = Mac.getInstance("HmacSHA256");
            SecretKeySpec secretKey = new SecretKeySpec(key, "HmacSHA256");
            this.hmac.init(secretKey);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private byte[] hash(byte[] x) {
        try {
            return this.hmac.doFinal(x);
        }
        catch (Exception e) {
            return null;
        }
    }

    private void hmacDrbgUpdate(byte[] providedData) {
        this.setKey(this.hash(HmacDrbg.bytesConcat(this.value, BYTE_ARRAY_0, HmacDrbg.emptyIfNull(providedData))));
        this.value = this.hash(this.value);
        if (providedData == null) {
            return;
        }
        this.setKey(this.hash(HmacDrbg.bytesConcat(this.value, BYTE_ARRAY_1, providedData)));
        this.value = this.hash(this.value);
    }

    private void hmacDrbgGenerate(byte[] out, int start, int count) {
        int bytesToWrite;
        for (int bytesWritten = 0; bytesWritten < count; bytesWritten += bytesToWrite) {
            this.value = this.hash(this.value);
            bytesToWrite = Math.min(count - bytesWritten, 32);
            System.arraycopy((byte[])this.value, (int)0, (byte[])out, (int)(start + bytesWritten), (int)bytesToWrite);
        }
        this.hmacDrbgUpdate(null);
    }

    public static byte[] generateEntropyInput() {
        byte[] result = new byte[48];
        new SecureRandom().nextBytes(result);
        return result;
    }

    public byte[] nextBytes(int length) {
        byte[] result = new byte[length];
        this.nextBytes(result);
        return result;
    }

    public void nextBytes(byte[] out) {
        this.nextBytes(out, 0, out.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nextBytes(byte[] out, int start, int count) {
        if (count == 0) {
            return;
        }
        if (this.bytesGenerated + count > 10000) {
            throw new IllegalStateException("Cannot generate more than a total of " + count + " bytes.");
        }
        try {
            int bytesToWrite;
            for (int bytesWritten = 0; bytesWritten < count; bytesWritten += bytesToWrite) {
                bytesToWrite = Math.min(count - bytesWritten, 937);
                this.hmacDrbgGenerate(out, start + bytesWritten, bytesToWrite);
            }
        }
        finally {
            this.bytesGenerated += count;
        }
    }

    private static byte[] bytesConcat(byte[] ... arrays) {
        int length = 0;
        for (byte[] array2 : arrays) {
            length += array2.length;
        }
        byte[] result = new byte[length];
        int pos = 0;
        for (byte[] array3 : arrays) {
            System.arraycopy((byte[])array3, (int)0, (byte[])result, (int)pos, (int)array3.length);
            pos += array3.length;
        }
        return result;
    }
}

