/*
 * Decompiled with CFR 0.152.
 */
package libcore.reflect;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import libcore.reflect.ParameterizedTypeImpl;
import libcore.util.EmptyArray;

public final class ListOfTypes {
    public static final ListOfTypes EMPTY = new ListOfTypes(0);
    private final ArrayList<Type> types;
    private Type[] resolvedTypes;

    ListOfTypes(int capacity) {
        this.types = new ArrayList(capacity);
    }

    ListOfTypes(Type[] types) {
        this.types = new ArrayList(types.length);
        for (Type type : types) {
            this.types.add(type);
        }
    }

    void add(Type type) {
        if (type == null) {
            throw new NullPointerException("type == null");
        }
        this.types.add(type);
    }

    int length() {
        return this.types.size();
    }

    public Type[] getResolvedTypes() {
        Type[] result = this.resolvedTypes;
        if (result == null) {
            result = this.resolveTypes(this.types);
            this.resolvedTypes = result;
        }
        return result;
    }

    private Type[] resolveTypes(List<Type> unresolved) {
        int size = unresolved.size();
        if (size == 0) {
            return EmptyArray.TYPE;
        }
        Type[] result = new Type[size];
        for (int i = 0; i < size; ++i) {
            Type type = unresolved.get(i);
            result[i] = type instanceof ParameterizedTypeImpl ? ((ParameterizedTypeImpl)type).getResolvedType() : type;
        }
        return result;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < this.types.size(); ++i) {
            if (i > 0) {
                result.append(", ");
            }
            result.append(this.types.get(i));
        }
        return result.toString();
    }
}

