/*
 * Decompiled with CFR 0.152.
 */
package libcore.util;

import android.icu.util.TimeZone;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import libcore.util.CountryTimeZones;
import libcore.util.TimeZoneDataFiles;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class TimeZoneFinder {
    private static final String TZLOOKUP_FILE_NAME = "tzlookup.xml";
    private static final String TIMEZONES_ELEMENT = "timezones";
    private static final String IANA_VERSION_ATTRIBUTE = "ianaversion";
    private static final String COUNTRY_ZONES_ELEMENT = "countryzones";
    private static final String COUNTRY_ELEMENT = "country";
    private static final String COUNTRY_CODE_ATTRIBUTE = "code";
    private static final String DEFAULT_TIME_ZONE_ID_ATTRIBUTE = "default";
    private static final String EVER_USES_UTC_ATTRIBUTE = "everutc";
    private static final String ID_ELEMENT = "id";
    private static TimeZoneFinder instance;
    private final ReaderSupplier xmlSource;
    private CountryTimeZones lastCountryTimeZones;

    private TimeZoneFinder(ReaderSupplier xmlSource) {
        this.xmlSource = xmlSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TimeZoneFinder getInstance() {
        Class<TimeZoneFinder> clazz = TimeZoneFinder.class;
        synchronized (TimeZoneFinder.class) {
            if (instance == null) {
                String[] tzLookupFilePaths = TimeZoneDataFiles.getTimeZoneFilePaths(TZLOOKUP_FILE_NAME);
                instance = TimeZoneFinder.createInstanceWithFallback(tzLookupFilePaths[0], tzLookupFilePaths[1]);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public static TimeZoneFinder createInstanceWithFallback(String ... tzLookupFilePaths) {
        IOException lastException = null;
        for (String tzLookupFilePath : tzLookupFilePaths) {
            try {
                return TimeZoneFinder.createInstance(tzLookupFilePath);
            }
            catch (IOException e) {
                if (lastException != null) {
                    e.addSuppressed(lastException);
                }
                lastException = e;
            }
        }
        System.logE((String)("No valid file found in set: " + Arrays.toString(tzLookupFilePaths) + " Printing exceptions and falling back to empty map."), (Throwable)lastException);
        return TimeZoneFinder.createInstanceForTests("<timezones><countryzones /></timezones>");
    }

    public static TimeZoneFinder createInstance(String path) throws IOException {
        ReaderSupplier xmlSupplier = ReaderSupplier.forFile(path, StandardCharsets.UTF_8);
        return new TimeZoneFinder(xmlSupplier);
    }

    public static TimeZoneFinder createInstanceForTests(String xml2) {
        return new TimeZoneFinder(ReaderSupplier.forString(xml2));
    }

    public void validate() throws IOException {
        try {
            this.processXml(new CountryZonesValidator());
        }
        catch (XmlPullParserException e) {
            throw new IOException("Parsing error", e);
        }
    }

    public String getIanaVersion() {
        String string2;
        block8: {
            Reader reader = this.xmlSource.get();
            Throwable throwable = null;
            try {
                XmlPullParserFactory xmlPullParserFactory = XmlPullParserFactory.newInstance();
                xmlPullParserFactory.setNamespaceAware(false);
                XmlPullParser parser = xmlPullParserFactory.newPullParser();
                parser.setInput(reader);
                TimeZoneFinder.findRequiredStartTag(parser, TIMEZONES_ELEMENT);
                string2 = parser.getAttributeValue(null, IANA_VERSION_ATTRIBUTE);
                if (reader == null) break block8;
            }
            catch (Throwable throwable2) {
                try {
                    try {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (reader != null) {
                            TimeZoneFinder.$closeResource(throwable, reader);
                        }
                        throw throwable3;
                    }
                }
                catch (IOException | XmlPullParserException e) {
                    return null;
                }
            }
            TimeZoneFinder.$closeResource(throwable, reader);
        }
        return string2;
    }

    public TimeZone lookupTimeZoneByCountryAndOffset(String countryIso, int offsetMillis, boolean isDst, long whenMillis, TimeZone bias) {
        CountryTimeZones countryTimeZones = this.lookupCountryTimeZones(countryIso);
        if (countryTimeZones == null) {
            return null;
        }
        CountryTimeZones.OffsetResult offsetResult = countryTimeZones.lookupByOffsetWithBias(offsetMillis, isDst, whenMillis, bias);
        return offsetResult != null ? offsetResult.mTimeZone : null;
    }

    public String lookupDefaultTimeZoneIdByCountry(String countryIso) {
        CountryTimeZones countryTimeZones = this.lookupCountryTimeZones(countryIso);
        return countryTimeZones == null ? null : countryTimeZones.getDefaultTimeZoneId();
    }

    public List<TimeZone> lookupTimeZonesByCountry(String countryIso) {
        CountryTimeZones countryTimeZones = this.lookupCountryTimeZones(countryIso);
        return countryTimeZones == null ? null : countryTimeZones.getIcuTimeZones();
    }

    public List<String> lookupTimeZoneIdsByCountry(String countryIso) {
        CountryTimeZones countryTimeZones = this.lookupCountryTimeZones(countryIso);
        return countryTimeZones == null ? null : countryTimeZones.getTimeZoneIds();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CountryTimeZones lookupCountryTimeZones(String countryIso) {
        TimeZoneFinder timeZoneFinder = this;
        synchronized (timeZoneFinder) {
            if (this.lastCountryTimeZones != null && this.lastCountryTimeZones.isForCountryCode(countryIso)) {
                return this.lastCountryTimeZones;
            }
        }
        SelectiveCountryTimeZonesExtractor extractor = new SelectiveCountryTimeZonesExtractor(countryIso);
        try {
            this.processXml(extractor);
            CountryTimeZones countryTimeZones = extractor.getValidatedCountryTimeZones();
            if (countryTimeZones == null) {
                return null;
            }
            TimeZoneFinder timeZoneFinder2 = this;
            synchronized (timeZoneFinder2) {
                this.lastCountryTimeZones = countryTimeZones;
            }
            return countryTimeZones;
        }
        catch (IOException | XmlPullParserException e) {
            System.logW((String)"Error reading country zones ", (Throwable)e);
            return null;
        }
    }

    private void processXml(CountryZonesProcessor processor) throws XmlPullParserException, IOException {
        try (Reader reader = this.xmlSource.get();){
            XmlPullParserFactory xmlPullParserFactory = XmlPullParserFactory.newInstance();
            xmlPullParserFactory.setNamespaceAware(false);
            XmlPullParser parser = xmlPullParserFactory.newPullParser();
            parser.setInput(reader);
            TimeZoneFinder.findRequiredStartTag(parser, TIMEZONES_ELEMENT);
            TimeZoneFinder.findRequiredStartTag(parser, COUNTRY_ZONES_ELEMENT);
            if (!TimeZoneFinder.processCountryZones(parser, processor)) {
                return;
            }
            TimeZoneFinder.checkOnEndTag(parser, COUNTRY_ZONES_ELEMENT);
            parser.next();
            TimeZoneFinder.consumeUntilEndTag(parser, TIMEZONES_ELEMENT);
            TimeZoneFinder.checkOnEndTag(parser, TIMEZONES_ELEMENT);
        }
    }

    private static boolean processCountryZones(XmlPullParser parser, CountryZonesProcessor processor) throws IOException, XmlPullParserException {
        while (TimeZoneFinder.findOptionalStartTag(parser, COUNTRY_ELEMENT)) {
            if (processor == null) {
                TimeZoneFinder.consumeUntilEndTag(parser, COUNTRY_ELEMENT);
            } else {
                String code = parser.getAttributeValue(null, COUNTRY_CODE_ATTRIBUTE);
                if (code == null || code.isEmpty()) {
                    throw new XmlPullParserException("Unable to find country code: " + parser.getPositionDescription());
                }
                String defaultTimeZoneId = parser.getAttributeValue(null, DEFAULT_TIME_ZONE_ID_ATTRIBUTE);
                if (defaultTimeZoneId == null || defaultTimeZoneId.isEmpty()) {
                    throw new XmlPullParserException("Unable to find default time zone ID: " + parser.getPositionDescription());
                }
                String everUsesUtcString = parser.getAttributeValue(null, EVER_USES_UTC_ATTRIBUTE);
                if (!"y".equals(everUsesUtcString) && !"n".equals(everUsesUtcString)) {
                    throw new XmlPullParserException("Unable to find UTC hint attribute (everutc): " + parser.getPositionDescription());
                }
                boolean everUsesUtc = everUsesUtcString.equals("y");
                String debugInfo = parser.getPositionDescription();
                List<String> timeZoneIds = TimeZoneFinder.parseZoneIds(parser);
                if (!processor.process(code, defaultTimeZoneId, everUsesUtc, timeZoneIds, debugInfo)) {
                    return false;
                }
            }
            TimeZoneFinder.checkOnEndTag(parser, COUNTRY_ELEMENT);
        }
        return true;
    }

    private static List<String> parseZoneIds(XmlPullParser parser) throws IOException, XmlPullParserException {
        ArrayList<String> timeZones = new ArrayList<String>();
        while (TimeZoneFinder.findOptionalStartTag(parser, ID_ELEMENT)) {
            String zoneIdString = TimeZoneFinder.consumeText(parser);
            TimeZoneFinder.checkOnEndTag(parser, ID_ELEMENT);
            timeZones.add(zoneIdString);
        }
        return Collections.unmodifiableList(timeZones);
    }

    private static void findRequiredStartTag(XmlPullParser parser, String elementName) throws IOException, XmlPullParserException {
        TimeZoneFinder.findStartTag(parser, elementName, true);
    }

    private static boolean findOptionalStartTag(XmlPullParser parser, String elementName) throws IOException, XmlPullParserException {
        return TimeZoneFinder.findStartTag(parser, elementName, false);
    }

    private static boolean findStartTag(XmlPullParser parser, String elementName, boolean elementRequired) throws IOException, XmlPullParserException {
        int type;
        block4: while ((type = parser.next()) != 1) {
            switch (type) {
                case 2: {
                    String currentElementName = parser.getName();
                    if (elementName.equals(currentElementName)) {
                        return true;
                    }
                    parser.next();
                    TimeZoneFinder.consumeUntilEndTag(parser, currentElementName);
                    continue block4;
                }
                case 3: {
                    if (elementRequired) {
                        throw new XmlPullParserException("No child element found with name " + elementName);
                    }
                    return false;
                }
            }
        }
        throw new XmlPullParserException("Unexpected end of document while looking for " + elementName);
    }

    private static void consumeUntilEndTag(XmlPullParser parser, String elementName) throws IOException, XmlPullParserException {
        if (parser.getEventType() == 3 && elementName.equals(parser.getName())) {
            return;
        }
        int requiredDepth = parser.getDepth();
        if (parser.getEventType() == 2) {
            --requiredDepth;
        }
        while (parser.getEventType() != 1) {
            int type = parser.next();
            int currentDepth = parser.getDepth();
            if (currentDepth < requiredDepth) {
                throw new XmlPullParserException("Unexpected depth while looking for end tag: " + parser.getPositionDescription());
            }
            if (currentDepth != requiredDepth || type != 3) continue;
            if (elementName.equals(parser.getName())) {
                return;
            }
            throw new XmlPullParserException("Unexpected eng tag: " + parser.getPositionDescription());
        }
        throw new XmlPullParserException("Unexpected end of document");
    }

    private static String consumeText(XmlPullParser parser) throws IOException, XmlPullParserException {
        int type = parser.next();
        if (type != 4) {
            throw new XmlPullParserException("Text not found. Found type=" + type + " at " + parser.getPositionDescription());
        }
        String text = parser.getText();
        type = parser.next();
        if (type != 3) {
            throw new XmlPullParserException("Unexpected nested tag or end of document when expecting text: type=" + type + " at " + parser.getPositionDescription());
        }
        return text;
    }

    private static void checkOnEndTag(XmlPullParser parser, String elementName) throws XmlPullParserException {
        if (parser.getEventType() != 3 || !parser.getName().equals(elementName)) {
            throw new XmlPullParserException("Unexpected tag encountered: " + parser.getPositionDescription());
        }
    }

    private static String normalizeCountryIso(String countryIso) {
        return countryIso.toLowerCase(Locale.US);
    }

    private static interface ReaderSupplier {
        public Reader get() throws IOException;

        public static ReaderSupplier forFile(String fileName, Charset charSet) throws IOException {
            Path file = Paths.get(fileName, new String[0]);
            if (!Files.exists(file, new LinkOption[0])) {
                throw new FileNotFoundException(fileName + " does not exist");
            }
            if (!Files.isRegularFile(file, new LinkOption[0]) && Files.isReadable(file)) {
                throw new IOException(fileName + " must be a regular readable file.");
            }
            return () -> Files.newBufferedReader(file, charSet);
        }

        public static ReaderSupplier forString(String xml2) {
            return () -> new StringReader(xml2);
        }
    }

    private static class SelectiveCountryTimeZonesExtractor
    implements CountryZonesProcessor {
        private final String countryCodeToMatch;
        private CountryTimeZones validatedCountryTimeZones;

        private SelectiveCountryTimeZonesExtractor(String countryCodeToMatch) {
            this.countryCodeToMatch = TimeZoneFinder.normalizeCountryIso(countryCodeToMatch);
        }

        @Override
        public boolean process(String countryIso, String defaultTimeZoneId, boolean everUsesUtc, List<String> countryTimeZoneIds, String debugInfo) {
            if (!this.countryCodeToMatch.equals(countryIso = TimeZoneFinder.normalizeCountryIso(countryIso))) {
                return true;
            }
            this.validatedCountryTimeZones = CountryTimeZones.createValidated(countryIso, defaultTimeZoneId, everUsesUtc, countryTimeZoneIds, debugInfo);
            return false;
        }

        private CountryTimeZones getValidatedCountryTimeZones() {
            return this.validatedCountryTimeZones;
        }
    }

    private static class CountryZonesValidator
    implements CountryZonesProcessor {
        private final Set<String> knownCountryCodes = new HashSet<String>();

        private CountryZonesValidator() {
        }

        @Override
        public boolean process(String countryIso, String defaultTimeZoneId, boolean everUsesUtc, List<String> timeZoneIds, String debugInfo) throws XmlPullParserException {
            if (!TimeZoneFinder.normalizeCountryIso(countryIso).equals(countryIso)) {
                throw new XmlPullParserException("Country code: " + countryIso + " is not normalized at " + debugInfo);
            }
            if (this.knownCountryCodes.contains(countryIso)) {
                throw new XmlPullParserException("Second entry for country code: " + countryIso + " at " + debugInfo);
            }
            if (timeZoneIds.isEmpty()) {
                throw new XmlPullParserException("No time zone IDs for country code: " + countryIso + " at " + debugInfo);
            }
            if (!timeZoneIds.contains(defaultTimeZoneId)) {
                throw new XmlPullParserException("defaultTimeZoneId for country code: " + countryIso + " is not one of the zones " + timeZoneIds + " at " + debugInfo);
            }
            this.knownCountryCodes.add(countryIso);
            return true;
        }
    }

    private static interface CountryZonesProcessor {
        public static final boolean CONTINUE = true;
        public static final boolean HALT = false;

        public boolean process(String var1, String var2, boolean var3, List<String> var4, String var5) throws XmlPullParserException;
    }
}

