/*
 * Decompiled with CFR 0.152.
 */
package android.accessibilityservice;

import android.accessibilityservice.AccessibilityButtonController$$Lambda$55;
import android.accessibilityservice.AccessibilityButtonController$$Lambda$56;
import android.accessibilityservice.IAccessibilityServiceConnection;
import android.os.Handler;
import android.os.RemoteException;
import android.util.ArrayMap;
import android.util.Slog;

public final class AccessibilityButtonController {
    private static final String LOG_TAG = "A11yButtonController";
    private final IAccessibilityServiceConnection mServiceConnection;
    private final Object mLock;
    private ArrayMap<AccessibilityButtonCallback, Handler> mCallbacks;

    AccessibilityButtonController(IAccessibilityServiceConnection serviceConnection) {
        this.mServiceConnection = serviceConnection;
        this.mLock = new Object();
    }

    public boolean isAccessibilityButtonAvailable() {
        try {
            return this.mServiceConnection.isAccessibilityButtonAvailable();
        }
        catch (RemoteException re) {
            Slog.w(LOG_TAG, "Failed to get accessibility button availability.", re);
            re.rethrowFromSystemServer();
            return false;
        }
    }

    public void registerAccessibilityButtonCallback(AccessibilityButtonCallback callback) {
        this.registerAccessibilityButtonCallback(callback, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerAccessibilityButtonCallback(AccessibilityButtonCallback callback, Handler handler) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mCallbacks == null) {
                this.mCallbacks = new ArrayMap();
            }
            this.mCallbacks.put(callback, handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterAccessibilityButtonCallback(AccessibilityButtonCallback callback) {
        Object object = this.mLock;
        synchronized (object) {
            boolean hasKey;
            if (this.mCallbacks == null) {
                return;
            }
            int keyIndex = this.mCallbacks.indexOfKey(callback);
            boolean bl = hasKey = keyIndex >= 0;
            if (hasKey) {
                this.mCallbacks.removeAt(keyIndex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dispatchAccessibilityButtonClicked() {
        ArrayMap<AccessibilityButtonCallback, Handler> entries;
        Object object = this.mLock;
        synchronized (object) {
            if (this.mCallbacks == null || this.mCallbacks.isEmpty()) {
                Slog.w(LOG_TAG, "Received accessibility button click with no callbacks!");
                return;
            }
            entries = new ArrayMap<AccessibilityButtonCallback, Handler>(this.mCallbacks);
        }
        int count = entries.size();
        for (int i = 0; i < count; ++i) {
            AccessibilityButtonCallback callback = entries.keyAt(i);
            Handler handler = entries.valueAt(i);
            if (handler != null) {
                handler.post(AccessibilityButtonController$$Lambda$55.get$Lambda(this, callback));
                continue;
            }
            callback.onClicked(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dispatchAccessibilityButtonAvailabilityChanged(boolean available) {
        ArrayMap<AccessibilityButtonCallback, Handler> entries;
        Object object = this.mLock;
        synchronized (object) {
            if (this.mCallbacks == null || this.mCallbacks.isEmpty()) {
                Slog.w(LOG_TAG, "Received accessibility button availability change with no callbacks!");
                return;
            }
            entries = new ArrayMap<AccessibilityButtonCallback, Handler>(this.mCallbacks);
        }
        int count = entries.size();
        for (int i = 0; i < count; ++i) {
            AccessibilityButtonCallback callback = entries.keyAt(i);
            Handler handler = entries.valueAt(i);
            if (handler != null) {
                handler.post(AccessibilityButtonController$$Lambda$56.get$Lambda(this, callback, available));
                continue;
            }
            callback.onAvailabilityChanged(this, available);
        }
    }

    final /* synthetic */ void lambda$dispatchAccessibilityButtonAvailabilityChanged$1$AccessibilityButtonController(AccessibilityButtonCallback accessibilityButtonCallback, boolean bl) {
        accessibilityButtonCallback.onAvailabilityChanged(this, bl);
    }

    final /* synthetic */ void lambda$dispatchAccessibilityButtonClicked$0$AccessibilityButtonController(AccessibilityButtonCallback accessibilityButtonCallback) {
        accessibilityButtonCallback.onClicked(this);
    }

    public static abstract class AccessibilityButtonCallback {
        public void onClicked(AccessibilityButtonController controller) {
        }

        public void onAvailabilityChanged(AccessibilityButtonController controller, boolean available) {
        }
    }
}

