/*
 * Decompiled with CFR 0.152.
 */
package android.animation;

import android.animation.AnimationHandler;
import android.animation.Animator;
import android.animation.ArgbEvaluator;
import android.animation.PropertyValuesHolder;
import android.animation.TimeInterpolator;
import android.animation.TypeEvaluator;
import android.annotation.IntDef;
import android.os.Looper;
import android.os.Trace;
import android.util.AndroidRuntimeException;
import android.util.Log;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.AnimationUtils;
import android.view.animation.LinearInterpolator;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.HashMap;

public class ValueAnimator
extends Animator
implements AnimationHandler.AnimationFrameCallback {
    private static final String TAG = "ValueAnimator";
    private static final boolean DEBUG = false;
    private static float sDurationScale = 1.0f;
    long mStartTime = -1L;
    boolean mStartTimeCommitted;
    float mSeekFraction = -1.0f;
    private long mPauseTime;
    private boolean mResumed = false;
    private static final TimeInterpolator sDefaultInterpolator = new AccelerateDecelerateInterpolator();
    private boolean mReversing;
    private float mOverallFraction = 0.0f;
    private float mCurrentFraction = 0.0f;
    private long mLastFrameTime = -1L;
    private long mFirstFrameTime = -1L;
    private boolean mRunning = false;
    private boolean mStarted = false;
    private boolean mStartListenersCalled = false;
    boolean mInitialized = false;
    private boolean mAnimationEndRequested = false;
    private long mDuration = 300L;
    private long mStartDelay = 0L;
    private int mRepeatCount = 0;
    private int mRepeatMode = 1;
    private boolean mSelfPulse = true;
    private boolean mSuppressSelfPulseRequested = false;
    private TimeInterpolator mInterpolator = sDefaultInterpolator;
    ArrayList<AnimatorUpdateListener> mUpdateListeners = null;
    PropertyValuesHolder[] mValues;
    HashMap<String, PropertyValuesHolder> mValuesMap;
    public static final int RESTART = 1;
    public static final int REVERSE = 2;
    public static final int INFINITE = -1;

    public static void setDurationScale(float durationScale) {
        sDurationScale = durationScale;
    }

    public static float getDurationScale() {
        return sDurationScale;
    }

    public static boolean areAnimatorsEnabled() {
        return sDurationScale != 0.0f;
    }

    public static ValueAnimator ofInt(int ... values) {
        ValueAnimator anim2 = new ValueAnimator();
        anim2.setIntValues(values);
        return anim2;
    }

    public static ValueAnimator ofArgb(int ... values) {
        ValueAnimator anim2 = new ValueAnimator();
        anim2.setIntValues(values);
        anim2.setEvaluator(ArgbEvaluator.getInstance());
        return anim2;
    }

    public static ValueAnimator ofFloat(float ... values) {
        ValueAnimator anim2 = new ValueAnimator();
        anim2.setFloatValues(values);
        return anim2;
    }

    public static ValueAnimator ofPropertyValuesHolder(PropertyValuesHolder ... values) {
        ValueAnimator anim2 = new ValueAnimator();
        anim2.setValues(values);
        return anim2;
    }

    public static ValueAnimator ofObject(TypeEvaluator evaluator, Object ... values) {
        ValueAnimator anim2 = new ValueAnimator();
        anim2.setObjectValues(values);
        anim2.setEvaluator(evaluator);
        return anim2;
    }

    public void setIntValues(int ... values) {
        if (values == null || values.length == 0) {
            return;
        }
        if (this.mValues == null || this.mValues.length == 0) {
            this.setValues(PropertyValuesHolder.ofInt("", values));
        } else {
            PropertyValuesHolder valuesHolder = this.mValues[0];
            valuesHolder.setIntValues(values);
        }
        this.mInitialized = false;
    }

    public void setFloatValues(float ... values) {
        if (values == null || values.length == 0) {
            return;
        }
        if (this.mValues == null || this.mValues.length == 0) {
            this.setValues(PropertyValuesHolder.ofFloat("", values));
        } else {
            PropertyValuesHolder valuesHolder = this.mValues[0];
            valuesHolder.setFloatValues(values);
        }
        this.mInitialized = false;
    }

    public void setObjectValues(Object ... values) {
        if (values == null || values.length == 0) {
            return;
        }
        if (this.mValues == null || this.mValues.length == 0) {
            this.setValues(PropertyValuesHolder.ofObject("", null, values));
        } else {
            PropertyValuesHolder valuesHolder = this.mValues[0];
            valuesHolder.setObjectValues(values);
        }
        this.mInitialized = false;
    }

    public void setValues(PropertyValuesHolder ... values) {
        int numValues = values.length;
        this.mValues = values;
        this.mValuesMap = new HashMap(numValues);
        for (int i = 0; i < numValues; ++i) {
            PropertyValuesHolder valuesHolder = values[i];
            this.mValuesMap.put(valuesHolder.getPropertyName(), valuesHolder);
        }
        this.mInitialized = false;
    }

    public PropertyValuesHolder[] getValues() {
        return this.mValues;
    }

    void initAnimation() {
        if (!this.mInitialized) {
            int numValues = this.mValues.length;
            for (int i = 0; i < numValues; ++i) {
                this.mValues[i].init();
            }
            this.mInitialized = true;
        }
    }

    @Override
    public ValueAnimator setDuration(long duration) {
        if (duration < 0L) {
            throw new IllegalArgumentException("Animators cannot have negative duration: " + duration);
        }
        this.mDuration = duration;
        return this;
    }

    private long getScaledDuration() {
        return (long)((float)this.mDuration * sDurationScale);
    }

    @Override
    public long getDuration() {
        return this.mDuration;
    }

    @Override
    public long getTotalDuration() {
        if (this.mRepeatCount == -1) {
            return -1L;
        }
        return this.mStartDelay + this.mDuration * (long)(this.mRepeatCount + 1);
    }

    public void setCurrentPlayTime(long playTime) {
        float fraction2 = this.mDuration > 0L ? (float)playTime / (float)this.mDuration : 1.0f;
        this.setCurrentFraction(fraction2);
    }

    public void setCurrentFraction(float fraction2) {
        this.initAnimation();
        fraction2 = this.clampFraction(fraction2);
        this.mStartTimeCommitted = true;
        if (this.isPulsingInternal()) {
            long seekTime = (long)((float)this.getScaledDuration() * fraction2);
            long currentTime = AnimationUtils.currentAnimationTimeMillis();
            this.mStartTime = currentTime - seekTime;
        } else {
            this.mSeekFraction = fraction2;
        }
        this.mOverallFraction = fraction2;
        float currentIterationFraction = this.getCurrentIterationFraction(fraction2, this.mReversing);
        this.animateValue(currentIterationFraction);
    }

    private int getCurrentIteration(float fraction2) {
        double iteration;
        if ((double)(fraction2 = this.clampFraction(fraction2)) == (iteration = Math.floor(fraction2)) && fraction2 > 0.0f) {
            iteration -= 1.0;
        }
        return (int)iteration;
    }

    private float getCurrentIterationFraction(float fraction2, boolean inReverse) {
        fraction2 = this.clampFraction(fraction2);
        int iteration = this.getCurrentIteration(fraction2);
        float currentFraction = fraction2 - (float)iteration;
        return this.shouldPlayBackward(iteration, inReverse) ? 1.0f - currentFraction : currentFraction;
    }

    private float clampFraction(float fraction2) {
        if (fraction2 < 0.0f) {
            fraction2 = 0.0f;
        } else if (this.mRepeatCount != -1) {
            fraction2 = Math.min(fraction2, (float)(this.mRepeatCount + 1));
        }
        return fraction2;
    }

    private boolean shouldPlayBackward(int iteration, boolean inReverse) {
        if (iteration > 0 && this.mRepeatMode == 2 && (iteration < this.mRepeatCount + 1 || this.mRepeatCount == -1)) {
            if (inReverse) {
                return iteration % 2 == 0;
            }
            return iteration % 2 != 0;
        }
        return inReverse;
    }

    public long getCurrentPlayTime() {
        if (!this.mInitialized || !this.mStarted && this.mSeekFraction < 0.0f) {
            return 0L;
        }
        if (this.mSeekFraction >= 0.0f) {
            return (long)((float)this.mDuration * this.mSeekFraction);
        }
        float durationScale = sDurationScale == 0.0f ? 1.0f : sDurationScale;
        return (long)((float)(AnimationUtils.currentAnimationTimeMillis() - this.mStartTime) / durationScale);
    }

    @Override
    public long getStartDelay() {
        return this.mStartDelay;
    }

    @Override
    public void setStartDelay(long startDelay) {
        if (startDelay < 0L) {
            Log.w(TAG, "Start delay should always be non-negative");
            startDelay = 0L;
        }
        this.mStartDelay = startDelay;
    }

    public static long getFrameDelay() {
        AnimationHandler.getInstance();
        return AnimationHandler.getFrameDelay();
    }

    public static void setFrameDelay(long frameDelay) {
        AnimationHandler.getInstance();
        AnimationHandler.setFrameDelay(frameDelay);
    }

    public Object getAnimatedValue() {
        if (this.mValues != null && this.mValues.length > 0) {
            return this.mValues[0].getAnimatedValue();
        }
        return null;
    }

    public Object getAnimatedValue(String propertyName) {
        PropertyValuesHolder valuesHolder = this.mValuesMap.get(propertyName);
        if (valuesHolder != null) {
            return valuesHolder.getAnimatedValue();
        }
        return null;
    }

    public void setRepeatCount(int value) {
        this.mRepeatCount = value;
    }

    public int getRepeatCount() {
        return this.mRepeatCount;
    }

    public void setRepeatMode(int value) {
        this.mRepeatMode = value;
    }

    public int getRepeatMode() {
        return this.mRepeatMode;
    }

    public void addUpdateListener(AnimatorUpdateListener listener) {
        if (this.mUpdateListeners == null) {
            this.mUpdateListeners = new ArrayList();
        }
        this.mUpdateListeners.add(listener);
    }

    public void removeAllUpdateListeners() {
        if (this.mUpdateListeners == null) {
            return;
        }
        this.mUpdateListeners.clear();
        this.mUpdateListeners = null;
    }

    public void removeUpdateListener(AnimatorUpdateListener listener) {
        if (this.mUpdateListeners == null) {
            return;
        }
        this.mUpdateListeners.remove(listener);
        if (this.mUpdateListeners.size() == 0) {
            this.mUpdateListeners = null;
        }
    }

    @Override
    public void setInterpolator(TimeInterpolator value) {
        this.mInterpolator = value != null ? value : new LinearInterpolator();
    }

    @Override
    public TimeInterpolator getInterpolator() {
        return this.mInterpolator;
    }

    public void setEvaluator(TypeEvaluator value) {
        if (value != null && this.mValues != null && this.mValues.length > 0) {
            this.mValues[0].setEvaluator(value);
        }
    }

    private void notifyStartListeners() {
        if (this.mListeners != null && !this.mStartListenersCalled) {
            ArrayList tmpListeners = (ArrayList)this.mListeners.clone();
            int numListeners = tmpListeners.size();
            for (int i = 0; i < numListeners; ++i) {
                ((Animator.AnimatorListener)tmpListeners.get(i)).onAnimationStart(this, this.mReversing);
            }
        }
        this.mStartListenersCalled = true;
    }

    private void start(boolean playBackwards) {
        if (Looper.myLooper() == null) {
            throw new AndroidRuntimeException("Animators may only be run on Looper threads");
        }
        this.mReversing = playBackwards;
        boolean bl = this.mSelfPulse = !this.mSuppressSelfPulseRequested;
        if (playBackwards && this.mSeekFraction != -1.0f && this.mSeekFraction != 0.0f) {
            if (this.mRepeatCount == -1) {
                float fraction2 = (float)((double)this.mSeekFraction - Math.floor(this.mSeekFraction));
                this.mSeekFraction = 1.0f - fraction2;
            } else {
                this.mSeekFraction = (float)(1 + this.mRepeatCount) - this.mSeekFraction;
            }
        }
        this.mStarted = true;
        this.mPaused = false;
        this.mRunning = false;
        this.mAnimationEndRequested = false;
        this.mLastFrameTime = -1L;
        this.mFirstFrameTime = -1L;
        this.mStartTime = -1L;
        this.addAnimationCallback(0L);
        if (this.mStartDelay == 0L || this.mSeekFraction >= 0.0f || this.mReversing) {
            this.startAnimation();
            if (this.mSeekFraction == -1.0f) {
                this.setCurrentPlayTime(0L);
            } else {
                this.setCurrentFraction(this.mSeekFraction);
            }
        }
    }

    @Override
    void startWithoutPulsing(boolean inReverse) {
        this.mSuppressSelfPulseRequested = true;
        if (inReverse) {
            this.reverse();
        } else {
            this.start();
        }
        this.mSuppressSelfPulseRequested = false;
    }

    @Override
    public void start() {
        this.start(false);
    }

    @Override
    public void cancel() {
        if (Looper.myLooper() == null) {
            throw new AndroidRuntimeException("Animators may only be run on Looper threads");
        }
        if (this.mAnimationEndRequested) {
            return;
        }
        if ((this.mStarted || this.mRunning) && this.mListeners != null) {
            if (!this.mRunning) {
                this.notifyStartListeners();
            }
            ArrayList tmpListeners = (ArrayList)this.mListeners.clone();
            for (Animator.AnimatorListener listener : tmpListeners) {
                listener.onAnimationCancel(this);
            }
        }
        this.endAnimation();
    }

    @Override
    public void end() {
        if (Looper.myLooper() == null) {
            throw new AndroidRuntimeException("Animators may only be run on Looper threads");
        }
        if (!this.mRunning) {
            this.startAnimation();
            this.mStarted = true;
        } else if (!this.mInitialized) {
            this.initAnimation();
        }
        this.animateValue(this.shouldPlayBackward(this.mRepeatCount, this.mReversing) ? 0.0f : 1.0f);
        this.endAnimation();
    }

    @Override
    public void resume() {
        if (Looper.myLooper() == null) {
            throw new AndroidRuntimeException("Animators may only be resumed from the same thread that the animator was started on");
        }
        if (this.mPaused && !this.mResumed) {
            this.mResumed = true;
            if (this.mPauseTime > 0L) {
                this.addAnimationCallback(0L);
            }
        }
        super.resume();
    }

    @Override
    public void pause() {
        boolean previouslyPaused = this.mPaused;
        super.pause();
        if (!previouslyPaused && this.mPaused) {
            this.mPauseTime = -1L;
            this.mResumed = false;
        }
    }

    @Override
    public boolean isRunning() {
        return this.mRunning;
    }

    @Override
    public boolean isStarted() {
        return this.mStarted;
    }

    @Override
    public void reverse() {
        if (this.isPulsingInternal()) {
            long currentTime = AnimationUtils.currentAnimationTimeMillis();
            long currentPlayTime = currentTime - this.mStartTime;
            long timeLeft = this.getScaledDuration() - currentPlayTime;
            this.mStartTime = currentTime - timeLeft;
            this.mStartTimeCommitted = true;
            this.mReversing = !this.mReversing;
        } else if (this.mStarted) {
            this.mReversing = !this.mReversing;
            this.end();
        } else {
            this.start(true);
        }
    }

    @Override
    public boolean canReverse() {
        return true;
    }

    private void endAnimation() {
        boolean notify;
        if (this.mAnimationEndRequested) {
            return;
        }
        this.removeAnimationCallback();
        this.mAnimationEndRequested = true;
        this.mPaused = false;
        boolean bl = notify = (this.mStarted || this.mRunning) && this.mListeners != null;
        if (notify && !this.mRunning) {
            this.notifyStartListeners();
        }
        this.mRunning = false;
        this.mStarted = false;
        this.mStartListenersCalled = false;
        this.mLastFrameTime = -1L;
        this.mFirstFrameTime = -1L;
        this.mStartTime = -1L;
        if (notify && this.mListeners != null) {
            ArrayList tmpListeners = (ArrayList)this.mListeners.clone();
            int numListeners = tmpListeners.size();
            for (int i = 0; i < numListeners; ++i) {
                ((Animator.AnimatorListener)tmpListeners.get(i)).onAnimationEnd(this, this.mReversing);
            }
        }
        this.mReversing = false;
        if (Trace.isTagEnabled(8L)) {
            Trace.asyncTraceEnd(8L, this.getNameForTrace(), System.identityHashCode(this));
        }
    }

    private void startAnimation() {
        if (Trace.isTagEnabled(8L)) {
            Trace.asyncTraceBegin(8L, this.getNameForTrace(), System.identityHashCode(this));
        }
        this.mAnimationEndRequested = false;
        this.initAnimation();
        this.mRunning = true;
        this.mOverallFraction = this.mSeekFraction >= 0.0f ? this.mSeekFraction : 0.0f;
        if (this.mListeners != null) {
            this.notifyStartListeners();
        }
    }

    private boolean isPulsingInternal() {
        return this.mLastFrameTime >= 0L;
    }

    String getNameForTrace() {
        return "animator";
    }

    @Override
    public void commitAnimationFrame(long frameTime) {
        if (!this.mStartTimeCommitted) {
            this.mStartTimeCommitted = true;
            long adjustment = frameTime - this.mLastFrameTime;
            if (adjustment > 0L) {
                this.mStartTime += adjustment;
            }
        }
    }

    boolean animateBasedOnTime(long currentTime) {
        boolean done = false;
        if (this.mRunning) {
            boolean lastIterationFinished;
            long scaledDuration = this.getScaledDuration();
            float fraction2 = scaledDuration > 0L ? (float)(currentTime - this.mStartTime) / (float)scaledDuration : 1.0f;
            float lastFraction = this.mOverallFraction;
            boolean newIteration = (int)fraction2 > (int)lastFraction;
            boolean bl = lastIterationFinished = fraction2 >= (float)(this.mRepeatCount + 1) && this.mRepeatCount != -1;
            if (scaledDuration == 0L) {
                done = true;
            } else if (newIteration && !lastIterationFinished) {
                if (this.mListeners != null) {
                    int numListeners = this.mListeners.size();
                    for (int i = 0; i < numListeners; ++i) {
                        ((Animator.AnimatorListener)this.mListeners.get(i)).onAnimationRepeat(this);
                    }
                }
            } else if (lastIterationFinished) {
                done = true;
            }
            this.mOverallFraction = this.clampFraction(fraction2);
            float currentIterationFraction = this.getCurrentIterationFraction(this.mOverallFraction, this.mReversing);
            this.animateValue(currentIterationFraction);
        }
        return done;
    }

    @Override
    void animateBasedOnPlayTime(long currentPlayTime, long lastPlayTime, boolean inReverse) {
        if (currentPlayTime < 0L || lastPlayTime < 0L) {
            throw new UnsupportedOperationException("Error: Play time should never be negative.");
        }
        this.initAnimation();
        if (this.mRepeatCount > 0) {
            int iteration = (int)(currentPlayTime / this.mDuration);
            int lastIteration = (int)(lastPlayTime / this.mDuration);
            if ((iteration = Math.min(iteration, this.mRepeatCount)) != (lastIteration = Math.min(lastIteration, this.mRepeatCount)) && this.mListeners != null) {
                int numListeners = this.mListeners.size();
                for (int i = 0; i < numListeners; ++i) {
                    ((Animator.AnimatorListener)this.mListeners.get(i)).onAnimationRepeat(this);
                }
            }
        }
        if (this.mRepeatCount != -1 && currentPlayTime >= (long)(this.mRepeatCount + 1) * this.mDuration) {
            this.skipToEndValue(inReverse);
        } else {
            float fraction2 = (float)currentPlayTime / (float)this.mDuration;
            fraction2 = this.getCurrentIterationFraction(fraction2, inReverse);
            this.animateValue(fraction2);
        }
    }

    @Override
    void skipToEndValue(boolean inReverse) {
        float endFraction;
        this.initAnimation();
        float f = endFraction = inReverse ? 0.0f : 1.0f;
        if (this.mRepeatCount % 2 == 1 && this.mRepeatMode == 2) {
            endFraction = 0.0f;
        }
        this.animateValue(endFraction);
    }

    @Override
    boolean isInitialized() {
        return this.mInitialized;
    }

    @Override
    public final boolean doAnimationFrame(long frameTime) {
        if (this.mStartTime < 0L) {
            long l = this.mStartTime = this.mReversing ? frameTime : frameTime + this.mStartDelay;
        }
        if (this.mPaused) {
            this.mPauseTime = frameTime;
            this.removeAnimationCallback();
            return false;
        }
        if (this.mResumed) {
            this.mResumed = false;
            if (this.mPauseTime > 0L) {
                this.mStartTime += frameTime - this.mPauseTime;
            }
        }
        if (!this.mRunning) {
            if (this.mStartTime > frameTime && this.mSeekFraction == -1.0f) {
                return false;
            }
            this.mRunning = true;
            this.startAnimation();
        }
        if (this.mLastFrameTime < 0L) {
            if (this.mSeekFraction >= 0.0f) {
                long seekTime = (long)((float)this.getScaledDuration() * this.mSeekFraction);
                this.mStartTime = frameTime - seekTime;
                this.mSeekFraction = -1.0f;
            }
            this.mStartTimeCommitted = false;
        }
        this.mLastFrameTime = frameTime;
        long currentTime = Math.max(frameTime, this.mStartTime);
        boolean finished = this.animateBasedOnTime(currentTime);
        if (finished) {
            this.endAnimation();
        }
        return finished;
    }

    @Override
    boolean pulseAnimationFrame(long frameTime) {
        if (this.mSelfPulse) {
            return false;
        }
        return this.doAnimationFrame(frameTime);
    }

    private void addOneShotCommitCallback() {
        if (!this.mSelfPulse) {
            return;
        }
        AnimationHandler handler = AnimationHandler.getInstance();
        handler.addOneShotCommitCallback(this);
    }

    private void removeAnimationCallback() {
        if (!this.mSelfPulse) {
            return;
        }
        AnimationHandler handler = AnimationHandler.getInstance();
        handler.removeCallback(this);
    }

    private void addAnimationCallback(long delay) {
        if (!this.mSelfPulse) {
            return;
        }
        AnimationHandler handler = AnimationHandler.getInstance();
        handler.addAnimationFrameCallback(this, delay);
    }

    public float getAnimatedFraction() {
        return this.mCurrentFraction;
    }

    void animateValue(float fraction2) {
        this.mCurrentFraction = fraction2 = this.mInterpolator.getInterpolation(fraction2);
        int numValues = this.mValues.length;
        for (int i = 0; i < numValues; ++i) {
            this.mValues[i].calculateValue(fraction2);
        }
        if (this.mUpdateListeners != null) {
            int numListeners = this.mUpdateListeners.size();
            for (int i = 0; i < numListeners; ++i) {
                this.mUpdateListeners.get(i).onAnimationUpdate(this);
            }
        }
    }

    @Override
    public ValueAnimator clone() {
        ValueAnimator anim2 = (ValueAnimator)super.clone();
        if (this.mUpdateListeners != null) {
            anim2.mUpdateListeners = new ArrayList<AnimatorUpdateListener>(this.mUpdateListeners);
        }
        anim2.mSeekFraction = -1.0f;
        anim2.mReversing = false;
        anim2.mInitialized = false;
        anim2.mStarted = false;
        anim2.mRunning = false;
        anim2.mPaused = false;
        anim2.mResumed = false;
        anim2.mStartListenersCalled = false;
        anim2.mStartTime = -1L;
        anim2.mStartTimeCommitted = false;
        anim2.mAnimationEndRequested = false;
        anim2.mPauseTime = -1L;
        anim2.mLastFrameTime = -1L;
        anim2.mFirstFrameTime = -1L;
        anim2.mOverallFraction = 0.0f;
        anim2.mCurrentFraction = 0.0f;
        anim2.mSelfPulse = true;
        anim2.mSuppressSelfPulseRequested = false;
        PropertyValuesHolder[] oldValues = this.mValues;
        if (oldValues != null) {
            int numValues = oldValues.length;
            anim2.mValues = new PropertyValuesHolder[numValues];
            anim2.mValuesMap = new HashMap(numValues);
            for (int i = 0; i < numValues; ++i) {
                PropertyValuesHolder newValuesHolder;
                anim2.mValues[i] = newValuesHolder = oldValues[i].clone();
                anim2.mValuesMap.put(newValuesHolder.getPropertyName(), newValuesHolder);
            }
        }
        return anim2;
    }

    public static int getCurrentAnimationsCount() {
        return AnimationHandler.getAnimationCount();
    }

    public String toString() {
        String returnVal = "ValueAnimator@" + Integer.toHexString(this.hashCode());
        if (this.mValues != null) {
            for (int i = 0; i < this.mValues.length; ++i) {
                returnVal = returnVal + "\n    " + this.mValues[i].toString();
            }
        }
        return returnVal;
    }

    @Override
    public void setAllowRunningAsynchronously(boolean mayRunAsync) {
    }

    public static interface AnimatorUpdateListener {
        public void onAnimationUpdate(ValueAnimator var1);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @IntDef(value={1L, 2L})
    public static @interface RepeatMode {
    }
}

