/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.annotation.IntDef;
import android.app.ActionBar;
import android.app.ActivityManager;
import android.app.ActivityManagerNative;
import android.app.ActivityOptions;
import android.app.ActivityThread;
import android.app.ActivityTransitionState;
import android.app.AlertDialog;
import android.app.Application;
import android.app.Dialog;
import android.app.Fragment;
import android.app.FragmentController;
import android.app.FragmentHostCallback;
import android.app.FragmentManager;
import android.app.FragmentManagerNonConfig;
import android.app.Instrumentation;
import android.app.LoaderManager;
import android.app.PendingIntent;
import android.app.PictureInPictureArgs;
import android.app.SearchManager;
import android.app.SharedElementCallback;
import android.app.TaskStackBuilder;
import android.app.VoiceInteractor;
import android.app.assist.AssistContent;
import android.content.ComponentCallbacks2;
import android.content.ComponentName;
import android.content.Context;
import android.content.IIntentSender;
import android.content.Intent;
import android.content.IntentSender;
import android.content.SharedPreferences;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.media.session.MediaController;
import android.net.Uri;
import android.os.BadParcelableException;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Parcelable;
import android.os.PersistableBundle;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.StrictMode;
import android.os.SystemProperties;
import android.os.UserHandle;
import android.text.Selection;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import android.text.method.TextKeyListener;
import android.transition.Scene;
import android.transition.TransitionManager;
import android.util.ArrayMap;
import android.util.AttributeSet;
import android.util.EventLog;
import android.util.Log;
import android.util.PrintWriterPrinter;
import android.util.SparseArray;
import android.util.SuperNotCalledException;
import android.view.ActionMode;
import android.view.ContextMenu;
import android.view.ContextThemeWrapper;
import android.view.DragAndDropPermissions;
import android.view.DragEvent;
import android.view.KeyEvent;
import android.view.KeyboardShortcutGroup;
import android.view.KeyboardShortcutInfo;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.MotionEvent;
import android.view.SearchEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewRootImpl;
import android.view.Window;
import android.view.WindowManager;
import android.view.WindowManagerGlobal;
import android.view.accessibility.AccessibilityEvent;
import android.view.autofill.AutoFillId;
import android.view.autofill.AutoFillManager;
import android.view.autofill.AutoFillValue;
import android.widget.Toast;
import android.widget.Toolbar;
import com.android.internal.R;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.app.IVoiceInteractor;
import com.android.internal.app.ToolbarActionBar;
import com.android.internal.app.WindowDecorActionBar;
import com.android.internal.policy.PhoneWindow;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class Activity
extends ContextThemeWrapper
implements LayoutInflater.Factory2,
Window.Callback,
KeyEvent.Callback,
View.OnCreateContextMenuListener,
ComponentCallbacks2,
Window.OnWindowDismissedCallback,
Window.WindowControllerCallback,
AutoFillManager.AutoFillClient {
    private static final String TAG = "Activity";
    private static final boolean DEBUG_LIFECYCLE = false;
    private static final boolean DEBUG_AUTO_FILL = true;
    public static final int RESULT_CANCELED = 0;
    public static final int RESULT_OK = -1;
    public static final int RESULT_FIRST_USER = 1;
    public static final int DONT_FINISH_TASK_WITH_ACTIVITY = 0;
    public static final int FINISH_TASK_WITH_ROOT_ACTIVITY = 1;
    public static final int FINISH_TASK_WITH_ACTIVITY = 2;
    static final String FRAGMENTS_TAG = "android:fragments";
    private static final String WINDOW_HIERARCHY_TAG = "android:viewHierarchyState";
    private static final String SAVED_DIALOG_IDS_KEY = "android:savedDialogIds";
    private static final String SAVED_DIALOGS_TAG = "android:savedDialogs";
    private static final String SAVED_DIALOG_KEY_PREFIX = "android:dialog_";
    private static final String SAVED_DIALOG_ARGS_KEY_PREFIX = "android:dialog_args_";
    private static final String HAS_CURENT_PERMISSIONS_REQUEST_KEY = "android:hasCurrentPermissionsRequest";
    private static final String REQUEST_PERMISSIONS_WHO_PREFIX = "@android:requestPermissions:";
    private static final String AUTO_FILL_AUTH_WHO_PREFIX = "@android:autoFillAuth:";
    private static final String KEYBOARD_SHORTCUTS_RECEIVER_PKG_NAME = "com.android.systemui";
    private SparseArray<ManagedDialog> mManagedDialogs;
    private Instrumentation mInstrumentation;
    private IBinder mToken;
    private int mIdent;
    String mEmbeddedID;
    private Application mApplication;
    Intent mIntent;
    String mReferrer;
    private ComponentName mComponent;
    ActivityInfo mActivityInfo;
    ActivityThread mMainThread;
    Activity mParent;
    boolean mCalled;
    boolean mResumed;
    boolean mStopped;
    boolean mFinished;
    boolean mStartedActivity;
    private boolean mDestroyed;
    private boolean mDoReportFullyDrawn = true;
    boolean mTemporaryPause = false;
    boolean mChangingConfigurations = false;
    int mConfigChangeFlags;
    Configuration mCurrentConfig;
    private SearchManager mSearchManager;
    private MenuInflater mMenuInflater;
    NonConfigurationInstances mLastNonConfigurationInstances;
    private Window mWindow;
    private WindowManager mWindowManager;
    View mDecor = null;
    boolean mWindowAdded = false;
    boolean mVisibleFromServer = false;
    boolean mVisibleFromClient = true;
    ActionBar mActionBar = null;
    private boolean mEnableDefaultActionBarUp;
    private VoiceInteractor mVoiceInteractor;
    private CharSequence mTitle;
    private int mTitleColor = 0;
    final Handler mHandler = new Handler();
    final FragmentController mFragments = FragmentController.createController(new HostCallbacks());
    boolean mVisibleBehind;
    @GuardedBy(value="mManagedCursors")
    private final ArrayList<ManagedCursor> mManagedCursors = new ArrayList();
    @GuardedBy(value="this")
    int mResultCode = 0;
    @GuardedBy(value="this")
    Intent mResultData = null;
    private TranslucentConversionListener mTranslucentCallback;
    private boolean mChangeCanvasToTranslucent;
    private SearchEvent mSearchEvent;
    private boolean mTitleReady = false;
    private int mActionModeTypeStarting = 0;
    private int mDefaultKeyMode = 0;
    private SpannableStringBuilder mDefaultKeySsb = null;
    private ActivityManager.TaskDescription mTaskDescription = new ActivityManager.TaskDescription();
    protected static final int[] FOCUSED_STATE_SET = new int[]{16842908};
    private final Object mInstanceTracker = StrictMode.trackActivity(this);
    private Thread mUiThread;
    ActivityTransitionState mActivityTransitionState = new ActivityTransitionState();
    SharedElementCallback mEnterTransitionListener = SharedElementCallback.NULL_CALLBACK;
    SharedElementCallback mExitTransitionListener = SharedElementCallback.NULL_CALLBACK;
    private boolean mHasCurrentPermissionsRequest;
    private boolean mAutoFillResetNeeded;
    public static final int DEFAULT_KEYS_DISABLE = 0;
    public static final int DEFAULT_KEYS_DIALER = 1;
    public static final int DEFAULT_KEYS_SHORTCUT = 2;
    public static final int DEFAULT_KEYS_SEARCH_LOCAL = 3;
    public static final int DEFAULT_KEYS_SEARCH_GLOBAL = 4;

    private static native String getDlWarning();

    public Intent getIntent() {
        return this.mIntent;
    }

    public void setIntent(Intent newIntent) {
        this.mIntent = newIntent;
    }

    public final Application getApplication() {
        return this.mApplication;
    }

    public final boolean isChild() {
        return this.mParent != null;
    }

    public final Activity getParent() {
        return this.mParent;
    }

    public WindowManager getWindowManager() {
        return this.mWindowManager;
    }

    public Window getWindow() {
        return this.mWindow;
    }

    public LoaderManager getLoaderManager() {
        return this.mFragments.getLoaderManager();
    }

    public View getCurrentFocus() {
        return this.mWindow != null ? this.mWindow.getCurrentFocus() : null;
    }

    protected void onCreate(Bundle savedInstanceState) {
        if (this.mLastNonConfigurationInstances != null) {
            this.mFragments.restoreLoaderNonConfig(this.mLastNonConfigurationInstances.loaders);
        }
        if (this.mActivityInfo.parentActivityName != null) {
            if (this.mActionBar == null) {
                this.mEnableDefaultActionBarUp = true;
            } else {
                this.mActionBar.setDefaultDisplayHomeAsUpEnabled(true);
            }
        }
        if (savedInstanceState != null) {
            Object p = savedInstanceState.getParcelable(FRAGMENTS_TAG);
            this.mFragments.restoreAllState((Parcelable)p, this.mLastNonConfigurationInstances != null ? this.mLastNonConfigurationInstances.fragments : null);
        }
        this.mFragments.dispatchCreate();
        this.getApplication().dispatchActivityCreated(this, savedInstanceState);
        if (this.mVoiceInteractor != null) {
            this.mVoiceInteractor.attachActivity(this);
        }
        this.mCalled = true;
    }

    public void onCreate(Bundle savedInstanceState, PersistableBundle persistentState) {
        this.onCreate(savedInstanceState);
    }

    final void performRestoreInstanceState(Bundle savedInstanceState) {
        this.onRestoreInstanceState(savedInstanceState);
        this.restoreManagedDialogs(savedInstanceState);
    }

    final void performRestoreInstanceState(Bundle savedInstanceState, PersistableBundle persistentState) {
        this.onRestoreInstanceState(savedInstanceState, persistentState);
        if (savedInstanceState != null) {
            this.restoreManagedDialogs(savedInstanceState);
        }
    }

    protected void onRestoreInstanceState(Bundle savedInstanceState) {
        Bundle windowState;
        if (this.mWindow != null && (windowState = savedInstanceState.getBundle(WINDOW_HIERARCHY_TAG)) != null) {
            this.mWindow.restoreHierarchyState(windowState);
        }
    }

    public void onRestoreInstanceState(Bundle savedInstanceState, PersistableBundle persistentState) {
        if (savedInstanceState != null) {
            this.onRestoreInstanceState(savedInstanceState);
        }
    }

    private void restoreManagedDialogs(Bundle savedInstanceState) {
        Bundle b = savedInstanceState.getBundle(SAVED_DIALOGS_TAG);
        if (b == null) {
            return;
        }
        int[] ids = b.getIntArray(SAVED_DIALOG_IDS_KEY);
        int numDialogs = ids.length;
        this.mManagedDialogs = new SparseArray(numDialogs);
        for (int i = 0; i < numDialogs; ++i) {
            Integer dialogId = ids[i];
            Bundle dialogState = b.getBundle(Activity.savedDialogKeyFor(dialogId));
            if (dialogState == null) continue;
            ManagedDialog md = new ManagedDialog();
            md.mArgs = b.getBundle(Activity.savedDialogArgsKeyFor(dialogId));
            md.mDialog = this.createDialog(dialogId, dialogState, md.mArgs);
            if (md.mDialog == null) continue;
            this.mManagedDialogs.put(dialogId, md);
            this.onPrepareDialog(dialogId, md.mDialog, md.mArgs);
            md.mDialog.onRestoreInstanceState(dialogState);
        }
    }

    private Dialog createDialog(Integer dialogId, Bundle state, Bundle args) {
        Dialog dialog = this.onCreateDialog(dialogId, args);
        if (dialog == null) {
            return null;
        }
        dialog.dispatchOnCreate(state);
        return dialog;
    }

    private static String savedDialogKeyFor(int key) {
        return SAVED_DIALOG_KEY_PREFIX + key;
    }

    private static String savedDialogArgsKeyFor(int key) {
        return SAVED_DIALOG_ARGS_KEY_PREFIX + key;
    }

    protected void onPostCreate(Bundle savedInstanceState) {
        if (!this.isChild()) {
            this.mTitleReady = true;
            this.onTitleChanged(this.getTitle(), this.getTitleColor());
        }
        this.mCalled = true;
    }

    public void onPostCreate(Bundle savedInstanceState, PersistableBundle persistentState) {
        this.onPostCreate(savedInstanceState);
    }

    protected void onStart() {
        this.mCalled = true;
        this.mFragments.doLoaderStart();
        this.getApplication().dispatchActivityStarted(this);
    }

    protected void onRestart() {
        this.mCalled = true;
    }

    public void onStateNotSaved() {
    }

    protected void onResume() {
        this.getApplication().dispatchActivityResumed(this);
        this.mActivityTransitionState.onResume(this, this.isTopOfTask());
        this.mCalled = true;
    }

    protected void onPostResume() {
        Window win = this.getWindow();
        if (win != null) {
            win.makeActive();
        }
        if (this.mActionBar != null) {
            this.mActionBar.setShowHideAnimationEnabled(true);
        }
        this.mCalled = true;
    }

    void setVoiceInteractor(IVoiceInteractor voiceInteractor) {
        if (this.mVoiceInteractor != null) {
            for (VoiceInteractor.Request activeRequest : this.mVoiceInteractor.getActiveRequests()) {
                activeRequest.cancel();
                activeRequest.clear();
            }
        }
        this.mVoiceInteractor = voiceInteractor == null ? null : new VoiceInteractor(voiceInteractor, this, this, Looper.myLooper());
    }

    public boolean isVoiceInteraction() {
        return this.mVoiceInteractor != null;
    }

    public boolean isVoiceInteractionRoot() {
        try {
            return this.mVoiceInteractor != null && ActivityManager.getService().isRootVoiceInteraction(this.mToken);
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    public VoiceInteractor getVoiceInteractor() {
        return this.mVoiceInteractor;
    }

    public boolean isLocalVoiceInteractionSupported() {
        try {
            return ActivityManager.getService().supportsLocalVoiceInteraction();
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    public void startLocalVoiceInteraction(Bundle privateOptions) {
        try {
            ActivityManager.getService().startLocalVoiceInteraction(this.mToken, privateOptions);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void onLocalVoiceInteractionStarted() {
    }

    public void onLocalVoiceInteractionStopped() {
    }

    public void stopLocalVoiceInteraction() {
        try {
            ActivityManager.getService().stopLocalVoiceInteraction(this.mToken);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    protected void onNewIntent(Intent intent) {
    }

    final void performSaveInstanceState(Bundle outState) {
        this.onSaveInstanceState(outState);
        this.saveManagedDialogs(outState);
        this.mActivityTransitionState.saveState(outState);
        this.storeHasCurrentPermissionRequest(outState);
    }

    final void performSaveInstanceState(Bundle outState, PersistableBundle outPersistentState) {
        this.onSaveInstanceState(outState, outPersistentState);
        this.saveManagedDialogs(outState);
        this.storeHasCurrentPermissionRequest(outState);
    }

    protected void onSaveInstanceState(Bundle outState) {
        outState.putBundle(WINDOW_HIERARCHY_TAG, this.mWindow.saveHierarchyState());
        Parcelable p = this.mFragments.saveAllState();
        if (p != null) {
            outState.putParcelable(FRAGMENTS_TAG, p);
        }
        this.getApplication().dispatchActivitySaveInstanceState(this, outState);
    }

    public void onSaveInstanceState(Bundle outState, PersistableBundle outPersistentState) {
        this.onSaveInstanceState(outState);
    }

    private void saveManagedDialogs(Bundle outState) {
        if (this.mManagedDialogs == null) {
            return;
        }
        int numDialogs = this.mManagedDialogs.size();
        if (numDialogs == 0) {
            return;
        }
        Bundle dialogState = new Bundle();
        int[] ids = new int[this.mManagedDialogs.size()];
        for (int i = 0; i < numDialogs; ++i) {
            int key;
            ids[i] = key = this.mManagedDialogs.keyAt(i);
            ManagedDialog md = this.mManagedDialogs.valueAt(i);
            dialogState.putBundle(Activity.savedDialogKeyFor(key), md.mDialog.onSaveInstanceState());
            if (md.mArgs == null) continue;
            dialogState.putBundle(Activity.savedDialogArgsKeyFor(key), md.mArgs);
        }
        dialogState.putIntArray(SAVED_DIALOG_IDS_KEY, ids);
        outState.putBundle(SAVED_DIALOGS_TAG, dialogState);
    }

    protected void onPause() {
        this.getApplication().dispatchActivityPaused(this);
        this.mCalled = true;
    }

    protected void onUserLeaveHint() {
    }

    public boolean onCreateThumbnail(Bitmap outBitmap, Canvas canvas) {
        return false;
    }

    public CharSequence onCreateDescription() {
        return null;
    }

    public void onProvideAssistData(Bundle data) {
    }

    public void onProvideAssistContent(AssistContent outContent) {
    }

    public final void requestShowKeyboardShortcuts() {
        Intent intent = new Intent("android.intent.action.SHOW_KEYBOARD_SHORTCUTS");
        intent.setPackage(KEYBOARD_SHORTCUTS_RECEIVER_PKG_NAME);
        this.sendBroadcastAsUser(intent, UserHandle.SYSTEM);
    }

    public final void dismissKeyboardShortcutsHelper() {
        Intent intent = new Intent("android.intent.action.DISMISS_KEYBOARD_SHORTCUTS");
        intent.setPackage(KEYBOARD_SHORTCUTS_RECEIVER_PKG_NAME);
        this.sendBroadcastAsUser(intent, UserHandle.SYSTEM);
    }

    @Override
    public void onProvideKeyboardShortcuts(List<KeyboardShortcutGroup> data, Menu menu2, int deviceId) {
        if (menu2 == null) {
            return;
        }
        KeyboardShortcutGroup group = null;
        int menuSize = menu2.size();
        for (int i = 0; i < menuSize; ++i) {
            MenuItem item = menu2.getItem(i);
            CharSequence title = item.getTitle();
            char alphaShortcut = item.getAlphabeticShortcut();
            int alphaModifiers = item.getAlphabeticModifiers();
            if (title == null || alphaShortcut == '\u0000') continue;
            if (group == null) {
                int resource = this.mApplication.getApplicationInfo().labelRes;
                group = new KeyboardShortcutGroup(resource != 0 ? this.getString(resource) : null);
            }
            group.addItem(new KeyboardShortcutInfo(title, alphaShortcut, alphaModifiers));
        }
        if (group != null) {
            data.add(group);
        }
    }

    public boolean showAssist(Bundle args) {
        try {
            return ActivityManager.getService().showAssistFromActivity(this.mToken, args);
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    protected void onStop() {
        if (this.mActionBar != null) {
            this.mActionBar.setShowHideAnimationEnabled(false);
        }
        this.mActivityTransitionState.onStop();
        this.getApplication().dispatchActivityStopped(this);
        this.mTranslucentCallback = null;
        this.mCalled = true;
        if (this.isFinishing() && this.mAutoFillResetNeeded) {
            this.getSystemService(AutoFillManager.class).reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onDestroy() {
        this.mCalled = true;
        if (this.mManagedDialogs != null) {
            int numDialogs = this.mManagedDialogs.size();
            for (int i = 0; i < numDialogs; ++i) {
                ManagedDialog md = this.mManagedDialogs.valueAt(i);
                if (!md.mDialog.isShowing()) continue;
                md.mDialog.dismiss();
            }
            this.mManagedDialogs = null;
        }
        ArrayList<ManagedCursor> arrayList = this.mManagedCursors;
        synchronized (arrayList) {
            int numCursors = this.mManagedCursors.size();
            for (int i = 0; i < numCursors; ++i) {
                ManagedCursor c = this.mManagedCursors.get(i);
                if (c == null) continue;
                c.mCursor.close();
            }
            this.mManagedCursors.clear();
        }
        if (this.mSearchManager != null) {
            this.mSearchManager.stopSearch();
        }
        if (this.mActionBar != null) {
            this.mActionBar.onDestroy();
        }
        this.getApplication().dispatchActivityDestroyed(this);
    }

    public void reportFullyDrawn() {
        if (this.mDoReportFullyDrawn) {
            this.mDoReportFullyDrawn = false;
            try {
                ActivityManager.getService().reportActivityFullyDrawn(this.mToken);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    public void onMultiWindowModeChanged(boolean isInMultiWindowMode) {
    }

    public boolean isInMultiWindowMode() {
        try {
            return ActivityManager.getService().isInMultiWindowMode(this.mToken);
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    public void onPictureInPictureModeChanged(boolean isInPictureInPictureMode) {
    }

    public boolean isInPictureInPictureMode() {
        try {
            return ActivityManager.getService().isInPictureInPictureMode(this.mToken);
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    public void enterPictureInPictureMode() {
        this.enterPictureInPictureMode(new PictureInPictureArgs());
    }

    public boolean enterPictureInPictureMode(PictureInPictureArgs args) {
        try {
            if (args == null) {
                throw new IllegalArgumentException("Expected non-null picture-in-picture args");
            }
            return ActivityManagerNative.getDefault().enterPictureInPictureMode(this.mToken, args);
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public void setPictureInPictureArgs(PictureInPictureArgs args) {
        try {
            if (args == null) {
                throw new IllegalArgumentException("Expected non-null picture-in-picture args");
            }
            ActivityManagerNative.getDefault().setPictureInPictureArgs(this.mToken, args);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    void dispatchMovedToDisplay(int displayId) {
        this.updateDisplay(displayId);
        this.onMovedToDisplay(displayId);
    }

    public void onMovedToDisplay(int displayId) {
    }

    @Override
    public void onConfigurationChanged(Configuration newConfig) {
        this.mCalled = true;
        this.mFragments.dispatchConfigurationChanged(newConfig);
        if (this.mWindow != null) {
            this.mWindow.onConfigurationChanged(newConfig);
        }
        if (this.mActionBar != null) {
            this.mActionBar.onConfigurationChanged(newConfig);
        }
    }

    public int getChangingConfigurations() {
        return this.mConfigChangeFlags;
    }

    public Object getLastNonConfigurationInstance() {
        return this.mLastNonConfigurationInstances != null ? this.mLastNonConfigurationInstances.activity : null;
    }

    public Object onRetainNonConfigurationInstance() {
        return null;
    }

    HashMap<String, Object> getLastNonConfigurationChildInstances() {
        return this.mLastNonConfigurationInstances != null ? this.mLastNonConfigurationInstances.children : null;
    }

    HashMap<String, Object> onRetainNonConfigurationChildInstances() {
        return null;
    }

    NonConfigurationInstances retainNonConfigurationInstances() {
        Object activity = this.onRetainNonConfigurationInstance();
        HashMap<String, Object> children = this.onRetainNonConfigurationChildInstances();
        FragmentManagerNonConfig fragments = this.mFragments.retainNestedNonConfig();
        this.mFragments.doLoaderStart();
        this.mFragments.doLoaderStop(true);
        ArrayMap<String, LoaderManager> loaders = this.mFragments.retainLoaderNonConfig();
        if (activity == null && children == null && fragments == null && loaders == null && this.mVoiceInteractor == null) {
            return null;
        }
        NonConfigurationInstances nci = new NonConfigurationInstances();
        nci.activity = activity;
        nci.children = children;
        nci.fragments = fragments;
        nci.loaders = loaders;
        if (this.mVoiceInteractor != null) {
            this.mVoiceInteractor.retainInstance();
            nci.voiceInteractor = this.mVoiceInteractor;
        }
        return nci;
    }

    @Override
    public void onLowMemory() {
        this.mCalled = true;
        this.mFragments.dispatchLowMemory();
    }

    @Override
    public void onTrimMemory(int level) {
        this.mCalled = true;
        this.mFragments.dispatchTrimMemory(level);
    }

    public FragmentManager getFragmentManager() {
        return this.mFragments.getFragmentManager();
    }

    public void onAttachFragment(Fragment fragment) {
    }

    @Deprecated
    public final Cursor managedQuery(Uri uri, String[] projection, String selection, String sortOrder) {
        Cursor c = this.getContentResolver().query(uri, projection, selection, null, sortOrder);
        if (c != null) {
            this.startManagingCursor(c);
        }
        return c;
    }

    @Deprecated
    public final Cursor managedQuery(Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder) {
        Cursor c = this.getContentResolver().query(uri, projection, selection, selectionArgs, sortOrder);
        if (c != null) {
            this.startManagingCursor(c);
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void startManagingCursor(Cursor c) {
        ArrayList<ManagedCursor> arrayList = this.mManagedCursors;
        synchronized (arrayList) {
            this.mManagedCursors.add(new ManagedCursor(c));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void stopManagingCursor(Cursor c) {
        ArrayList<ManagedCursor> arrayList = this.mManagedCursors;
        synchronized (arrayList) {
            int N = this.mManagedCursors.size();
            for (int i = 0; i < N; ++i) {
                ManagedCursor mc = this.mManagedCursors.get(i);
                if (mc.mCursor != c) continue;
                this.mManagedCursors.remove(i);
                break;
            }
        }
    }

    @Deprecated
    public void setPersistent(boolean isPersistent) {
    }

    public View findViewById(int id2) {
        return this.getWindow().findViewById(id2);
    }

    public ActionBar getActionBar() {
        this.initWindowDecorActionBar();
        return this.mActionBar;
    }

    public void setActionBar(Toolbar toolbar) {
        ActionBar ab = this.getActionBar();
        if (ab instanceof WindowDecorActionBar) {
            throw new IllegalStateException("This Activity already has an action bar supplied by the window decor. Do not request Window.FEATURE_ACTION_BAR and set android:windowActionBar to false in your theme to use a Toolbar instead.");
        }
        this.mMenuInflater = null;
        if (ab != null) {
            ab.onDestroy();
        }
        if (toolbar != null) {
            ToolbarActionBar tbab = new ToolbarActionBar(toolbar, this.getTitle(), this);
            this.mActionBar = tbab;
            this.mWindow.setCallback(tbab.getWrappedWindowCallback());
        } else {
            this.mActionBar = null;
            this.mWindow.setCallback(this);
        }
        this.invalidateOptionsMenu();
    }

    private void initWindowDecorActionBar() {
        Window window = this.getWindow();
        window.getDecorView();
        if (this.isChild() || !window.hasFeature(8) || this.mActionBar != null) {
            return;
        }
        this.mActionBar = new WindowDecorActionBar(this);
        this.mActionBar.setDefaultDisplayHomeAsUpEnabled(this.mEnableDefaultActionBarUp);
        this.mWindow.setDefaultIcon(this.mActivityInfo.getIconResource());
        this.mWindow.setDefaultLogo(this.mActivityInfo.getLogoResource());
    }

    public void setContentView(int layoutResID) {
        this.getWindow().setContentView(layoutResID);
        this.initWindowDecorActionBar();
    }

    public void setContentView(View view) {
        this.getWindow().setContentView(view);
        this.initWindowDecorActionBar();
    }

    public void setContentView(View view, ViewGroup.LayoutParams params) {
        this.getWindow().setContentView(view, params);
        this.initWindowDecorActionBar();
    }

    public void addContentView(View view, ViewGroup.LayoutParams params) {
        this.getWindow().addContentView(view, params);
        this.initWindowDecorActionBar();
    }

    public TransitionManager getContentTransitionManager() {
        return this.getWindow().getTransitionManager();
    }

    public void setContentTransitionManager(TransitionManager tm) {
        this.getWindow().setTransitionManager(tm);
    }

    public Scene getContentScene() {
        return this.getWindow().getContentScene();
    }

    public void setFinishOnTouchOutside(boolean finish) {
        this.mWindow.setCloseOnTouchOutside(finish);
    }

    public final void setDefaultKeyMode(int mode) {
        this.mDefaultKeyMode = mode;
        switch (mode) {
            case 0: 
            case 2: {
                this.mDefaultKeySsb = null;
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                this.mDefaultKeySsb = new SpannableStringBuilder();
                Selection.setSelection(this.mDefaultKeySsb, 0);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    @Override
    public boolean onKeyDown(int keyCode, KeyEvent event) {
        boolean handled;
        if (keyCode == 4) {
            if (this.getApplicationInfo().targetSdkVersion >= 5) {
                event.startTracking();
            } else {
                this.onBackPressed();
            }
            return true;
        }
        if (this.mDefaultKeyMode == 0) {
            return false;
        }
        if (this.mDefaultKeyMode == 2) {
            Window w = this.getWindow();
            return w.hasFeature(0) && w.performPanelShortcut(0, keyCode, event, 2);
        }
        boolean clearSpannable = false;
        if (event.getRepeatCount() != 0 || event.isSystem()) {
            clearSpannable = true;
            handled = false;
        } else {
            handled = TextKeyListener.getInstance().onKeyDown(null, this.mDefaultKeySsb, keyCode, event);
            if (handled && this.mDefaultKeySsb.length() > 0) {
                String str = this.mDefaultKeySsb.toString();
                clearSpannable = true;
                switch (this.mDefaultKeyMode) {
                    case 1: {
                        Intent intent = new Intent("android.intent.action.DIAL", Uri.parse("tel:" + str));
                        intent.addFlags(0x10000000);
                        this.startActivity(intent);
                        break;
                    }
                    case 3: {
                        this.startSearch(str, false, null, false);
                        break;
                    }
                    case 4: {
                        this.startSearch(str, false, null, true);
                    }
                }
            }
        }
        if (clearSpannable) {
            this.mDefaultKeySsb.clear();
            this.mDefaultKeySsb.clearSpans();
            Selection.setSelection(this.mDefaultKeySsb, 0);
        }
        return handled;
    }

    @Override
    public boolean onKeyLongPress(int keyCode, KeyEvent event) {
        return false;
    }

    @Override
    public boolean onKeyUp(int keyCode, KeyEvent event) {
        if (this.getApplicationInfo().targetSdkVersion >= 5 && keyCode == 4 && event.isTracking() && !event.isCanceled()) {
            this.onBackPressed();
            return true;
        }
        return false;
    }

    @Override
    public boolean onKeyMultiple(int keyCode, int repeatCount, KeyEvent event) {
        return false;
    }

    public void onBackPressed() {
        if (this.mActionBar != null && this.mActionBar.collapseActionView()) {
            return;
        }
        if (!this.mFragments.getFragmentManager().popBackStackImmediate()) {
            this.finishAfterTransition();
        }
    }

    public boolean onKeyShortcut(int keyCode, KeyEvent event) {
        ActionBar actionBar = this.getActionBar();
        return actionBar != null && actionBar.onKeyShortcut(keyCode, event);
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.mWindow.shouldCloseOnTouch(this, event)) {
            this.finish();
            return true;
        }
        return false;
    }

    public boolean onTrackballEvent(MotionEvent event) {
        return false;
    }

    public boolean onGenericMotionEvent(MotionEvent event) {
        return false;
    }

    public void onUserInteraction() {
    }

    @Override
    public void onWindowAttributesChanged(WindowManager.LayoutParams params) {
        View decor;
        if (this.mParent == null && (decor = this.mDecor) != null && decor.getParent() != null) {
            this.getWindowManager().updateViewLayout(decor, params);
        }
    }

    @Override
    public void onContentChanged() {
    }

    @Override
    public void onWindowFocusChanged(boolean hasFocus) {
    }

    @Override
    public void onAttachedToWindow() {
    }

    @Override
    public void onDetachedFromWindow() {
    }

    public boolean hasWindowFocus() {
        View d;
        Window w = this.getWindow();
        if (w != null && (d = w.getDecorView()) != null) {
            return d.hasWindowFocus();
        }
        return false;
    }

    @Override
    public void onWindowDismissed(boolean finishTask, boolean suppressWindowTransition) {
        this.finish(finishTask ? 2 : 0);
        if (suppressWindowTransition) {
            this.overridePendingTransition(0, 0);
        }
    }

    @Override
    public void exitFreeformMode() throws RemoteException {
        ActivityManager.getService().exitFreeformMode(this.mToken);
    }

    @Override
    public int getWindowStackId() throws RemoteException {
        return ActivityManager.getService().getActivityStackId(this.mToken);
    }

    @Override
    public void enterPictureInPictureModeIfPossible() {
        if (this.mActivityInfo.supportsPictureInPicture()) {
            this.enterPictureInPictureMode();
        }
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent event) {
        this.onUserInteraction();
        int keyCode = event.getKeyCode();
        if (keyCode == 82 && this.mActionBar != null && this.mActionBar.onMenuKeyEvent(event)) {
            return true;
        }
        Window win = this.getWindow();
        if (win.superDispatchKeyEvent(event)) {
            return true;
        }
        View decor = this.mDecor;
        if (decor == null) {
            decor = win.getDecorView();
        }
        return event.dispatch(this, decor != null ? decor.getKeyDispatcherState() : null, this);
    }

    @Override
    public boolean dispatchKeyShortcutEvent(KeyEvent event) {
        this.onUserInteraction();
        if (this.getWindow().superDispatchKeyShortcutEvent(event)) {
            return true;
        }
        return this.onKeyShortcut(event.getKeyCode(), event);
    }

    @Override
    public boolean dispatchTouchEvent(MotionEvent ev) {
        if (ev.getAction() == 0) {
            this.onUserInteraction();
        }
        if (this.getWindow().superDispatchTouchEvent(ev)) {
            return true;
        }
        return this.onTouchEvent(ev);
    }

    @Override
    public boolean dispatchTrackballEvent(MotionEvent ev) {
        this.onUserInteraction();
        if (this.getWindow().superDispatchTrackballEvent(ev)) {
            return true;
        }
        return this.onTrackballEvent(ev);
    }

    @Override
    public boolean dispatchGenericMotionEvent(MotionEvent ev) {
        this.onUserInteraction();
        if (this.getWindow().superDispatchGenericMotionEvent(ev)) {
            return true;
        }
        return this.onGenericMotionEvent(ev);
    }

    @Override
    public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent event) {
        event.setClassName(this.getClass().getName());
        event.setPackageName(this.getPackageName());
        WindowManager.LayoutParams params = this.getWindow().getAttributes();
        boolean isFullScreen = params.width == -1 && params.height == -1;
        event.setFullScreen(isFullScreen);
        CharSequence title = this.getTitle();
        if (!TextUtils.isEmpty(title)) {
            event.getText().add(title);
        }
        return true;
    }

    @Override
    public View onCreatePanelView(int featureId) {
        return null;
    }

    @Override
    public boolean onCreatePanelMenu(int featureId, Menu menu2) {
        if (featureId == 0) {
            boolean show = this.onCreateOptionsMenu(menu2);
            return show |= this.mFragments.dispatchCreateOptionsMenu(menu2, this.getMenuInflater());
        }
        return false;
    }

    @Override
    public boolean onPreparePanel(int featureId, View view, Menu menu2) {
        if (featureId == 0 && menu2 != null) {
            boolean goforit = this.onPrepareOptionsMenu(menu2);
            return goforit |= this.mFragments.dispatchPrepareOptionsMenu(menu2);
        }
        return true;
    }

    @Override
    public boolean onMenuOpened(int featureId, Menu menu2) {
        if (featureId == 8) {
            this.initWindowDecorActionBar();
            if (this.mActionBar != null) {
                this.mActionBar.dispatchMenuVisibilityChanged(true);
            } else {
                Log.e(TAG, "Tried to open action bar menu with no action bar");
            }
        }
        return true;
    }

    @Override
    public boolean onMenuItemSelected(int featureId, MenuItem item) {
        CharSequence titleCondensed = item.getTitleCondensed();
        switch (featureId) {
            case 0: {
                if (titleCondensed != null) {
                    EventLog.writeEvent(50000, 0, titleCondensed.toString());
                }
                if (this.onOptionsItemSelected(item)) {
                    return true;
                }
                if (this.mFragments.dispatchOptionsItemSelected(item)) {
                    return true;
                }
                if (item.getItemId() == 16908332 && this.mActionBar != null && (this.mActionBar.getDisplayOptions() & 4) != 0) {
                    if (this.mParent == null) {
                        return this.onNavigateUp();
                    }
                    return this.mParent.onNavigateUpFromChild(this);
                }
                return false;
            }
            case 6: {
                if (titleCondensed != null) {
                    EventLog.writeEvent(50000, 1, titleCondensed.toString());
                }
                if (this.onContextItemSelected(item)) {
                    return true;
                }
                return this.mFragments.dispatchContextItemSelected(item);
            }
        }
        return false;
    }

    @Override
    public void onPanelClosed(int featureId, Menu menu2) {
        switch (featureId) {
            case 0: {
                this.mFragments.dispatchOptionsMenuClosed(menu2);
                this.onOptionsMenuClosed(menu2);
                break;
            }
            case 6: {
                this.onContextMenuClosed(menu2);
                break;
            }
            case 8: {
                this.initWindowDecorActionBar();
                this.mActionBar.dispatchMenuVisibilityChanged(false);
            }
        }
    }

    public void invalidateOptionsMenu() {
        if (this.mWindow.hasFeature(0) && (this.mActionBar == null || !this.mActionBar.invalidateOptionsMenu())) {
            this.mWindow.invalidatePanelMenu(0);
        }
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        if (this.mParent != null) {
            return this.mParent.onCreateOptionsMenu(menu2);
        }
        return true;
    }

    public boolean onPrepareOptionsMenu(Menu menu2) {
        if (this.mParent != null) {
            return this.mParent.onPrepareOptionsMenu(menu2);
        }
        return true;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        if (this.mParent != null) {
            return this.mParent.onOptionsItemSelected(item);
        }
        return false;
    }

    public boolean onNavigateUp() {
        Intent upIntent = this.getParentActivityIntent();
        if (upIntent != null) {
            if (this.mActivityInfo.taskAffinity == null) {
                this.finish();
            } else if (this.shouldUpRecreateTask(upIntent)) {
                TaskStackBuilder b = TaskStackBuilder.create(this);
                this.onCreateNavigateUpTaskStack(b);
                this.onPrepareNavigateUpTaskStack(b);
                b.startActivities();
                if (this.mResultCode != 0 || this.mResultData != null) {
                    Log.i(TAG, "onNavigateUp only finishing topmost activity to return a result");
                    this.finish();
                } else {
                    this.finishAffinity();
                }
            } else {
                this.navigateUpTo(upIntent);
            }
            return true;
        }
        return false;
    }

    public boolean onNavigateUpFromChild(Activity child) {
        return this.onNavigateUp();
    }

    public void onCreateNavigateUpTaskStack(TaskStackBuilder builder) {
        builder.addParentStack(this);
    }

    public void onPrepareNavigateUpTaskStack(TaskStackBuilder builder) {
    }

    public void onOptionsMenuClosed(Menu menu2) {
        if (this.mParent != null) {
            this.mParent.onOptionsMenuClosed(menu2);
        }
    }

    public void openOptionsMenu() {
        if (this.mWindow.hasFeature(0) && (this.mActionBar == null || !this.mActionBar.openOptionsMenu())) {
            this.mWindow.openPanel(0, null);
        }
    }

    public void closeOptionsMenu() {
        if (this.mWindow.hasFeature(0)) {
            this.mWindow.closePanel(0);
        }
    }

    @Override
    public void onCreateContextMenu(ContextMenu menu2, View v, ContextMenu.ContextMenuInfo menuInfo) {
    }

    public void registerForContextMenu(View view) {
        view.setOnCreateContextMenuListener(this);
    }

    public void unregisterForContextMenu(View view) {
        view.setOnCreateContextMenuListener(null);
    }

    public void openContextMenu(View view) {
        view.showContextMenu();
    }

    public void closeContextMenu() {
        if (this.mWindow.hasFeature(6)) {
            this.mWindow.closePanel(6);
        }
    }

    public boolean onContextItemSelected(MenuItem item) {
        if (this.mParent != null) {
            return this.mParent.onContextItemSelected(item);
        }
        return false;
    }

    public void onContextMenuClosed(Menu menu2) {
        if (this.mParent != null) {
            this.mParent.onContextMenuClosed(menu2);
        }
    }

    @Deprecated
    protected Dialog onCreateDialog(int id2) {
        return null;
    }

    @Deprecated
    protected Dialog onCreateDialog(int id2, Bundle args) {
        return this.onCreateDialog(id2);
    }

    @Deprecated
    protected void onPrepareDialog(int id2, Dialog dialog) {
        dialog.setOwnerActivity(this);
    }

    @Deprecated
    protected void onPrepareDialog(int id2, Dialog dialog, Bundle args) {
        this.onPrepareDialog(id2, dialog);
    }

    @Deprecated
    public final void showDialog(int id2) {
        this.showDialog(id2, null);
    }

    @Deprecated
    public final boolean showDialog(int id2, Bundle args) {
        ManagedDialog md;
        if (this.mManagedDialogs == null) {
            this.mManagedDialogs = new SparseArray();
        }
        if ((md = this.mManagedDialogs.get(id2)) == null) {
            md = new ManagedDialog();
            md.mDialog = this.createDialog(id2, null, args);
            if (md.mDialog == null) {
                return false;
            }
            this.mManagedDialogs.put(id2, md);
        }
        md.mArgs = args;
        this.onPrepareDialog(id2, md.mDialog, args);
        md.mDialog.show();
        return true;
    }

    @Deprecated
    public final void dismissDialog(int id2) {
        if (this.mManagedDialogs == null) {
            throw this.missingDialog(id2);
        }
        ManagedDialog md = this.mManagedDialogs.get(id2);
        if (md == null) {
            throw this.missingDialog(id2);
        }
        md.mDialog.dismiss();
    }

    private IllegalArgumentException missingDialog(int id2) {
        return new IllegalArgumentException("no dialog with id " + id2 + " was ever " + "shown via Activity#showDialog");
    }

    @Deprecated
    public final void removeDialog(int id2) {
        ManagedDialog md;
        if (this.mManagedDialogs != null && (md = this.mManagedDialogs.get(id2)) != null) {
            md.mDialog.dismiss();
            this.mManagedDialogs.remove(id2);
        }
    }

    @Override
    public boolean onSearchRequested(SearchEvent searchEvent) {
        this.mSearchEvent = searchEvent;
        boolean result = this.onSearchRequested();
        this.mSearchEvent = null;
        return result;
    }

    @Override
    public boolean onSearchRequested() {
        if ((this.getResources().getConfiguration().uiMode & 0xF) != 4) {
            this.startSearch(null, false, null, false);
            return true;
        }
        return false;
    }

    public final SearchEvent getSearchEvent() {
        return this.mSearchEvent;
    }

    public void startSearch(String initialQuery, boolean selectInitialQuery, Bundle appSearchData, boolean globalSearch) {
        this.ensureSearchManager();
        this.mSearchManager.startSearch(initialQuery, selectInitialQuery, this.getComponentName(), appSearchData, globalSearch);
    }

    public void triggerSearch(String query, Bundle appSearchData) {
        this.ensureSearchManager();
        this.mSearchManager.triggerSearch(query, this.getComponentName(), appSearchData);
    }

    public void takeKeyEvents(boolean get) {
        this.getWindow().takeKeyEvents(get);
    }

    public final boolean requestWindowFeature(int featureId) {
        return this.getWindow().requestFeature(featureId);
    }

    public final void setFeatureDrawableResource(int featureId, int resId) {
        this.getWindow().setFeatureDrawableResource(featureId, resId);
    }

    public final void setFeatureDrawableUri(int featureId, Uri uri) {
        this.getWindow().setFeatureDrawableUri(featureId, uri);
    }

    public final void setFeatureDrawable(int featureId, Drawable drawable2) {
        this.getWindow().setFeatureDrawable(featureId, drawable2);
    }

    public final void setFeatureDrawableAlpha(int featureId, int alpha) {
        this.getWindow().setFeatureDrawableAlpha(featureId, alpha);
    }

    public LayoutInflater getLayoutInflater() {
        return this.getWindow().getLayoutInflater();
    }

    public MenuInflater getMenuInflater() {
        if (this.mMenuInflater == null) {
            this.initWindowDecorActionBar();
            this.mMenuInflater = this.mActionBar != null ? new MenuInflater(this.mActionBar.getThemedContext(), this) : new MenuInflater(this);
        }
        return this.mMenuInflater;
    }

    @Override
    public void setTheme(int resid) {
        super.setTheme(resid);
        this.mWindow.setTheme(resid);
    }

    @Override
    protected void onApplyThemeResource(Resources.Theme theme, int resid, boolean first) {
        int colorBackground;
        int colorPrimary;
        if (this.mParent == null) {
            super.onApplyThemeResource(theme, resid, first);
        } else {
            try {
                theme.setTo(this.mParent.getTheme());
            }
            catch (Exception exception) {
                // empty catch block
            }
            theme.applyStyle(resid, false);
        }
        TypedArray a = theme.obtainStyledAttributes(R.styleable.ActivityTaskDescription);
        if (this.mTaskDescription.getPrimaryColor() == 0 && (colorPrimary = a.getColor(1, 0)) != 0 && Color.alpha(colorPrimary) == 255) {
            this.mTaskDescription.setPrimaryColor(colorPrimary);
        }
        if (this.mTaskDescription.getBackgroundColor() == 0 && (colorBackground = a.getColor(0, 0)) != 0 && Color.alpha(colorBackground) == 255) {
            this.mTaskDescription.setBackgroundColor(colorBackground);
        }
        a.recycle();
        this.setTaskDescription(this.mTaskDescription);
    }

    public final void requestPermissions(String[] permissions, int requestCode) {
        if (requestCode < 0) {
            throw new IllegalArgumentException("requestCode should be >= 0");
        }
        if (this.mHasCurrentPermissionsRequest) {
            Log.w(TAG, "Can reqeust only one set of permissions at a time");
            this.onRequestPermissionsResult(requestCode, new String[0], new int[0]);
            return;
        }
        Intent intent = this.getPackageManager().buildRequestPermissionsIntent(permissions);
        this.startActivityForResult(REQUEST_PERMISSIONS_WHO_PREFIX, intent, requestCode, null);
        this.mHasCurrentPermissionsRequest = true;
    }

    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
    }

    public boolean shouldShowRequestPermissionRationale(String permission2) {
        return this.getPackageManager().shouldShowRequestPermissionRationale(permission2);
    }

    public void startActivityForResult(Intent intent, int requestCode) {
        this.startActivityForResult(intent, requestCode, null);
    }

    public void startActivityForResult(Intent intent, int requestCode, Bundle options) {
        if (this.mParent == null) {
            options = this.transferSpringboardActivityOptions(options);
            Instrumentation.ActivityResult ar = this.mInstrumentation.execStartActivity((Context)this, (IBinder)this.mMainThread.getApplicationThread(), this.mToken, this, intent, requestCode, options);
            if (ar != null) {
                this.mMainThread.sendActivityResult(this.mToken, this.mEmbeddedID, requestCode, ar.getResultCode(), ar.getResultData());
            }
            if (requestCode >= 0) {
                this.mStartedActivity = true;
            }
            this.cancelInputsAndStartExitTransition(options);
        } else if (options != null) {
            this.mParent.startActivityFromChild(this, intent, requestCode, options);
        } else {
            this.mParent.startActivityFromChild(this, intent, requestCode);
        }
    }

    private void cancelInputsAndStartExitTransition(Bundle options) {
        View decor;
        View view = decor = this.mWindow != null ? this.mWindow.peekDecorView() : null;
        if (decor != null) {
            decor.cancelPendingInputEvents();
        }
        if (options != null && !this.isTopOfTask()) {
            this.mActivityTransitionState.startExitOutTransition(this, options);
        }
    }

    public boolean isActivityTransitionRunning() {
        return this.mActivityTransitionState.isTransitionRunning();
    }

    private Bundle transferSpringboardActivityOptions(Bundle options) {
        ActivityOptions activityOptions;
        if (options == null && this.mWindow != null && !this.mWindow.isActive() && (activityOptions = this.getActivityOptions()) != null && activityOptions.getAnimationType() == 5) {
            return activityOptions.toBundle();
        }
        return options;
    }

    public void startActivityForResultAsUser(Intent intent, int requestCode, UserHandle user) {
        this.startActivityForResultAsUser(intent, requestCode, null, user);
    }

    public void startActivityForResultAsUser(Intent intent, int requestCode, Bundle options, UserHandle user) {
        if (this.mParent != null) {
            throw new RuntimeException("Can't be called from a child");
        }
        options = this.transferSpringboardActivityOptions(options);
        Instrumentation.ActivityResult ar = this.mInstrumentation.execStartActivity(this, this.mMainThread.getApplicationThread(), this.mToken, this, intent, requestCode, options, user);
        if (ar != null) {
            this.mMainThread.sendActivityResult(this.mToken, this.mEmbeddedID, requestCode, ar.getResultCode(), ar.getResultData());
        }
        if (requestCode >= 0) {
            this.mStartedActivity = true;
        }
        this.cancelInputsAndStartExitTransition(options);
    }

    @Override
    public void startActivityAsUser(Intent intent, UserHandle user) {
        this.startActivityAsUser(intent, null, user);
    }

    @Override
    public void startActivityAsUser(Intent intent, Bundle options, UserHandle user) {
        if (this.mParent != null) {
            throw new RuntimeException("Can't be called from a child");
        }
        options = this.transferSpringboardActivityOptions(options);
        Instrumentation.ActivityResult ar = this.mInstrumentation.execStartActivity(this, this.mMainThread.getApplicationThread(), this.mToken, this, intent, -1, options, user);
        if (ar != null) {
            this.mMainThread.sendActivityResult(this.mToken, this.mEmbeddedID, -1, ar.getResultCode(), ar.getResultData());
        }
        this.cancelInputsAndStartExitTransition(options);
    }

    public void startActivityAsCaller(Intent intent, Bundle options, boolean ignoreTargetSecurity, int userId) {
        if (this.mParent != null) {
            throw new RuntimeException("Can't be called from a child");
        }
        options = this.transferSpringboardActivityOptions(options);
        Instrumentation.ActivityResult ar = this.mInstrumentation.execStartActivityAsCaller(this, this.mMainThread.getApplicationThread(), this.mToken, this, intent, -1, options, ignoreTargetSecurity, userId);
        if (ar != null) {
            this.mMainThread.sendActivityResult(this.mToken, this.mEmbeddedID, -1, ar.getResultCode(), ar.getResultData());
        }
        this.cancelInputsAndStartExitTransition(options);
    }

    public void startIntentSenderForResult(IntentSender intent, int requestCode, Intent fillInIntent, int flagsMask, int flagsValues, int extraFlags) throws IntentSender.SendIntentException {
        this.startIntentSenderForResult(intent, requestCode, fillInIntent, flagsMask, flagsValues, extraFlags, null);
    }

    public void startIntentSenderForResult(IntentSender intent, int requestCode, Intent fillInIntent, int flagsMask, int flagsValues, int extraFlags, Bundle options) throws IntentSender.SendIntentException {
        if (this.mParent == null) {
            this.startIntentSenderForResultInner(intent, this.mEmbeddedID, requestCode, fillInIntent, flagsMask, flagsValues, options);
        } else if (options != null) {
            this.mParent.startIntentSenderFromChild(this, intent, requestCode, fillInIntent, flagsMask, flagsValues, extraFlags, options);
        } else {
            this.mParent.startIntentSenderFromChild(this, intent, requestCode, fillInIntent, flagsMask, flagsValues, extraFlags);
        }
    }

    private void startIntentSenderForResultInner(IntentSender intent, String who, int requestCode, Intent fillInIntent, int flagsMask, int flagsValues, Bundle options) throws IntentSender.SendIntentException {
        try {
            int result;
            String resolvedType = null;
            if (fillInIntent != null) {
                fillInIntent.migrateExtraStreamToClipData();
                fillInIntent.prepareToLeaveProcess(this);
                resolvedType = fillInIntent.resolveTypeIfNeeded(this.getContentResolver());
            }
            if ((result = ActivityManager.getService().startActivityIntentSender(this.mMainThread.getApplicationThread(), intent, fillInIntent, resolvedType, this.mToken, who, requestCode, flagsMask, flagsValues, options)) == -6) {
                throw new IntentSender.SendIntentException();
            }
            Instrumentation.checkStartActivityResult(result, null);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        if (requestCode >= 0) {
            this.mStartedActivity = true;
        }
    }

    @Override
    public void startActivity(Intent intent) {
        this.startActivity(intent, null);
    }

    @Override
    public void startActivity(Intent intent, Bundle options) {
        if (options != null) {
            this.startActivityForResult(intent, -1, options);
        } else {
            this.startActivityForResult(intent, -1);
        }
    }

    @Override
    public void startActivities(Intent[] intents) {
        this.startActivities(intents, null);
    }

    @Override
    public void startActivities(Intent[] intents, Bundle options) {
        this.mInstrumentation.execStartActivities(this, this.mMainThread.getApplicationThread(), this.mToken, this, intents, options);
    }

    @Override
    public void startIntentSender(IntentSender intent, Intent fillInIntent, int flagsMask, int flagsValues, int extraFlags) throws IntentSender.SendIntentException {
        this.startIntentSender(intent, fillInIntent, flagsMask, flagsValues, extraFlags, null);
    }

    @Override
    public void startIntentSender(IntentSender intent, Intent fillInIntent, int flagsMask, int flagsValues, int extraFlags, Bundle options) throws IntentSender.SendIntentException {
        if (options != null) {
            this.startIntentSenderForResult(intent, -1, fillInIntent, flagsMask, flagsValues, extraFlags, options);
        } else {
            this.startIntentSenderForResult(intent, -1, fillInIntent, flagsMask, flagsValues, extraFlags);
        }
    }

    public boolean startActivityIfNeeded(Intent intent, int requestCode) {
        return this.startActivityIfNeeded(intent, requestCode, null);
    }

    public boolean startActivityIfNeeded(Intent intent, int requestCode, Bundle options) {
        if (this.mParent == null) {
            int result = 1;
            try {
                Uri referrer = this.onProvideReferrer();
                if (referrer != null) {
                    intent.putExtra("android.intent.extra.REFERRER", referrer);
                }
                intent.migrateExtraStreamToClipData();
                intent.prepareToLeaveProcess(this);
                result = ActivityManager.getService().startActivity(this.mMainThread.getApplicationThread(), this.getBasePackageName(), intent, intent.resolveTypeIfNeeded(this.getContentResolver()), this.mToken, this.mEmbeddedID, requestCode, 1, null, options);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            Instrumentation.checkStartActivityResult(result, intent);
            if (requestCode >= 0) {
                this.mStartedActivity = true;
            }
            return result != 1;
        }
        throw new UnsupportedOperationException("startActivityIfNeeded can only be called from a top-level activity");
    }

    public boolean startNextMatchingActivity(Intent intent) {
        return this.startNextMatchingActivity(intent, null);
    }

    public boolean startNextMatchingActivity(Intent intent, Bundle options) {
        if (this.mParent == null) {
            try {
                intent.migrateExtraStreamToClipData();
                intent.prepareToLeaveProcess(this);
                return ActivityManager.getService().startNextMatchingActivity(this.mToken, intent, options);
            }
            catch (RemoteException remoteException) {
                return false;
            }
        }
        throw new UnsupportedOperationException("startNextMatchingActivity can only be called from a top-level activity");
    }

    public void startActivityFromChild(Activity child, Intent intent, int requestCode) {
        this.startActivityFromChild(child, intent, requestCode, null);
    }

    public void startActivityFromChild(Activity child, Intent intent, int requestCode, Bundle options) {
        options = this.transferSpringboardActivityOptions(options);
        Instrumentation.ActivityResult ar = this.mInstrumentation.execStartActivity((Context)this, (IBinder)this.mMainThread.getApplicationThread(), this.mToken, child, intent, requestCode, options);
        if (ar != null) {
            this.mMainThread.sendActivityResult(this.mToken, child.mEmbeddedID, requestCode, ar.getResultCode(), ar.getResultData());
        }
        this.cancelInputsAndStartExitTransition(options);
    }

    public void startActivityFromFragment(Fragment fragment, Intent intent, int requestCode) {
        this.startActivityFromFragment(fragment, intent, requestCode, null);
    }

    public void startActivityFromFragment(Fragment fragment, Intent intent, int requestCode, Bundle options) {
        this.startActivityForResult(fragment.mWho, intent, requestCode, options);
    }

    @Override
    public void startActivityForResult(String who, Intent intent, int requestCode, Bundle options) {
        Uri referrer = this.onProvideReferrer();
        if (referrer != null) {
            intent.putExtra("android.intent.extra.REFERRER", referrer);
        }
        options = this.transferSpringboardActivityOptions(options);
        Instrumentation.ActivityResult ar = this.mInstrumentation.execStartActivity((Context)this, (IBinder)this.mMainThread.getApplicationThread(), this.mToken, who, intent, requestCode, options);
        if (ar != null) {
            this.mMainThread.sendActivityResult(this.mToken, who, requestCode, ar.getResultCode(), ar.getResultData());
        }
        this.cancelInputsAndStartExitTransition(options);
    }

    @Override
    public boolean canStartActivityForResult() {
        return true;
    }

    public void startIntentSenderFromChild(Activity child, IntentSender intent, int requestCode, Intent fillInIntent, int flagsMask, int flagsValues, int extraFlags) throws IntentSender.SendIntentException {
        this.startIntentSenderFromChild(child, intent, requestCode, fillInIntent, flagsMask, flagsValues, extraFlags, null);
    }

    public void startIntentSenderFromChild(Activity child, IntentSender intent, int requestCode, Intent fillInIntent, int flagsMask, int flagsValues, int extraFlags, Bundle options) throws IntentSender.SendIntentException {
        this.startIntentSenderForResultInner(intent, child.mEmbeddedID, requestCode, fillInIntent, flagsMask, flagsValues, options);
    }

    public void startIntentSenderFromChildFragment(Fragment child, IntentSender intent, int requestCode, Intent fillInIntent, int flagsMask, int flagsValues, int extraFlags, Bundle options) throws IntentSender.SendIntentException {
        this.startIntentSenderForResultInner(intent, child.mWho, requestCode, fillInIntent, flagsMask, flagsValues, options);
    }

    public void overridePendingTransition(int enterAnim, int exitAnim) {
        try {
            ActivityManager.getService().overridePendingTransition(this.mToken, this.getPackageName(), enterAnim, exitAnim);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setResult(int resultCode) {
        Activity activity = this;
        synchronized (activity) {
            this.mResultCode = resultCode;
            this.mResultData = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setResult(int resultCode, Intent data) {
        Activity activity = this;
        synchronized (activity) {
            this.mResultCode = resultCode;
            this.mResultData = data;
        }
    }

    public Uri getReferrer() {
        Intent intent = this.getIntent();
        try {
            Uri referrer = (Uri)intent.getParcelableExtra("android.intent.extra.REFERRER");
            if (referrer != null) {
                return referrer;
            }
            String referrerName = intent.getStringExtra("android.intent.extra.REFERRER_NAME");
            if (referrerName != null) {
                return Uri.parse(referrerName);
            }
        }
        catch (BadParcelableException e) {
            Log.w(TAG, "Cannot read referrer from intent; intent extras contain unknown custom Parcelable objects");
        }
        if (this.mReferrer != null) {
            return new Uri.Builder().scheme("android-app").authority(this.mReferrer).build();
        }
        return null;
    }

    public Uri onProvideReferrer() {
        return null;
    }

    public String getCallingPackage() {
        try {
            return ActivityManager.getService().getCallingPackage(this.mToken);
        }
        catch (RemoteException e) {
            return null;
        }
    }

    public ComponentName getCallingActivity() {
        try {
            return ActivityManager.getService().getCallingActivity(this.mToken);
        }
        catch (RemoteException e) {
            return null;
        }
    }

    public void setVisible(boolean visible) {
        if (this.mVisibleFromClient != visible) {
            this.mVisibleFromClient = visible;
            if (this.mVisibleFromServer) {
                if (visible) {
                    this.makeVisible();
                } else {
                    this.mDecor.setVisibility(4);
                }
            }
        }
    }

    void makeVisible() {
        if (!this.mWindowAdded) {
            WindowManager wm = this.getWindowManager();
            wm.addView(this.mDecor, this.getWindow().getAttributes());
            this.mWindowAdded = true;
        }
        this.mDecor.setVisibility(0);
    }

    public boolean isFinishing() {
        return this.mFinished;
    }

    public boolean isDestroyed() {
        return this.mDestroyed;
    }

    public boolean isChangingConfigurations() {
        return this.mChangingConfigurations;
    }

    public void recreate() {
        if (this.mParent != null) {
            throw new IllegalStateException("Can only be called on top-level activity");
        }
        if (Looper.myLooper() != this.mMainThread.getLooper()) {
            throw new IllegalStateException("Must be called from main thread");
        }
        try {
            ActivityManager.getService().requestActivityRelaunch(this.mToken);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finish(int finishTask) {
        if (this.mParent == null) {
            Intent resultData;
            int resultCode;
            Activity activity = this;
            synchronized (activity) {
                resultCode = this.mResultCode;
                resultData = this.mResultData;
            }
            try {
                if (resultData != null) {
                    resultData.prepareToLeaveProcess(this);
                }
                if (ActivityManager.getService().finishActivity(this.mToken, resultCode, resultData, finishTask)) {
                    this.mFinished = true;
                }
            }
            catch (RemoteException remoteException) {}
        } else {
            this.mParent.finishFromChild(this);
        }
    }

    public void finish() {
        this.finish(0);
    }

    public void finishAffinity() {
        if (this.mParent != null) {
            throw new IllegalStateException("Can not be called from an embedded activity");
        }
        if (this.mResultCode != 0 || this.mResultData != null) {
            throw new IllegalStateException("Can not be called to deliver a result");
        }
        try {
            if (ActivityManager.getService().finishActivityAffinity(this.mToken)) {
                this.mFinished = true;
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void finishFromChild(Activity child) {
        this.finish();
    }

    public void finishAfterTransition() {
        if (!this.mActivityTransitionState.startExitBackTransition(this)) {
            this.finish();
        }
    }

    public void finishActivity(int requestCode) {
        if (this.mParent == null) {
            try {
                ActivityManager.getService().finishSubActivity(this.mToken, this.mEmbeddedID, requestCode);
            }
            catch (RemoteException remoteException) {}
        } else {
            this.mParent.finishActivityFromChild(this, requestCode);
        }
    }

    public void finishActivityFromChild(Activity child, int requestCode) {
        try {
            ActivityManager.getService().finishSubActivity(this.mToken, child.mEmbeddedID, requestCode);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void finishAndRemoveTask() {
        this.finish(1);
    }

    public boolean releaseInstance() {
        try {
            return ActivityManager.getService().releaseActivityInstance(this.mToken);
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
    }

    public void onActivityReenter(int resultCode, Intent data) {
    }

    public PendingIntent createPendingResult(int requestCode, Intent data, int flags) {
        String packageName = this.getPackageName();
        try {
            data.prepareToLeaveProcess(this);
            IIntentSender target = ActivityManager.getService().getIntentSender(3, packageName, this.mParent == null ? this.mToken : this.mParent.mToken, this.mEmbeddedID, requestCode, new Intent[]{data}, null, flags, null, UserHandle.myUserId());
            return target != null ? new PendingIntent(target) : null;
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    public void setRequestedOrientation(int requestedOrientation) {
        if (this.mParent == null) {
            try {
                ActivityManager.getService().setRequestedOrientation(this.mToken, requestedOrientation);
            }
            catch (RemoteException remoteException) {}
        } else {
            this.mParent.setRequestedOrientation(requestedOrientation);
        }
    }

    public int getRequestedOrientation() {
        if (this.mParent == null) {
            try {
                return ActivityManager.getService().getRequestedOrientation(this.mToken);
            }
            catch (RemoteException remoteException) {
            }
        } else {
            return this.mParent.getRequestedOrientation();
        }
        return -1;
    }

    public int getTaskId() {
        try {
            return ActivityManager.getService().getTaskForActivity(this.mToken, false);
        }
        catch (RemoteException e) {
            return -1;
        }
    }

    public boolean isTaskRoot() {
        try {
            return ActivityManager.getService().getTaskForActivity(this.mToken, true) >= 0;
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public boolean moveTaskToBack(boolean nonRoot) {
        try {
            return ActivityManager.getService().moveActivityTaskToBack(this.mToken, nonRoot);
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    public String getLocalClassName() {
        String pkg = this.getPackageName();
        String cls = this.mComponent.getClassName();
        int packageLen = pkg.length();
        if (!cls.startsWith(pkg) || cls.length() <= packageLen || cls.charAt(packageLen) != '.') {
            return cls;
        }
        return cls.substring(packageLen + 1);
    }

    public ComponentName getComponentName() {
        return this.mComponent;
    }

    public SharedPreferences getPreferences(int mode) {
        return this.getSharedPreferences(this.getLocalClassName(), mode);
    }

    private void ensureSearchManager() {
        if (this.mSearchManager != null) {
            return;
        }
        try {
            this.mSearchManager = new SearchManager(this, null);
        }
        catch (ServiceManager.ServiceNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public Object getSystemService(String name) {
        if (this.getBaseContext() == null) {
            throw new IllegalStateException("System services not available to Activities before onCreate()");
        }
        if ("window".equals(name)) {
            return this.mWindowManager;
        }
        if ("search".equals(name)) {
            this.ensureSearchManager();
            return this.mSearchManager;
        }
        return super.getSystemService(name);
    }

    public void setTitle(CharSequence title) {
        this.mTitle = title;
        this.onTitleChanged(title, this.mTitleColor);
        if (this.mParent != null) {
            this.mParent.onChildTitleChanged(this, title);
        }
    }

    public void setTitle(int titleId) {
        this.setTitle(this.getText(titleId));
    }

    @Deprecated
    public void setTitleColor(int textColor) {
        this.mTitleColor = textColor;
        this.onTitleChanged(this.mTitle, textColor);
    }

    public final CharSequence getTitle() {
        return this.mTitle;
    }

    public final int getTitleColor() {
        return this.mTitleColor;
    }

    protected void onTitleChanged(CharSequence title, int color2) {
        if (this.mTitleReady) {
            Window win = this.getWindow();
            if (win != null) {
                win.setTitle(title);
                if (color2 != 0) {
                    win.setTitleColor(color2);
                }
            }
            if (this.mActionBar != null) {
                this.mActionBar.setWindowTitle(title);
            }
        }
    }

    protected void onChildTitleChanged(Activity childActivity, CharSequence title) {
    }

    public void setTaskDescription(ActivityManager.TaskDescription taskDescription) {
        if (this.mTaskDescription != taskDescription) {
            this.mTaskDescription.copyFrom(taskDescription);
            if (taskDescription.getIconFilename() == null && taskDescription.getIcon() != null) {
                int size = ActivityManager.getLauncherLargeIconSizeInner(this);
                Bitmap icon = Bitmap.createScaledBitmap(taskDescription.getIcon(), size, size, true);
                this.mTaskDescription.setIcon(icon);
            }
        }
        try {
            ActivityManager.getService().setTaskDescription(this.mToken, this.mTaskDescription);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Deprecated
    public final void setProgressBarVisibility(boolean visible) {
        this.getWindow().setFeatureInt(2, visible ? -1 : -2);
    }

    @Deprecated
    public final void setProgressBarIndeterminateVisibility(boolean visible) {
        this.getWindow().setFeatureInt(5, visible ? -1 : -2);
    }

    @Deprecated
    public final void setProgressBarIndeterminate(boolean indeterminate) {
        this.getWindow().setFeatureInt(2, indeterminate ? -3 : -4);
    }

    @Deprecated
    public final void setProgress(int progress) {
        this.getWindow().setFeatureInt(2, progress + 0);
    }

    @Deprecated
    public final void setSecondaryProgress(int secondaryProgress) {
        this.getWindow().setFeatureInt(2, secondaryProgress + 20000);
    }

    public final void setVolumeControlStream(int streamType) {
        this.getWindow().setVolumeControlStream(streamType);
    }

    public final int getVolumeControlStream() {
        return this.getWindow().getVolumeControlStream();
    }

    public final void setMediaController(MediaController controller) {
        this.getWindow().setMediaController(controller);
    }

    public final MediaController getMediaController() {
        return this.getWindow().getMediaController();
    }

    public final void runOnUiThread(Runnable action) {
        if (Thread.currentThread() != this.mUiThread) {
            this.mHandler.post(action);
        } else {
            action.run();
        }
    }

    @Override
    public View onCreateView(String name, Context context, AttributeSet attrs) {
        return null;
    }

    @Override
    public View onCreateView(View parent, String name, Context context, AttributeSet attrs) {
        if (!"fragment".equals(name)) {
            return this.onCreateView(name, context, attrs);
        }
        return this.mFragments.onCreateView(parent, name, context, attrs);
    }

    public void dump(String prefix, FileDescriptor fd, PrintWriter writer, String[] args) {
        this.dumpInner(prefix, fd, writer, args);
    }

    void dumpInner(String prefix, FileDescriptor fd, PrintWriter writer, String[] args) {
        writer.print(prefix);
        writer.print("Local Activity ");
        writer.print(Integer.toHexString(System.identityHashCode(this)));
        writer.println(" State:");
        String innerPrefix = prefix + "  ";
        writer.print(innerPrefix);
        writer.print("mResumed=");
        writer.print(this.mResumed);
        writer.print(" mStopped=");
        writer.print(this.mStopped);
        writer.print(" mFinished=");
        writer.println(this.mFinished);
        writer.print(innerPrefix);
        writer.print("mChangingConfigurations=");
        writer.println(this.mChangingConfigurations);
        writer.print(innerPrefix);
        writer.print("mCurrentConfig=");
        writer.println(this.mCurrentConfig);
        this.mFragments.dumpLoaders(innerPrefix, fd, writer, args);
        this.mFragments.getFragmentManager().dump(innerPrefix, fd, writer, args);
        if (this.mVoiceInteractor != null) {
            this.mVoiceInteractor.dump(innerPrefix, fd, writer, args);
        }
        if (this.getWindow() != null && this.getWindow().peekDecorView() != null && this.getWindow().peekDecorView().getViewRootImpl() != null) {
            this.getWindow().peekDecorView().getViewRootImpl().dump(prefix, fd, writer, args);
        }
        this.mHandler.getLooper().dump(new PrintWriterPrinter(writer), prefix);
    }

    public boolean isImmersive() {
        try {
            return ActivityManager.getService().isImmersive(this.mToken);
        }
        catch (RemoteException e) {
            return false;
        }
    }

    private boolean isTopOfTask() {
        if (this.mToken == null || this.mWindow == null) {
            return false;
        }
        try {
            return ActivityManager.getService().isTopOfTask(this.getActivityToken());
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public void convertFromTranslucent() {
        try {
            this.mTranslucentCallback = null;
            if (ActivityManager.getService().convertFromTranslucent(this.mToken)) {
                WindowManagerGlobal.getInstance().changeCanvasOpacity(this.mToken, true);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public boolean convertToTranslucent(TranslucentConversionListener callback, ActivityOptions options) {
        boolean drawComplete;
        try {
            this.mTranslucentCallback = callback;
            this.mChangeCanvasToTranslucent = ActivityManager.getService().convertToTranslucent(this.mToken, options == null ? null : options.toBundle());
            WindowManagerGlobal.getInstance().changeCanvasOpacity(this.mToken, false);
            drawComplete = true;
        }
        catch (RemoteException e) {
            this.mChangeCanvasToTranslucent = false;
            drawComplete = false;
        }
        if (!this.mChangeCanvasToTranslucent && this.mTranslucentCallback != null) {
            this.mTranslucentCallback.onTranslucentConversionComplete(drawComplete);
        }
        return this.mChangeCanvasToTranslucent;
    }

    void onTranslucentConversionComplete(boolean drawComplete) {
        if (this.mTranslucentCallback != null) {
            this.mTranslucentCallback.onTranslucentConversionComplete(drawComplete);
            this.mTranslucentCallback = null;
        }
        if (this.mChangeCanvasToTranslucent) {
            WindowManagerGlobal.getInstance().changeCanvasOpacity(this.mToken, false);
        }
    }

    public void onNewActivityOptions(ActivityOptions options) {
        this.mActivityTransitionState.setEnterActivityOptions(this, options);
        if (!this.mStopped) {
            this.mActivityTransitionState.enterReady(this);
        }
    }

    ActivityOptions getActivityOptions() {
        try {
            return ActivityOptions.fromBundle(ActivityManager.getService().getActivityOptions(this.mToken));
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    public boolean requestVisibleBehind(boolean visible) {
        if (!this.mResumed) {
            visible = false;
        }
        try {
            this.mVisibleBehind = ActivityManager.getService().requestVisibleBehind(this.mToken, visible) && visible;
        }
        catch (RemoteException e) {
            this.mVisibleBehind = false;
        }
        return this.mVisibleBehind;
    }

    public void onVisibleBehindCanceled() {
        this.mCalled = true;
    }

    public boolean isBackgroundVisibleBehind() {
        try {
            return ActivityManager.getService().isBackgroundVisibleBehind(this.mToken);
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    public void onBackgroundVisibleBehindChanged(boolean visible) {
    }

    public void onEnterAnimationComplete() {
    }

    public void dispatchEnterAnimationComplete() {
        this.onEnterAnimationComplete();
        if (this.getWindow() != null && this.getWindow().getDecorView() != null) {
            this.getWindow().getDecorView().getViewTreeObserver().dispatchOnEnterAnimationComplete();
        }
    }

    public void setImmersive(boolean i) {
        try {
            ActivityManager.getService().setImmersive(this.mToken, i);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void setVrModeEnabled(boolean enabled, ComponentName requestedComponent) throws PackageManager.NameNotFoundException {
        try {
            if (ActivityManager.getService().setVrMode(this.mToken, enabled, requestedComponent) != 0) {
                throw new PackageManager.NameNotFoundException(requestedComponent.flattenToString());
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public ActionMode startActionMode(ActionMode.Callback callback) {
        return this.mWindow.getDecorView().startActionMode(callback);
    }

    public ActionMode startActionMode(ActionMode.Callback callback, int type) {
        return this.mWindow.getDecorView().startActionMode(callback, type);
    }

    @Override
    public ActionMode onWindowStartingActionMode(ActionMode.Callback callback) {
        if (this.mActionModeTypeStarting == 0) {
            this.initWindowDecorActionBar();
            if (this.mActionBar != null) {
                return this.mActionBar.startActionMode(callback);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ActionMode onWindowStartingActionMode(ActionMode.Callback callback, int type) {
        try {
            this.mActionModeTypeStarting = type;
            ActionMode actionMode = this.onWindowStartingActionMode(callback);
            return actionMode;
        }
        finally {
            this.mActionModeTypeStarting = 0;
        }
    }

    @Override
    public void onActionModeStarted(ActionMode mode) {
    }

    @Override
    public void onActionModeFinished(ActionMode mode) {
    }

    public boolean shouldUpRecreateTask(Intent targetIntent) {
        try {
            PackageManager pm = this.getPackageManager();
            ComponentName cn = targetIntent.getComponent();
            if (cn == null) {
                cn = targetIntent.resolveActivity(pm);
            }
            ActivityInfo info = pm.getActivityInfo(cn, 0);
            if (info.taskAffinity == null) {
                return false;
            }
            return ActivityManager.getService().shouldUpRecreateTask(this.mToken, info.taskAffinity);
        }
        catch (RemoteException e) {
            return false;
        }
        catch (PackageManager.NameNotFoundException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean navigateUpTo(Intent upIntent) {
        if (this.mParent == null) {
            Intent resultData;
            int resultCode;
            ComponentName destInfo = upIntent.getComponent();
            if (destInfo == null) {
                destInfo = upIntent.resolveActivity(this.getPackageManager());
                if (destInfo == null) {
                    return false;
                }
                upIntent = new Intent(upIntent);
                upIntent.setComponent(destInfo);
            }
            Activity activity = this;
            synchronized (activity) {
                resultCode = this.mResultCode;
                resultData = this.mResultData;
            }
            if (resultData != null) {
                resultData.prepareToLeaveProcess(this);
            }
            try {
                upIntent.prepareToLeaveProcess(this);
                return ActivityManager.getService().navigateUpTo(this.mToken, upIntent, resultCode, resultData);
            }
            catch (RemoteException e) {
                return false;
            }
        }
        return this.mParent.navigateUpToFromChild(this, upIntent);
    }

    public boolean navigateUpToFromChild(Activity child, Intent upIntent) {
        return this.navigateUpTo(upIntent);
    }

    public Intent getParentActivityIntent() {
        String parentName = this.mActivityInfo.parentActivityName;
        if (TextUtils.isEmpty(parentName)) {
            return null;
        }
        ComponentName target = new ComponentName((Context)this, parentName);
        try {
            ActivityInfo parentInfo = this.getPackageManager().getActivityInfo(target, 0);
            String parentActivity = parentInfo.parentActivityName;
            Intent parentIntent = parentActivity == null ? Intent.makeMainActivity(target) : new Intent().setComponent(target);
            return parentIntent;
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.e(TAG, "getParentActivityIntent: bad parentActivityName '" + parentName + "' in manifest");
            return null;
        }
    }

    public void setEnterSharedElementCallback(SharedElementCallback callback) {
        if (callback == null) {
            callback = SharedElementCallback.NULL_CALLBACK;
        }
        this.mEnterTransitionListener = callback;
    }

    public void setExitSharedElementCallback(SharedElementCallback callback) {
        if (callback == null) {
            callback = SharedElementCallback.NULL_CALLBACK;
        }
        this.mExitTransitionListener = callback;
    }

    public void postponeEnterTransition() {
        this.mActivityTransitionState.postponeEnterTransition();
    }

    public void startPostponedEnterTransition() {
        this.mActivityTransitionState.startPostponedEnterTransition();
    }

    public DragAndDropPermissions requestDragAndDropPermissions(DragEvent event) {
        DragAndDropPermissions dragAndDropPermissions = DragAndDropPermissions.obtain(event);
        if (dragAndDropPermissions != null && dragAndDropPermissions.take(this.getActivityToken())) {
            return dragAndDropPermissions;
        }
        return null;
    }

    final void setParent(Activity parent) {
        this.mParent = parent;
    }

    final void attach(Context context, ActivityThread aThread, Instrumentation instr, IBinder token, int ident, Application application, Intent intent, ActivityInfo info, CharSequence title, Activity parent, String id2, NonConfigurationInstances lastNonConfigurationInstances, Configuration config, String referrer, IVoiceInteractor voiceInteractor, Window window) {
        this.attachBaseContext(context);
        this.mFragments.attachHost(null);
        this.mWindow = new PhoneWindow(this, window);
        this.mWindow.setWindowControllerCallback(this);
        this.mWindow.setCallback(this);
        this.mWindow.setOnWindowDismissedCallback(this);
        this.mWindow.getLayoutInflater().setPrivateFactory(this);
        if (info.softInputMode != 0) {
            this.mWindow.setSoftInputMode(info.softInputMode);
        }
        if (info.uiOptions != 0) {
            this.mWindow.setUiOptions(info.uiOptions);
        }
        this.mUiThread = Thread.currentThread();
        this.mMainThread = aThread;
        this.mInstrumentation = instr;
        this.mToken = token;
        this.mIdent = ident;
        this.mApplication = application;
        this.mIntent = intent;
        this.mReferrer = referrer;
        this.mComponent = intent.getComponent();
        this.mActivityInfo = info;
        this.mTitle = title;
        this.mParent = parent;
        this.mEmbeddedID = id2;
        this.mLastNonConfigurationInstances = lastNonConfigurationInstances;
        if (voiceInteractor != null) {
            this.mVoiceInteractor = lastNonConfigurationInstances != null ? lastNonConfigurationInstances.voiceInteractor : new VoiceInteractor(voiceInteractor, this, this, Looper.myLooper());
        }
        this.mWindow.setWindowManager((WindowManager)context.getSystemService("window"), this.mToken, this.mComponent.flattenToString(), (info.flags & 0x200) != 0);
        if (this.mParent != null) {
            this.mWindow.setContainer(this.mParent.getWindow());
        }
        this.mWindowManager = this.mWindow.getWindowManager();
        this.mCurrentConfig = config;
        this.mWindow.setColorMode(info.colorMode);
    }

    @Override
    public final IBinder getActivityToken() {
        return this.mParent != null ? this.mParent.getActivityToken() : this.mToken;
    }

    final void performCreateCommon() {
        this.mVisibleFromClient = !this.mWindow.getWindowStyle().getBoolean(10, false);
        this.mFragments.dispatchActivityCreated();
        this.mActivityTransitionState.setEnterActivityOptions(this, this.getActivityOptions());
    }

    final void performCreate(Bundle icicle) {
        this.restoreHasCurrentPermissionRequest(icicle);
        this.onCreate(icicle);
        this.mActivityTransitionState.readState(icicle);
        this.performCreateCommon();
    }

    final void performCreate(Bundle icicle, PersistableBundle persistentState) {
        this.restoreHasCurrentPermissionRequest(icicle);
        this.onCreate(icicle, persistentState);
        this.mActivityTransitionState.readState(icicle);
        this.performCreateCommon();
    }

    final void performStart() {
        String dlwarning;
        boolean isAppDebuggable;
        this.mActivityTransitionState.setEnterActivityOptions(this, this.getActivityOptions());
        this.mFragments.noteStateNotSaved();
        this.mCalled = false;
        this.mFragments.execPendingActions();
        this.mInstrumentation.callActivityOnStart(this);
        if (!this.mCalled) {
            throw new SuperNotCalledException("Activity " + this.mComponent.toShortString() + " did not call through to super.onStart()");
        }
        this.mFragments.dispatchStart();
        this.mFragments.reportLoaderStart();
        boolean isDlwarningEnabled = SystemProperties.getInt("ro.bionic.ld.warning", 0) == 1;
        boolean bl = isAppDebuggable = (this.mApplication.getApplicationInfo().flags & 2) != 0;
        if ((isAppDebuggable || isDlwarningEnabled) && (dlwarning = Activity.getDlWarning()) != null) {
            String appName = this.getApplicationInfo().loadLabel(this.getPackageManager()).toString();
            String warning = "Detected problems with app native libraries\n(please consult log for detail):\n" + dlwarning;
            if (isAppDebuggable) {
                new AlertDialog.Builder(this).setTitle(appName).setMessage(warning).setPositiveButton(17039370, null).setCancelable(false).show();
            } else {
                Toast.makeText((Context)this, appName + "\n" + warning, 1).show();
            }
        }
        this.mActivityTransitionState.enterReady(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void performRestart() {
        this.mFragments.noteStateNotSaved();
        if (this.mToken != null && this.mParent == null) {
            WindowManagerGlobal.getInstance().setStoppedState(this.mToken, false);
        }
        if (this.mStopped) {
            this.mStopped = false;
            ArrayList<ManagedCursor> arrayList = this.mManagedCursors;
            synchronized (arrayList) {
                int N = this.mManagedCursors.size();
                for (int i = 0; i < N; ++i) {
                    ManagedCursor mc = this.mManagedCursors.get(i);
                    if (!mc.mReleased && !mc.mUpdated) continue;
                    if (!mc.mCursor.requery() && this.getApplicationInfo().targetSdkVersion >= 14) {
                        throw new IllegalStateException("trying to requery an already closed cursor  " + mc.mCursor);
                    }
                    mc.mReleased = false;
                    mc.mUpdated = false;
                }
            }
            this.mCalled = false;
            this.mInstrumentation.callActivityOnRestart(this);
            if (!this.mCalled) {
                throw new SuperNotCalledException("Activity " + this.mComponent.toShortString() + " did not call through to super.onRestart()");
            }
            this.performStart();
        }
    }

    final void performResume() {
        this.performRestart();
        this.mFragments.execPendingActions();
        this.mLastNonConfigurationInstances = null;
        this.mCalled = false;
        this.mInstrumentation.callActivityOnResume(this);
        if (!this.mCalled) {
            throw new SuperNotCalledException("Activity " + this.mComponent.toShortString() + " did not call through to super.onResume()");
        }
        if (!this.mVisibleFromClient && !this.mFinished) {
            Log.w(TAG, "An activity without a UI must call finish() before onResume() completes");
            if (this.getApplicationInfo().targetSdkVersion > 22) {
                throw new IllegalStateException("Activity " + this.mComponent.toShortString() + " did not call finish() prior to onResume() completing");
            }
        }
        this.mCalled = false;
        this.mFragments.dispatchResume();
        this.mFragments.execPendingActions();
        this.onPostResume();
        if (!this.mCalled) {
            throw new SuperNotCalledException("Activity " + this.mComponent.toShortString() + " did not call through to super.onPostResume()");
        }
    }

    final void performPause() {
        this.mDoReportFullyDrawn = false;
        this.mFragments.dispatchPause();
        this.mCalled = false;
        this.onPause();
        this.mResumed = false;
        if (!this.mCalled && this.getApplicationInfo().targetSdkVersion >= 9) {
            throw new SuperNotCalledException("Activity " + this.mComponent.toShortString() + " did not call through to super.onPause()");
        }
        this.mResumed = false;
    }

    final void performUserLeaving() {
        this.onUserInteraction();
        this.onUserLeaveHint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void performStop(boolean preserveWindow) {
        this.mDoReportFullyDrawn = false;
        this.mFragments.doLoaderStop(this.mChangingConfigurations);
        if (!this.mStopped) {
            if (this.mWindow != null) {
                this.mWindow.closeAllPanels();
            }
            if (!preserveWindow && this.mToken != null && this.mParent == null) {
                WindowManagerGlobal.getInstance().setStoppedState(this.mToken, true);
            }
            this.mFragments.dispatchStop();
            this.mCalled = false;
            this.mInstrumentation.callActivityOnStop(this);
            if (!this.mCalled) {
                throw new SuperNotCalledException("Activity " + this.mComponent.toShortString() + " did not call through to super.onStop()");
            }
            ArrayList<ManagedCursor> arrayList = this.mManagedCursors;
            synchronized (arrayList) {
                int N = this.mManagedCursors.size();
                for (int i = 0; i < N; ++i) {
                    ManagedCursor mc = this.mManagedCursors.get(i);
                    if (mc.mReleased) continue;
                    mc.mCursor.deactivate();
                    mc.mReleased = true;
                }
            }
            this.mStopped = true;
        }
        this.mResumed = false;
    }

    final void performDestroy() {
        this.mDestroyed = true;
        this.mWindow.destroy();
        this.mFragments.dispatchDestroy();
        this.onDestroy();
        this.mFragments.doLoaderDestroy();
        if (this.mVoiceInteractor != null) {
            this.mVoiceInteractor.detachActivity();
        }
    }

    final void dispatchMultiWindowModeChanged(boolean isInMultiWindowMode) {
        this.mFragments.dispatchMultiWindowModeChanged(isInMultiWindowMode);
        if (this.mWindow != null) {
            this.mWindow.onMultiWindowModeChanged();
        }
        this.onMultiWindowModeChanged(isInMultiWindowMode);
    }

    final void dispatchPictureInPictureModeChanged(boolean isInPictureInPictureMode) {
        this.mFragments.dispatchPictureInPictureModeChanged(isInPictureInPictureMode);
        this.onPictureInPictureModeChanged(isInPictureInPictureMode);
    }

    public final boolean isResumed() {
        return this.mResumed;
    }

    private void storeHasCurrentPermissionRequest(Bundle bundle) {
        if (bundle != null && this.mHasCurrentPermissionsRequest) {
            bundle.putBoolean(HAS_CURENT_PERMISSIONS_REQUEST_KEY, true);
        }
    }

    private void restoreHasCurrentPermissionRequest(Bundle bundle) {
        if (bundle != null) {
            this.mHasCurrentPermissionsRequest = bundle.getBoolean(HAS_CURENT_PERMISSIONS_REQUEST_KEY, false);
        }
    }

    void dispatchActivityResult(String who, int requestCode, int resultCode, Intent data) {
        this.mFragments.noteStateNotSaved();
        if (who == null) {
            this.onActivityResult(requestCode, resultCode, data);
        } else if (who.startsWith(REQUEST_PERMISSIONS_WHO_PREFIX)) {
            if (TextUtils.isEmpty(who = who.substring(REQUEST_PERMISSIONS_WHO_PREFIX.length()))) {
                this.dispatchRequestPermissionsResult(requestCode, data);
            } else {
                Fragment frag = this.mFragments.findFragmentByWho(who);
                if (frag != null) {
                    this.dispatchRequestPermissionsResultToFragment(requestCode, data, frag);
                }
            }
        } else if (who.startsWith("@android:view:")) {
            ArrayList<ViewRootImpl> views = WindowManagerGlobal.getInstance().getRootViews(this.getActivityToken());
            for (ViewRootImpl viewRoot : views) {
                if (viewRoot.getView() == null || !viewRoot.getView().dispatchActivityResult(who, requestCode, resultCode, data)) continue;
                return;
            }
        } else if (who.startsWith(AUTO_FILL_AUTH_WHO_PREFIX)) {
            Intent resultData = resultCode == -1 ? data : null;
            this.getSystemService(AutoFillManager.class).onAuthenticationResult(resultData);
        } else {
            Fragment frag = this.mFragments.findFragmentByWho(who);
            if (frag != null) {
                frag.onActivityResult(requestCode, resultCode, data);
            }
        }
    }

    public void startLockTask() {
        try {
            ActivityManager.getService().startLockTaskModeByToken(this.mToken);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void stopLockTask() {
        try {
            ActivityManager.getService().stopLockTaskMode();
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void showLockTaskEscapeMessage() {
        try {
            ActivityManager.getService().showLockTaskEscapeMessage(this.mToken);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public boolean isOverlayWithDecorCaptionEnabled() {
        return this.mWindow.isOverlayWithDecorCaptionEnabled();
    }

    public void setOverlayWithDecorCaptionEnabled(boolean enabled) {
        this.mWindow.setOverlayWithDecorCaptionEnabled(enabled);
    }

    private void dispatchRequestPermissionsResult(int requestCode, Intent data) {
        this.mHasCurrentPermissionsRequest = false;
        String[] permissions = data != null ? data.getStringArrayExtra("android.content.pm.extra.REQUEST_PERMISSIONS_NAMES") : new String[]{};
        int[] grantResults = data != null ? data.getIntArrayExtra("android.content.pm.extra.REQUEST_PERMISSIONS_RESULTS") : new int[]{};
        this.onRequestPermissionsResult(requestCode, permissions, grantResults);
    }

    private void dispatchRequestPermissionsResultToFragment(int requestCode, Intent data, Fragment fragment) {
        String[] permissions = data != null ? data.getStringArrayExtra("android.content.pm.extra.REQUEST_PERMISSIONS_NAMES") : new String[]{};
        int[] grantResults = data != null ? data.getIntArrayExtra("android.content.pm.extra.REQUEST_PERMISSIONS_RESULTS") : new int[]{};
        fragment.onRequestPermissionsResult(requestCode, permissions, grantResults);
    }

    @Override
    public void autoFill(List<AutoFillId> ids, List<AutoFillValue> values) {
        View root = this.getWindow().getDecorView();
        int itemCount = ids.size();
        for (int i = 0; i < itemCount; ++i) {
            AutoFillId id2 = ids.get(i);
            AutoFillValue value = values.get(i);
            int viewId = id2.getViewId();
            Object view = root.findViewByAccessibilityIdTraversal(viewId);
            if (view == null) {
                Log.w(TAG, "autoFill(): no View with id " + viewId);
                continue;
            }
            if (id2.isVirtual()) {
                ((View)view).autoFillVirtual(id2.getVirtualChildId(), value);
                continue;
            }
            ((View)view).autoFill(value);
        }
    }

    @Override
    public void authenticate(IntentSender intent, Intent fillInIntent) {
        try {
            this.startIntentSenderForResultInner(intent, AUTO_FILL_AUTH_WHO_PREFIX, 0, fillInIntent, 0, 0, null);
        }
        catch (IntentSender.SendIntentException e) {
            Log.e(TAG, "authenticate() failed for intent:" + intent, e);
        }
    }

    @Override
    public void resetableStateAvailable() {
        this.mAutoFillResetNeeded = true;
    }

    class HostCallbacks
    extends FragmentHostCallback<Activity> {
        public HostCallbacks() {
            super(Activity.this);
        }

        @Override
        public void onDump(String prefix, FileDescriptor fd, PrintWriter writer, String[] args) {
            Activity.this.dump(prefix, fd, writer, args);
        }

        @Override
        public boolean onShouldSaveFragmentState(Fragment fragment) {
            return !Activity.this.isFinishing();
        }

        @Override
        public LayoutInflater onGetLayoutInflater() {
            LayoutInflater result = Activity.this.getLayoutInflater();
            if (this.onUseFragmentManagerInflaterFactory()) {
                return result.cloneInContext(Activity.this);
            }
            return result;
        }

        @Override
        public boolean onUseFragmentManagerInflaterFactory() {
            return Activity.this.getApplicationInfo().targetSdkVersion >= 21;
        }

        @Override
        public Activity onGetHost() {
            return Activity.this;
        }

        @Override
        public void onInvalidateOptionsMenu() {
            Activity.this.invalidateOptionsMenu();
        }

        @Override
        public void onStartActivityFromFragment(Fragment fragment, Intent intent, int requestCode, Bundle options) {
            Activity.this.startActivityFromFragment(fragment, intent, requestCode, options);
        }

        @Override
        public void onStartIntentSenderFromFragment(Fragment fragment, IntentSender intent, int requestCode, Intent fillInIntent, int flagsMask, int flagsValues, int extraFlags, Bundle options) throws IntentSender.SendIntentException {
            if (Activity.this.mParent == null) {
                Activity.this.startIntentSenderForResultInner(intent, fragment.mWho, requestCode, fillInIntent, flagsMask, flagsValues, options);
            } else if (options != null) {
                Activity.this.mParent.startIntentSenderFromChildFragment(fragment, intent, requestCode, fillInIntent, flagsMask, flagsValues, extraFlags, options);
            }
        }

        @Override
        public void onRequestPermissionsFromFragment(Fragment fragment, String[] permissions, int requestCode) {
            String who = Activity.REQUEST_PERMISSIONS_WHO_PREFIX + fragment.mWho;
            Intent intent = Activity.this.getPackageManager().buildRequestPermissionsIntent(permissions);
            Activity.this.startActivityForResult(who, intent, requestCode, null);
        }

        @Override
        public boolean onHasWindowAnimations() {
            return Activity.this.getWindow() != null;
        }

        @Override
        public int onGetWindowAnimations() {
            Window w = Activity.this.getWindow();
            return w == null ? 0 : w.getAttributes().windowAnimations;
        }

        @Override
        public void onAttachFragment(Fragment fragment) {
            Activity.this.onAttachFragment(fragment);
        }

        @Override
        public View onFindViewById(int id2) {
            return Activity.this.findViewById(id2);
        }

        @Override
        public boolean onHasView() {
            Window w = Activity.this.getWindow();
            return w != null && w.peekDecorView() != null;
        }
    }

    public static interface TranslucentConversionListener {
        public void onTranslucentConversionComplete(boolean var1);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @IntDef(value={0L, 1L, 2L, 3L, 4L})
    static @interface DefaultKeyMode {
    }

    private static final class ManagedCursor {
        private final Cursor mCursor;
        private boolean mReleased;
        private boolean mUpdated;

        ManagedCursor(Cursor cursor) {
            this.mCursor = cursor;
            this.mReleased = false;
            this.mUpdated = false;
        }
    }

    static final class NonConfigurationInstances {
        Object activity;
        HashMap<String, Object> children;
        FragmentManagerNonConfig fragments;
        ArrayMap<String, LoaderManager> loaders;
        VoiceInteractor voiceInteractor;

        NonConfigurationInstances() {
        }
    }

    private static class ManagedDialog {
        Dialog mDialog;
        Bundle mArgs;

        private ManagedDialog() {
        }
    }
}

