/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.app.Activity;
import android.app.ActivityTransitionCoordinator;
import android.app.EnterTransitionCoordinator$$Lambda$19;
import android.app.EnterTransitionCoordinator$$Lambda$20;
import android.app.EnterTransitionCoordinator$3$$Lambda$11;
import android.app.EnterTransitionCoordinator$3$$Lambda$12;
import android.app.SharedElementCallback;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.ResultReceiver;
import android.text.TextUtils;
import android.transition.Transition;
import android.transition.TransitionListenerAdapter;
import android.transition.TransitionManager;
import android.util.ArrayMap;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewGroupOverlay;
import android.view.ViewTreeObserver;
import android.view.Window;
import com.android.internal.view.OneShotPreDrawListener;
import java.util.ArrayList;

class EnterTransitionCoordinator
extends ActivityTransitionCoordinator {
    private static final String TAG = "EnterTransitionCoordinator";
    private static final int MIN_ANIMATION_FRAMES = 2;
    private boolean mSharedElementTransitionStarted;
    private Activity mActivity;
    private boolean mHasStopped;
    private boolean mIsCanceled;
    private ObjectAnimator mBackgroundAnimator;
    private boolean mIsExitTransitionComplete;
    private boolean mIsReadyForTransition;
    private Bundle mSharedElementsBundle;
    private boolean mWasOpaque;
    private boolean mAreViewsReady;
    private boolean mIsViewsTransitionStarted;
    private Transition mEnterViewsTransition;
    private OneShotPreDrawListener mViewsReadyListener;
    private final boolean mIsCrossTask;
    private Drawable mReplacedBackground;

    public EnterTransitionCoordinator(Activity activity, ResultReceiver resultReceiver, ArrayList<String> sharedElementNames, boolean isReturning, boolean isCrossTask) {
        super(activity.getWindow(), sharedElementNames, EnterTransitionCoordinator.getListener(activity, isReturning && !isCrossTask), isReturning);
        this.mActivity = activity;
        this.mIsCrossTask = isCrossTask;
        this.setResultReceiver(resultReceiver);
        this.prepareEnter();
        Bundle resultReceiverBundle = new Bundle();
        resultReceiverBundle.putParcelable("android:remoteReceiver", this);
        this.mResultReceiver.send(100, resultReceiverBundle);
        final ViewGroup decorView = this.getDecor();
        if (decorView != null) {
            final ViewTreeObserver viewTreeObserver = decorView.getViewTreeObserver();
            viewTreeObserver.addOnPreDrawListener(new ViewTreeObserver.OnPreDrawListener(){

                @Override
                public boolean onPreDraw() {
                    if (EnterTransitionCoordinator.this.mIsReadyForTransition) {
                        if (viewTreeObserver.isAlive()) {
                            viewTreeObserver.removeOnPreDrawListener(this);
                        } else {
                            decorView.getViewTreeObserver().removeOnPreDrawListener(this);
                        }
                    }
                    return false;
                }
            });
        }
    }

    boolean isCrossTask() {
        return this.mIsCrossTask;
    }

    public void viewInstancesReady(ArrayList<String> accepted, ArrayList<String> localNames, ArrayList<View> localViews) {
        boolean remap = false;
        for (int i = 0; i < localViews.size(); ++i) {
            View view = localViews.get(i);
            if (TextUtils.equals(view.getTransitionName(), localNames.get(i)) && view.isAttachedToWindow()) continue;
            remap = true;
            break;
        }
        if (remap) {
            this.triggerViewsReady(this.mapNamedElements(accepted, localNames));
        } else {
            this.triggerViewsReady(this.mapSharedElements(accepted, localViews));
        }
    }

    public void namedViewsReady(ArrayList<String> accepted, ArrayList<String> localNames) {
        this.triggerViewsReady(this.mapNamedElements(accepted, localNames));
    }

    public Transition getEnterViewsTransition() {
        return this.mEnterViewsTransition;
    }

    @Override
    protected void viewsReady(ArrayMap<String, View> sharedElements) {
        super.viewsReady(sharedElements);
        this.mIsReadyForTransition = true;
        this.hideViews(this.mSharedElements);
        if (this.getViewsTransition() != null && this.mTransitioningViews != null) {
            this.stripOffscreenViews();
            this.hideViews(this.mTransitioningViews);
        }
        if (this.mIsReturning) {
            this.sendSharedElementDestination();
        } else {
            this.moveSharedElementsToOverlay();
        }
        if (this.mSharedElementsBundle != null) {
            this.onTakeSharedElements();
        }
    }

    private void triggerViewsReady(ArrayMap<String, View> sharedElements) {
        if (this.mAreViewsReady) {
            return;
        }
        this.mAreViewsReady = true;
        ViewGroup decor = this.getDecor();
        if (decor == null || decor.isAttachedToWindow() && (sharedElements.isEmpty() || !sharedElements.valueAt(0).isLayoutRequested())) {
            this.viewsReady(sharedElements);
        } else {
            this.mViewsReadyListener = OneShotPreDrawListener.add(decor, EnterTransitionCoordinator$$Lambda$19.get$Lambda(this, sharedElements));
            decor.invalidate();
        }
    }

    private ArrayMap<String, View> mapNamedElements(ArrayList<String> accepted, ArrayList<String> localNames) {
        ArrayMap<String, View> sharedElements = new ArrayMap<String, View>();
        ViewGroup decorView = this.getDecor();
        if (decorView != null) {
            decorView.findNamedViews(sharedElements);
        }
        if (accepted != null) {
            for (int i = 0; i < localNames.size(); ++i) {
                View view;
                String localName = localNames.get(i);
                String acceptedName = accepted.get(i);
                if (localName == null || localName.equals(acceptedName) || (view = sharedElements.get(localName)) == null) continue;
                sharedElements.put(acceptedName, view);
            }
        }
        return sharedElements;
    }

    private void sendSharedElementDestination() {
        boolean allReady;
        ViewGroup decorView = this.getDecor();
        if (this.allowOverlappingTransitions() && this.getEnterViewsTransition() != null) {
            allReady = false;
        } else if (decorView == null) {
            allReady = true;
        } else {
            boolean bl = allReady = !decorView.isLayoutRequested();
            if (allReady) {
                for (int i = 0; i < this.mSharedElements.size(); ++i) {
                    if (!((View)this.mSharedElements.get(i)).isLayoutRequested()) continue;
                    allReady = false;
                    break;
                }
            }
        }
        if (allReady) {
            Bundle state = this.captureSharedElementState();
            this.moveSharedElementsToOverlay();
            this.mResultReceiver.send(107, state);
        } else if (decorView != null) {
            OneShotPreDrawListener.add(decorView, EnterTransitionCoordinator$$Lambda$20.get$Lambda(this));
        }
        if (this.allowOverlappingTransitions()) {
            this.startEnterTransitionOnly();
        }
    }

    private static SharedElementCallback getListener(Activity activity, boolean isReturning) {
        return isReturning ? activity.mExitTransitionListener : activity.mEnterTransitionListener;
    }

    @Override
    protected void onReceiveResult(int resultCode, Bundle resultData) {
        switch (resultCode) {
            case 103: {
                if (this.mIsCanceled) break;
                this.mSharedElementsBundle = resultData;
                this.onTakeSharedElements();
                break;
            }
            case 104: {
                if (this.mIsCanceled) break;
                this.mIsExitTransitionComplete = true;
                if (!this.mSharedElementTransitionStarted) break;
                this.onRemoteExitTransitionComplete();
                break;
            }
            case 106: {
                this.cancel();
            }
        }
    }

    public boolean isWaitingForRemoteExit() {
        return this.mIsReturning && this.mResultReceiver != null;
    }

    public void forceViewsToAppear() {
        if (!this.mIsReturning) {
            return;
        }
        if (!this.mIsReadyForTransition) {
            this.mIsReadyForTransition = true;
            ViewGroup decor = this.getDecor();
            if (decor != null && this.mViewsReadyListener != null) {
                this.mViewsReadyListener.removeListener();
                this.mViewsReadyListener = null;
            }
            this.showViews(this.mTransitioningViews, true);
            this.setTransitioningViewsVisiblity(0, true);
            this.mSharedElements.clear();
            this.mAllSharedElementNames.clear();
            this.mTransitioningViews.clear();
            this.mIsReadyForTransition = true;
            this.viewsTransitionComplete();
            this.sharedElementTransitionComplete();
        } else {
            if (!this.mSharedElementTransitionStarted) {
                this.moveSharedElementsFromOverlay();
                this.mSharedElementTransitionStarted = true;
                this.showViews(this.mSharedElements, true);
                this.mSharedElements.clear();
                this.sharedElementTransitionComplete();
            }
            if (!this.mIsViewsTransitionStarted) {
                this.mIsViewsTransitionStarted = true;
                this.showViews(this.mTransitioningViews, true);
                this.setTransitioningViewsVisiblity(0, true);
                this.mTransitioningViews.clear();
                this.viewsTransitionComplete();
            }
            this.cancelPendingTransitions();
        }
        this.mAreViewsReady = true;
        if (this.mResultReceiver != null) {
            this.mResultReceiver.send(106, null);
            this.mResultReceiver = null;
        }
    }

    private void cancel() {
        if (!this.mIsCanceled) {
            this.mIsCanceled = true;
            if (this.getViewsTransition() == null || this.mIsViewsTransitionStarted) {
                this.showViews(this.mSharedElements, true);
            } else if (this.mTransitioningViews != null) {
                this.mTransitioningViews.addAll(this.mSharedElements);
            }
            this.moveSharedElementsFromOverlay();
            this.mSharedElementNames.clear();
            this.mSharedElements.clear();
            this.mAllSharedElementNames.clear();
            this.startSharedElementTransition(null);
            this.onRemoteExitTransitionComplete();
        }
    }

    public boolean isReturning() {
        return this.mIsReturning;
    }

    protected void prepareEnter() {
        ViewGroup decorView = this.getDecor();
        if (this.mActivity == null || decorView == null) {
            return;
        }
        if (!this.isCrossTask()) {
            this.mActivity.overridePendingTransition(0, 0);
        }
        if (!this.mIsReturning) {
            this.mWasOpaque = this.mActivity.convertToTranslucent(null, null);
            Drawable background = decorView.getBackground();
            if (background == null) {
                this.mReplacedBackground = background = new ColorDrawable(0);
            } else {
                this.getWindow().setBackgroundDrawable(null);
                background = background.mutate();
                background.setAlpha(0);
            }
            this.getWindow().setBackgroundDrawable(background);
        } else {
            this.mActivity = null;
        }
    }

    @Override
    protected Transition getViewsTransition() {
        Window window = this.getWindow();
        if (window == null) {
            return null;
        }
        if (this.mIsReturning) {
            return window.getReenterTransition();
        }
        return window.getEnterTransition();
    }

    protected Transition getSharedElementTransition() {
        Window window = this.getWindow();
        if (window == null) {
            return null;
        }
        if (this.mIsReturning) {
            return window.getSharedElementReenterTransition();
        }
        return window.getSharedElementEnterTransition();
    }

    private void startSharedElementTransition(Bundle sharedElementState) {
        ViewGroup decorView = this.getDecor();
        if (decorView == null) {
            return;
        }
        ArrayList<String> rejectedNames = new ArrayList<String>(this.mAllSharedElementNames);
        rejectedNames.removeAll(this.mSharedElementNames);
        ArrayList<View> rejectedSnapshots = this.createSnapshots(sharedElementState, rejectedNames);
        if (this.mListener != null) {
            this.mListener.onRejectSharedElements(rejectedSnapshots);
        }
        EnterTransitionCoordinator.removeNullViews(rejectedSnapshots);
        this.startRejectedAnimations(rejectedSnapshots);
        ArrayList<View> sharedElementSnapshots = this.createSnapshots(sharedElementState, this.mSharedElementNames);
        this.showViews(this.mSharedElements, true);
        this.scheduleSetSharedElementEnd(sharedElementSnapshots);
        ArrayList<ActivityTransitionCoordinator.SharedElementOriginalState> originalImageViewState = this.setSharedElementState(sharedElementState, sharedElementSnapshots);
        this.requestLayoutForSharedElements();
        boolean startEnterTransition = this.allowOverlappingTransitions() && !this.mIsReturning;
        boolean startSharedElementTransition = true;
        this.setGhostVisibility(4);
        this.scheduleGhostVisibilityChange(4);
        this.pauseInput();
        Transition transition2 = this.beginTransition(decorView, startEnterTransition, startSharedElementTransition);
        this.scheduleGhostVisibilityChange(0);
        this.setGhostVisibility(0);
        if (startEnterTransition) {
            this.startEnterTransition(transition2);
        }
        EnterTransitionCoordinator.setOriginalSharedElementState(this.mSharedElements, originalImageViewState);
        if (this.mResultReceiver != null) {
            decorView.postOnAnimation(new Runnable(){
                int mAnimations;

                @Override
                public void run() {
                    if (this.mAnimations++ < 2) {
                        ViewGroup decorView = EnterTransitionCoordinator.this.getDecor();
                        if (decorView != null) {
                            decorView.postOnAnimation(this);
                        }
                    } else if (EnterTransitionCoordinator.this.mResultReceiver != null) {
                        EnterTransitionCoordinator.this.mResultReceiver.send(101, null);
                        EnterTransitionCoordinator.this.mResultReceiver = null;
                    }
                }
            });
        }
    }

    private static void removeNullViews(ArrayList<View> views) {
        if (views != null) {
            for (int i = views.size() - 1; i >= 0; --i) {
                if (views.get(i) != null) continue;
                views.remove(i);
            }
        }
    }

    private void onTakeSharedElements() {
        if (!this.mIsReadyForTransition || this.mSharedElementsBundle == null) {
            return;
        }
        final Bundle sharedElementState = this.mSharedElementsBundle;
        this.mSharedElementsBundle = null;
        SharedElementCallback.OnSharedElementsReadyListener listener = new SharedElementCallback.OnSharedElementsReadyListener(){

            @Override
            public void onSharedElementsReady() {
                ViewGroup decorView = EnterTransitionCoordinator.this.getDecor();
                if (decorView != null) {
                    OneShotPreDrawListener.add(decorView, false, EnterTransitionCoordinator$3$$Lambda$11.get$Lambda(this, sharedElementState));
                    decorView.invalidate();
                }
            }

            final /* synthetic */ void lambda$onSharedElementsReady$19$EnterTransitionCoordinator$3(Bundle bundle) {
                EnterTransitionCoordinator.this.startTransition(EnterTransitionCoordinator$3$$Lambda$12.get$Lambda(this, bundle));
            }

            final /* synthetic */ void lambda$null$18$EnterTransitionCoordinator$3(Bundle bundle) {
                EnterTransitionCoordinator.this.startSharedElementTransition(bundle);
            }
        };
        if (this.mListener == null) {
            listener.onSharedElementsReady();
        } else {
            this.mListener.onSharedElementsArrived(this.mSharedElementNames, this.mSharedElements, listener);
        }
    }

    private void requestLayoutForSharedElements() {
        int numSharedElements = this.mSharedElements.size();
        for (int i = 0; i < numSharedElements; ++i) {
            ((View)this.mSharedElements.get(i)).requestLayout();
        }
    }

    private Transition beginTransition(ViewGroup decorView, boolean startEnterTransition, boolean startSharedElementTransition) {
        Transition transition2;
        Transition sharedElementTransition = null;
        if (startSharedElementTransition) {
            if (!this.mSharedElementNames.isEmpty()) {
                sharedElementTransition = this.configureTransition(this.getSharedElementTransition(), false);
            }
            if (sharedElementTransition == null) {
                this.sharedElementTransitionStarted();
                this.sharedElementTransitionComplete();
            } else {
                sharedElementTransition.addListener(new TransitionListenerAdapter(){

                    @Override
                    public void onTransitionStart(Transition transition2) {
                        EnterTransitionCoordinator.this.sharedElementTransitionStarted();
                    }

                    @Override
                    public void onTransitionEnd(Transition transition2) {
                        transition2.removeListener(this);
                        EnterTransitionCoordinator.this.sharedElementTransitionComplete();
                    }
                });
            }
        }
        Transition viewsTransition = null;
        if (startEnterTransition) {
            this.mIsViewsTransitionStarted = true;
            if (this.mTransitioningViews != null && !this.mTransitioningViews.isEmpty()) {
                viewsTransition = this.configureTransition(this.getViewsTransition(), true);
            }
            if (viewsTransition == null) {
                this.viewsTransitionComplete();
            } else {
                final ArrayList transitioningViews = this.mTransitioningViews;
                viewsTransition.addListener(new ActivityTransitionCoordinator.ContinueTransitionListener(){

                    @Override
                    public void onTransitionStart(Transition transition2) {
                        EnterTransitionCoordinator.this.mEnterViewsTransition = transition2;
                        if (transitioningViews != null) {
                            EnterTransitionCoordinator.this.showViews(transitioningViews, false);
                        }
                        super.onTransitionStart(transition2);
                    }

                    @Override
                    public void onTransitionEnd(Transition transition2) {
                        EnterTransitionCoordinator.this.mEnterViewsTransition = null;
                        transition2.removeListener(this);
                        EnterTransitionCoordinator.this.viewsTransitionComplete();
                        super.onTransitionEnd(transition2);
                    }
                });
            }
        }
        if ((transition2 = EnterTransitionCoordinator.mergeTransitions(sharedElementTransition, viewsTransition)) != null) {
            transition2.addListener(new ActivityTransitionCoordinator.ContinueTransitionListener(this));
            if (startEnterTransition) {
                this.setTransitioningViewsVisiblity(4, false);
            }
            TransitionManager.beginDelayedTransition(decorView, transition2);
            if (startEnterTransition) {
                this.setTransitioningViewsVisiblity(0, false);
            }
            decorView.invalidate();
        } else {
            this.transitionStarted();
        }
        return transition2;
    }

    @Override
    protected void onTransitionsComplete() {
        this.moveSharedElementsFromOverlay();
        ViewGroup decorView = this.getDecor();
        if (decorView != null) {
            decorView.sendAccessibilityEvent(2048);
            Window window = this.getWindow();
            if (window != null && this.mReplacedBackground == decorView.getBackground()) {
                window.setBackgroundDrawable(null);
            }
        }
    }

    private void sharedElementTransitionStarted() {
        this.mSharedElementTransitionStarted = true;
        if (this.mIsExitTransitionComplete) {
            this.send(104, null);
        }
    }

    private void startEnterTransition(Transition transition2) {
        ViewGroup decorView = this.getDecor();
        if (!this.mIsReturning && decorView != null) {
            Drawable background = decorView.getBackground();
            if (background != null) {
                background = background.mutate();
                this.getWindow().setBackgroundDrawable(background);
                this.mBackgroundAnimator = ObjectAnimator.ofInt((Object)background, "alpha", 255);
                this.mBackgroundAnimator.setDuration(this.getFadeDuration());
                this.mBackgroundAnimator.addListener(new AnimatorListenerAdapter(){

                    @Override
                    public void onAnimationEnd(Animator animation) {
                        EnterTransitionCoordinator.this.makeOpaque();
                        EnterTransitionCoordinator.this.backgroundAnimatorComplete();
                    }
                });
                this.mBackgroundAnimator.start();
            } else if (transition2 != null) {
                transition2.addListener(new TransitionListenerAdapter(){

                    @Override
                    public void onTransitionEnd(Transition transition2) {
                        transition2.removeListener(this);
                        EnterTransitionCoordinator.this.makeOpaque();
                    }
                });
                this.backgroundAnimatorComplete();
            } else {
                this.makeOpaque();
                this.backgroundAnimatorComplete();
            }
        } else {
            this.backgroundAnimatorComplete();
        }
    }

    public void stop() {
        Drawable drawable2;
        ViewGroup decorView;
        if (this.mBackgroundAnimator != null) {
            this.mBackgroundAnimator.end();
            this.mBackgroundAnimator = null;
        } else if (this.mWasOpaque && (decorView = this.getDecor()) != null && (drawable2 = decorView.getBackground()) != null) {
            drawable2.setAlpha(1);
        }
        this.makeOpaque();
        this.mIsCanceled = true;
        this.mResultReceiver = null;
        this.mActivity = null;
        this.moveSharedElementsFromOverlay();
        if (this.mTransitioningViews != null) {
            this.showViews(this.mTransitioningViews, true);
            this.setTransitioningViewsVisiblity(0, true);
        }
        this.showViews(this.mSharedElements, true);
        this.clearState();
    }

    public boolean cancelEnter() {
        this.setGhostVisibility(4);
        this.mHasStopped = true;
        this.mIsCanceled = true;
        this.clearState();
        return super.cancelPendingTransitions();
    }

    @Override
    protected void clearState() {
        this.mSharedElementsBundle = null;
        this.mEnterViewsTransition = null;
        this.mResultReceiver = null;
        if (this.mBackgroundAnimator != null) {
            this.mBackgroundAnimator.cancel();
            this.mBackgroundAnimator = null;
        }
        super.clearState();
    }

    private void makeOpaque() {
        if (!this.mHasStopped && this.mActivity != null) {
            if (this.mWasOpaque) {
                this.mActivity.convertFromTranslucent();
            }
            this.mActivity = null;
        }
    }

    private boolean allowOverlappingTransitions() {
        return this.mIsReturning ? this.getWindow().getAllowReturnTransitionOverlap() : this.getWindow().getAllowEnterTransitionOverlap();
    }

    private void startRejectedAnimations(final ArrayList<View> rejectedSnapshots) {
        if (rejectedSnapshots == null || rejectedSnapshots.isEmpty()) {
            return;
        }
        final ViewGroup decorView = this.getDecor();
        if (decorView != null) {
            ViewGroupOverlay overlay = decorView.getOverlay();
            Animator animator2 = null;
            int numRejected = rejectedSnapshots.size();
            for (int i = 0; i < numRejected; ++i) {
                View snapshot = rejectedSnapshots.get(i);
                overlay.add(snapshot);
                animator2 = ObjectAnimator.ofFloat(snapshot, View.ALPHA, 1.0f, 0.0f);
                ((ObjectAnimator)animator2).start();
            }
            animator2.addListener(new AnimatorListenerAdapter(){

                @Override
                public void onAnimationEnd(Animator animation) {
                    ViewGroupOverlay overlay = decorView.getOverlay();
                    int numRejected = rejectedSnapshots.size();
                    for (int i = 0; i < numRejected; ++i) {
                        overlay.remove((View)rejectedSnapshots.get(i));
                    }
                }
            });
        }
    }

    protected void onRemoteExitTransitionComplete() {
        if (!this.allowOverlappingTransitions()) {
            this.startEnterTransitionOnly();
        }
    }

    private void startEnterTransitionOnly() {
        this.startTransition(new Runnable(){

            @Override
            public void run() {
                boolean startEnterTransition = true;
                boolean startSharedElementTransition = false;
                ViewGroup decorView = EnterTransitionCoordinator.this.getDecor();
                if (decorView != null) {
                    Transition transition2 = EnterTransitionCoordinator.this.beginTransition(decorView, startEnterTransition, startSharedElementTransition);
                    EnterTransitionCoordinator.this.startEnterTransition(transition2);
                }
            }
        });
    }

    final /* synthetic */ void lambda$sendSharedElementDestination$17$EnterTransitionCoordinator() {
        if (this.mResultReceiver != null) {
            Bundle state = this.captureSharedElementState();
            this.moveSharedElementsToOverlay();
            this.mResultReceiver.send(107, state);
        }
    }

    final /* synthetic */ void lambda$triggerViewsReady$16$EnterTransitionCoordinator(ArrayMap arrayMap) {
        this.mViewsReadyListener = null;
        this.viewsReady(arrayMap);
    }
}

