/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.IEphemeralResolver;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.content.pm.EphemeralResolveInfo;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.IRemoteCallback;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import java.util.List;

public abstract class EphemeralResolverService
extends Service {
    public static final String EXTRA_RESOLVE_INFO = "android.app.extra.RESOLVE_INFO";
    public static final String EXTRA_SEQUENCE = "android.app.extra.SEQUENCE";
    private static final String EXTRA_PREFIX = "android.app.PREFIX";
    private static final String EXTRA_HOSTNAME = "android.app.HOSTNAME";
    private Handler mHandler;

    @Deprecated
    public abstract List<EphemeralResolveInfo> onEphemeralResolveInfoList(int[] var1, int var2);

    public List<EphemeralResolveInfo> onGetEphemeralResolveInfo(int[] digestPrefix) {
        return this.onEphemeralResolveInfoList(digestPrefix, -4096);
    }

    public EphemeralResolveInfo onGetEphemeralIntentFilter(String hostName) {
        throw new IllegalStateException("Must define");
    }

    public Looper getLooper() {
        return this.getBaseContext().getMainLooper();
    }

    @Override
    public final void attachBaseContext(Context base) {
        super.attachBaseContext(base);
        this.mHandler = new ServiceHandler(this.getLooper());
    }

    @Override
    public final IBinder onBind(Intent intent) {
        return new IEphemeralResolver.Stub(){

            @Override
            public void getEphemeralResolveInfoList(IRemoteCallback callback, int[] digestPrefix, int sequence) {
                Message msg = EphemeralResolverService.this.mHandler.obtainMessage(1, sequence, 0, callback);
                Bundle data = new Bundle();
                data.putIntArray(EphemeralResolverService.EXTRA_PREFIX, digestPrefix);
                msg.setData(data);
                msg.sendToTarget();
            }

            @Override
            public void getEphemeralIntentFilterList(IRemoteCallback callback, String hostName, int sequence) {
                Message msg = EphemeralResolverService.this.mHandler.obtainMessage(2, sequence, 0, callback);
                Bundle data = new Bundle();
                data.putString(EphemeralResolverService.EXTRA_HOSTNAME, hostName);
                msg.setData(data);
                msg.sendToTarget();
            }
        };
    }

    private final class ServiceHandler
    extends Handler {
        public static final int MSG_GET_EPHEMERAL_RESOLVE_INFO = 1;
        public static final int MSG_GET_EPHEMERAL_INTENT_FILTER = 2;

        public ServiceHandler(Looper looper) {
            super(looper, null, true);
        }

        @Override
        public void handleMessage(Message message) {
            int action = message.what;
            switch (action) {
                case 1: {
                    IRemoteCallback callback = (IRemoteCallback)message.obj;
                    int[] digestPrefix = message.getData().getIntArray(EphemeralResolverService.EXTRA_PREFIX);
                    List<EphemeralResolveInfo> resolveInfo = EphemeralResolverService.this.onGetEphemeralResolveInfo(digestPrefix);
                    Bundle data = new Bundle();
                    data.putInt(EphemeralResolverService.EXTRA_SEQUENCE, message.arg1);
                    data.putParcelableList(EphemeralResolverService.EXTRA_RESOLVE_INFO, resolveInfo);
                    try {
                        callback.sendResult(data);
                    }
                    catch (RemoteException remoteException) {}
                    break;
                }
                case 2: {
                    IRemoteCallback callback = (IRemoteCallback)message.obj;
                    String hostName = message.getData().getString(EphemeralResolverService.EXTRA_HOSTNAME);
                    EphemeralResolveInfo resolveInfo = EphemeralResolverService.this.onGetEphemeralIntentFilter(hostName);
                    Bundle data = new Bundle();
                    data.putInt(EphemeralResolverService.EXTRA_SEQUENCE, message.arg1);
                    data.putParcelable(EphemeralResolverService.EXTRA_RESOLVE_INFO, resolveInfo);
                    try {
                        callback.sendResult(data);
                    }
                    catch (RemoteException remoteException) {}
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown message: " + action);
                }
            }
        }
    }
}

