/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.Activity;
import android.app.ActivityManager;
import android.app.IActivityManager;
import android.app.KeyguardManager$1$$Lambda$22;
import android.app.KeyguardManager$1$$Lambda$23;
import android.app.KeyguardManager$1$$Lambda$24;
import android.app.trust.ITrustManager;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.UserHandle;
import android.util.Log;
import android.view.IOnKeyguardExitResult;
import android.view.IWindowManager;
import android.view.WindowManagerGlobal;
import com.android.internal.policy.IKeyguardDismissCallback;
import java.util.List;

public class KeyguardManager {
    private static final String TAG = "KeyguardManager";
    private final Context mContext;
    private final IWindowManager mWM;
    private final IActivityManager mAm;
    private final ITrustManager mTrustManager;
    public static final String ACTION_CONFIRM_DEVICE_CREDENTIAL = "android.app.action.CONFIRM_DEVICE_CREDENTIAL";
    public static final String ACTION_CONFIRM_DEVICE_CREDENTIAL_WITH_USER = "android.app.action.CONFIRM_DEVICE_CREDENTIAL_WITH_USER";
    public static final String EXTRA_TITLE = "android.app.extra.TITLE";
    public static final String EXTRA_DESCRIPTION = "android.app.extra.DESCRIPTION";

    public Intent createConfirmDeviceCredentialIntent(CharSequence title, CharSequence description) {
        if (!this.isDeviceSecure()) {
            return null;
        }
        Intent intent = new Intent(ACTION_CONFIRM_DEVICE_CREDENTIAL);
        intent.putExtra(EXTRA_TITLE, title);
        intent.putExtra(EXTRA_DESCRIPTION, description);
        intent.setPackage(this.getSettingsPackageForIntent(intent));
        return intent;
    }

    public Intent createConfirmDeviceCredentialIntent(CharSequence title, CharSequence description, int userId) {
        if (!this.isDeviceSecure(userId)) {
            return null;
        }
        Intent intent = new Intent(ACTION_CONFIRM_DEVICE_CREDENTIAL_WITH_USER);
        intent.putExtra(EXTRA_TITLE, title);
        intent.putExtra(EXTRA_DESCRIPTION, description);
        intent.putExtra("android.intent.extra.USER_ID", userId);
        intent.setPackage(this.getSettingsPackageForIntent(intent));
        return intent;
    }

    private String getSettingsPackageForIntent(Intent intent) {
        int i = 0;
        List<ResolveInfo> resolveInfos = this.mContext.getPackageManager().queryIntentActivities(intent, 0x100000);
        if (i < resolveInfos.size()) {
            return resolveInfos.get((int)i).activityInfo.packageName;
        }
        return "com.android.settings";
    }

    KeyguardManager(Context context) throws ServiceManager.ServiceNotFoundException {
        this.mContext = context;
        this.mWM = WindowManagerGlobal.getWindowManagerService();
        this.mAm = ActivityManager.getService();
        this.mTrustManager = ITrustManager.Stub.asInterface(ServiceManager.getServiceOrThrow("trust"));
    }

    @Deprecated
    public KeyguardLock newKeyguardLock(String tag) {
        return new KeyguardLock(tag);
    }

    public boolean isKeyguardLocked() {
        try {
            return this.mWM.isKeyguardLocked();
        }
        catch (RemoteException ex) {
            return false;
        }
    }

    public boolean isKeyguardSecure() {
        try {
            return this.mWM.isKeyguardSecure();
        }
        catch (RemoteException ex) {
            return false;
        }
    }

    public boolean inKeyguardRestrictedInputMode() {
        try {
            return this.mWM.inKeyguardRestrictedInputMode();
        }
        catch (RemoteException ex) {
            return false;
        }
    }

    public boolean isDeviceLocked() {
        return this.isDeviceLocked(UserHandle.myUserId());
    }

    public boolean isDeviceLocked(int userId) {
        try {
            return this.mTrustManager.isDeviceLocked(userId);
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public boolean isDeviceSecure() {
        return this.isDeviceSecure(UserHandle.myUserId());
    }

    public boolean isDeviceSecure(int userId) {
        try {
            return this.mTrustManager.isDeviceSecure(userId);
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public void dismissKeyguard(Activity activity, final KeyguardDismissCallback callback, Handler handler) {
        try {
            final Handler actualHandler = handler != null ? handler : new Handler(Looper.getMainLooper());
            this.mAm.dismissKeyguard(activity.getActivityToken(), new IKeyguardDismissCallback.Stub(){

                @Override
                public void onDismissError() throws RemoteException {
                    KeyguardDismissCallback keyguardDismissCallback = callback;
                    keyguardDismissCallback.getClass();
                    actualHandler.post(KeyguardManager$1$$Lambda$22.get$Lambda(keyguardDismissCallback));
                }

                @Override
                public void onDismissSucceeded() throws RemoteException {
                    KeyguardDismissCallback keyguardDismissCallback = callback;
                    keyguardDismissCallback.getClass();
                    actualHandler.post(KeyguardManager$1$$Lambda$23.get$Lambda(keyguardDismissCallback));
                }

                @Override
                public void onDismissCancelled() throws RemoteException {
                    KeyguardDismissCallback keyguardDismissCallback = callback;
                    keyguardDismissCallback.getClass();
                    actualHandler.post(KeyguardManager$1$$Lambda$24.get$Lambda(keyguardDismissCallback));
                }
            });
        }
        catch (RemoteException e) {
            Log.i(TAG, "Failed to dismiss keyguard: " + e);
        }
    }

    @Deprecated
    public void exitKeyguardSecurely(final OnKeyguardExitResult callback) {
        try {
            this.mWM.exitKeyguardSecurely(new IOnKeyguardExitResult.Stub(){

                @Override
                public void onKeyguardExitResult(boolean success) throws RemoteException {
                    if (callback != null) {
                        callback.onKeyguardExitResult(success);
                    }
                }
            });
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public static abstract class KeyguardDismissCallback {
        public void onDismissError() {
        }

        public void onDismissSucceeded() {
        }

        public void onDismissCancelled() {
        }
    }

    @Deprecated
    public static interface OnKeyguardExitResult {
        public void onKeyguardExitResult(boolean var1);
    }

    @Deprecated
    public class KeyguardLock {
        private final IBinder mToken = new Binder();
        private final String mTag;

        KeyguardLock(String tag) {
            this.mTag = tag;
        }

        public void disableKeyguard() {
            try {
                KeyguardManager.this.mWM.disableKeyguard(this.mToken, this.mTag);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }

        public void reenableKeyguard() {
            try {
                KeyguardManager.this.mWM.reenableKeyguard(this.mToken);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }
}

