/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.Notification;
import android.media.AudioAttributes;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.service.notification.NotificationListenerService;
import android.text.TextUtils;
import java.io.IOException;
import java.util.Arrays;
import org.json.JSONException;
import org.json.JSONObject;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlSerializer;

public final class NotificationChannel
implements Parcelable {
    public static final String DEFAULT_CHANNEL_ID = "miscellaneous";
    private static final String TAG_CHANNEL = "channel";
    private static final String ATT_NAME = "name";
    private static final String ATT_ID = "id";
    private static final String ATT_DELETED = "deleted";
    private static final String ATT_PRIORITY = "priority";
    private static final String ATT_VISIBILITY = "visibility";
    private static final String ATT_IMPORTANCE = "importance";
    private static final String ATT_LIGHTS = "lights";
    private static final String ATT_LIGHT_COLOR = "light_color";
    private static final String ATT_VIBRATION = "vibration";
    private static final String ATT_VIBRATION_ENABLED = "vibration_enabled";
    private static final String ATT_SOUND = "sound";
    private static final String ATT_USAGE = "usage";
    private static final String ATT_FLAGS = "flags";
    private static final String ATT_CONTENT_TYPE = "content_type";
    private static final String ATT_SHOW_BADGE = "show_badge";
    private static final String ATT_USER_LOCKED = "locked";
    private static final String ATT_GROUP = "group";
    private static final String DELIMITER = ",";
    public static final int USER_LOCKED_PRIORITY = 1;
    public static final int USER_LOCKED_VISIBILITY = 2;
    public static final int USER_LOCKED_IMPORTANCE = 4;
    public static final int USER_LOCKED_LIGHTS = 8;
    public static final int USER_LOCKED_VIBRATION = 16;
    public static final int USER_LOCKED_SOUND = 32;
    public static final int USER_LOCKED_ALLOWED = 64;
    public static final int USER_LOCKED_SHOW_BADGE = 128;
    public static final int USER_LOCKED_AUDIO_ATTRIBUTES = 256;
    public static final int[] LOCKABLE_FIELDS = new int[]{1, 2, 4, 8, 16, 32, 64, 128, 256};
    private static final int DEFAULT_LIGHT_COLOR = 0;
    private static final int DEFAULT_VISIBILITY = -1000;
    private static final int DEFAULT_IMPORTANCE = -1000;
    private static final boolean DEFAULT_DELETED = false;
    private static final boolean DEFAULT_SHOW_BADGE = true;
    private final String mId;
    private CharSequence mName;
    private int mImportance = -1000;
    private boolean mBypassDnd;
    private int mLockscreenVisibility = -1000;
    private Uri mSound;
    private boolean mLights;
    private int mLightColor = 0;
    private long[] mVibration;
    private int mUserLockedFields;
    private boolean mVibrationEnabled;
    private boolean mShowBadge = true;
    private boolean mDeleted = false;
    private String mGroup;
    private AudioAttributes mAudioAttributes = Notification.AUDIO_ATTRIBUTES_DEFAULT;
    public static final Parcelable.Creator<NotificationChannel> CREATOR = new Parcelable.Creator<NotificationChannel>(){

        @Override
        public NotificationChannel createFromParcel(Parcel in) {
            return new NotificationChannel(in);
        }

        public NotificationChannel[] newArray(int size) {
            return new NotificationChannel[size];
        }
    };

    public NotificationChannel(String id2, CharSequence name, int importance) {
        this.mId = id2;
        this.mName = name;
        this.mImportance = importance;
    }

    protected NotificationChannel(Parcel in) {
        this.mId = in.readByte() != 0 ? in.readString() : null;
        this.mName = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in);
        this.mImportance = in.readInt();
        this.mBypassDnd = in.readByte() != 0;
        this.mLockscreenVisibility = in.readInt();
        this.mSound = in.readByte() != 0 ? Uri.CREATOR.createFromParcel(in) : null;
        this.mLights = in.readByte() != 0;
        this.mVibration = in.createLongArray();
        this.mUserLockedFields = in.readInt();
        this.mVibrationEnabled = in.readByte() != 0;
        this.mShowBadge = in.readByte() != 0;
        this.mDeleted = in.readByte() != 0;
        this.mGroup = in.readByte() != 0 ? in.readString() : null;
        this.mAudioAttributes = in.readInt() > 0 ? AudioAttributes.CREATOR.createFromParcel(in) : null;
        this.mLightColor = in.readInt();
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        if (this.mId != null) {
            dest.writeByte((byte)1);
            dest.writeString(this.mId);
        } else {
            dest.writeByte((byte)0);
        }
        TextUtils.writeToParcel(this.mName, dest, flags);
        dest.writeInt(this.mImportance);
        dest.writeByte(this.mBypassDnd ? (byte)1 : 0);
        dest.writeInt(this.mLockscreenVisibility);
        if (this.mSound != null) {
            dest.writeByte((byte)1);
            this.mSound.writeToParcel(dest, 0);
        } else {
            dest.writeByte((byte)0);
        }
        dest.writeByte(this.mLights ? (byte)1 : 0);
        dest.writeLongArray(this.mVibration);
        dest.writeInt(this.mUserLockedFields);
        dest.writeByte(this.mVibrationEnabled ? (byte)1 : 0);
        dest.writeByte(this.mShowBadge ? (byte)1 : 0);
        dest.writeByte(this.mDeleted ? (byte)1 : 0);
        if (this.mGroup != null) {
            dest.writeByte((byte)1);
            dest.writeString(this.mGroup);
        } else {
            dest.writeByte((byte)0);
        }
        if (this.mAudioAttributes != null) {
            dest.writeInt(1);
            this.mAudioAttributes.writeToParcel(dest, 0);
        } else {
            dest.writeInt(0);
        }
        dest.writeInt(this.mLightColor);
    }

    public void lockFields(int field) {
        this.mUserLockedFields |= field;
    }

    public void setDeleted(boolean deleted) {
        this.mDeleted = deleted;
    }

    public void setBypassDnd(boolean bypassDnd) {
        this.mBypassDnd = bypassDnd;
    }

    public void setLockscreenVisibility(int lockscreenVisibility) {
        this.mLockscreenVisibility = lockscreenVisibility;
    }

    public void setImportance(int importance) {
        this.mImportance = importance;
    }

    public void setGroup(String groupId) {
        this.mGroup = groupId;
    }

    public void setShowBadge(boolean showBadge) {
        this.mShowBadge = showBadge;
    }

    public void setSound(Uri sound, AudioAttributes audioAttributes) {
        this.mSound = sound;
        this.mAudioAttributes = audioAttributes;
    }

    public void enableLights(boolean lights) {
        this.mLights = lights;
    }

    public void setLightColor(int argb) {
        this.mLightColor = argb;
    }

    public void enableVibration(boolean vibration) {
        this.mVibrationEnabled = vibration;
    }

    public void setVibrationPattern(long[] vibrationPattern) {
        this.mVibrationEnabled = vibrationPattern != null && vibrationPattern.length > 0;
        this.mVibration = vibrationPattern;
    }

    public String getId() {
        return this.mId;
    }

    public CharSequence getName() {
        return this.mName;
    }

    public int getImportance() {
        return this.mImportance;
    }

    public boolean canBypassDnd() {
        return this.mBypassDnd;
    }

    public Uri getSound() {
        return this.mSound;
    }

    public AudioAttributes getAudioAttributes() {
        return this.mAudioAttributes;
    }

    public boolean shouldShowLights() {
        return this.mLights;
    }

    public int getLightColor() {
        return this.mLightColor;
    }

    public boolean shouldVibrate() {
        return this.mVibrationEnabled;
    }

    public long[] getVibrationPattern() {
        return this.mVibration;
    }

    public int getLockscreenVisibility() {
        return this.mLockscreenVisibility;
    }

    public boolean canShowBadge() {
        return this.mShowBadge;
    }

    public String getGroup() {
        return this.mGroup;
    }

    public boolean isDeleted() {
        return this.mDeleted;
    }

    public int getUserLockedFields() {
        return this.mUserLockedFields;
    }

    public void populateFromXml(XmlPullParser parser) {
        this.setBypassDnd(0 != NotificationChannel.safeInt(parser, ATT_PRIORITY, 0));
        this.setLockscreenVisibility(NotificationChannel.safeInt(parser, ATT_VISIBILITY, -1000));
        this.setSound(NotificationChannel.safeUri(parser, ATT_SOUND), NotificationChannel.safeAudioAttributes(parser));
        this.enableLights(NotificationChannel.safeBool(parser, ATT_LIGHTS, false));
        this.setLightColor(NotificationChannel.safeInt(parser, ATT_LIGHT_COLOR, 0));
        this.enableVibration(NotificationChannel.safeBool(parser, ATT_VIBRATION_ENABLED, false));
        this.setVibrationPattern(NotificationChannel.safeLongArray(parser, ATT_VIBRATION, null));
        this.setShowBadge(NotificationChannel.safeBool(parser, ATT_SHOW_BADGE, false));
        this.setDeleted(NotificationChannel.safeBool(parser, ATT_DELETED, false));
        this.setGroup(parser.getAttributeValue(null, ATT_GROUP));
        this.lockFields(NotificationChannel.safeInt(parser, ATT_USER_LOCKED, 0));
    }

    public void writeXml(XmlSerializer out) throws IOException {
        out.startTag(null, TAG_CHANNEL);
        out.attribute(null, ATT_ID, this.getId());
        out.attribute(null, ATT_NAME, this.getName().toString());
        if (this.getImportance() != -1000) {
            out.attribute(null, ATT_IMPORTANCE, Integer.toString(this.getImportance()));
        }
        if (this.canBypassDnd()) {
            out.attribute(null, ATT_PRIORITY, Integer.toString(2));
        }
        if (this.getLockscreenVisibility() != -1000) {
            out.attribute(null, ATT_VISIBILITY, Integer.toString(this.getLockscreenVisibility()));
        }
        if (this.getSound() != null) {
            out.attribute(null, ATT_SOUND, this.getSound().toString());
        }
        if (this.getAudioAttributes() != null) {
            out.attribute(null, ATT_USAGE, Integer.toString(this.getAudioAttributes().getUsage()));
            out.attribute(null, ATT_CONTENT_TYPE, Integer.toString(this.getAudioAttributes().getContentType()));
            out.attribute(null, ATT_FLAGS, Integer.toString(this.getAudioAttributes().getFlags()));
        }
        if (this.shouldShowLights()) {
            out.attribute(null, ATT_LIGHTS, Boolean.toString(this.shouldShowLights()));
        }
        if (this.getLightColor() != 0) {
            out.attribute(null, ATT_LIGHT_COLOR, Integer.toString(this.getLightColor()));
        }
        if (this.shouldVibrate()) {
            out.attribute(null, ATT_VIBRATION_ENABLED, Boolean.toString(this.shouldVibrate()));
        }
        if (this.getVibrationPattern() != null) {
            out.attribute(null, ATT_VIBRATION, NotificationChannel.longArrayToString(this.getVibrationPattern()));
        }
        if (this.getUserLockedFields() != 0) {
            out.attribute(null, ATT_USER_LOCKED, Integer.toString(this.getUserLockedFields()));
        }
        if (this.canShowBadge()) {
            out.attribute(null, ATT_SHOW_BADGE, Boolean.toString(this.canShowBadge()));
        }
        if (this.isDeleted()) {
            out.attribute(null, ATT_DELETED, Boolean.toString(this.isDeleted()));
        }
        if (this.getGroup() != null) {
            out.attribute(null, ATT_GROUP, this.getGroup());
        }
        out.endTag(null, TAG_CHANNEL);
    }

    public JSONObject toJson() throws JSONException {
        JSONObject record = new JSONObject();
        record.put(ATT_ID, this.getId());
        record.put(ATT_NAME, this.getName());
        if (this.getImportance() != -1000) {
            record.put(ATT_IMPORTANCE, NotificationListenerService.Ranking.importanceToString(this.getImportance()));
        }
        if (this.canBypassDnd()) {
            record.put(ATT_PRIORITY, 2);
        }
        if (this.getLockscreenVisibility() != -1000) {
            record.put(ATT_VISIBILITY, Notification.visibilityToString(this.getLockscreenVisibility()));
        }
        if (this.getSound() != null) {
            record.put(ATT_SOUND, this.getSound().toString());
        }
        if (this.getAudioAttributes() != null) {
            record.put(ATT_USAGE, Integer.toString(this.getAudioAttributes().getUsage()));
            record.put(ATT_CONTENT_TYPE, Integer.toString(this.getAudioAttributes().getContentType()));
            record.put(ATT_FLAGS, Integer.toString(this.getAudioAttributes().getFlags()));
        }
        record.put(ATT_LIGHTS, Boolean.toString(this.shouldShowLights()));
        record.put(ATT_LIGHT_COLOR, Integer.toString(this.getLightColor()));
        record.put(ATT_VIBRATION_ENABLED, Boolean.toString(this.shouldVibrate()));
        record.put(ATT_USER_LOCKED, Integer.toString(this.getUserLockedFields()));
        record.put(ATT_VIBRATION, NotificationChannel.longArrayToString(this.getVibrationPattern()));
        record.put(ATT_SHOW_BADGE, Boolean.toString(this.canShowBadge()));
        record.put(ATT_DELETED, Boolean.toString(this.isDeleted()));
        record.put(ATT_GROUP, this.getGroup());
        return record;
    }

    private static AudioAttributes safeAudioAttributes(XmlPullParser parser) {
        int usage = NotificationChannel.safeInt(parser, ATT_USAGE, 5);
        int contentType = NotificationChannel.safeInt(parser, ATT_CONTENT_TYPE, 4);
        int flags = NotificationChannel.safeInt(parser, ATT_FLAGS, 0);
        return new AudioAttributes.Builder().setUsage(usage).setContentType(contentType).setFlags(flags).build();
    }

    private static Uri safeUri(XmlPullParser parser, String att) {
        String val = parser.getAttributeValue(null, att);
        return val == null ? null : Uri.parse(val);
    }

    private static int safeInt(XmlPullParser parser, String att, int defValue) {
        String val = parser.getAttributeValue(null, att);
        return NotificationChannel.tryParseInt(val, defValue);
    }

    private static int tryParseInt(String value, int defValue) {
        if (TextUtils.isEmpty(value)) {
            return defValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return defValue;
        }
    }

    private static boolean safeBool(XmlPullParser parser, String att, boolean defValue) {
        String value = parser.getAttributeValue(null, att);
        if (TextUtils.isEmpty(value)) {
            return defValue;
        }
        return Boolean.parseBoolean(value);
    }

    private static long[] safeLongArray(XmlPullParser parser, String att, long[] defValue) {
        String attributeValue = parser.getAttributeValue(null, att);
        if (TextUtils.isEmpty(attributeValue)) {
            return defValue;
        }
        String[] values = attributeValue.split(DELIMITER);
        long[] longValues = new long[values.length];
        for (int i = 0; i < values.length; ++i) {
            try {
                longValues[i] = Long.parseLong(values[i]);
                continue;
            }
            catch (NumberFormatException e) {
                longValues[i] = 0L;
            }
        }
        return longValues;
    }

    private static String longArrayToString(long[] values) {
        StringBuffer sb = new StringBuffer();
        if (values != null) {
            for (int i = 0; i < values.length - 1; ++i) {
                sb.append(values[i]).append(DELIMITER);
            }
            sb.append(values[values.length - 1]);
        }
        return sb.toString();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NotificationChannel that = (NotificationChannel)o;
        if (this.getImportance() != that.getImportance()) {
            return false;
        }
        if (this.mBypassDnd != that.mBypassDnd) {
            return false;
        }
        if (this.getLockscreenVisibility() != that.getLockscreenVisibility()) {
            return false;
        }
        if (this.mLights != that.mLights) {
            return false;
        }
        if (this.getLightColor() != that.getLightColor()) {
            return false;
        }
        if (this.getUserLockedFields() != that.getUserLockedFields()) {
            return false;
        }
        if (this.mVibrationEnabled != that.mVibrationEnabled) {
            return false;
        }
        if (this.mShowBadge != that.mShowBadge) {
            return false;
        }
        if (this.isDeleted() != that.isDeleted()) {
            return false;
        }
        if (this.getId() != null ? !this.getId().equals(that.getId()) : that.getId() != null) {
            return false;
        }
        if (this.getName() != null ? !this.getName().equals(that.getName()) : that.getName() != null) {
            return false;
        }
        if (this.getSound() != null ? !this.getSound().equals(that.getSound()) : that.getSound() != null) {
            return false;
        }
        if (!Arrays.equals(this.mVibration, that.mVibration)) {
            return false;
        }
        if (this.getGroup() != null ? !this.getGroup().equals(that.getGroup()) : that.getGroup() != null) {
            return false;
        }
        return this.getAudioAttributes() != null ? this.getAudioAttributes().equals(that.getAudioAttributes()) : that.getAudioAttributes() == null;
    }

    public int hashCode() {
        int result = this.getId() != null ? this.getId().hashCode() : 0;
        result = 31 * result + (this.getName() != null ? this.getName().hashCode() : 0);
        result = 31 * result + this.getImportance();
        result = 31 * result + (this.mBypassDnd ? 1 : 0);
        result = 31 * result + this.getLockscreenVisibility();
        result = 31 * result + (this.getSound() != null ? this.getSound().hashCode() : 0);
        result = 31 * result + (this.mLights ? 1 : 0);
        result = 31 * result + this.getLightColor();
        result = 31 * result + Arrays.hashCode(this.mVibration);
        result = 31 * result + this.getUserLockedFields();
        result = 31 * result + (this.mVibrationEnabled ? 1 : 0);
        result = 31 * result + (this.mShowBadge ? 1 : 0);
        result = 31 * result + (this.isDeleted() ? 1 : 0);
        result = 31 * result + (this.getGroup() != null ? this.getGroup().hashCode() : 0);
        result = 31 * result + (this.getAudioAttributes() != null ? this.getAudioAttributes().hashCode() : 0);
        return result;
    }

    public String toString() {
        return "NotificationChannel{mId='" + this.mId + '\'' + ", mName=" + this.mName + ", mImportance=" + this.mImportance + ", mBypassDnd=" + this.mBypassDnd + ", mLockscreenVisibility=" + this.mLockscreenVisibility + ", mSound=" + this.mSound + ", mLights=" + this.mLights + ", mLightColor=" + this.mLightColor + ", mVibration=" + Arrays.toString(this.mVibration) + ", mUserLockedFields=" + this.mUserLockedFields + ", mVibrationEnabled=" + this.mVibrationEnabled + ", mShowBadge=" + this.mShowBadge + ", mDeleted=" + this.mDeleted + ", mGroup='" + this.mGroup + '\'' + ", mAudioAttributes=" + this.mAudioAttributes + '}';
    }
}

