/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.NotificationChannel;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;
import org.xmlpull.v1.XmlSerializer;

public final class NotificationChannelGroup
implements Parcelable {
    private static final String TAG_GROUP = "channelGroup";
    private static final String ATT_NAME = "name";
    private static final String ATT_ID = "id";
    private final String mId;
    private CharSequence mName;
    private List<NotificationChannel> mChannels = new ArrayList<NotificationChannel>();
    public static final Parcelable.Creator<NotificationChannelGroup> CREATOR = new Parcelable.Creator<NotificationChannelGroup>(){

        @Override
        public NotificationChannelGroup createFromParcel(Parcel in) {
            return new NotificationChannelGroup(in);
        }

        public NotificationChannelGroup[] newArray(int size) {
            return new NotificationChannelGroup[size];
        }
    };

    public NotificationChannelGroup(String id2, CharSequence name) {
        this.mId = id2;
        this.mName = name;
    }

    protected NotificationChannelGroup(Parcel in) {
        this.mId = in.readByte() != 0 ? in.readString() : null;
        this.mName = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in);
        in.readParcelableList(this.mChannels, NotificationChannel.class.getClassLoader());
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        if (this.mId != null) {
            dest.writeByte((byte)1);
            dest.writeString(this.mId);
        } else {
            dest.writeByte((byte)0);
        }
        TextUtils.writeToParcel(this.mName, dest, flags);
        dest.writeParcelableList(this.mChannels, flags);
    }

    public String getId() {
        return this.mId;
    }

    public CharSequence getName() {
        return this.mName;
    }

    public List<NotificationChannel> getChannels() {
        return this.mChannels;
    }

    public void addChannel(NotificationChannel channel) {
        this.mChannels.add(channel);
    }

    public void writeXml(XmlSerializer out) throws IOException {
        out.startTag(null, TAG_GROUP);
        out.attribute(null, ATT_ID, this.getId());
        out.attribute(null, ATT_NAME, this.getName().toString());
        out.endTag(null, TAG_GROUP);
    }

    public JSONObject toJson() throws JSONException {
        JSONObject record = new JSONObject();
        record.put(ATT_ID, this.getId());
        record.put(ATT_NAME, this.getName());
        return record;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NotificationChannelGroup that = (NotificationChannelGroup)o;
        if (this.getId() != null ? !this.getId().equals(that.getId()) : that.getId() != null) {
            return false;
        }
        if (this.getName() != null ? !this.getName().equals(that.getName()) : that.getName() != null) {
            return false;
        }
        return this.getChannels() != null ? this.getChannels().equals(that.getChannels()) : that.getChannels() == null;
    }

    public NotificationChannelGroup clone() {
        return new NotificationChannelGroup(this.getId(), this.getName());
    }

    public int hashCode() {
        int result = this.getId() != null ? this.getId().hashCode() : 0;
        result = 31 * result + (this.getName() != null ? this.getName().hashCode() : 0);
        result = 31 * result + (this.getChannels() != null ? this.getChannels().hashCode() : 0);
        return result;
    }

    public String toString() {
        return "NotificationChannelGroup{mId='" + this.mId + '\'' + ", mName=" + this.mName + '}';
    }
}

