/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.RemoteAction;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.ArrayList;
import java.util.List;

public final class PictureInPictureArgs
implements Parcelable {
    private Float mAspectRatio;
    private List<RemoteAction> mUserActions;
    public static final Parcelable.Creator<PictureInPictureArgs> CREATOR = new Parcelable.Creator<PictureInPictureArgs>(){

        @Override
        public PictureInPictureArgs createFromParcel(Parcel in) {
            return new PictureInPictureArgs(in);
        }

        public PictureInPictureArgs[] newArray(int size) {
            return new PictureInPictureArgs[size];
        }
    };

    PictureInPictureArgs(Parcel in) {
        if (in.readInt() != 0) {
            this.mAspectRatio = Float.valueOf(in.readFloat());
        }
        if (in.readInt() != 0) {
            this.mUserActions = new ArrayList<RemoteAction>();
            in.readParcelableList(this.mUserActions, RemoteAction.class.getClassLoader());
        }
    }

    public PictureInPictureArgs() {
    }

    public PictureInPictureArgs(float aspectRatio, List<RemoteAction> actions) {
        this.mAspectRatio = Float.valueOf(aspectRatio);
        if (actions != null) {
            this.mUserActions = new ArrayList<RemoteAction>(actions);
        }
    }

    public void copyOnlySet(PictureInPictureArgs otherArgs) {
        if (otherArgs.hasSetAspectRatio()) {
            this.mAspectRatio = otherArgs.mAspectRatio;
        }
        if (otherArgs.hasSetActions()) {
            this.mUserActions = otherArgs.mUserActions;
        }
    }

    public void setAspectRatio(float aspectRatio) {
        this.mAspectRatio = Float.valueOf(aspectRatio);
    }

    public float getAspectRatio() {
        if (this.mAspectRatio != null) {
            return this.mAspectRatio.floatValue();
        }
        return 0.0f;
    }

    public boolean hasSetAspectRatio() {
        return this.mAspectRatio != null;
    }

    public void setActions(List<RemoteAction> actions) {
        if (this.mUserActions != null) {
            this.mUserActions = null;
        }
        if (actions != null) {
            this.mUserActions = new ArrayList<RemoteAction>(actions);
        }
    }

    public List<RemoteAction> getActions() {
        return this.mUserActions;
    }

    public boolean hasSetActions() {
        return this.mUserActions != null;
    }

    public PictureInPictureArgs clone() {
        return new PictureInPictureArgs(this.mAspectRatio.floatValue(), this.mUserActions);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        if (this.mAspectRatio != null) {
            out.writeInt(1);
            out.writeFloat(this.mAspectRatio.floatValue());
        } else {
            out.writeInt(0);
        }
        if (this.mUserActions != null) {
            out.writeInt(1);
            out.writeParcelableList(this.mUserActions, 0);
        } else {
            out.writeInt(0);
        }
    }
}

