/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import com.android.internal.annotations.GuardedBy;
import java.util.Iterator;
import java.util.LinkedList;

public class QueuedWork {
    private static final String LOG_TAG = QueuedWork.class.getSimpleName();
    private static final boolean DEBUG = true;
    private static final long DELAY = 100L;
    private static final Object sLock = new Object();
    private static Object sProcessingWork = new Object();
    @GuardedBy(value="sLock")
    private static final LinkedList<Runnable> sFinishers = new LinkedList();
    @GuardedBy(value="sLock")
    private static Handler sHandler = null;
    @GuardedBy(value="sLock")
    private static final LinkedList<Runnable> sWork = new LinkedList();
    @GuardedBy(value="sLock")
    private static boolean sCanDelay = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Handler getHandler() {
        Object object = sLock;
        synchronized (object) {
            if (sHandler == null) {
                HandlerThread handlerThread = new HandlerThread("queued-work-looper", -2);
                handlerThread.start();
                sHandler = new QueuedWorkHandler(handlerThread.getLooper());
            }
            return sHandler;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addFinisher(Runnable finisher) {
        Object object = sLock;
        synchronized (object) {
            sFinishers.add(finisher);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeFinisher(Runnable finisher) {
        Object object = sLock;
        synchronized (object) {
            sFinishers.remove(finisher);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitToFinish() {
        long startTime = 0L;
        boolean hadMessages = false;
        startTime = System.currentTimeMillis();
        Handler handler = QueuedWork.getHandler();
        Object object = sLock;
        synchronized (object) {
            if (handler.hasMessages(1)) {
                handler.removeMessages(1);
                hadMessages = true;
                Log.d(LOG_TAG, "waiting");
            }
            sCanDelay = false;
        }
        QueuedWork.processPendingWork();
        try {
            while (true) {
                Runnable finisher;
                Object object2 = sLock;
                synchronized (object2) {
                    finisher = sFinishers.poll();
                }
                if (finisher == null) {
                    break;
                }
                finisher.run();
            }
        }
        finally {
            sCanDelay = true;
        }
        long waitTime = System.currentTimeMillis() - startTime;
        if (waitTime > 0L || hadMessages) {
            Log.d(LOG_TAG, "waited " + waitTime + " ms");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void queue(Runnable work, boolean shouldDelay) {
        Handler handler = QueuedWork.getHandler();
        Object object = sLock;
        synchronized (object) {
            sWork.add(work);
            if (shouldDelay && sCanDelay) {
                handler.sendEmptyMessageDelayed(1, 100L);
            } else {
                handler.sendEmptyMessage(1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasPendingWork() {
        Object object = sLock;
        synchronized (object) {
            return !sWork.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processPendingWork() {
        long startTime = 0L;
        startTime = System.currentTimeMillis();
        Object object = sProcessingWork;
        synchronized (object) {
            LinkedList work;
            Iterator iterator = sLock;
            synchronized (iterator) {
                work = (LinkedList)sWork.clone();
                sWork.clear();
                QueuedWork.getHandler().removeMessages(1);
            }
            if (work.size() > 0) {
                for (Runnable w : work) {
                    w.run();
                }
                Log.d(LOG_TAG, "processing " + work.size() + " items took " + (System.currentTimeMillis() - startTime) + " ms");
            }
        }
    }

    private static class QueuedWorkHandler
    extends Handler {
        static final int MSG_RUN = 1;

        QueuedWorkHandler(Looper looper) {
            super(looper);
        }

        @Override
        public void handleMessage(Message msg) {
            if (msg.what == 1) {
                QueuedWork.processPendingWork();
            }
        }
    }
}

