/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.Dialog;
import android.app.DialogFragment;
import android.app.Fragment;
import android.app.FragmentManager;
import android.app.FragmentTransaction;
import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.RecoverableSecurityException$LocalDialog$$Lambda$27;
import android.app.RemoteAction;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.drawable.Icon;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.internal.util.Preconditions;

public final class RecoverableSecurityException
extends SecurityException
implements Parcelable {
    private static final String TAG = "RecoverableSecurityException";
    private final CharSequence mUserMessage;
    private final RemoteAction mUserAction;
    public static final Parcelable.Creator<RecoverableSecurityException> CREATOR = new Parcelable.Creator<RecoverableSecurityException>(){

        @Override
        public RecoverableSecurityException createFromParcel(Parcel source) {
            return new RecoverableSecurityException(source);
        }

        public RecoverableSecurityException[] newArray(int size) {
            return new RecoverableSecurityException[size];
        }
    };

    public RecoverableSecurityException(Parcel in) {
        this(new SecurityException(in.readString()), in.readCharSequence(), RemoteAction.CREATOR.createFromParcel(in));
    }

    public RecoverableSecurityException(Throwable cause, CharSequence userMessage, RemoteAction userAction) {
        super(cause.getMessage());
        this.mUserMessage = Preconditions.checkNotNull(userMessage);
        this.mUserAction = Preconditions.checkNotNull(userAction);
    }

    @Deprecated
    public RecoverableSecurityException(Throwable cause, CharSequence userMessage, CharSequence userActionTitle, PendingIntent userAction) {
        this(cause, userMessage, new RemoteAction(Icon.createWithResource("android", 17302586), userActionTitle, userActionTitle, userAction));
    }

    public CharSequence getUserMessage() {
        return this.mUserMessage;
    }

    public RemoteAction getUserAction() {
        return this.mUserAction;
    }

    public void showAsNotification(Context context) {
        NotificationManager nm = context.getSystemService(NotificationManager.class);
        String tag = "RecoverableSecurityException_" + this.mUserAction.getActionIntent().getCreatorUid();
        nm.createNotificationChannel(new NotificationChannel(tag, TAG, 3));
        Notification.Builder builder = new Notification.Builder(context, tag).setSmallIcon(17302583).setContentTitle(this.mUserAction.getTitle()).setContentText(this.mUserMessage).setContentIntent(this.mUserAction.getActionIntent()).setCategory("err");
        nm.notify(tag, 0, builder.build());
    }

    public void showAsDialog(Activity activity) {
        LocalDialog dialog = new LocalDialog();
        Bundle args = new Bundle();
        args.putParcelable(TAG, this);
        dialog.setArguments(args);
        String tag = "RecoverableSecurityException_" + this.mUserAction.getActionIntent().getCreatorUid();
        FragmentManager fm = activity.getFragmentManager();
        FragmentTransaction ft = fm.beginTransaction();
        Fragment old = fm.findFragmentByTag(tag);
        if (old != null) {
            ft.remove(old);
        }
        ft.add(dialog, tag);
        ft.commitAllowingStateLoss();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.getMessage());
        dest.writeCharSequence(this.mUserMessage);
        this.mUserAction.writeToParcel(dest, flags);
    }

    public static class LocalDialog
    extends DialogFragment {
        @Override
        public Dialog onCreateDialog(Bundle savedInstanceState) {
            RecoverableSecurityException e = (RecoverableSecurityException)this.getArguments().getParcelable(RecoverableSecurityException.TAG);
            return new AlertDialog.Builder(this.getActivity()).setMessage(e.mUserMessage).setPositiveButton(e.mUserAction.getTitle(), RecoverableSecurityException$LocalDialog$$Lambda$27.get$Lambda(e)).setNegativeButton(0x1040000, null).create();
        }

        static final /* synthetic */ void lambda$onCreateDialog$29$RecoverableSecurityException$LocalDialog(RecoverableSecurityException recoverableSecurityException, DialogInterface dialog, int which) {
            try {
                recoverableSecurityException.mUserAction.getActionIntent().send();
            }
            catch (PendingIntent.CanceledException canceledException) {
                // empty catch block
            }
        }
    }
}

