/*
 * Decompiled with CFR 0.152.
 */
package android.app.usage;

import android.app.usage.ExternalStorageStats;
import android.app.usage.IStorageStatsManager;
import android.app.usage.StorageStats;
import android.content.Context;
import android.os.RemoteException;
import android.os.UserHandle;
import com.android.internal.util.Preconditions;

public class StorageStatsManager {
    private final Context mContext;
    private final IStorageStatsManager mService;

    public StorageStatsManager(Context context, IStorageStatsManager service) {
        this.mContext = Preconditions.checkNotNull(context);
        this.mService = Preconditions.checkNotNull(service);
    }

    public boolean isQuotaSupported(String volumeUuid) {
        try {
            return this.mService.isQuotaSupported(volumeUuid, this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public long getTotalBytes(String volumeUuid) {
        try {
            return this.mService.getTotalBytes(volumeUuid, this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public long getFreeBytes(String volumeUuid) {
        try {
            return this.mService.getFreeBytes(volumeUuid, this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public StorageStats queryStatsForPackage(String volumeUuid, String packageName, UserHandle user) {
        try {
            return this.mService.queryStatsForPackage(volumeUuid, packageName, user.getIdentifier(), this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public StorageStats queryStatsForUid(String volumeUuid, int uid) {
        try {
            return this.mService.queryStatsForUid(volumeUuid, uid, this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public StorageStats queryStatsForUser(String volumeUuid, UserHandle user) {
        try {
            return this.mService.queryStatsForUser(volumeUuid, user.getIdentifier(), this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public ExternalStorageStats queryExternalStatsForUser(String volumeUuid, UserHandle user) {
        try {
            return this.mService.queryExternalStatsForUser(volumeUuid, user.getIdentifier(), this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }
}

