/*
 * Decompiled with CFR 0.152.
 */
package android.companion;

import android.annotation.IntDef;
import android.companion.BluetoothDeviceFilter;
import android.companion.BluetoothLEDeviceFilter;
import android.companion.DeviceFilter;
import android.os.Parcel;
import android.os.Parcelable;
import android.provider.OneTimeUseBuilder;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public final class AssociationRequest<F extends DeviceFilter>
implements Parcelable {
    public static final int MEDIUM_TYPE_BLUETOOTH = 0;
    public static final int MEDIUM_TYPE_BLUETOOTH_LE = 1;
    public static final int MEDIUM_TYPE_WIFI = 2;
    private final boolean mSingleDevice;
    private final int mMediumType;
    private final F mDeviceFilter;
    public static final Parcelable.Creator<AssociationRequest> CREATOR = new Parcelable.Creator<AssociationRequest>(){

        @Override
        public AssociationRequest createFromParcel(Parcel in) {
            return new AssociationRequest(in);
        }

        public AssociationRequest[] newArray(int size) {
            return new AssociationRequest[size];
        }
    };

    private AssociationRequest(boolean singleDevice, int mMediumType, F deviceFilter) {
        this.mSingleDevice = singleDevice;
        this.mMediumType = mMediumType;
        this.mDeviceFilter = deviceFilter;
    }

    private AssociationRequest(Parcel in) {
        this(in.readByte() != 0, in.readInt(), (DeviceFilter)in.readParcelable(AssociationRequest.class.getClassLoader()));
    }

    public boolean isSingleDevice() {
        return this.mSingleDevice;
    }

    public int getMediumType() {
        return this.mMediumType;
    }

    public F getDeviceFilter() {
        return this.mDeviceFilter;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeByte((byte)(this.mSingleDevice ? 1 : 0));
        dest.writeInt(this.mMediumType);
        dest.writeParcelable((Parcelable)this.mDeviceFilter, flags);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    /* synthetic */ AssociationRequest(boolean x0, int x1, DeviceFilter x2, 1 x3) {
        this(x0, x1, x2);
    }

    public static final class Builder<F extends DeviceFilter>
    extends OneTimeUseBuilder<AssociationRequest<F>> {
        private boolean mSingleDevice = false;
        private int mMediumType;
        private F mDeviceFilter = null;

        private Builder() {
        }

        public static Builder<BluetoothLEDeviceFilter> createForBluetoothLEDevice() {
            return super.setMediumType(1);
        }

        public static Builder<BluetoothDeviceFilter> createForBluetoothDevice() {
            return super.setMediumType(0);
        }

        public Builder<F> setSingleDevice(boolean singleDevice) {
            this.checkNotUsed();
            this.mSingleDevice = singleDevice;
            return this;
        }

        public Builder<F> setDeviceFilter(F deviceFilter) {
            this.checkNotUsed();
            this.mDeviceFilter = deviceFilter;
            return this;
        }

        private Builder<F> setMediumType(int deviceType) {
            this.mMediumType = deviceType;
            return this;
        }

        @Override
        public AssociationRequest<F> build() {
            this.markUsed();
            return new AssociationRequest(this.mSingleDevice, this.mMediumType, (DeviceFilter)this.mDeviceFilter, null);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @IntDef(value={0L, 1L, 2L})
    public static @interface MediumType {
    }
}

