/*
 * Decompiled with CFR 0.152.
 */
package android.companion;

import android.bluetooth.BluetoothDevice;
import android.companion.BluetoothDeviceFilterUtils;
import android.companion.DeviceFilter;
import android.os.Parcel;
import android.os.ParcelUuid;
import android.os.Parcelable;
import android.provider.OneTimeUseBuilder;
import com.android.internal.util.ArrayUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public final class BluetoothDeviceFilter
implements DeviceFilter<BluetoothDevice> {
    private static BluetoothDeviceFilter NO_OP;
    private final Pattern mNamePattern;
    private final String mAddress;
    private final List<ParcelUuid> mServiceUuids;
    private final List<ParcelUuid> mServiceUuidMasks;
    public static final Parcelable.Creator<BluetoothDeviceFilter> CREATOR;

    private BluetoothDeviceFilter(Pattern namePattern, String address, List<ParcelUuid> serviceUuids, List<ParcelUuid> serviceUuidMasks) {
        this.mNamePattern = namePattern;
        this.mAddress = address;
        this.mServiceUuids = ArrayUtils.emptyIfNull(serviceUuids);
        this.mServiceUuidMasks = ArrayUtils.emptyIfNull(serviceUuidMasks);
    }

    private BluetoothDeviceFilter(Parcel in) {
        this(BluetoothDeviceFilterUtils.patternFromString(in.readString()), in.readString(), BluetoothDeviceFilter.readUuids(in), BluetoothDeviceFilter.readUuids(in));
    }

    private static List<ParcelUuid> readUuids(Parcel in) {
        ArrayList<ParcelUuid> list = new ArrayList<ParcelUuid>();
        in.readParcelableList(list, ParcelUuid.class.getClassLoader());
        return list;
    }

    public static BluetoothDeviceFilter nullsafe(BluetoothDeviceFilter nullable) {
        return nullable != null ? nullable : BluetoothDeviceFilter.noOp();
    }

    public static BluetoothDeviceFilter noOp() {
        if (NO_OP == null) {
            NO_OP = new Builder().build();
        }
        return NO_OP;
    }

    @Override
    public boolean matches(BluetoothDevice device) {
        return BluetoothDeviceFilterUtils.matchesAddress(this.mAddress, device) && BluetoothDeviceFilterUtils.matchesServiceUuids(this.mServiceUuids, this.mServiceUuidMasks, device) && BluetoothDeviceFilterUtils.matchesName(this.getNamePattern(), device);
    }

    public Pattern getNamePattern() {
        return this.mNamePattern;
    }

    public String getAddress() {
        return this.mAddress;
    }

    public List<ParcelUuid> getServiceUuids() {
        return this.mServiceUuids;
    }

    public List<ParcelUuid> getServiceUuidMasks() {
        return this.mServiceUuidMasks;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(BluetoothDeviceFilterUtils.patternToString(this.getNamePattern()));
        dest.writeString(this.mAddress);
        dest.writeParcelableList(this.mServiceUuids, flags);
        dest.writeParcelableList(this.mServiceUuidMasks, flags);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    static {
        CREATOR = new Parcelable.Creator<BluetoothDeviceFilter>(){

            @Override
            public BluetoothDeviceFilter createFromParcel(Parcel in) {
                return new BluetoothDeviceFilter(in);
            }

            public BluetoothDeviceFilter[] newArray(int size) {
                return new BluetoothDeviceFilter[size];
            }
        };
    }

    public static final class Builder
    extends OneTimeUseBuilder<BluetoothDeviceFilter> {
        private Pattern mNamePattern;
        private String mAddress;
        private ArrayList<ParcelUuid> mServiceUuid;
        private ArrayList<ParcelUuid> mServiceUuidMask;

        public Builder setNamePattern(Pattern regex) {
            this.checkNotUsed();
            this.mNamePattern = regex;
            return this;
        }

        public Builder setAddress(String address) {
            this.checkNotUsed();
            this.mAddress = address;
            return this;
        }

        public Builder addServiceUuid(ParcelUuid serviceUuid, ParcelUuid serviceUuidMask) {
            this.checkNotUsed();
            this.mServiceUuid = ArrayUtils.add(this.mServiceUuid, serviceUuid);
            this.mServiceUuidMask = ArrayUtils.add(this.mServiceUuidMask, serviceUuidMask);
            return this;
        }

        @Override
        public BluetoothDeviceFilter build() {
            this.markUsed();
            return new BluetoothDeviceFilter(this.mNamePattern, this.mAddress, this.mServiceUuid, this.mServiceUuidMask);
        }
    }
}

