/*
 * Decompiled with CFR 0.152.
 */
package android.companion;

import android.annotation.SuppressLint;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.le.ScanFilter;
import android.companion.BluetoothDeviceFilterUtils;
import android.companion.DeviceFilter;
import android.os.Parcel;
import android.os.Parcelable;
import android.provider.OneTimeUseBuilder;
import com.android.internal.util.ObjectUtils;
import java.util.regex.Pattern;

public final class BluetoothLEDeviceFilter
implements DeviceFilter<BluetoothDevice> {
    private static BluetoothLEDeviceFilter NO_OP;
    private final Pattern mNamePattern;
    private final ScanFilter mScanFilter;
    public static final Parcelable.Creator<BluetoothLEDeviceFilter> CREATOR;

    private BluetoothLEDeviceFilter(Pattern namePattern, ScanFilter scanFilter) {
        this.mNamePattern = namePattern;
        this.mScanFilter = ObjectUtils.firstNotNull(scanFilter, ScanFilter.EMPTY);
    }

    @SuppressLint(value={"ParcelClassLoader"})
    private BluetoothLEDeviceFilter(Parcel in) {
        this(BluetoothDeviceFilterUtils.patternFromString(in.readString()), (ScanFilter)in.readParcelable(null));
    }

    public static BluetoothLEDeviceFilter nullsafe(BluetoothLEDeviceFilter nullable) {
        return nullable != null ? nullable : BluetoothLEDeviceFilter.noOp();
    }

    public static BluetoothLEDeviceFilter noOp() {
        if (NO_OP == null) {
            NO_OP = new Builder().build();
        }
        return NO_OP;
    }

    public Pattern getNamePattern() {
        return this.mNamePattern;
    }

    public ScanFilter getScanFilter() {
        return this.mScanFilter;
    }

    @Override
    public boolean matches(BluetoothDevice device) {
        return BluetoothDeviceFilterUtils.matches(this.getScanFilter(), device) && BluetoothDeviceFilterUtils.matchesName(this.getNamePattern(), device);
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(BluetoothDeviceFilterUtils.patternToString(this.getNamePattern()));
        dest.writeParcelable(this.mScanFilter, flags);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    static {
        CREATOR = new Parcelable.Creator<BluetoothLEDeviceFilter>(){

            @Override
            public BluetoothLEDeviceFilter createFromParcel(Parcel in) {
                return new BluetoothLEDeviceFilter(in);
            }

            public BluetoothLEDeviceFilter[] newArray(int size) {
                return new BluetoothLEDeviceFilter[size];
            }
        };
    }

    public static final class Builder
    extends OneTimeUseBuilder<BluetoothLEDeviceFilter> {
        private ScanFilter mScanFilter;
        private Pattern mNamePattern;

        public Builder setNamePattern(Pattern regex) {
            this.checkNotUsed();
            this.mNamePattern = regex;
            return this;
        }

        public Builder setScanFilter(ScanFilter scanFilter) {
            this.checkNotUsed();
            this.mScanFilter = scanFilter;
            return this;
        }

        @Override
        public BluetoothLEDeviceFilter build() {
            this.markUsed();
            return new BluetoothLEDeviceFilter(this.mNamePattern, this.mScanFilter);
        }
    }
}

