/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import android.content.IntentFilter;
import android.content.pm.EphemeralIntentFilter;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public final class EphemeralResolveInfo
implements Parcelable {
    public static final String SHA_ALGORITHM = "SHA-256";
    private final EphemeralDigest mDigest;
    private final String mPackageName;
    private final List<EphemeralIntentFilter> mFilters;
    private final int mVersionCode;
    @Deprecated
    private final List<IntentFilter> mLegacyFilters;
    public static final Parcelable.Creator<EphemeralResolveInfo> CREATOR = new Parcelable.Creator<EphemeralResolveInfo>(){

        @Override
        public EphemeralResolveInfo createFromParcel(Parcel in) {
            return new EphemeralResolveInfo(in);
        }

        public EphemeralResolveInfo[] newArray(int size) {
            return new EphemeralResolveInfo[size];
        }
    };

    @Deprecated
    public EphemeralResolveInfo(Uri uri, String packageName, List<IntentFilter> filters) {
        if (uri == null || packageName == null || filters == null || filters.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.mDigest = new EphemeralDigest(uri.getHost());
        this.mPackageName = packageName;
        this.mFilters = new ArrayList<EphemeralIntentFilter>();
        this.mFilters.add(new EphemeralIntentFilter(packageName, filters));
        this.mLegacyFilters = new ArrayList<IntentFilter>(filters.size());
        this.mLegacyFilters.addAll(filters);
        this.mVersionCode = -1;
    }

    @Deprecated
    public EphemeralResolveInfo(EphemeralDigest digest, String packageName, List<EphemeralIntentFilter> filters) {
        this(digest, packageName, filters, -1);
    }

    public EphemeralResolveInfo(EphemeralDigest digest, String packageName, List<EphemeralIntentFilter> filters, int versionConde) {
        if (packageName == null && filters != null && filters.size() != 0 || packageName != null && (filters == null || filters.size() == 0)) {
            throw new IllegalArgumentException();
        }
        this.mDigest = digest;
        if (filters != null) {
            this.mFilters = new ArrayList<EphemeralIntentFilter>(filters.size());
            this.mFilters.addAll(filters);
        } else {
            this.mFilters = null;
        }
        this.mLegacyFilters = null;
        this.mPackageName = packageName;
        this.mVersionCode = versionConde;
    }

    public EphemeralResolveInfo(String hostName, String packageName, List<EphemeralIntentFilter> filters) {
        this(new EphemeralDigest(hostName), packageName, filters);
    }

    EphemeralResolveInfo(Parcel in) {
        this.mDigest = (EphemeralDigest)in.readParcelable(null);
        this.mPackageName = in.readString();
        this.mFilters = new ArrayList<EphemeralIntentFilter>();
        in.readList(this.mFilters, null);
        this.mVersionCode = in.readInt();
        this.mLegacyFilters = new ArrayList<IntentFilter>();
        in.readList(this.mLegacyFilters, null);
    }

    public byte[] getDigestBytes() {
        return this.mDigest.getDigestBytes()[0];
    }

    public int getDigestPrefix() {
        return this.mDigest.getDigestPrefix()[0];
    }

    public String getPackageName() {
        return this.mPackageName;
    }

    public List<EphemeralIntentFilter> getIntentFilters() {
        return this.mFilters;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    @Deprecated
    public List<IntentFilter> getFilters() {
        return this.mLegacyFilters;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeParcelable(this.mDigest, flags);
        out.writeString(this.mPackageName);
        out.writeList(this.mFilters);
        out.writeInt(this.mVersionCode);
        out.writeList(this.mLegacyFilters);
    }

    public static final class EphemeralDigest
    implements Parcelable {
        private static final int DIGEST_MASK = -4096;
        private static final int DIGEST_PREFIX_COUNT = 5;
        private final byte[][] mDigestBytes;
        private final int[] mDigestPrefix;
        public static final Parcelable.Creator<EphemeralDigest> CREATOR = new Parcelable.Creator<EphemeralDigest>(){

            @Override
            public EphemeralDigest createFromParcel(Parcel in) {
                return new EphemeralDigest(in);
            }

            public EphemeralDigest[] newArray(int size) {
                return new EphemeralDigest[size];
            }
        };

        public EphemeralDigest(String hostName) {
            this(hostName, -1);
        }

        public EphemeralDigest(String hostName, int maxDigests) {
            if (hostName == null) {
                throw new IllegalArgumentException();
            }
            this.mDigestBytes = EphemeralDigest.generateDigest(hostName.toLowerCase(Locale.ENGLISH), maxDigests);
            this.mDigestPrefix = new int[this.mDigestBytes.length];
            for (int i = 0; i < this.mDigestBytes.length; ++i) {
                this.mDigestPrefix[i] = ((this.mDigestBytes[i][0] & 0xFF) << 24 | (this.mDigestBytes[i][1] & 0xFF) << 16 | (this.mDigestBytes[i][2] & 0xFF) << 8 | (this.mDigestBytes[i][3] & 0xFF) << 0) & 0xFFFFF000;
            }
        }

        private static byte[][] generateDigest(String hostName, int maxDigests) {
            ArrayList<byte[]> digests = new ArrayList<byte[]>();
            try {
                MessageDigest digest = MessageDigest.getInstance(EphemeralResolveInfo.SHA_ALGORITHM);
                if (maxDigests <= 0) {
                    byte[] hostBytes = hostName.getBytes();
                    digests.add(digest.digest(hostBytes));
                } else {
                    int prevDot = hostName.lastIndexOf(46);
                    if ((prevDot = hostName.lastIndexOf(46, prevDot - 1)) < 0) {
                        digests.add(digest.digest(hostName.getBytes()));
                    } else {
                        byte[] hostBytes = hostName.substring(prevDot + 1, hostName.length()).getBytes();
                        digests.add(digest.digest(hostBytes));
                        for (int digestCount = 1; prevDot >= 0 && digestCount < maxDigests; ++digestCount) {
                            prevDot = hostName.lastIndexOf(46, prevDot - 1);
                            hostBytes = hostName.substring(prevDot + 1, hostName.length()).getBytes();
                            digests.add(digest.digest(hostBytes));
                        }
                    }
                }
            }
            catch (NoSuchAlgorithmException e) {
                throw new IllegalStateException("could not find digest algorithm");
            }
            return (byte[][])digests.toArray((T[])new byte[digests.size()][]);
        }

        EphemeralDigest(Parcel in) {
            int digestCount = in.readInt();
            if (digestCount == -1) {
                this.mDigestBytes = null;
            } else {
                this.mDigestBytes = new byte[digestCount][];
                for (int i = 0; i < digestCount; ++i) {
                    this.mDigestBytes[i] = in.createByteArray();
                }
            }
            this.mDigestPrefix = in.createIntArray();
        }

        public byte[][] getDigestBytes() {
            return this.mDigestBytes;
        }

        public int[] getDigestPrefix() {
            return this.mDigestPrefix;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel out, int flags) {
            if (this.mDigestBytes == null) {
                out.writeInt(-1);
            } else {
                out.writeInt(this.mDigestBytes.length);
                for (int i = 0; i < this.mDigestBytes.length; ++i) {
                    out.writeByteArray(this.mDigestBytes[i]);
                }
            }
            out.writeIntArray(this.mDigestPrefix);
        }
    }
}

