/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm.split;

import android.content.pm.PackageParser;
import android.content.pm.split.SplitAssetLoader;
import android.content.pm.split.SplitDependencyLoaderHelper;
import android.content.res.AssetManager;
import android.os.Build;
import android.util.SparseIntArray;
import java.util.ArrayList;
import java.util.Collections;
import libcore.io.IoUtils;

public class SplitAssetDependencyLoader
extends SplitDependencyLoaderHelper<PackageParser.PackageParserException>
implements SplitAssetLoader {
    private static final int BASE_ASSET_PATH_IDX = -1;
    private final String mBasePath;
    private final String[] mSplitNames;
    private final String[] mSplitPaths;
    private final int mFlags;
    private String[] mCachedBasePaths;
    private AssetManager mCachedBaseAssetManager;
    private String[][] mCachedSplitPaths;
    private AssetManager[] mCachedAssetManagers;

    public SplitAssetDependencyLoader(PackageParser.PackageLite pkg, SparseIntArray dependencies, int flags) {
        super(dependencies);
        this.mBasePath = pkg.baseCodePath;
        this.mSplitNames = pkg.splitNames;
        this.mSplitPaths = pkg.splitCodePaths;
        this.mFlags = flags;
        this.mCachedBasePaths = null;
        this.mCachedBaseAssetManager = null;
        this.mCachedSplitPaths = new String[this.mSplitNames.length][];
        this.mCachedAssetManagers = new AssetManager[this.mSplitNames.length];
    }

    @Override
    protected boolean isSplitCached(int splitIdx) {
        if (splitIdx != -1) {
            return this.mCachedAssetManagers[splitIdx] != null;
        }
        return this.mCachedBaseAssetManager != null;
    }

    private void addAllConfigSplits(String splitName, ArrayList<String> outAssetPaths) {
        for (int i = 0; i < this.mSplitNames.length; ++i) {
            if (!SplitAssetDependencyLoader.isConfigurationSplitOf(this.mSplitNames[i], splitName)) continue;
            outAssetPaths.add(this.mSplitPaths[i]);
        }
    }

    private static AssetManager createAssetManagerWithPaths(String[] assetPaths, int flags) throws PackageParser.PackageParserException {
        AssetManager assets = new AssetManager();
        try {
            assets.setConfiguration(0, 0, null, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, Build.VERSION.RESOURCES_SDK_INT);
            for (String assetPath : assetPaths) {
                if ((flags & 4) != 0 && !PackageParser.isApkPath(assetPath)) {
                    throw new PackageParser.PackageParserException(-100, "Invalid package file: " + assetPath);
                }
                if (assets.addAssetPath(assetPath) != 0) continue;
                throw new PackageParser.PackageParserException(-101, "Failed adding asset path: " + assetPath);
            }
            return assets;
        }
        catch (Throwable e) {
            IoUtils.closeQuietly(assets);
            throw e;
        }
    }

    @Override
    protected void constructSplit(int splitIdx, int parentSplitIdx) throws PackageParser.PackageParserException {
        ArrayList<String> assetPaths = new ArrayList<String>();
        if (splitIdx == -1) {
            assetPaths.add(this.mBasePath);
            this.addAllConfigSplits(null, assetPaths);
            this.mCachedBasePaths = assetPaths.toArray(new String[assetPaths.size()]);
            this.mCachedBaseAssetManager = SplitAssetDependencyLoader.createAssetManagerWithPaths(this.mCachedBasePaths, this.mFlags);
            return;
        }
        if (parentSplitIdx == -1) {
            Collections.addAll(assetPaths, this.mCachedBasePaths);
        } else {
            Collections.addAll(assetPaths, this.mCachedSplitPaths[parentSplitIdx]);
        }
        assetPaths.add(this.mSplitPaths[splitIdx]);
        this.addAllConfigSplits(this.mSplitNames[splitIdx], assetPaths);
        this.mCachedSplitPaths[splitIdx] = assetPaths.toArray(new String[assetPaths.size()]);
        this.mCachedAssetManagers[splitIdx] = SplitAssetDependencyLoader.createAssetManagerWithPaths(this.mCachedSplitPaths[splitIdx], this.mFlags);
    }

    @Override
    public AssetManager getBaseAssetManager() throws PackageParser.PackageParserException {
        this.loadDependenciesForSplit(-1);
        return this.mCachedBaseAssetManager;
    }

    @Override
    public AssetManager getSplitAssetManager(int idx) throws PackageParser.PackageParserException {
        this.loadDependenciesForSplit(idx);
        return this.mCachedAssetManagers[idx];
    }

    @Override
    public void close() throws Exception {
        IoUtils.closeQuietly(this.mCachedBaseAssetManager);
        for (AssetManager assets : this.mCachedAssetManagers) {
            IoUtils.closeQuietly(assets);
        }
    }
}

