/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm.split;

import android.util.IntArray;
import android.util.SparseIntArray;

public abstract class SplitDependencyLoaderHelper<E extends Exception> {
    private final SparseIntArray mDependencies;

    protected SplitDependencyLoaderHelper(SparseIntArray dependencies) {
        this.mDependencies = dependencies;
    }

    protected void loadDependenciesForSplit(int splitIdx) throws E {
        if (this.isSplitCached(splitIdx)) {
            return;
        }
        IntArray linearDependencies = new IntArray();
        linearDependencies.add(splitIdx);
        while (splitIdx >= 0) {
            int n = splitIdx = this.mDependencies != null ? this.mDependencies.get(splitIdx, -1) : -1;
            if (this.isSplitCached(splitIdx)) break;
            linearDependencies.add(splitIdx);
        }
        int parentIdx = splitIdx;
        for (int i = linearDependencies.size() - 1; i >= 0; --i) {
            int idx = linearDependencies.get(i);
            this.constructSplit(idx, parentIdx);
            parentIdx = idx;
        }
    }

    protected abstract boolean isSplitCached(int var1);

    protected abstract void constructSplit(int var1, int var2) throws E;

    protected static boolean isConfigurationSplitOf(String splitName, String featureSplitName) {
        if (featureSplitName == null || featureSplitName.length() == 0) {
            if (splitName.startsWith("config_")) {
                return true;
            }
            return splitName.startsWith("$");
        }
        return splitName.startsWith(featureSplitName + "$");
    }
}

