/*
 * Decompiled with CFR 0.152.
 */
package android.content.res;

import android.content.res.Resources;
import android.content.res.TypedArray;
import android.text.FontConfig;
import android.util.AttributeSet;
import android.util.Xml;
import com.android.internal.R;
import java.io.IOException;
import java.util.ArrayList;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class FontResourcesParser {
    private static final int NORMAL_WEIGHT = 400;
    private static final int ITALIC = 1;

    public static FontConfig parse(XmlPullParser parser, Resources resources) throws XmlPullParserException, IOException {
        int type;
        while ((type = parser.next()) != 2 && type != 1) {
        }
        if (type != 2) {
            throw new XmlPullParserException("No start tag found");
        }
        return FontResourcesParser.readFamilies(parser, resources);
    }

    private static FontConfig readFamilies(XmlPullParser parser, Resources resources) throws XmlPullParserException, IOException {
        FontConfig config = new FontConfig();
        parser.require(2, null, "font-family");
        String tag = parser.getName();
        if (tag.equals("font-family")) {
            config.getFamilies().add(FontResourcesParser.readFamily(parser, resources));
        } else {
            FontResourcesParser.skip(parser);
        }
        return config;
    }

    private static FontConfig.Family readFamily(XmlPullParser parser, Resources resources) throws XmlPullParserException, IOException {
        AttributeSet attrs = Xml.asAttributeSet(parser);
        TypedArray array2 = resources.obtainAttributes(attrs, R.styleable.FontFamily);
        String authority = array2.getString(0);
        String query = array2.getString(1);
        array2.recycle();
        if (authority != null && query != null) {
            while (parser.next() != 3) {
                FontResourcesParser.skip(parser);
            }
            return new FontConfig.Family(authority, query);
        }
        ArrayList<FontConfig.Font> fonts = new ArrayList<FontConfig.Font>();
        while (parser.next() != 3) {
            if (parser.getEventType() != 2) continue;
            String tag = parser.getName();
            if (tag.equals("font")) {
                fonts.add(FontResourcesParser.readFont(parser, resources));
                continue;
            }
            FontResourcesParser.skip(parser);
        }
        return new FontConfig.Family(null, fonts, null, null);
    }

    private static FontConfig.Font readFont(XmlPullParser parser, Resources resources) throws XmlPullParserException, IOException {
        AttributeSet attrs = Xml.asAttributeSet(parser);
        TypedArray array2 = resources.obtainAttributes(attrs, R.styleable.FontFamilyFont);
        int weight = array2.getInt(2, 400);
        boolean isItalic = 1 == array2.getInt(0, 0);
        String filename = array2.getString(1);
        int resourceId = array2.getResourceId(1, 0);
        array2.recycle();
        while (parser.next() != 3) {
            FontResourcesParser.skip(parser);
        }
        return new FontConfig.Font(filename, 0, null, weight, isItalic, resourceId);
    }

    private static void skip(XmlPullParser parser) throws XmlPullParserException, IOException {
        int depth = 1;
        while (depth > 0) {
            switch (parser.next()) {
                case 2: {
                    ++depth;
                    break;
                }
                case 3: {
                    --depth;
                }
            }
        }
    }
}

