/*
 * Decompiled with CFR 0.152.
 */
package android.filterfw.core;

import android.filterfw.core.Frame;
import android.filterfw.core.FrameFormat;
import android.filterfw.core.SimpleFrameManager;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class CachedFrameManager
extends SimpleFrameManager {
    private SortedMap<Integer, Frame> mAvailableFrames = new TreeMap<Integer, Frame>();
    private int mStorageCapacity = 0x1800000;
    private int mStorageSize = 0;
    private int mTimeStamp = 0;

    @Override
    public Frame newFrame(FrameFormat format) {
        Frame result = this.findAvailableFrame(format, 0, 0L);
        if (result == null) {
            result = super.newFrame(format);
        }
        result.setTimestamp(-2L);
        return result;
    }

    @Override
    public Frame newBoundFrame(FrameFormat format, int bindingType, long bindingId) {
        Frame result = this.findAvailableFrame(format, bindingType, bindingId);
        if (result == null) {
            result = super.newBoundFrame(format, bindingType, bindingId);
        }
        result.setTimestamp(-2L);
        return result;
    }

    @Override
    public Frame retainFrame(Frame frame) {
        return super.retainFrame(frame);
    }

    @Override
    public Frame releaseFrame(Frame frame) {
        if (frame.isReusable()) {
            int refCount = frame.decRefCount();
            if (refCount == 0 && frame.hasNativeAllocation()) {
                if (!this.storeFrame(frame)) {
                    frame.releaseNativeAllocation();
                }
                return null;
            }
            if (refCount < 0) {
                throw new RuntimeException("Frame reference count dropped below 0!");
            }
        } else {
            super.releaseFrame(frame);
        }
        return frame;
    }

    public void clearCache() {
        for (Frame frame : this.mAvailableFrames.values()) {
            frame.releaseNativeAllocation();
        }
        this.mAvailableFrames.clear();
    }

    @Override
    public void tearDown() {
        this.clearCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean storeFrame(Frame frame) {
        SortedMap<Integer, Frame> sortedMap = this.mAvailableFrames;
        synchronized (sortedMap) {
            int frameSize = frame.getFormat().getSize();
            if (frameSize > this.mStorageCapacity) {
                return false;
            }
            int newStorageSize = this.mStorageSize + frameSize;
            while (newStorageSize > this.mStorageCapacity) {
                this.dropOldestFrame();
                newStorageSize = this.mStorageSize + frameSize;
            }
            frame.onFrameStore();
            this.mStorageSize = newStorageSize;
            this.mAvailableFrames.put(this.mTimeStamp, frame);
            ++this.mTimeStamp;
            return true;
        }
    }

    private void dropOldestFrame() {
        int oldest = this.mAvailableFrames.firstKey();
        Frame frame = (Frame)this.mAvailableFrames.get(oldest);
        this.mStorageSize -= frame.getFormat().getSize();
        frame.releaseNativeAllocation();
        this.mAvailableFrames.remove(oldest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Frame findAvailableFrame(FrameFormat format, int bindingType, long bindingId) {
        SortedMap<Integer, Frame> sortedMap = this.mAvailableFrames;
        synchronized (sortedMap) {
            for (Map.Entry<Integer, Frame> entry : this.mAvailableFrames.entrySet()) {
                Frame frame = entry.getValue();
                if (!frame.getFormat().isReplaceableBy(format) || bindingType != frame.getBindingType() || bindingType != 0 && bindingId != frame.getBindingId()) continue;
                super.retainFrame(frame);
                this.mAvailableFrames.remove(entry.getKey());
                frame.onFrameFetch();
                frame.reset(format);
                this.mStorageSize -= format.getSize();
                return frame;
            }
        }
        return null;
    }
}

