/*
 * Decompiled with CFR 0.152.
 */
package android.filterfw.core;

import android.filterfw.core.Frame;
import android.filterfw.core.FrameFormat;
import android.filterfw.core.FrameManager;
import android.filterfw.core.GLFrame;
import android.filterfw.core.NativeBuffer;
import android.filterfw.core.SimpleFrame;
import android.graphics.Bitmap;
import java.nio.ByteBuffer;

public class NativeFrame
extends Frame {
    private int nativeFrameId = -1;

    NativeFrame(FrameFormat format, FrameManager frameManager) {
        super(format, frameManager);
        int capacity = format.getSize();
        this.nativeAllocate(capacity);
        this.setReusable(capacity != 0);
    }

    @Override
    protected synchronized void releaseNativeAllocation() {
        this.nativeDeallocate();
        this.nativeFrameId = -1;
    }

    @Override
    protected synchronized boolean hasNativeAllocation() {
        return this.nativeFrameId != -1;
    }

    @Override
    public int getCapacity() {
        return this.getNativeCapacity();
    }

    @Override
    public Object getObjectValue() {
        if (this.getFormat().getBaseType() != 8) {
            return this.getData();
        }
        Class structClass = this.getFormat().getObjectClass();
        if (structClass == null) {
            throw new RuntimeException("Attempting to get object data from frame that does not specify a structure object class!");
        }
        if (!NativeBuffer.class.isAssignableFrom(structClass)) {
            throw new RuntimeException("NativeFrame object class must be a subclass of NativeBuffer!");
        }
        NativeBuffer structData = null;
        try {
            structData = (NativeBuffer)structClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not instantiate new structure instance of type '" + structClass + "'!");
        }
        if (!this.getNativeBuffer(structData)) {
            throw new RuntimeException("Could not get the native structured data for frame!");
        }
        structData.attachToFrame(this);
        return structData;
    }

    @Override
    public void setInts(int[] ints) {
        this.assertFrameMutable();
        if (ints.length * NativeFrame.nativeIntSize() > this.getFormat().getSize()) {
            throw new RuntimeException("NativeFrame cannot hold " + ints.length + " integers. (Can only hold " + this.getFormat().getSize() / NativeFrame.nativeIntSize() + " integers).");
        }
        if (!this.setNativeInts(ints)) {
            throw new RuntimeException("Could not set int values for native frame!");
        }
    }

    @Override
    public int[] getInts() {
        return this.getNativeInts(this.getFormat().getSize());
    }

    @Override
    public void setFloats(float[] floats) {
        this.assertFrameMutable();
        if (floats.length * NativeFrame.nativeFloatSize() > this.getFormat().getSize()) {
            throw new RuntimeException("NativeFrame cannot hold " + floats.length + " floats. (Can only hold " + this.getFormat().getSize() / NativeFrame.nativeFloatSize() + " floats).");
        }
        if (!this.setNativeFloats(floats)) {
            throw new RuntimeException("Could not set int values for native frame!");
        }
    }

    @Override
    public float[] getFloats() {
        return this.getNativeFloats(this.getFormat().getSize());
    }

    @Override
    public void setData(ByteBuffer buffer, int offset, int length) {
        this.assertFrameMutable();
        byte[] bytes = buffer.array();
        if (length + offset > buffer.limit()) {
            throw new RuntimeException("Offset and length exceed buffer size in native setData: " + (length + offset) + " bytes given, but only " + buffer.limit() + " bytes available!");
        }
        if (this.getFormat().getSize() != length) {
            throw new RuntimeException("Data size in setData does not match native frame size: Frame size is " + this.getFormat().getSize() + " bytes, but " + length + " bytes given!");
        }
        if (!this.setNativeData(bytes, offset, length)) {
            throw new RuntimeException("Could not set native frame data!");
        }
    }

    @Override
    public ByteBuffer getData() {
        byte[] data = this.getNativeData(this.getFormat().getSize());
        return data == null ? null : ByteBuffer.wrap(data);
    }

    @Override
    public void setBitmap(Bitmap bitmap) {
        int bps;
        int byteCount;
        this.assertFrameMutable();
        if (this.getFormat().getNumberOfDimensions() != 2) {
            throw new RuntimeException("Attempting to set Bitmap for non 2-dimensional native frame!");
        }
        if (this.getFormat().getWidth() != bitmap.getWidth() || this.getFormat().getHeight() != bitmap.getHeight()) {
            throw new RuntimeException("Bitmap dimensions do not match native frame dimensions!");
        }
        Bitmap rgbaBitmap = NativeFrame.convertBitmapToRGBA(bitmap);
        if (!this.setNativeBitmap(rgbaBitmap, byteCount = rgbaBitmap.getByteCount(), bps = this.getFormat().getBytesPerSample())) {
            throw new RuntimeException("Could not set native frame bitmap data!");
        }
    }

    @Override
    public Bitmap getBitmap() {
        int bps;
        int byteCount;
        if (this.getFormat().getNumberOfDimensions() != 2) {
            throw new RuntimeException("Attempting to get Bitmap for non 2-dimensional native frame!");
        }
        Bitmap result = Bitmap.createBitmap(this.getFormat().getWidth(), this.getFormat().getHeight(), Bitmap.Config.ARGB_8888);
        if (!this.getNativeBitmap(result, byteCount = result.getByteCount(), bps = this.getFormat().getBytesPerSample())) {
            throw new RuntimeException("Could not get bitmap data from native frame!");
        }
        return result;
    }

    @Override
    public void setDataFromFrame(Frame frame) {
        if (this.getFormat().getSize() < frame.getFormat().getSize()) {
            throw new RuntimeException("Attempting to assign frame of size " + frame.getFormat().getSize() + " to " + "smaller native frame of size " + this.getFormat().getSize() + "!");
        }
        if (frame instanceof NativeFrame) {
            this.nativeCopyFromNative((NativeFrame)frame);
        } else if (frame instanceof GLFrame) {
            this.nativeCopyFromGL((GLFrame)frame);
        } else if (frame instanceof SimpleFrame) {
            this.setObjectValue(frame.getObjectValue());
        } else {
            super.setDataFromFrame(frame);
        }
    }

    public String toString() {
        return "NativeFrame id: " + this.nativeFrameId + " (" + this.getFormat() + ") of size " + this.getCapacity();
    }

    private native boolean nativeAllocate(int var1);

    private native boolean nativeDeallocate();

    private native int getNativeCapacity();

    private static native int nativeIntSize();

    private static native int nativeFloatSize();

    private native boolean setNativeData(byte[] var1, int var2, int var3);

    private native byte[] getNativeData(int var1);

    private native boolean getNativeBuffer(NativeBuffer var1);

    private native boolean setNativeInts(int[] var1);

    private native boolean setNativeFloats(float[] var1);

    private native int[] getNativeInts(int var1);

    private native float[] getNativeFloats(int var1);

    private native boolean setNativeBitmap(Bitmap var1, int var2, int var3);

    private native boolean getNativeBitmap(Bitmap var1, int var2, int var3);

    private native boolean nativeCopyFromNative(NativeFrame var1);

    private native boolean nativeCopyFromGL(GLFrame var1);

    static {
        System.loadLibrary("filterfw");
    }
}

