/*
 * Decompiled with CFR 0.152.
 */
package android.gesture;

import android.content.Context;
import android.gesture.GestureLibrary;
import android.util.Log;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;

public final class GestureLibraries {
    private GestureLibraries() {
    }

    public static GestureLibrary fromFile(String path) {
        return GestureLibraries.fromFile(new File(path));
    }

    public static GestureLibrary fromFile(File path) {
        return new FileGestureLibrary(path);
    }

    public static GestureLibrary fromPrivateFile(Context context, String name) {
        return GestureLibraries.fromFile(context.getFileStreamPath(name));
    }

    public static GestureLibrary fromRawResource(Context context, int resourceId) {
        return new ResourceGestureLibrary(context, resourceId);
    }

    private static class ResourceGestureLibrary
    extends GestureLibrary {
        private final WeakReference<Context> mContext;
        private final int mResourceId;

        public ResourceGestureLibrary(Context context, int resourceId) {
            this.mContext = new WeakReference<Context>(context);
            this.mResourceId = resourceId;
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }

        @Override
        public boolean save() {
            return false;
        }

        @Override
        public boolean load() {
            boolean result = false;
            Context context = (Context)this.mContext.get();
            if (context != null) {
                InputStream in = context.getResources().openRawResource(this.mResourceId);
                try {
                    this.mStore.load(in, true);
                    result = true;
                }
                catch (IOException e) {
                    Log.d("Gestures", "Could not load the gesture library from raw resource " + context.getResources().getResourceName(this.mResourceId), e);
                }
            }
            return result;
        }
    }

    private static class FileGestureLibrary
    extends GestureLibrary {
        private final File mPath;

        public FileGestureLibrary(File path) {
            this.mPath = path;
        }

        @Override
        public boolean isReadOnly() {
            return !this.mPath.canWrite();
        }

        @Override
        public boolean save() {
            if (!this.mStore.hasChanged()) {
                return true;
            }
            File file = this.mPath;
            File parentFile = file.getParentFile();
            if (!parentFile.exists() && !parentFile.mkdirs()) {
                return false;
            }
            boolean result = false;
            try {
                file.createNewFile();
                this.mStore.save(new FileOutputStream(file), true);
                result = true;
            }
            catch (FileNotFoundException e) {
                Log.d("Gestures", "Could not save the gesture library in " + this.mPath, e);
            }
            catch (IOException e) {
                Log.d("Gestures", "Could not save the gesture library in " + this.mPath, e);
            }
            return result;
        }

        @Override
        public boolean load() {
            boolean result = false;
            File file = this.mPath;
            if (file.exists() && file.canRead()) {
                try {
                    this.mStore.load(new FileInputStream(file), true);
                    result = true;
                }
                catch (FileNotFoundException e) {
                    Log.d("Gestures", "Could not load the gesture library from " + this.mPath, e);
                }
                catch (IOException e) {
                    Log.d("Gestures", "Could not load the gesture library from " + this.mPath, e);
                }
            }
            return result;
        }
    }
}

