/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.content.res.AssetManager;
import android.text.FontConfig;
import android.util.Log;
import dalvik.annotation.optimization.CriticalNative;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.List;

public class FontFamily {
    private static String TAG = "FontFamily";
    public long mNativePtr;
    private long mBuilderPtr;

    public FontFamily() {
        this.mBuilderPtr = FontFamily.nInitBuilder(null, 0);
    }

    public FontFamily(String lang, String variant) {
        int varEnum = 0;
        if ("compact".equals(variant)) {
            varEnum = 1;
        } else if ("elegant".equals(variant)) {
            varEnum = 2;
        }
        this.mBuilderPtr = FontFamily.nInitBuilder(lang, varEnum);
    }

    public void freeze() {
        if (this.mBuilderPtr == 0L) {
            throw new IllegalStateException("This FontFamily is already frozen");
        }
        this.mNativePtr = FontFamily.nCreateFamily(this.mBuilderPtr);
        this.mBuilderPtr = 0L;
    }

    public void abortCreation() {
        if (this.mBuilderPtr == 0L) {
            throw new IllegalStateException("This FontFamily is already frozen or abandoned");
        }
        FontFamily.nAbort(this.mBuilderPtr);
        this.mBuilderPtr = 0L;
    }

    protected void finalize() throws Throwable {
        try {
            if (this.mNativePtr != 0L) {
                FontFamily.nUnrefFamily(this.mNativePtr);
            }
            if (this.mBuilderPtr != 0L) {
                FontFamily.nAbort(this.mBuilderPtr);
            }
        }
        finally {
            super.finalize();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean addFont(String path, int ttcIndex) {
        if (this.mBuilderPtr == 0L) {
            throw new IllegalStateException("Unable to call addFont after freezing.");
        }
        try (FileInputStream file = new FileInputStream(path);){
            FileChannel fileChannel = file.getChannel();
            long fontSize = fileChannel.size();
            MappedByteBuffer fontBuffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, fontSize);
            boolean bl = FontFamily.nAddFont(this.mBuilderPtr, fontBuffer, ttcIndex);
            return bl;
        }
        catch (IOException e) {
            Log.e(TAG, "Error mapping font file " + path);
            return false;
        }
    }

    public boolean addFontWeightStyle(ByteBuffer font, int ttcIndex, List<FontConfig.Axis> axes, int weight, boolean style2) {
        if (this.mBuilderPtr == 0L) {
            throw new IllegalStateException("Unable to call addFontWeightStyle after freezing.");
        }
        return FontFamily.nAddFontWeightStyle(this.mBuilderPtr, font, ttcIndex, axes, weight, style2);
    }

    public boolean addFontFromAssetManager(AssetManager mgr, String path, int cookie, boolean isAsset, int weight, boolean isItalic) {
        if (this.mBuilderPtr == 0L) {
            throw new IllegalStateException("Unable to call addFontFromAsset after freezing.");
        }
        return FontFamily.nAddFontFromAssetManager(this.mBuilderPtr, mgr, path, cookie, isAsset, weight, isItalic);
    }

    private static native long nInitBuilder(String var0, int var1);

    @CriticalNative
    private static native long nCreateFamily(long var0);

    @CriticalNative
    private static native void nAbort(long var0);

    @CriticalNative
    private static native void nUnrefFamily(long var0);

    private static native boolean nAddFont(long var0, ByteBuffer var2, int var3);

    private static native boolean nAddFontWeightStyle(long var0, ByteBuffer var2, int var3, List<FontConfig.Axis> var4, int var5, boolean var6);

    private static native boolean nAddFontFromAssetManager(long var0, AssetManager var2, String var3, int var4, boolean var5, int var6, boolean var7);
}

