/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.text.FontConfig;
import android.util.Xml;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.regex.Pattern;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class FontListParser {
    private static final Pattern FILENAME_WHITESPACE_PATTERN = Pattern.compile("^[ \\n\\r\\t]+|[ \\n\\r\\t]+$");
    private static final Pattern TAG_PATTERN = Pattern.compile("[\\x20-\\x7E]{4}");
    private static final Pattern STYLE_VALUE_PATTERN = Pattern.compile("-?(([0-9]+(\\.[0-9]+)?)|(\\.[0-9]+))");

    public static FontConfig parse(InputStream in) throws XmlPullParserException, IOException {
        try {
            XmlPullParser parser = Xml.newPullParser();
            parser.setInput(in, null);
            parser.nextTag();
            FontConfig fontConfig = FontListParser.readFamilies(parser);
            return fontConfig;
        }
        finally {
            in.close();
        }
    }

    public static ArrayList<FontConfig.Axis> parseFontVariationSettings(String settings) {
        String[] settingList;
        ArrayList<FontConfig.Axis> axisList = new ArrayList<FontConfig.Axis>();
        if (settings == null) {
            return axisList;
        }
        block2: for (String setting : settingList = settings.split(",")) {
            float styleValue;
            String tagString;
            char c;
            int pos;
            for (pos = 0; pos < setting.length() && (c = setting.charAt(pos)) != '\'' && c != '\"'; ++pos) {
                if (!FontListParser.isSpacer(c)) continue block2;
            }
            if (pos + 7 > setting.length() || setting.charAt(pos) != setting.charAt(pos + 5) || !TAG_PATTERN.matcher(tagString = setting.substring(pos + 1, pos + 5)).matches()) continue;
            pos += 6;
            while (pos < setting.length() && FontListParser.isSpacer(setting.charAt(pos++))) {
            }
            String valueString = setting.substring(pos - 1);
            if (!STYLE_VALUE_PATTERN.matcher(valueString).matches()) continue;
            try {
                styleValue = Float.parseFloat(valueString);
            }
            catch (NumberFormatException e) {
                continue;
            }
            int tag = FontListParser.makeTag(tagString.charAt(0), tagString.charAt(1), tagString.charAt(2), tagString.charAt(3));
            axisList.add(new FontConfig.Axis(tag, styleValue));
        }
        return axisList;
    }

    public static int makeTag(char c1, char c2, char c3, char c4) {
        return c1 << 24 | c2 << 16 | c3 << 8 | c4;
    }

    private static boolean isSpacer(char c) {
        return c == ' ' || c == '\r' || c == '\t' || c == '\n';
    }

    private static FontConfig readFamilies(XmlPullParser parser) throws XmlPullParserException, IOException {
        FontConfig config = new FontConfig();
        parser.require(2, null, "familyset");
        while (parser.next() != 3) {
            if (parser.getEventType() != 2) continue;
            String tag = parser.getName();
            if (tag.equals("family")) {
                config.getFamilies().add(FontListParser.readFamily(parser));
                continue;
            }
            if (tag.equals("alias")) {
                config.getAliases().add(FontListParser.readAlias(parser));
                continue;
            }
            FontListParser.skip(parser);
        }
        return config;
    }

    private static FontConfig.Family readFamily(XmlPullParser parser) throws XmlPullParserException, IOException {
        String name = parser.getAttributeValue(null, "name");
        String lang = parser.getAttributeValue(null, "lang");
        String variant = parser.getAttributeValue(null, "variant");
        ArrayList<FontConfig.Font> fonts = new ArrayList<FontConfig.Font>();
        while (parser.next() != 3) {
            if (parser.getEventType() != 2) continue;
            String tag = parser.getName();
            if (tag.equals("font")) {
                fonts.add(FontListParser.readFont(parser));
                continue;
            }
            FontListParser.skip(parser);
        }
        return new FontConfig.Family(name, fonts, lang, variant);
    }

    private static FontConfig.Font readFont(XmlPullParser parser) throws XmlPullParserException, IOException {
        String indexStr = parser.getAttributeValue(null, "index");
        int index = indexStr == null ? 0 : Integer.parseInt(indexStr);
        ArrayList<FontConfig.Axis> axes = new ArrayList<FontConfig.Axis>();
        String weightStr = parser.getAttributeValue(null, "weight");
        int weight = weightStr == null ? 400 : Integer.parseInt(weightStr);
        boolean isItalic = "italic".equals(parser.getAttributeValue(null, "style"));
        StringBuilder filename = new StringBuilder();
        while (parser.next() != 3) {
            if (parser.getEventType() == 4) {
                filename.append(parser.getText());
            }
            if (parser.getEventType() != 2) continue;
            String tag = parser.getName();
            if (tag.equals("axis")) {
                axes.add(FontListParser.readAxis(parser));
                continue;
            }
            FontListParser.skip(parser);
        }
        String fullFilename = "/system/fonts/" + FILENAME_WHITESPACE_PATTERN.matcher(filename).replaceAll("");
        return new FontConfig.Font(fullFilename, index, axes, weight, isItalic);
    }

    private static FontConfig.Axis readAxis(XmlPullParser parser) throws XmlPullParserException, IOException {
        int tag = 0;
        String tagStr = parser.getAttributeValue(null, "tag");
        if (tagStr == null || !TAG_PATTERN.matcher(tagStr).matches()) {
            throw new XmlPullParserException("Invalid tag attribute value.", parser, null);
        }
        tag = FontListParser.makeTag(tagStr.charAt(0), tagStr.charAt(1), tagStr.charAt(2), tagStr.charAt(3));
        float styleValue = 0.0f;
        String styleValueStr = parser.getAttributeValue(null, "stylevalue");
        if (styleValueStr == null || !STYLE_VALUE_PATTERN.matcher(styleValueStr).matches()) {
            throw new XmlPullParserException("Invalid styleValue attribute value.", parser, null);
        }
        styleValue = Float.parseFloat(styleValueStr);
        FontListParser.skip(parser);
        return new FontConfig.Axis(tag, styleValue);
    }

    private static FontConfig.Alias readAlias(XmlPullParser parser) throws XmlPullParserException, IOException {
        String name = parser.getAttributeValue(null, "name");
        String toName = parser.getAttributeValue(null, "to");
        String weightStr = parser.getAttributeValue(null, "weight");
        int weight = weightStr == null ? 400 : Integer.parseInt(weightStr);
        FontListParser.skip(parser);
        return new FontConfig.Alias(name, toName, weight);
    }

    private static void skip(XmlPullParser parser) throws XmlPullParserException, IOException {
        int depth = 1;
        while (depth > 0) {
            switch (parser.next()) {
                case 2: {
                    ++depth;
                    break;
                }
                case 3: {
                    --depth;
                }
            }
        }
    }
}

