/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.view.Surface;
import java.lang.ref.WeakReference;

public class SurfaceTexture {
    private final Looper mCreatorLooper = Looper.myLooper();
    private Handler mOnFrameAvailableHandler;
    private long mSurfaceTexture;
    private long mProducer;
    private long mFrameAvailableListener;
    private boolean mIsSingleBuffered;

    public SurfaceTexture(int texName) {
        this(texName, false);
    }

    public SurfaceTexture(int texName, boolean singleBufferMode) {
        this.mIsSingleBuffered = singleBufferMode;
        this.nativeInit(false, texName, singleBufferMode, new WeakReference<SurfaceTexture>(this));
    }

    public SurfaceTexture(boolean singleBufferMode) {
        this.mIsSingleBuffered = singleBufferMode;
        this.nativeInit(true, 0, singleBufferMode, new WeakReference<SurfaceTexture>(this));
    }

    public void setOnFrameAvailableListener(OnFrameAvailableListener listener) {
        this.setOnFrameAvailableListener(listener, null);
    }

    public void setOnFrameAvailableListener(final OnFrameAvailableListener listener, Handler handler) {
        if (listener != null) {
            Looper looper = handler != null ? handler.getLooper() : (this.mCreatorLooper != null ? this.mCreatorLooper : Looper.getMainLooper());
            this.mOnFrameAvailableHandler = new Handler(looper, null, true){

                @Override
                public void handleMessage(Message msg) {
                    listener.onFrameAvailable(SurfaceTexture.this);
                }
            };
        } else {
            this.mOnFrameAvailableHandler = null;
        }
    }

    public void setDefaultBufferSize(int width, int height) {
        this.nativeSetDefaultBufferSize(width, height);
    }

    public void updateTexImage() {
        this.nativeUpdateTexImage();
    }

    public void releaseTexImage() {
        this.nativeReleaseTexImage();
    }

    public void detachFromGLContext() {
        int err = this.nativeDetachFromGLContext();
        if (err != 0) {
            throw new RuntimeException("Error during detachFromGLContext (see logcat for details)");
        }
    }

    public void attachToGLContext(int texName) {
        int err = this.nativeAttachToGLContext(texName);
        if (err != 0) {
            throw new RuntimeException("Error during attachToGLContext (see logcat for details)");
        }
    }

    public void getTransformMatrix(float[] mtx) {
        if (mtx.length != 16) {
            throw new IllegalArgumentException();
        }
        this.nativeGetTransformMatrix(mtx);
    }

    public long getTimestamp() {
        return this.nativeGetTimestamp();
    }

    public void release() {
        this.nativeRelease();
    }

    public boolean isReleased() {
        return this.nativeIsReleased();
    }

    protected void finalize() throws Throwable {
        try {
            this.nativeFinalize();
        }
        finally {
            super.finalize();
        }
    }

    private static void postEventFromNative(WeakReference<SurfaceTexture> weakSelf) {
        Handler handler;
        SurfaceTexture st = (SurfaceTexture)weakSelf.get();
        if (st != null && (handler = st.mOnFrameAvailableHandler) != null) {
            handler.sendEmptyMessage(0);
        }
    }

    public boolean isSingleBuffered() {
        return this.mIsSingleBuffered;
    }

    private native void nativeInit(boolean var1, int var2, boolean var3, WeakReference<SurfaceTexture> var4) throws Surface.OutOfResourcesException;

    private native void nativeFinalize();

    private native void nativeGetTransformMatrix(float[] var1);

    private native long nativeGetTimestamp();

    private native void nativeSetDefaultBufferSize(int var1, int var2);

    private native void nativeUpdateTexImage();

    private native void nativeReleaseTexImage();

    private native int nativeDetachFromGLContext();

    private native int nativeAttachToGLContext(int var1);

    private native int nativeGetQueuedCount();

    private native void nativeRelease();

    private native boolean nativeIsReleased();

    @Deprecated
    public static class OutOfResourcesException
    extends Exception {
        public OutOfResourcesException() {
        }

        public OutOfResourcesException(String name) {
            super(name);
        }
    }

    public static interface OnFrameAvailableListener {
        public void onFrameAvailable(SurfaceTexture var1);
    }
}

