/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.annotation.IntDef;
import android.content.res.AssetManager;
import android.graphics.FontFamily;
import android.graphics.FontListParser;
import android.graphics.Typeface$$Lambda$74;
import android.graphics.Typeface$1$$Lambda$73;
import android.graphics.fonts.FontRequest;
import android.graphics.fonts.FontResult;
import android.os.Bundle;
import android.os.Handler;
import android.os.ParcelFileDescriptor;
import android.os.ResultReceiver;
import android.provider.FontsContract;
import android.text.FontConfig;
import android.util.Log;
import android.util.LongSparseArray;
import android.util.LruCache;
import android.util.SparseArray;
import com.android.internal.annotations.GuardedBy;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import libcore.io.IoUtils;
import org.xmlpull.v1.XmlPullParserException;

public class Typeface {
    private static String TAG = "Typeface";
    public static final Typeface DEFAULT;
    public static final Typeface DEFAULT_BOLD;
    public static final Typeface SANS_SERIF;
    public static final Typeface SERIF;
    public static final Typeface MONOSPACE;
    static Typeface[] sDefaults;
    private static final LongSparseArray<SparseArray<Typeface>> sTypefaceCache;
    @GuardedBy(value="sLock")
    private static FontsContract sFontsContract;
    @GuardedBy(value="sLock")
    private static Handler mHandler;
    private static final LruCache<String, Typeface> sDynamicTypefaceCache;
    static Typeface sDefaultTypeface;
    static Map<String, Typeface> sSystemFontMap;
    static FontFamily[] sFallbackFonts;
    private static final Object sLock;
    static final String FONTS_CONFIG = "fonts.xml";
    public long native_instance;
    public static final int NORMAL = 0;
    public static final int BOLD = 1;
    public static final int ITALIC = 2;
    public static final int BOLD_ITALIC = 3;
    private int mStyle = 0;
    private static final FontRequestCallback NO_OP_REQUEST_CALLBACK;

    private static void setDefault(Typeface t) {
        sDefaultTypeface = t;
        Typeface.nativeSetDefault(t.native_instance);
    }

    public int getStyle() {
        return this.mStyle;
    }

    public final boolean isBold() {
        return (this.mStyle & 1) != 0;
    }

    public final boolean isItalic() {
        return (this.mStyle & 2) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Typeface createFromResources(AssetManager mgr, String path, int cookie) {
        if (sFallbackFonts != null) {
            LruCache<String, Typeface> lruCache = sDynamicTypefaceCache;
            synchronized (lruCache) {
                String key = Typeface.createAssetUid(mgr, path);
                Typeface typeface = sDynamicTypefaceCache.get(key);
                if (typeface != null) {
                    return typeface;
                }
                FontFamily fontFamily = new FontFamily();
                if (fontFamily.addFontFromAssetManager(mgr, path, cookie, false, 0, false)) {
                    fontFamily.freeze();
                    FontFamily[] families = new FontFamily[]{fontFamily};
                    typeface = Typeface.createFromFamiliesWithDefault(families);
                    sDynamicTypefaceCache.put(key, typeface);
                    return typeface;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Typeface createFromResources(FontConfig config, AssetManager mgr, String path) {
        if (sFallbackFonts != null) {
            Typeface typeface = Typeface.findFromCache(mgr, path);
            if (typeface != null) {
                return typeface;
            }
            List<FontConfig.Family> families = config.getFamilies();
            if (families == null || families.isEmpty()) {
                throw new RuntimeException("Font resource " + path + " contained no font families.");
            }
            if (families.size() > 1) {
                throw new RuntimeException("Font resource " + path + " contained more than one family.");
            }
            FontConfig.Family family = families.get(0);
            if (family.getProviderAuthority() != null && family.getQuery() != null) {
                typeface = Typeface.findFromCache(family.getProviderAuthority(), family.getQuery());
                if (typeface != null) {
                    return typeface;
                }
                Typeface.create(new FontRequest(family.getProviderAuthority(), family.getQuery()), NO_OP_REQUEST_CALLBACK);
                return DEFAULT;
            }
            FontFamily fontFamily = new FontFamily();
            List<FontConfig.Font> fonts = family.getFonts();
            if (fonts == null || fonts.isEmpty()) {
                throw new RuntimeException("Font resource " + path + " contained no fonts.");
            }
            for (int i = 0; i < fonts.size(); ++i) {
                FontConfig.Font font = fonts.get(i);
                if (fontFamily.addFontFromAssetManager(mgr, font.getFontName(), 0, false, font.getWeight(), font.isItalic())) continue;
                return null;
            }
            fontFamily.freeze();
            FontFamily[] familyChain = new FontFamily[]{fontFamily};
            typeface = Typeface.createFromFamiliesWithDefault(familyChain);
            LruCache<String, Typeface> lruCache = sDynamicTypefaceCache;
            synchronized (lruCache) {
                String key = Typeface.createAssetUid(mgr, path);
                sDynamicTypefaceCache.put(key, typeface);
            }
            return typeface;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Typeface findFromCache(AssetManager mgr, String path) {
        LruCache<String, Typeface> lruCache = sDynamicTypefaceCache;
        synchronized (lruCache) {
            String key = Typeface.createAssetUid(mgr, path);
            Typeface typeface = sDynamicTypefaceCache.get(key);
            if (typeface != null) {
                return typeface;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void create(final FontRequest request, final FontRequestCallback callback) {
        Typeface cachedTypeface = Typeface.findFromCache(request.getProviderAuthority(), request.getQuery());
        if (cachedTypeface != null) {
            mHandler.post(Typeface$$Lambda$74.get$Lambda(callback, cachedTypeface));
            return;
        }
        Object object = sLock;
        synchronized (object) {
            if (sFontsContract == null) {
                sFontsContract = new FontsContract();
                mHandler = new Handler();
            }
            ResultReceiver receiver = new ResultReceiver(null){

                @Override
                public void onReceiveResult(int resultCode, Bundle resultData) {
                    mHandler.post(Typeface$1$$Lambda$73.get$Lambda(request, callback, resultCode, resultData));
                }

                static final /* synthetic */ void lambda$onReceiveResult$6$Typeface$1(FontRequest fontRequest, FontRequestCallback fontRequestCallback, int n, Bundle bundle) {
                    Typeface.receiveResult(fontRequest, fontRequestCallback, n, bundle);
                }
            };
            sFontsContract.getFont(request, receiver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Typeface findFromCache(String providerAuthority, String query) {
        LruCache<String, Typeface> lruCache = sDynamicTypefaceCache;
        synchronized (lruCache) {
            String key = Typeface.createProviderUid(providerAuthority, query);
            Typeface typeface = sDynamicTypefaceCache.get(key);
            if (typeface != null) {
                return typeface;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void receiveResult(FontRequest request, FontRequestCallback callback, int resultCode, Bundle resultData) {
        Typeface cachedTypeface = Typeface.findFromCache(request.getProviderAuthority(), request.getQuery());
        if (cachedTypeface != null) {
            callback.onTypefaceRetrieved(cachedTypeface);
            return;
        }
        if (resultCode == 2) {
            callback.onTypefaceRequestFailed(0);
            return;
        }
        if (resultCode == 1 || resultData == null) {
            callback.onTypefaceRequestFailed(2);
            return;
        }
        ArrayList resultList = resultData.getParcelableArrayList("font_results");
        if (resultList == null || resultList.isEmpty()) {
            callback.onTypefaceRequestFailed(2);
            return;
        }
        FontFamily fontFamily = new FontFamily();
        for (int i = 0; i < resultList.size(); ++i) {
            FontResult result = (FontResult)resultList.get(i);
            ParcelFileDescriptor fd = result.getFileDescriptor();
            if (fd == null) {
                callback.onTypefaceRequestFailed(1);
                return;
            }
            try (FileInputStream is = new FileInputStream(fd.getFileDescriptor());){
                FileChannel fileChannel = is.getChannel();
                long fontSize = fileChannel.size();
                MappedByteBuffer fontBuffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, fontSize);
                int style2 = result.getStyle();
                int weight = (style2 & 1) != 0 ? 700 : 400;
                if (fontFamily.addFontWeightStyle(fontBuffer, result.getTtcIndex(), null, weight, (style2 & 2) != 0)) continue;
                Log.e(TAG, "Error creating font " + request.getQuery());
                callback.onTypefaceRequestFailed(1);
                return;
            }
            catch (IOException e) {
                Log.e(TAG, "Error reading font " + request.getQuery(), e);
                callback.onTypefaceRequestFailed(1);
                return;
            }
            finally {
                IoUtils.closeQuietly(fd);
            }
        }
        fontFamily.freeze();
        Typeface typeface = Typeface.createFromFamiliesWithDefault(new FontFamily[]{fontFamily});
        LruCache<String, Typeface> lruCache = sDynamicTypefaceCache;
        synchronized (lruCache) {
            String key = Typeface.createProviderUid(request.getProviderAuthority(), request.getQuery());
            sDynamicTypefaceCache.put(key, typeface);
        }
        callback.onTypefaceRetrieved(typeface);
    }

    public static Typeface create(String familyName, int style2) {
        if (sSystemFontMap != null) {
            return Typeface.create(sSystemFontMap.get(familyName), style2);
        }
        return null;
    }

    public static Typeface create(Typeface family, int style2) {
        Typeface typeface;
        SparseArray<Typeface> styles;
        if (style2 < 0 || style2 > 3) {
            style2 = 0;
        }
        long ni = 0L;
        if (family != null) {
            if (family.mStyle == style2) {
                return family;
            }
            ni = family.native_instance;
        }
        if ((styles = sTypefaceCache.get(ni)) != null && (typeface = styles.get(style2)) != null) {
            return typeface;
        }
        typeface = new Typeface(Typeface.nativeCreateFromTypeface(ni, style2));
        if (styles == null) {
            styles = new SparseArray(4);
            sTypefaceCache.put(ni, styles);
        }
        styles.put(style2, typeface);
        return typeface;
    }

    public static Typeface createFromTypefaceWithVariation(Typeface family, String fontVariationSettings) {
        long ni = family == null ? 0L : family.native_instance;
        ArrayList<FontConfig.Axis> axes = FontListParser.parseFontVariationSettings(fontVariationSettings);
        return new Typeface(Typeface.nativeCreateFromTypefaceWithVariation(ni, axes));
    }

    public static Typeface defaultFromStyle(int style2) {
        return sDefaults[style2];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Typeface createFromAsset(AssetManager mgr, String path) {
        if (sFallbackFonts != null) {
            LruCache<String, Typeface> lruCache = sDynamicTypefaceCache;
            synchronized (lruCache) {
                String key = Typeface.createAssetUid(mgr, path);
                Typeface typeface = sDynamicTypefaceCache.get(key);
                if (typeface != null) {
                    return typeface;
                }
                FontFamily fontFamily = new FontFamily();
                if (fontFamily.addFontFromAssetManager(mgr, path, 0, true, 0, false)) {
                    fontFamily.freeze();
                    FontFamily[] families = new FontFamily[]{fontFamily};
                    typeface = Typeface.createFromFamiliesWithDefault(families);
                    sDynamicTypefaceCache.put(key, typeface);
                    return typeface;
                }
                fontFamily.abortCreation();
            }
        }
        throw new RuntimeException("Font asset not found " + path);
    }

    private static String createAssetUid(AssetManager mgr, String path) {
        SparseArray<String> pkgs = mgr.getAssignedPackageIdentifiers();
        StringBuilder builder = new StringBuilder();
        builder.append("asset:");
        int size = pkgs.size();
        for (int i = 0; i < size; ++i) {
            builder.append(pkgs.valueAt(i));
            builder.append("-");
        }
        builder.append(path);
        return builder.toString();
    }

    private static String createProviderUid(String authority, String query) {
        StringBuilder builder = new StringBuilder();
        builder.append("provider:");
        builder.append(authority);
        builder.append("-");
        builder.append(query);
        return builder.toString();
    }

    public static Typeface createFromFile(File path) {
        return Typeface.createFromFile(path.getAbsolutePath());
    }

    public static Typeface createFromFile(String path) {
        if (sFallbackFonts != null) {
            FontFamily fontFamily = new FontFamily();
            if (fontFamily.addFont(path, 0)) {
                fontFamily.freeze();
                FontFamily[] families = new FontFamily[]{fontFamily};
                return Typeface.createFromFamiliesWithDefault(families);
            }
            fontFamily.abortCreation();
        }
        throw new RuntimeException("Font not found " + path);
    }

    public static Typeface createFromFamilies(FontFamily[] families) {
        long[] ptrArray = new long[families.length];
        for (int i = 0; i < families.length; ++i) {
            ptrArray[i] = families[i].mNativePtr;
        }
        return new Typeface(Typeface.nativeCreateFromArray(ptrArray));
    }

    public static Typeface createFromFamiliesWithDefault(FontFamily[] families) {
        int i;
        long[] ptrArray = new long[families.length + sFallbackFonts.length];
        for (i = 0; i < families.length; ++i) {
            ptrArray[i] = families[i].mNativePtr;
        }
        for (i = 0; i < sFallbackFonts.length; ++i) {
            ptrArray[i + families.length] = Typeface.sFallbackFonts[i].mNativePtr;
        }
        return new Typeface(Typeface.nativeCreateFromArray(ptrArray));
    }

    private Typeface(long ni) {
        if (ni == 0L) {
            throw new RuntimeException("native typeface cannot be made");
        }
        this.native_instance = ni;
        this.mStyle = Typeface.nativeGetStyle(ni);
    }

    private static FontFamily makeFamilyFromParsed(FontConfig.Family family, Map<String, ByteBuffer> bufferForPath) {
        FontFamily fontFamily = new FontFamily(family.getLanguage(), family.getVariant());
        for (FontConfig.Font font : family.getFonts()) {
            ByteBuffer fontBuffer = bufferForPath.get(font.getFontName());
            if (fontBuffer == null) {
                try (FileInputStream file = new FileInputStream(font.getFontName());){
                    FileChannel fileChannel = file.getChannel();
                    long fontSize = fileChannel.size();
                    fontBuffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, fontSize);
                    bufferForPath.put(font.getFontName(), fontBuffer);
                }
                catch (IOException e) {
                    Log.e(TAG, "Error mapping font file " + font.getFontName());
                    continue;
                }
            }
            if (fontFamily.addFontWeightStyle(fontBuffer, font.getTtcIndex(), font.getAxes(), font.getWeight(), font.isItalic())) continue;
            Log.e(TAG, "Error creating font " + font.getFontName() + "#" + font.getTtcIndex());
        }
        fontFamily.freeze();
        return fontFamily;
    }

    private static void init() {
        File systemFontConfigLocation = Typeface.getSystemFontConfigLocation();
        File configFilename = new File(systemFontConfigLocation, FONTS_CONFIG);
        try {
            FileInputStream fontsIn = new FileInputStream(configFilename);
            FontConfig fontConfig = FontListParser.parse(fontsIn);
            HashMap<String, ByteBuffer> bufferForPath = new HashMap<String, ByteBuffer>();
            ArrayList<FontFamily> familyList = new ArrayList<FontFamily>();
            for (int i = 0; i < fontConfig.getFamilies().size(); ++i) {
                FontConfig.Family f = fontConfig.getFamilies().get(i);
                if (i != 0 && f.getName() != null) continue;
                familyList.add(Typeface.makeFamilyFromParsed(f, bufferForPath));
            }
            sFallbackFonts = familyList.toArray(new FontFamily[familyList.size()]);
            Typeface.setDefault(Typeface.createFromFamilies(sFallbackFonts));
            HashMap<String, Typeface> systemFonts = new HashMap<String, Typeface>();
            for (int i = 0; i < fontConfig.getFamilies().size(); ++i) {
                Typeface typeface;
                FontConfig.Family f = fontConfig.getFamilies().get(i);
                if (f.getName() == null) continue;
                if (i == 0) {
                    typeface = sDefaultTypeface;
                } else {
                    FontFamily fontFamily = Typeface.makeFamilyFromParsed(f, bufferForPath);
                    FontFamily[] families = new FontFamily[]{fontFamily};
                    typeface = Typeface.createFromFamiliesWithDefault(families);
                }
                systemFonts.put(f.getName(), typeface);
            }
            for (FontConfig.Alias alias : fontConfig.getAliases()) {
                Typeface base;
                Typeface newFace = base = (Typeface)systemFonts.get(alias.getToName());
                int weight = alias.getWeight();
                if (weight != 400) {
                    newFace = new Typeface(Typeface.nativeCreateWeightAlias(base.native_instance, weight));
                }
                systemFonts.put(alias.getName(), newFace);
            }
            sSystemFontMap = systemFonts;
        }
        catch (RuntimeException e) {
            Log.w(TAG, "Didn't create default family (most likely, non-Minikin build)", e);
        }
        catch (FileNotFoundException e) {
            Log.e(TAG, "Error opening " + configFilename, e);
        }
        catch (IOException e) {
            Log.e(TAG, "Error reading " + configFilename, e);
        }
        catch (XmlPullParserException e) {
            Log.e(TAG, "XML parse exception for " + configFilename, e);
        }
    }

    private static File getSystemFontConfigLocation() {
        return new File("/system/etc/");
    }

    protected void finalize() throws Throwable {
        try {
            Typeface.nativeUnref(this.native_instance);
            this.native_instance = 0L;
        }
        finally {
            super.finalize();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Typeface typeface = (Typeface)o;
        return this.mStyle == typeface.mStyle && this.native_instance == typeface.native_instance;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + (int)(this.native_instance ^ this.native_instance >>> 32);
        result = 31 * result + this.mStyle;
        return result;
    }

    private static native long nativeCreateFromTypeface(long var0, int var2);

    private static native long nativeCreateFromTypefaceWithVariation(long var0, List<FontConfig.Axis> var2);

    private static native long nativeCreateWeightAlias(long var0, int var2);

    private static native void nativeUnref(long var0);

    private static native int nativeGetStyle(long var0);

    private static native long nativeCreateFromArray(long[] var0);

    private static native void nativeSetDefault(long var0);

    static final /* synthetic */ void lambda$create$5$Typeface(FontRequestCallback fontRequestCallback, Typeface typeface) {
        fontRequestCallback.onTypefaceRetrieved(typeface);
    }

    static {
        sTypefaceCache = new LongSparseArray(3);
        sDynamicTypefaceCache = new LruCache(16);
        sLock = new Object();
        NO_OP_REQUEST_CALLBACK = new FontRequestCallback(){

            @Override
            public void onTypefaceRetrieved(Typeface typeface) {
            }

            @Override
            public void onTypefaceRequestFailed(int reason) {
            }
        };
        Typeface.init();
        DEFAULT = Typeface.create((String)null, 0);
        DEFAULT_BOLD = Typeface.create((String)null, 1);
        SANS_SERIF = Typeface.create("sans-serif", 0);
        SERIF = Typeface.create("serif", 0);
        MONOSPACE = Typeface.create("monospace", 0);
        sDefaults = new Typeface[]{DEFAULT, DEFAULT_BOLD, Typeface.create((String)null, 2), Typeface.create((String)null, 3)};
    }

    public static interface FontRequestCallback {
        public static final int FAIL_REASON_PROVIDER_NOT_FOUND = 0;
        public static final int FAIL_REASON_FONT_LOAD_ERROR = 1;
        public static final int FAIL_REASON_FONT_NOT_FOUND = 2;

        public void onTypefaceRetrieved(Typeface var1);

        public void onTypefaceRequestFailed(int var1);

        @Retention(value=RetentionPolicy.SOURCE)
        @IntDef(value={0L, 1L, 2L})
        public static @interface FontRequestFailReason {
        }
    }
}

