/*
 * Decompiled with CFR 0.152.
 */
package android.hardware;

import android.annotation.IntDef;
import android.os.Parcel;
import android.os.Parcelable;
import dalvik.annotation.optimization.FastNative;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import libcore.util.NativeAllocationRegistry;

public final class HardwareBuffer
implements Parcelable {
    public static final int RGBA_8888 = 1;
    public static final int RGBX_8888 = 2;
    public static final int RGB_888 = 3;
    public static final int RGB_565 = 4;
    public static final int RGBA_FP16 = 22;
    public static final int RGBA_1010102 = 43;
    public static final int BLOB = 33;
    private long mNativeObject;
    private Runnable mCleaner;
    public static final long USAGE0_CPU_READ = 2L;
    public static final long USAGE0_CPU_READ_OFTEN = 6L;
    public static final long USAGE0_CPU_WRITE = 32L;
    public static final long USAGE0_CPU_WRITE_OFTEN = 96L;
    public static final long USAGE0_GPU_SAMPLED_IMAGE = 1024L;
    public static final long USAGE0_GPU_COLOR_OUTPUT = 2048L;
    public static final long USAGE0_GPU_STORAGE_IMAGE = 3072L;
    public static final long USAGE0_GPU_CUBEMAP = 8192L;
    public static final long USAGE0_GPU_DATA_BUFFER = 16384L;
    public static final long USAGE0_PROTECTED_CONTENT = 262144L;
    public static final long USAGE0_SENSOR_DIRECT_DATA = 0x20000000L;
    public static final long USAGE0_VIDEO_ENCODE = 0x200000L;
    private static final long NATIVE_HARDWARE_BUFFER_SIZE = 232L;
    public static final Parcelable.Creator<HardwareBuffer> CREATOR = new Parcelable.Creator<HardwareBuffer>(){

        @Override
        public HardwareBuffer createFromParcel(Parcel in) {
            long nativeObject = HardwareBuffer.nReadHardwareBufferFromParcel(in);
            if (nativeObject != 0L) {
                return new HardwareBuffer(nativeObject);
            }
            return null;
        }

        public HardwareBuffer[] newArray(int size) {
            return new HardwareBuffer[size];
        }
    };

    public static HardwareBuffer create(int width, int height, int format, int layers, long usage) {
        if (!HardwareBuffer.isSupportedFormat(format)) {
            throw new IllegalArgumentException("Invalid pixel format " + format);
        }
        if (width <= 0) {
            throw new IllegalArgumentException("Invalid width " + width);
        }
        if (height <= 0) {
            throw new IllegalArgumentException("Invalid height " + height);
        }
        if (layers <= 0) {
            throw new IllegalArgumentException("Invalid layer count " + layers);
        }
        if (format == 33 && height != 1) {
            throw new IllegalArgumentException("Height must be 1 when using the BLOB format");
        }
        long nativeObject = HardwareBuffer.nCreateHardwareBuffer(width, height, format, layers, usage);
        if (nativeObject == 0L) {
            throw new IllegalArgumentException("Unable to create a HardwareBuffer, either the dimensions passed were too large, too many image layers were requested, or an invalid set of usage flags was passed");
        }
        return new HardwareBuffer(nativeObject);
    }

    private HardwareBuffer(long nativeObject) {
        this.mNativeObject = nativeObject;
        ClassLoader loader = HardwareBuffer.class.getClassLoader();
        NativeAllocationRegistry registry = new NativeAllocationRegistry(loader, HardwareBuffer.nGetNativeFinalizer(), 232L);
        this.mCleaner = registry.registerNativeAllocation((Object)this, this.mNativeObject);
    }

    public int getWidth() {
        if (this.mNativeObject == 0L) {
            throw new IllegalStateException("This HardwareBuffer has been destroyed and its width cannot be obtained.");
        }
        return HardwareBuffer.nGetWidth(this.mNativeObject);
    }

    public int getHeight() {
        if (this.mNativeObject == 0L) {
            throw new IllegalStateException("This HardwareBuffer has been destroyed and its height cannot be obtained.");
        }
        return HardwareBuffer.nGetHeight(this.mNativeObject);
    }

    public int getFormat() {
        if (this.mNativeObject == 0L) {
            throw new IllegalStateException("This HardwareBuffer has been destroyed and its format cannot be obtained.");
        }
        return HardwareBuffer.nGetFormat(this.mNativeObject);
    }

    public int getLayers() {
        if (this.mNativeObject == 0L) {
            throw new IllegalStateException("This HardwareBuffer has been destroyed and its layer count cannot be obtained.");
        }
        return HardwareBuffer.nGetLayers(this.mNativeObject);
    }

    public long getUsage() {
        if (this.mNativeObject == 0L) {
            throw new IllegalStateException("This HardwareBuffer has been destroyed and its usage cannot be obtained.");
        }
        return HardwareBuffer.nGetUsage(this.mNativeObject);
    }

    public void destroy() {
        if (this.mNativeObject != 0L) {
            this.mNativeObject = 0L;
            this.mCleaner.run();
            this.mCleaner = null;
        }
    }

    public boolean isDestroyed() {
        return this.mNativeObject == 0L;
    }

    @Override
    public int describeContents() {
        return 1;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        if (this.mNativeObject == 0L) {
            throw new IllegalStateException("This HardwareBuffer has been destroyed and cannot be written to a parcel.");
        }
        HardwareBuffer.nWriteHardwareBufferToParcel(this.mNativeObject, dest);
    }

    private static boolean isSupportedFormat(int format) {
        switch (format) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 22: 
            case 33: 
            case 43: {
                return true;
            }
        }
        return false;
    }

    private static native long nCreateHardwareBuffer(int var0, int var1, int var2, int var3, long var4);

    private static native long nGetNativeFinalizer();

    private static native void nWriteHardwareBufferToParcel(long var0, Parcel var2);

    private static native long nReadHardwareBufferFromParcel(Parcel var0);

    @FastNative
    private static native int nGetWidth(long var0);

    @FastNative
    private static native int nGetHeight(long var0);

    @FastNative
    private static native int nGetFormat(long var0);

    @FastNative
    private static native int nGetLayers(long var0);

    @FastNative
    private static native long nGetUsage(long var0);

    @Retention(value=RetentionPolicy.SOURCE)
    @IntDef(flag=true, value={2L, 6L, 32L, 96L, 1024L, 2048L, 3072L, 8192L, 16384L, 262144L, 0x20000000L, 0x200000L})
    public static @interface Usage0 {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @IntDef(value={1L, 22L, 43L, 2L, 3L, 4L, 33L})
    public static @interface Format {
    }
}

