/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2;

import android.annotation.IntDef;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.TotalCaptureResult;
import android.hardware.camera2.params.InputConfiguration;
import android.hardware.camera2.params.OutputConfiguration;
import android.os.Handler;
import android.view.Surface;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.List;

public abstract class CameraDevice
implements AutoCloseable {
    public static final int TEMPLATE_PREVIEW = 1;
    public static final int TEMPLATE_STILL_CAPTURE = 2;
    public static final int TEMPLATE_RECORD = 3;
    public static final int TEMPLATE_VIDEO_SNAPSHOT = 4;
    public static final int TEMPLATE_ZERO_SHUTTER_LAG = 5;
    public static final int TEMPLATE_MANUAL = 6;

    public abstract String getId();

    public abstract void createCaptureSession(List<Surface> var1, CameraCaptureSession.StateCallback var2, Handler var3) throws CameraAccessException;

    public abstract void createCaptureSessionByOutputConfigurations(List<OutputConfiguration> var1, CameraCaptureSession.StateCallback var2, Handler var3) throws CameraAccessException;

    public abstract void createReprocessableCaptureSession(InputConfiguration var1, List<Surface> var2, CameraCaptureSession.StateCallback var3, Handler var4) throws CameraAccessException;

    public abstract void createReprocessableCaptureSessionByConfigurations(InputConfiguration var1, List<OutputConfiguration> var2, CameraCaptureSession.StateCallback var3, Handler var4) throws CameraAccessException;

    public abstract void createConstrainedHighSpeedCaptureSession(List<Surface> var1, CameraCaptureSession.StateCallback var2, Handler var3) throws CameraAccessException;

    public abstract CaptureRequest.Builder createCaptureRequest(int var1) throws CameraAccessException;

    public abstract CaptureRequest.Builder createReprocessCaptureRequest(TotalCaptureResult var1) throws CameraAccessException;

    @Override
    public abstract void close();

    public static abstract class StateCallback {
        public static final int ERROR_CAMERA_IN_USE = 1;
        public static final int ERROR_MAX_CAMERAS_IN_USE = 2;
        public static final int ERROR_CAMERA_DISABLED = 3;
        public static final int ERROR_CAMERA_DEVICE = 4;
        public static final int ERROR_CAMERA_SERVICE = 5;

        public abstract void onOpened(CameraDevice var1);

        public void onClosed(CameraDevice camera) {
        }

        public abstract void onDisconnected(CameraDevice var1);

        public abstract void onError(CameraDevice var1, int var2);

        @Retention(value=RetentionPolicy.SOURCE)
        @IntDef(value={1L, 2L, 3L, 4L, 5L})
        public static @interface ErrorCode {
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @IntDef(value={1L, 2L, 3L, 4L, 5L, 6L})
    public static @interface RequestTemplate {
    }
}

