/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.radio.V1_0;

import android.os.HwBlob;
import android.os.HwParcel;
import java.util.ArrayList;
import java.util.Objects;

public final class CellIdentityCdma {
    public int networkId;
    public int systemId;
    public int baseStationId;
    public int longitude;
    public int latitude;

    public final boolean equals(CellIdentityCdma other) {
        if (this.networkId != other.networkId) {
            return false;
        }
        if (this.systemId != other.systemId) {
            return false;
        }
        if (this.baseStationId != other.baseStationId) {
            return false;
        }
        if (this.longitude != other.longitude) {
            return false;
        }
        return this.latitude == other.latitude;
    }

    public final int hashCode() {
        return Objects.hash(this.networkId, this.systemId, this.baseStationId, this.longitude, this.latitude);
    }

    public final void readFromParcel(HwParcel parcel) {
        HwBlob blob = parcel.readBuffer();
        this.readEmbeddedFromParcel(parcel, blob, 0L);
    }

    public static final ArrayList<CellIdentityCdma> readVectorFromParcel(HwParcel parcel) {
        ArrayList<CellIdentityCdma> _hidl_vec = new ArrayList<CellIdentityCdma>();
        HwBlob _hidl_blob = parcel.readBuffer();
        HwBlob childBlob = parcel.readEmbeddedBuffer(_hidl_blob.handle(), 0L, true);
        _hidl_vec.clear();
        int _hidl_vec_size = _hidl_blob.getInt32(8L);
        for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            CellIdentityCdma _hidl_vec_element = new CellIdentityCdma();
            _hidl_vec_element.readEmbeddedFromParcel(parcel, childBlob, _hidl_index_0 * 20);
            _hidl_vec.add(_hidl_vec_element);
        }
        return _hidl_vec;
    }

    public final void readEmbeddedFromParcel(HwParcel parcel, HwBlob _hidl_blob, long _hidl_offset) {
        this.networkId = _hidl_blob.getInt32(_hidl_offset + 0L);
        this.systemId = _hidl_blob.getInt32(_hidl_offset + 4L);
        this.baseStationId = _hidl_blob.getInt32(_hidl_offset + 8L);
        this.longitude = _hidl_blob.getInt32(_hidl_offset + 12L);
        this.latitude = _hidl_blob.getInt32(_hidl_offset + 16L);
    }

    public final void writeToParcel(HwParcel parcel) {
        HwBlob _hidl_blob = new HwBlob(20);
        this.writeEmbeddedToBlob(_hidl_blob, 0L);
        parcel.writeBuffer(_hidl_blob);
    }

    public static final void writeVectorToParcel(HwParcel parcel, ArrayList<CellIdentityCdma> _hidl_vec) {
        HwBlob _hidl_blob = new HwBlob(24);
        int _hidl_vec_size = _hidl_vec.size();
        _hidl_blob.putInt32(8L, _hidl_vec_size);
        _hidl_blob.putBool(12L, false);
        HwBlob childBlob = new HwBlob(_hidl_vec_size * 20);
        for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            _hidl_vec.get(_hidl_index_0).writeEmbeddedToBlob(childBlob, _hidl_index_0 * 20);
        }
        _hidl_blob.putBlob(0L, childBlob);
        parcel.writeBuffer(_hidl_blob);
    }

    public final void writeEmbeddedToBlob(HwBlob _hidl_blob, long _hidl_offset) {
        _hidl_blob.putInt32(_hidl_offset + 0L, this.networkId);
        _hidl_blob.putInt32(_hidl_offset + 4L, this.systemId);
        _hidl_blob.putInt32(_hidl_offset + 8L, this.baseStationId);
        _hidl_blob.putInt32(_hidl_offset + 12L, this.longitude);
        _hidl_blob.putInt32(_hidl_offset + 16L, this.latitude);
    }
}

