/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.radio.V1_0;

import android.os.HwBlob;
import android.os.HwParcel;
import java.util.ArrayList;
import java.util.Objects;

public final class CellIdentityWcdma {
    public String mcc = new String();
    public String mnc = new String();
    public int lac;
    public int cid;
    public int psc;
    public int uarfcn;

    public final boolean equals(CellIdentityWcdma other) {
        if (!Objects.deepEquals(this.mcc, other.mcc)) {
            return false;
        }
        if (!Objects.deepEquals(this.mnc, other.mnc)) {
            return false;
        }
        if (this.lac != other.lac) {
            return false;
        }
        if (this.cid != other.cid) {
            return false;
        }
        if (this.psc != other.psc) {
            return false;
        }
        return this.uarfcn == other.uarfcn;
    }

    public final int hashCode() {
        return Objects.hash(this.mcc, this.mnc, this.lac, this.cid, this.psc, this.uarfcn);
    }

    public final void readFromParcel(HwParcel parcel) {
        HwBlob blob = parcel.readBuffer();
        this.readEmbeddedFromParcel(parcel, blob, 0L);
    }

    public static final ArrayList<CellIdentityWcdma> readVectorFromParcel(HwParcel parcel) {
        ArrayList<CellIdentityWcdma> _hidl_vec = new ArrayList<CellIdentityWcdma>();
        HwBlob _hidl_blob = parcel.readBuffer();
        HwBlob childBlob = parcel.readEmbeddedBuffer(_hidl_blob.handle(), 0L, true);
        _hidl_vec.clear();
        int _hidl_vec_size = _hidl_blob.getInt32(8L);
        for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            CellIdentityWcdma _hidl_vec_element = new CellIdentityWcdma();
            _hidl_vec_element.readEmbeddedFromParcel(parcel, childBlob, _hidl_index_0 * 48);
            _hidl_vec.add(_hidl_vec_element);
        }
        return _hidl_vec;
    }

    public final void readEmbeddedFromParcel(HwParcel parcel, HwBlob _hidl_blob, long _hidl_offset) {
        parcel.readEmbeddedBuffer(_hidl_blob.handle(), _hidl_offset + 0L + 0L, false);
        this.mcc = _hidl_blob.getString(_hidl_offset + 0L);
        parcel.readEmbeddedBuffer(_hidl_blob.handle(), _hidl_offset + 16L + 0L, false);
        this.mnc = _hidl_blob.getString(_hidl_offset + 16L);
        this.lac = _hidl_blob.getInt32(_hidl_offset + 32L);
        this.cid = _hidl_blob.getInt32(_hidl_offset + 36L);
        this.psc = _hidl_blob.getInt32(_hidl_offset + 40L);
        this.uarfcn = _hidl_blob.getInt32(_hidl_offset + 44L);
    }

    public final void writeToParcel(HwParcel parcel) {
        HwBlob _hidl_blob = new HwBlob(48);
        this.writeEmbeddedToBlob(_hidl_blob, 0L);
        parcel.writeBuffer(_hidl_blob);
    }

    public static final void writeVectorToParcel(HwParcel parcel, ArrayList<CellIdentityWcdma> _hidl_vec) {
        HwBlob _hidl_blob = new HwBlob(24);
        int _hidl_vec_size = _hidl_vec.size();
        _hidl_blob.putInt32(8L, _hidl_vec_size);
        _hidl_blob.putBool(12L, false);
        HwBlob childBlob = new HwBlob(_hidl_vec_size * 48);
        for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            _hidl_vec.get(_hidl_index_0).writeEmbeddedToBlob(childBlob, _hidl_index_0 * 48);
        }
        _hidl_blob.putBlob(0L, childBlob);
        parcel.writeBuffer(_hidl_blob);
    }

    public final void writeEmbeddedToBlob(HwBlob _hidl_blob, long _hidl_offset) {
        _hidl_blob.putString(_hidl_offset + 0L, this.mcc);
        _hidl_blob.putString(_hidl_offset + 16L, this.mnc);
        _hidl_blob.putInt32(_hidl_offset + 32L, this.lac);
        _hidl_blob.putInt32(_hidl_offset + 36L, this.cid);
        _hidl_blob.putInt32(_hidl_offset + 40L, this.psc);
        _hidl_blob.putInt32(_hidl_offset + 44L, this.uarfcn);
    }
}

