/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.radio.V1_0;

import android.hardware.radio.V1_0.CellIdentityLte;
import android.hardware.radio.V1_0.LteSignalStrength;
import android.os.HwBlob;
import android.os.HwParcel;
import java.util.ArrayList;
import java.util.Objects;

public final class CellInfoLte {
    public final CellIdentityLte cellIdentityLte = new CellIdentityLte();
    public final LteSignalStrength signalStrengthLte = new LteSignalStrength();

    public final boolean equals(CellInfoLte other) {
        if (!Objects.deepEquals(this.cellIdentityLte, other.cellIdentityLte)) {
            return false;
        }
        return Objects.deepEquals(this.signalStrengthLte, other.signalStrengthLte);
    }

    public final int hashCode() {
        return Objects.hash(this.cellIdentityLte, this.signalStrengthLte);
    }

    public final void readFromParcel(HwParcel parcel) {
        HwBlob blob = parcel.readBuffer();
        this.readEmbeddedFromParcel(parcel, blob, 0L);
    }

    public static final ArrayList<CellInfoLte> readVectorFromParcel(HwParcel parcel) {
        ArrayList<CellInfoLte> _hidl_vec = new ArrayList<CellInfoLte>();
        HwBlob _hidl_blob = parcel.readBuffer();
        HwBlob childBlob = parcel.readEmbeddedBuffer(_hidl_blob.handle(), 0L, true);
        _hidl_vec.clear();
        int _hidl_vec_size = _hidl_blob.getInt32(8L);
        for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            CellInfoLte _hidl_vec_element = new CellInfoLte();
            _hidl_vec_element.readEmbeddedFromParcel(parcel, childBlob, _hidl_index_0 * 72);
            _hidl_vec.add(_hidl_vec_element);
        }
        return _hidl_vec;
    }

    public final void readEmbeddedFromParcel(HwParcel parcel, HwBlob _hidl_blob, long _hidl_offset) {
        this.cellIdentityLte.readEmbeddedFromParcel(parcel, _hidl_blob, _hidl_offset + 0L);
        this.signalStrengthLte.readEmbeddedFromParcel(parcel, _hidl_blob, _hidl_offset + 48L);
    }

    public final void writeToParcel(HwParcel parcel) {
        HwBlob _hidl_blob = new HwBlob(72);
        this.writeEmbeddedToBlob(_hidl_blob, 0L);
        parcel.writeBuffer(_hidl_blob);
    }

    public static final void writeVectorToParcel(HwParcel parcel, ArrayList<CellInfoLte> _hidl_vec) {
        HwBlob _hidl_blob = new HwBlob(24);
        int _hidl_vec_size = _hidl_vec.size();
        _hidl_blob.putInt32(8L, _hidl_vec_size);
        _hidl_blob.putBool(12L, false);
        HwBlob childBlob = new HwBlob(_hidl_vec_size * 72);
        for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            _hidl_vec.get(_hidl_index_0).writeEmbeddedToBlob(childBlob, _hidl_index_0 * 72);
        }
        _hidl_blob.putBlob(0L, childBlob);
        parcel.writeBuffer(_hidl_blob);
    }

    public final void writeEmbeddedToBlob(HwBlob _hidl_blob, long _hidl_offset) {
        this.cellIdentityLte.writeEmbeddedToBlob(_hidl_blob, _hidl_offset + 0L);
        this.signalStrengthLte.writeEmbeddedToBlob(_hidl_blob, _hidl_offset + 48L);
    }
}

