/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.radio.V1_0;

import android.hardware.radio.V1_0.ISapCallback;
import android.hidl.base.V1_0.DebugInfo;
import android.hidl.base.V1_0.IBase;
import android.os.HwBinder;
import android.os.HwParcel;
import android.os.IHwBinder;
import android.os.IHwInterface;
import android.os.RemoteException;
import android.os.SystemProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;

public interface ISap
extends IBase {
    public static final String kInterfaceName = "android.hardware.radio@1.0::ISap";

    public static ISap asInterface(IHwBinder binder) {
        if (binder == null) {
            return null;
        }
        IHwInterface iface = binder.queryLocalInterface(kInterfaceName);
        if (iface != null && iface instanceof ISap) {
            return (ISap)iface;
        }
        return new Proxy(binder);
    }

    @Override
    public IHwBinder asBinder();

    public static ISap getService(String serviceName) throws RemoteException {
        return ISap.asInterface(HwBinder.getService(kInterfaceName, serviceName));
    }

    public static ISap getService() throws RemoteException {
        return ISap.asInterface(HwBinder.getService(kInterfaceName, "default"));
    }

    public void setCallback(ISapCallback var1) throws RemoteException;

    public void connectReq(int var1, int var2) throws RemoteException;

    public void disconnectReq(int var1) throws RemoteException;

    public void apduReq(int var1, int var2, ArrayList<Byte> var3) throws RemoteException;

    public void transferAtrReq(int var1) throws RemoteException;

    public void powerReq(int var1, boolean var2) throws RemoteException;

    public void resetSimReq(int var1) throws RemoteException;

    public void transferCardReaderStatusReq(int var1) throws RemoteException;

    public void setTransferProtocolReq(int var1, int var2) throws RemoteException;

    @Override
    public ArrayList<String> interfaceChain() throws RemoteException;

    @Override
    public String interfaceDescriptor() throws RemoteException;

    @Override
    public void setHALInstrumentation() throws RemoteException;

    @Override
    public boolean linkToDeath(IHwBinder.DeathRecipient var1, long var2) throws RemoteException;

    @Override
    public void ping() throws RemoteException;

    @Override
    public DebugInfo getDebugInfo() throws RemoteException;

    @Override
    public void notifySyspropsChanged() throws RemoteException;

    @Override
    public boolean unlinkToDeath(IHwBinder.DeathRecipient var1) throws RemoteException;

    public static abstract class Stub
    extends HwBinder
    implements ISap {
        @Override
        public IHwBinder asBinder() {
            return this;
        }

        @Override
        public final ArrayList<String> interfaceChain() {
            return new ArrayList<String>(Arrays.asList(ISap.kInterfaceName, "android.hidl.base@1.0::IBase"));
        }

        @Override
        public final String interfaceDescriptor() {
            return ISap.kInterfaceName;
        }

        @Override
        public final void setHALInstrumentation() {
        }

        @Override
        public final boolean linkToDeath(IHwBinder.DeathRecipient recipient, long cookie) {
            return true;
        }

        @Override
        public final void ping() {
        }

        @Override
        public final DebugInfo getDebugInfo() {
            DebugInfo info = new DebugInfo();
            info.pid = -1;
            info.ptr = 0L;
            return info;
        }

        @Override
        public final void notifySyspropsChanged() {
            SystemProperties.reportSyspropChanged();
        }

        @Override
        public final boolean unlinkToDeath(IHwBinder.DeathRecipient recipient) {
            return true;
        }

        @Override
        public IHwInterface queryLocalInterface(String descriptor) {
            if (ISap.kInterfaceName.equals(descriptor)) {
                return this;
            }
            return null;
        }

        public void registerAsService(String serviceName) throws RemoteException {
            this.registerService(this.interfaceChain(), serviceName);
        }

        @Override
        public void onTransact(int _hidl_code, HwParcel _hidl_request, HwParcel _hidl_reply, int _hidl_flags) throws RemoteException {
            switch (_hidl_code) {
                case 1: {
                    _hidl_request.enforceInterface(ISap.kInterfaceName);
                    ISapCallback sapCallback = ISapCallback.asInterface(_hidl_request.readStrongBinder());
                    this.setCallback(sapCallback);
                    _hidl_reply.writeStatus(0);
                    _hidl_reply.send();
                    break;
                }
                case 2: {
                    _hidl_request.enforceInterface(ISap.kInterfaceName);
                    int token = _hidl_request.readInt32();
                    int maxMsgSize = _hidl_request.readInt32();
                    this.connectReq(token, maxMsgSize);
                    break;
                }
                case 3: {
                    _hidl_request.enforceInterface(ISap.kInterfaceName);
                    int token = _hidl_request.readInt32();
                    this.disconnectReq(token);
                    break;
                }
                case 4: {
                    _hidl_request.enforceInterface(ISap.kInterfaceName);
                    int token = _hidl_request.readInt32();
                    int type = _hidl_request.readInt32();
                    ArrayList<Byte> command = _hidl_request.readInt8Vector();
                    this.apduReq(token, type, command);
                    break;
                }
                case 5: {
                    _hidl_request.enforceInterface(ISap.kInterfaceName);
                    int token = _hidl_request.readInt32();
                    this.transferAtrReq(token);
                    break;
                }
                case 6: {
                    _hidl_request.enforceInterface(ISap.kInterfaceName);
                    int token = _hidl_request.readInt32();
                    boolean state = _hidl_request.readBool();
                    this.powerReq(token, state);
                    break;
                }
                case 7: {
                    _hidl_request.enforceInterface(ISap.kInterfaceName);
                    int token = _hidl_request.readInt32();
                    this.resetSimReq(token);
                    break;
                }
                case 8: {
                    _hidl_request.enforceInterface(ISap.kInterfaceName);
                    int token = _hidl_request.readInt32();
                    this.transferCardReaderStatusReq(token);
                    break;
                }
                case 9: {
                    _hidl_request.enforceInterface(ISap.kInterfaceName);
                    int token = _hidl_request.readInt32();
                    int transferProtocol = _hidl_request.readInt32();
                    this.setTransferProtocolReq(token, transferProtocol);
                    break;
                }
                case 256067662: {
                    _hidl_request.enforceInterface("android.hidl.base@1.0::IBase");
                    ArrayList<String> _hidl_out_descriptors = this.interfaceChain();
                    _hidl_reply.writeStatus(0);
                    _hidl_reply.writeStringVector(_hidl_out_descriptors);
                    _hidl_reply.send();
                    break;
                }
                case 256131655: {
                    _hidl_request.enforceInterface("android.hidl.base@1.0::IBase");
                    _hidl_reply.writeStatus(0);
                    _hidl_reply.send();
                    break;
                }
                case 256136003: {
                    _hidl_request.enforceInterface("android.hidl.base@1.0::IBase");
                    String _hidl_out_descriptor = this.interfaceDescriptor();
                    _hidl_reply.writeStatus(0);
                    _hidl_reply.writeString(_hidl_out_descriptor);
                    _hidl_reply.send();
                    break;
                }
                case 256462420: {
                    _hidl_request.enforceInterface("android.hidl.base@1.0::IBase");
                    this.setHALInstrumentation();
                    break;
                }
                case 256660548: {
                    break;
                }
                case 256921159: {
                    break;
                }
                case 257049926: {
                    _hidl_request.enforceInterface("android.hidl.base@1.0::IBase");
                    DebugInfo _hidl_out_info = this.getDebugInfo();
                    _hidl_reply.writeStatus(0);
                    _hidl_out_info.writeToParcel(_hidl_reply);
                    _hidl_reply.send();
                    break;
                }
                case 257120595: {
                    _hidl_request.enforceInterface("android.hidl.base@1.0::IBase");
                    this.notifySyspropsChanged();
                    break;
                }
            }
        }
    }

    public static final class Proxy
    implements ISap {
        private IHwBinder mRemote;

        public Proxy(IHwBinder remote) {
            this.mRemote = Objects.requireNonNull(remote);
        }

        @Override
        public IHwBinder asBinder() {
            return this.mRemote;
        }

        @Override
        public void setCallback(ISapCallback sapCallback) throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken(ISap.kInterfaceName);
            _hidl_request.writeStrongBinder(sapCallback == null ? null : sapCallback.asBinder());
            HwParcel _hidl_reply = new HwParcel();
            this.mRemote.transact(1, _hidl_request, _hidl_reply, 0);
            _hidl_reply.verifySuccess();
            _hidl_request.releaseTemporaryStorage();
        }

        @Override
        public void connectReq(int token, int maxMsgSize) throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken(ISap.kInterfaceName);
            _hidl_request.writeInt32(token);
            _hidl_request.writeInt32(maxMsgSize);
            HwParcel _hidl_reply = new HwParcel();
            this.mRemote.transact(2, _hidl_request, _hidl_reply, 1);
            _hidl_request.releaseTemporaryStorage();
        }

        @Override
        public void disconnectReq(int token) throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken(ISap.kInterfaceName);
            _hidl_request.writeInt32(token);
            HwParcel _hidl_reply = new HwParcel();
            this.mRemote.transact(3, _hidl_request, _hidl_reply, 1);
            _hidl_request.releaseTemporaryStorage();
        }

        @Override
        public void apduReq(int token, int type, ArrayList<Byte> command) throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken(ISap.kInterfaceName);
            _hidl_request.writeInt32(token);
            _hidl_request.writeInt32(type);
            _hidl_request.writeInt8Vector(command);
            HwParcel _hidl_reply = new HwParcel();
            this.mRemote.transact(4, _hidl_request, _hidl_reply, 1);
            _hidl_request.releaseTemporaryStorage();
        }

        @Override
        public void transferAtrReq(int token) throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken(ISap.kInterfaceName);
            _hidl_request.writeInt32(token);
            HwParcel _hidl_reply = new HwParcel();
            this.mRemote.transact(5, _hidl_request, _hidl_reply, 1);
            _hidl_request.releaseTemporaryStorage();
        }

        @Override
        public void powerReq(int token, boolean state) throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken(ISap.kInterfaceName);
            _hidl_request.writeInt32(token);
            _hidl_request.writeBool(state);
            HwParcel _hidl_reply = new HwParcel();
            this.mRemote.transact(6, _hidl_request, _hidl_reply, 1);
            _hidl_request.releaseTemporaryStorage();
        }

        @Override
        public void resetSimReq(int token) throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken(ISap.kInterfaceName);
            _hidl_request.writeInt32(token);
            HwParcel _hidl_reply = new HwParcel();
            this.mRemote.transact(7, _hidl_request, _hidl_reply, 1);
            _hidl_request.releaseTemporaryStorage();
        }

        @Override
        public void transferCardReaderStatusReq(int token) throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken(ISap.kInterfaceName);
            _hidl_request.writeInt32(token);
            HwParcel _hidl_reply = new HwParcel();
            this.mRemote.transact(8, _hidl_request, _hidl_reply, 1);
            _hidl_request.releaseTemporaryStorage();
        }

        @Override
        public void setTransferProtocolReq(int token, int transferProtocol) throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken(ISap.kInterfaceName);
            _hidl_request.writeInt32(token);
            _hidl_request.writeInt32(transferProtocol);
            HwParcel _hidl_reply = new HwParcel();
            this.mRemote.transact(9, _hidl_request, _hidl_reply, 1);
            _hidl_request.releaseTemporaryStorage();
        }

        @Override
        public ArrayList<String> interfaceChain() throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken("android.hidl.base@1.0::IBase");
            HwParcel _hidl_reply = new HwParcel();
            this.mRemote.transact(256067662, _hidl_request, _hidl_reply, 0);
            _hidl_reply.verifySuccess();
            _hidl_request.releaseTemporaryStorage();
            ArrayList<String> _hidl_out_descriptors = _hidl_reply.readStringVector();
            return _hidl_out_descriptors;
        }

        @Override
        public String interfaceDescriptor() throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken("android.hidl.base@1.0::IBase");
            HwParcel _hidl_reply = new HwParcel();
            this.mRemote.transact(256136003, _hidl_request, _hidl_reply, 0);
            _hidl_reply.verifySuccess();
            _hidl_request.releaseTemporaryStorage();
            String _hidl_out_descriptor = _hidl_reply.readString();
            return _hidl_out_descriptor;
        }

        @Override
        public void setHALInstrumentation() throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken("android.hidl.base@1.0::IBase");
            HwParcel _hidl_reply = new HwParcel();
            this.mRemote.transact(256462420, _hidl_request, _hidl_reply, 1);
            _hidl_request.releaseTemporaryStorage();
        }

        @Override
        public boolean linkToDeath(IHwBinder.DeathRecipient recipient, long cookie) throws RemoteException {
            return this.mRemote.linkToDeath(recipient, cookie);
        }

        @Override
        public void ping() throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken("android.hidl.base@1.0::IBase");
            HwParcel _hidl_reply = new HwParcel();
            this.mRemote.transact(256921159, _hidl_request, _hidl_reply, 0);
            _hidl_reply.verifySuccess();
            _hidl_request.releaseTemporaryStorage();
        }

        @Override
        public DebugInfo getDebugInfo() throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken("android.hidl.base@1.0::IBase");
            HwParcel _hidl_reply = new HwParcel();
            this.mRemote.transact(257049926, _hidl_request, _hidl_reply, 0);
            _hidl_reply.verifySuccess();
            _hidl_request.releaseTemporaryStorage();
            DebugInfo _hidl_out_info = new DebugInfo();
            _hidl_out_info.readFromParcel(_hidl_reply);
            return _hidl_out_info;
        }

        @Override
        public void notifySyspropsChanged() throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken("android.hidl.base@1.0::IBase");
            HwParcel _hidl_reply = new HwParcel();
            this.mRemote.transact(257120595, _hidl_request, _hidl_reply, 1);
            _hidl_request.releaseTemporaryStorage();
        }

        @Override
        public boolean unlinkToDeath(IHwBinder.DeathRecipient recipient) throws RemoteException {
            return this.mRemote.unlinkToDeath(recipient);
        }
    }
}

