/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.radio.V1_0;

import android.os.HwBlob;
import android.os.HwParcel;
import java.util.ArrayList;
import java.util.Objects;

public final class LceDataInfo {
    public int lastHopCapacityKbps;
    public byte confidenceLevel;
    public boolean lceSuspended;

    public final boolean equals(LceDataInfo other) {
        if (this.lastHopCapacityKbps != other.lastHopCapacityKbps) {
            return false;
        }
        if (this.confidenceLevel != other.confidenceLevel) {
            return false;
        }
        return this.lceSuspended == other.lceSuspended;
    }

    public final int hashCode() {
        return Objects.hash(this.lastHopCapacityKbps, this.confidenceLevel, this.lceSuspended);
    }

    public final void readFromParcel(HwParcel parcel) {
        HwBlob blob = parcel.readBuffer();
        this.readEmbeddedFromParcel(parcel, blob, 0L);
    }

    public static final ArrayList<LceDataInfo> readVectorFromParcel(HwParcel parcel) {
        ArrayList<LceDataInfo> _hidl_vec = new ArrayList<LceDataInfo>();
        HwBlob _hidl_blob = parcel.readBuffer();
        HwBlob childBlob = parcel.readEmbeddedBuffer(_hidl_blob.handle(), 0L, true);
        _hidl_vec.clear();
        int _hidl_vec_size = _hidl_blob.getInt32(8L);
        for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            LceDataInfo _hidl_vec_element = new LceDataInfo();
            _hidl_vec_element.readEmbeddedFromParcel(parcel, childBlob, _hidl_index_0 * 8);
            _hidl_vec.add(_hidl_vec_element);
        }
        return _hidl_vec;
    }

    public final void readEmbeddedFromParcel(HwParcel parcel, HwBlob _hidl_blob, long _hidl_offset) {
        this.lastHopCapacityKbps = _hidl_blob.getInt32(_hidl_offset + 0L);
        this.confidenceLevel = _hidl_blob.getInt8(_hidl_offset + 4L);
        this.lceSuspended = _hidl_blob.getBool(_hidl_offset + 5L);
    }

    public final void writeToParcel(HwParcel parcel) {
        HwBlob _hidl_blob = new HwBlob(8);
        this.writeEmbeddedToBlob(_hidl_blob, 0L);
        parcel.writeBuffer(_hidl_blob);
    }

    public static final void writeVectorToParcel(HwParcel parcel, ArrayList<LceDataInfo> _hidl_vec) {
        HwBlob _hidl_blob = new HwBlob(24);
        int _hidl_vec_size = _hidl_vec.size();
        _hidl_blob.putInt32(8L, _hidl_vec_size);
        _hidl_blob.putBool(12L, false);
        HwBlob childBlob = new HwBlob(_hidl_vec_size * 8);
        for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            _hidl_vec.get(_hidl_index_0).writeEmbeddedToBlob(childBlob, _hidl_index_0 * 8);
        }
        _hidl_blob.putBlob(0L, childBlob);
        parcel.writeBuffer(_hidl_blob);
    }

    public final void writeEmbeddedToBlob(HwBlob _hidl_blob, long _hidl_offset) {
        _hidl_blob.putInt32(_hidl_offset + 0L, this.lastHopCapacityKbps);
        _hidl_blob.putInt8(_hidl_offset + 4L, this.confidenceLevel);
        _hidl_blob.putBool(_hidl_offset + 5L, this.lceSuspended);
    }
}

