/*
 * Decompiled with CFR 0.152.
 */
package android.hidl.base.V1_0;

import android.os.HwBlob;
import android.os.HwParcel;
import java.util.ArrayList;
import java.util.Objects;

public final class DebugInfo {
    public int pid;
    public long ptr;

    public final boolean equals(DebugInfo other) {
        if (this.pid != other.pid) {
            return false;
        }
        return this.ptr == other.ptr;
    }

    public final int hashCode() {
        return Objects.hash(this.pid, this.ptr);
    }

    public final void readFromParcel(HwParcel parcel) {
        HwBlob blob = parcel.readBuffer();
        this.readEmbeddedFromParcel(parcel, blob, 0L);
    }

    public static final ArrayList<DebugInfo> readVectorFromParcel(HwParcel parcel) {
        ArrayList<DebugInfo> _hidl_vec = new ArrayList<DebugInfo>();
        HwBlob _hidl_blob = parcel.readBuffer();
        HwBlob childBlob = parcel.readEmbeddedBuffer(_hidl_blob.handle(), 0L, true);
        _hidl_vec.clear();
        int _hidl_vec_size = _hidl_blob.getInt32(8L);
        for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            DebugInfo _hidl_vec_element = new DebugInfo();
            _hidl_vec_element.readEmbeddedFromParcel(parcel, childBlob, _hidl_index_0 * 16);
            _hidl_vec.add(_hidl_vec_element);
        }
        return _hidl_vec;
    }

    public final void readEmbeddedFromParcel(HwParcel parcel, HwBlob _hidl_blob, long _hidl_offset) {
        this.pid = _hidl_blob.getInt32(_hidl_offset + 0L);
        this.ptr = _hidl_blob.getInt64(_hidl_offset + 8L);
    }

    public final void writeToParcel(HwParcel parcel) {
        HwBlob _hidl_blob = new HwBlob(16);
        this.writeEmbeddedToBlob(_hidl_blob, 0L);
        parcel.writeBuffer(_hidl_blob);
    }

    public static final void writeVectorToParcel(HwParcel parcel, ArrayList<DebugInfo> _hidl_vec) {
        HwBlob _hidl_blob = new HwBlob(24);
        int _hidl_vec_size = _hidl_vec.size();
        _hidl_blob.putInt32(8L, _hidl_vec_size);
        _hidl_blob.putBool(12L, false);
        HwBlob childBlob = new HwBlob(_hidl_vec_size * 16);
        for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            _hidl_vec.get(_hidl_index_0).writeEmbeddedToBlob(childBlob, _hidl_index_0 * 16);
        }
        _hidl_blob.putBlob(0L, childBlob);
        parcel.writeBuffer(_hidl_blob);
    }

    public final void writeEmbeddedToBlob(HwBlob _hidl_blob, long _hidl_offset) {
        _hidl_blob.putInt32(_hidl_offset + 0L, this.pid);
        _hidl_blob.putInt64(_hidl_offset + 8L, this.ptr);
    }
}

