/*
 * Decompiled with CFR 0.152.
 */
package android.hidl.manager.V1_0;

import android.hidl.base.V1_0.DebugInfo;
import android.hidl.base.V1_0.IBase;
import android.hidl.manager.V1_0.IServiceNotification;
import android.os.HwBinder;
import android.os.HwBlob;
import android.os.HwParcel;
import android.os.IHwBinder;
import android.os.IHwInterface;
import android.os.RemoteException;
import android.os.SystemProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;

public interface IServiceManager
extends IBase {
    public static final String kInterfaceName = "android.hidl.manager@1.0::IServiceManager";

    public static IServiceManager asInterface(IHwBinder binder) {
        if (binder == null) {
            return null;
        }
        IHwInterface iface = binder.queryLocalInterface(kInterfaceName);
        if (iface != null && iface instanceof IServiceManager) {
            return (IServiceManager)iface;
        }
        return new Proxy(binder);
    }

    @Override
    public IHwBinder asBinder();

    public static IServiceManager getService(String serviceName) throws RemoteException {
        return IServiceManager.asInterface(HwBinder.getService(kInterfaceName, serviceName));
    }

    public static IServiceManager getService() throws RemoteException {
        return IServiceManager.asInterface(HwBinder.getService(kInterfaceName, "default"));
    }

    public IBase get(String var1, String var2) throws RemoteException;

    public boolean add(ArrayList<String> var1, String var2, IBase var3) throws RemoteException;

    public ArrayList<String> list() throws RemoteException;

    public ArrayList<String> listByInterface(String var1) throws RemoteException;

    public boolean registerForNotifications(String var1, String var2, IServiceNotification var3) throws RemoteException;

    public ArrayList<InstanceDebugInfo> debugDump() throws RemoteException;

    public void registerPassthroughClient(String var1, String var2, int var3) throws RemoteException;

    @Override
    public ArrayList<String> interfaceChain() throws RemoteException;

    @Override
    public String interfaceDescriptor() throws RemoteException;

    @Override
    public void setHALInstrumentation() throws RemoteException;

    @Override
    public boolean linkToDeath(IHwBinder.DeathRecipient var1, long var2) throws RemoteException;

    @Override
    public void ping() throws RemoteException;

    @Override
    public DebugInfo getDebugInfo() throws RemoteException;

    @Override
    public void notifySyspropsChanged() throws RemoteException;

    @Override
    public boolean unlinkToDeath(IHwBinder.DeathRecipient var1) throws RemoteException;

    public static abstract class Stub
    extends HwBinder
    implements IServiceManager {
        @Override
        public IHwBinder asBinder() {
            return this;
        }

        @Override
        public final ArrayList<String> interfaceChain() {
            return new ArrayList<String>(Arrays.asList(IServiceManager.kInterfaceName, "android.hidl.base@1.0::IBase"));
        }

        @Override
        public final String interfaceDescriptor() {
            return IServiceManager.kInterfaceName;
        }

        @Override
        public final void setHALInstrumentation() {
        }

        @Override
        public final boolean linkToDeath(IHwBinder.DeathRecipient recipient, long cookie) {
            return true;
        }

        @Override
        public final void ping() {
        }

        @Override
        public final DebugInfo getDebugInfo() {
            DebugInfo info = new DebugInfo();
            info.pid = -1;
            info.ptr = 0L;
            return info;
        }

        @Override
        public final void notifySyspropsChanged() {
            SystemProperties.reportSyspropChanged();
        }

        @Override
        public final boolean unlinkToDeath(IHwBinder.DeathRecipient recipient) {
            return true;
        }

        @Override
        public IHwInterface queryLocalInterface(String descriptor) {
            if (IServiceManager.kInterfaceName.equals(descriptor)) {
                return this;
            }
            return null;
        }

        public void registerAsService(String serviceName) throws RemoteException {
            this.registerService(this.interfaceChain(), serviceName);
        }

        @Override
        public void onTransact(int _hidl_code, HwParcel _hidl_request, HwParcel _hidl_reply, int _hidl_flags) throws RemoteException {
            switch (_hidl_code) {
                case 1: {
                    _hidl_request.enforceInterface(IServiceManager.kInterfaceName);
                    String fqName = _hidl_request.readString();
                    String name = _hidl_request.readString();
                    IBase _hidl_out_service = this.get(fqName, name);
                    _hidl_reply.writeStatus(0);
                    _hidl_reply.writeStrongBinder(_hidl_out_service == null ? null : _hidl_out_service.asBinder());
                    _hidl_reply.send();
                    break;
                }
                case 2: {
                    _hidl_request.enforceInterface(IServiceManager.kInterfaceName);
                    ArrayList<String> interfaceChain = _hidl_request.readStringVector();
                    String name = _hidl_request.readString();
                    IBase service = IBase.asInterface(_hidl_request.readStrongBinder());
                    boolean _hidl_out_success = this.add(interfaceChain, name, service);
                    _hidl_reply.writeStatus(0);
                    _hidl_reply.writeBool(_hidl_out_success);
                    _hidl_reply.send();
                    break;
                }
                case 3: {
                    _hidl_request.enforceInterface(IServiceManager.kInterfaceName);
                    ArrayList<String> _hidl_out_fqInstanceNames = this.list();
                    _hidl_reply.writeStatus(0);
                    _hidl_reply.writeStringVector(_hidl_out_fqInstanceNames);
                    _hidl_reply.send();
                    break;
                }
                case 4: {
                    _hidl_request.enforceInterface(IServiceManager.kInterfaceName);
                    String fqName = _hidl_request.readString();
                    ArrayList<String> _hidl_out_instanceNames = this.listByInterface(fqName);
                    _hidl_reply.writeStatus(0);
                    _hidl_reply.writeStringVector(_hidl_out_instanceNames);
                    _hidl_reply.send();
                    break;
                }
                case 5: {
                    _hidl_request.enforceInterface(IServiceManager.kInterfaceName);
                    String fqName = _hidl_request.readString();
                    String name = _hidl_request.readString();
                    IServiceNotification callback = IServiceNotification.asInterface(_hidl_request.readStrongBinder());
                    boolean _hidl_out_success = this.registerForNotifications(fqName, name, callback);
                    _hidl_reply.writeStatus(0);
                    _hidl_reply.writeBool(_hidl_out_success);
                    _hidl_reply.send();
                    break;
                }
                case 6: {
                    _hidl_request.enforceInterface(IServiceManager.kInterfaceName);
                    ArrayList<InstanceDebugInfo> _hidl_out_info = this.debugDump();
                    _hidl_reply.writeStatus(0);
                    InstanceDebugInfo.writeVectorToParcel(_hidl_reply, _hidl_out_info);
                    _hidl_reply.send();
                    break;
                }
                case 7: {
                    _hidl_request.enforceInterface(IServiceManager.kInterfaceName);
                    String fqName = _hidl_request.readString();
                    String name = _hidl_request.readString();
                    int pid = _hidl_request.readInt32();
                    this.registerPassthroughClient(fqName, name, pid);
                    break;
                }
                case 256067662: {
                    _hidl_request.enforceInterface("android.hidl.base@1.0::IBase");
                    ArrayList<String> _hidl_out_descriptors = this.interfaceChain();
                    _hidl_reply.writeStatus(0);
                    _hidl_reply.writeStringVector(_hidl_out_descriptors);
                    _hidl_reply.send();
                    break;
                }
                case 256131655: {
                    _hidl_request.enforceInterface("android.hidl.base@1.0::IBase");
                    _hidl_reply.writeStatus(0);
                    _hidl_reply.send();
                    break;
                }
                case 256136003: {
                    _hidl_request.enforceInterface("android.hidl.base@1.0::IBase");
                    String _hidl_out_descriptor = this.interfaceDescriptor();
                    _hidl_reply.writeStatus(0);
                    _hidl_reply.writeString(_hidl_out_descriptor);
                    _hidl_reply.send();
                    break;
                }
                case 256462420: {
                    _hidl_request.enforceInterface("android.hidl.base@1.0::IBase");
                    this.setHALInstrumentation();
                    break;
                }
                case 256660548: {
                    break;
                }
                case 256921159: {
                    break;
                }
                case 257049926: {
                    _hidl_request.enforceInterface("android.hidl.base@1.0::IBase");
                    DebugInfo _hidl_out_info = this.getDebugInfo();
                    _hidl_reply.writeStatus(0);
                    _hidl_out_info.writeToParcel(_hidl_reply);
                    _hidl_reply.send();
                    break;
                }
                case 257120595: {
                    _hidl_request.enforceInterface("android.hidl.base@1.0::IBase");
                    this.notifySyspropsChanged();
                    break;
                }
            }
        }
    }

    public static final class Proxy
    implements IServiceManager {
        private IHwBinder mRemote;

        public Proxy(IHwBinder remote) {
            this.mRemote = Objects.requireNonNull(remote);
        }

        @Override
        public IHwBinder asBinder() {
            return this.mRemote;
        }

        @Override
        public IBase get(String fqName, String name) throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken(IServiceManager.kInterfaceName);
            _hidl_request.writeString(fqName);
            _hidl_request.writeString(name);
            HwParcel _hidl_reply = new HwParcel();
            this.mRemote.transact(1, _hidl_request, _hidl_reply, 0);
            _hidl_reply.verifySuccess();
            _hidl_request.releaseTemporaryStorage();
            IBase _hidl_out_service = IBase.asInterface(_hidl_reply.readStrongBinder());
            return _hidl_out_service;
        }

        @Override
        public boolean add(ArrayList<String> interfaceChain, String name, IBase service) throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken(IServiceManager.kInterfaceName);
            _hidl_request.writeStringVector(interfaceChain);
            _hidl_request.writeString(name);
            _hidl_request.writeStrongBinder(service == null ? null : service.asBinder());
            HwParcel _hidl_reply = new HwParcel();
            this.mRemote.transact(2, _hidl_request, _hidl_reply, 0);
            _hidl_reply.verifySuccess();
            _hidl_request.releaseTemporaryStorage();
            boolean _hidl_out_success = _hidl_reply.readBool();
            return _hidl_out_success;
        }

        @Override
        public ArrayList<String> list() throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken(IServiceManager.kInterfaceName);
            HwParcel _hidl_reply = new HwParcel();
            this.mRemote.transact(3, _hidl_request, _hidl_reply, 0);
            _hidl_reply.verifySuccess();
            _hidl_request.releaseTemporaryStorage();
            ArrayList<String> _hidl_out_fqInstanceNames = _hidl_reply.readStringVector();
            return _hidl_out_fqInstanceNames;
        }

        @Override
        public ArrayList<String> listByInterface(String fqName) throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken(IServiceManager.kInterfaceName);
            _hidl_request.writeString(fqName);
            HwParcel _hidl_reply = new HwParcel();
            this.mRemote.transact(4, _hidl_request, _hidl_reply, 0);
            _hidl_reply.verifySuccess();
            _hidl_request.releaseTemporaryStorage();
            ArrayList<String> _hidl_out_instanceNames = _hidl_reply.readStringVector();
            return _hidl_out_instanceNames;
        }

        @Override
        public boolean registerForNotifications(String fqName, String name, IServiceNotification callback) throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken(IServiceManager.kInterfaceName);
            _hidl_request.writeString(fqName);
            _hidl_request.writeString(name);
            _hidl_request.writeStrongBinder(callback == null ? null : callback.asBinder());
            HwParcel _hidl_reply = new HwParcel();
            this.mRemote.transact(5, _hidl_request, _hidl_reply, 0);
            _hidl_reply.verifySuccess();
            _hidl_request.releaseTemporaryStorage();
            boolean _hidl_out_success = _hidl_reply.readBool();
            return _hidl_out_success;
        }

        @Override
        public ArrayList<InstanceDebugInfo> debugDump() throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken(IServiceManager.kInterfaceName);
            HwParcel _hidl_reply = new HwParcel();
            this.mRemote.transact(6, _hidl_request, _hidl_reply, 0);
            _hidl_reply.verifySuccess();
            _hidl_request.releaseTemporaryStorage();
            ArrayList<InstanceDebugInfo> _hidl_out_info = InstanceDebugInfo.readVectorFromParcel(_hidl_reply);
            return _hidl_out_info;
        }

        @Override
        public void registerPassthroughClient(String fqName, String name, int pid) throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken(IServiceManager.kInterfaceName);
            _hidl_request.writeString(fqName);
            _hidl_request.writeString(name);
            _hidl_request.writeInt32(pid);
            HwParcel _hidl_reply = new HwParcel();
            this.mRemote.transact(7, _hidl_request, _hidl_reply, 1);
            _hidl_request.releaseTemporaryStorage();
        }

        @Override
        public ArrayList<String> interfaceChain() throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken("android.hidl.base@1.0::IBase");
            HwParcel _hidl_reply = new HwParcel();
            this.mRemote.transact(256067662, _hidl_request, _hidl_reply, 0);
            _hidl_reply.verifySuccess();
            _hidl_request.releaseTemporaryStorage();
            ArrayList<String> _hidl_out_descriptors = _hidl_reply.readStringVector();
            return _hidl_out_descriptors;
        }

        @Override
        public String interfaceDescriptor() throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken("android.hidl.base@1.0::IBase");
            HwParcel _hidl_reply = new HwParcel();
            this.mRemote.transact(256136003, _hidl_request, _hidl_reply, 0);
            _hidl_reply.verifySuccess();
            _hidl_request.releaseTemporaryStorage();
            String _hidl_out_descriptor = _hidl_reply.readString();
            return _hidl_out_descriptor;
        }

        @Override
        public void setHALInstrumentation() throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken("android.hidl.base@1.0::IBase");
            HwParcel _hidl_reply = new HwParcel();
            this.mRemote.transact(256462420, _hidl_request, _hidl_reply, 1);
            _hidl_request.releaseTemporaryStorage();
        }

        @Override
        public boolean linkToDeath(IHwBinder.DeathRecipient recipient, long cookie) throws RemoteException {
            return this.mRemote.linkToDeath(recipient, cookie);
        }

        @Override
        public void ping() throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken("android.hidl.base@1.0::IBase");
            HwParcel _hidl_reply = new HwParcel();
            this.mRemote.transact(256921159, _hidl_request, _hidl_reply, 0);
            _hidl_reply.verifySuccess();
            _hidl_request.releaseTemporaryStorage();
        }

        @Override
        public DebugInfo getDebugInfo() throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken("android.hidl.base@1.0::IBase");
            HwParcel _hidl_reply = new HwParcel();
            this.mRemote.transact(257049926, _hidl_request, _hidl_reply, 0);
            _hidl_reply.verifySuccess();
            _hidl_request.releaseTemporaryStorage();
            DebugInfo _hidl_out_info = new DebugInfo();
            _hidl_out_info.readFromParcel(_hidl_reply);
            return _hidl_out_info;
        }

        @Override
        public void notifySyspropsChanged() throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken("android.hidl.base@1.0::IBase");
            HwParcel _hidl_reply = new HwParcel();
            this.mRemote.transact(257120595, _hidl_request, _hidl_reply, 1);
            _hidl_request.releaseTemporaryStorage();
        }

        @Override
        public boolean unlinkToDeath(IHwBinder.DeathRecipient recipient) throws RemoteException {
            return this.mRemote.unlinkToDeath(recipient);
        }
    }

    public static final class InstanceDebugInfo {
        public String interfaceName = new String();
        public String instanceName = new String();
        public final ArrayList<Integer> clientPids = new ArrayList();

        public final boolean equals(InstanceDebugInfo other) {
            if (!Objects.deepEquals(this.interfaceName, other.interfaceName)) {
                return false;
            }
            if (!Objects.deepEquals(this.instanceName, other.instanceName)) {
                return false;
            }
            return Objects.deepEquals(this.clientPids, other.clientPids);
        }

        public final int hashCode() {
            return Objects.hash(this.interfaceName, this.instanceName, this.clientPids);
        }

        public final void readFromParcel(HwParcel parcel) {
            HwBlob blob = parcel.readBuffer();
            this.readEmbeddedFromParcel(parcel, blob, 0L);
        }

        public static final ArrayList<InstanceDebugInfo> readVectorFromParcel(HwParcel parcel) {
            ArrayList<InstanceDebugInfo> _hidl_vec = new ArrayList<InstanceDebugInfo>();
            HwBlob _hidl_blob = parcel.readBuffer();
            HwBlob childBlob = parcel.readEmbeddedBuffer(_hidl_blob.handle(), 0L, true);
            _hidl_vec.clear();
            int _hidl_vec_size = _hidl_blob.getInt32(8L);
            for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
                InstanceDebugInfo _hidl_vec_element = new InstanceDebugInfo();
                _hidl_vec_element.readEmbeddedFromParcel(parcel, childBlob, _hidl_index_0 * 48);
                _hidl_vec.add(_hidl_vec_element);
            }
            return _hidl_vec;
        }

        public final void readEmbeddedFromParcel(HwParcel parcel, HwBlob _hidl_blob, long _hidl_offset) {
            parcel.readEmbeddedBuffer(_hidl_blob.handle(), _hidl_offset + 0L + 0L, false);
            this.interfaceName = _hidl_blob.getString(_hidl_offset + 0L);
            parcel.readEmbeddedBuffer(_hidl_blob.handle(), _hidl_offset + 16L + 0L, false);
            this.instanceName = _hidl_blob.getString(_hidl_offset + 16L);
            HwBlob childBlob = parcel.readEmbeddedBuffer(_hidl_blob.handle(), _hidl_offset + 32L + 0L, true);
            this.clientPids.clear();
            int _hidl_vec_size = _hidl_blob.getInt32(_hidl_offset + 32L + 8L);
            for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
                int _hidl_vec_element = childBlob.getInt32(_hidl_index_0 * 4);
                this.clientPids.add(_hidl_vec_element);
            }
        }

        public final void writeToParcel(HwParcel parcel) {
            HwBlob _hidl_blob = new HwBlob(48);
            this.writeEmbeddedToBlob(_hidl_blob, 0L);
            parcel.writeBuffer(_hidl_blob);
        }

        public static final void writeVectorToParcel(HwParcel parcel, ArrayList<InstanceDebugInfo> _hidl_vec) {
            HwBlob _hidl_blob = new HwBlob(24);
            int _hidl_vec_size = _hidl_vec.size();
            _hidl_blob.putInt32(8L, _hidl_vec_size);
            _hidl_blob.putBool(12L, false);
            HwBlob childBlob = new HwBlob(_hidl_vec_size * 48);
            for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
                _hidl_vec.get(_hidl_index_0).writeEmbeddedToBlob(childBlob, _hidl_index_0 * 48);
            }
            _hidl_blob.putBlob(0L, childBlob);
            parcel.writeBuffer(_hidl_blob);
        }

        public final void writeEmbeddedToBlob(HwBlob _hidl_blob, long _hidl_offset) {
            _hidl_blob.putString(_hidl_offset + 0L, this.interfaceName);
            _hidl_blob.putString(_hidl_offset + 16L, this.instanceName);
            int _hidl_vec_size = this.clientPids.size();
            _hidl_blob.putInt32(_hidl_offset + 32L + 8L, _hidl_vec_size);
            _hidl_blob.putBool(_hidl_offset + 32L + 12L, false);
            HwBlob childBlob = new HwBlob(_hidl_vec_size * 4);
            for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
                childBlob.putInt32(_hidl_index_0 * 4, this.clientPids.get(_hidl_index_0));
            }
            _hidl_blob.putBlob(_hidl_offset + 32L + 0L, childBlob);
        }
    }
}

