/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.annotation.IntDef;
import android.content.ContentResolver;
import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.media.DrmInitData;
import android.media.MediaCodec;
import android.media.MediaDataSource;
import android.media.MediaFormat;
import android.media.MediaHTTPService;
import android.net.Uri;
import android.os.Bundle;
import android.os.IBinder;
import com.android.internal.util.Preconditions;
import java.io.FileDescriptor;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public final class MediaExtractor {
    public static final int SEEK_TO_PREVIOUS_SYNC = 0;
    public static final int SEEK_TO_NEXT_SYNC = 1;
    public static final int SEEK_TO_CLOSEST_SYNC = 2;
    public static final int SAMPLE_FLAG_SYNC = 1;
    public static final int SAMPLE_FLAG_ENCRYPTED = 2;
    private long mNativeContext;

    public MediaExtractor() {
        this.native_setup();
    }

    public final native void setDataSource(MediaDataSource var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setDataSource(Context context, Uri uri, Map<String, String> headers) throws IOException {
        String scheme = uri.getScheme();
        if (scheme == null || scheme.equals("file")) {
            this.setDataSource(uri.getPath());
            return;
        }
        try (AssetFileDescriptor fd = null;){
            ContentResolver resolver = context.getContentResolver();
            fd = resolver.openAssetFileDescriptor(uri, "r");
            if (fd == null) {
                return;
            }
            if (fd.getDeclaredLength() < 0L) {
                this.setDataSource(fd.getFileDescriptor());
            } else {
                this.setDataSource(fd.getFileDescriptor(), fd.getStartOffset(), fd.getDeclaredLength());
            }
            return;
        }
        this.setDataSource(uri.toString(), headers);
    }

    public final void setDataSource(String path, Map<String, String> headers) throws IOException {
        String[] keys = null;
        String[] values = null;
        if (headers != null) {
            keys = new String[headers.size()];
            values = new String[headers.size()];
            int i = 0;
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                keys[i] = entry.getKey();
                values[i] = entry.getValue();
                ++i;
            }
        }
        this.nativeSetDataSource(MediaHTTPService.createHttpServiceBinderIfNecessary(path), path, keys, values);
    }

    private final native void nativeSetDataSource(IBinder var1, String var2, String[] var3, String[] var4) throws IOException;

    public final void setDataSource(String path) throws IOException {
        this.nativeSetDataSource(MediaHTTPService.createHttpServiceBinderIfNecessary(path), path, null, null);
    }

    public final void setDataSource(AssetFileDescriptor afd) throws IOException, IllegalArgumentException, IllegalStateException {
        Preconditions.checkNotNull(afd);
        if (afd.getDeclaredLength() < 0L) {
            this.setDataSource(afd.getFileDescriptor());
        } else {
            this.setDataSource(afd.getFileDescriptor(), afd.getStartOffset(), afd.getDeclaredLength());
        }
    }

    public final void setDataSource(FileDescriptor fd) throws IOException {
        this.setDataSource(fd, 0L, 0x7FFFFFFFFFFFFFFL);
    }

    public final native void setDataSource(FileDescriptor var1, long var2, long var4) throws IOException;

    protected void finalize() {
        this.native_finalize();
    }

    public final native void release();

    public final native int getTrackCount();

    public DrmInitData getDrmInitData() {
        Map<String, Object> formatMap = this.getFileFormatNative();
        if (formatMap == null) {
            return null;
        }
        if (formatMap.containsKey("pssh")) {
            Map<UUID, byte[]> psshMap = this.getPsshInfo();
            final HashMap<UUID, DrmInitData.SchemeInitData> initDataMap = new HashMap<UUID, DrmInitData.SchemeInitData>();
            for (Map.Entry<UUID, byte[]> e : psshMap.entrySet()) {
                UUID uuid = e.getKey();
                byte[] data = e.getValue();
                initDataMap.put(uuid, new DrmInitData.SchemeInitData("cenc", data));
            }
            return new DrmInitData(){

                @Override
                public DrmInitData.SchemeInitData get(UUID schemeUuid) {
                    return (DrmInitData.SchemeInitData)initDataMap.get(schemeUuid);
                }
            };
        }
        int numTracks = this.getTrackCount();
        for (int i = 0; i < numTracks; ++i) {
            Map<String, Object> trackFormatMap = this.getTrackFormatNative(i);
            if (!trackFormatMap.containsKey("crypto-key")) continue;
            ByteBuffer buf = (ByteBuffer)trackFormatMap.get("crypto-key");
            buf.rewind();
            final byte[] data = new byte[buf.remaining()];
            buf.get(data);
            return new DrmInitData(){

                @Override
                public DrmInitData.SchemeInitData get(UUID schemeUuid) {
                    return new DrmInitData.SchemeInitData("webm", data);
                }
            };
        }
        return null;
    }

    public Map<UUID, byte[]> getPsshInfo() {
        HashMap<UUID, byte[]> psshMap = null;
        Map<String, Object> formatMap = this.getFileFormatNative();
        if (formatMap != null && formatMap.containsKey("pssh")) {
            ByteBuffer rawpssh = (ByteBuffer)formatMap.get("pssh");
            rawpssh.order(ByteOrder.nativeOrder());
            rawpssh.rewind();
            formatMap.remove("pssh");
            psshMap = new HashMap<UUID, byte[]>();
            while (rawpssh.remaining() > 0) {
                rawpssh.order(ByteOrder.BIG_ENDIAN);
                long msb = rawpssh.getLong();
                long lsb = rawpssh.getLong();
                UUID uuid = new UUID(msb, lsb);
                rawpssh.order(ByteOrder.nativeOrder());
                int datalen = rawpssh.getInt();
                byte[] psshdata = new byte[datalen];
                rawpssh.get(psshdata);
                psshMap.put(uuid, psshdata);
            }
        }
        return psshMap;
    }

    private native Map<String, Object> getFileFormatNative();

    public MediaFormat getTrackFormat(int index) {
        return new MediaFormat(this.getTrackFormatNative(index));
    }

    private native Map<String, Object> getTrackFormatNative(int var1);

    public native void selectTrack(int var1);

    public native void unselectTrack(int var1);

    public native void seekTo(long var1, int var3);

    public native boolean advance();

    public native int readSampleData(ByteBuffer var1, int var2);

    public native int getSampleTrackIndex();

    public native long getSampleTime();

    public native int getSampleFlags();

    public native boolean getSampleCryptoInfo(MediaCodec.CryptoInfo var1);

    public native long getCachedDuration();

    public native boolean hasCacheReachedEndOfStream();

    public native Bundle getMetrics();

    private static final native void native_init();

    private final native void native_setup();

    private final native void native_finalize();

    static {
        System.loadLibrary("media_jni");
        MediaExtractor.native_init();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @IntDef(flag=true, value={1L, 2L})
    public static @interface SampleFlag {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @IntDef(value={0L, 1L, 2L})
    public static @interface SeekMode {
    }
}

