/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.annotation.IntDef;
import android.app.ActivityThread;
import android.app.Application;
import android.content.ContentProvider;
import android.content.ContentResolver;
import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.media.AudioAttributes;
import android.media.AudioSystem;
import android.media.BufferingParams;
import android.media.DeniedByServerException;
import android.media.MediaDataSource;
import android.media.MediaDrm;
import android.media.MediaDrmException;
import android.media.MediaFormat;
import android.media.MediaHTTPService;
import android.media.MediaTimeProvider;
import android.media.MediaTimestamp;
import android.media.Metadata;
import android.media.NotProvisionedException;
import android.media.PlaybackParams;
import android.media.PlayerBase;
import android.media.ResourceBusyException;
import android.media.RingtoneManager;
import android.media.SRTRenderer;
import android.media.SubtitleController;
import android.media.SubtitleData;
import android.media.SubtitleTrack;
import android.media.SyncParams;
import android.media.TimedMetaData;
import android.media.TimedText;
import android.media.UnsupportedSchemeException;
import android.media.VolumeShaper;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.PowerManager;
import android.os.SystemProperties;
import android.system.ErrnoException;
import android.system.OsConstants;
import android.util.Log;
import android.util.Pair;
import android.view.Surface;
import android.view.SurfaceHolder;
import com.android.internal.util.Preconditions;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.ref.WeakReference;
import java.net.HttpCookie;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.URL;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.UUID;
import java.util.Vector;
import libcore.io.IoBridge;
import libcore.io.Libcore;
import libcore.io.Streams;

public class MediaPlayer
extends PlayerBase
implements SubtitleController.Listener {
    public static final boolean METADATA_UPDATE_ONLY = true;
    public static final boolean METADATA_ALL = false;
    public static final boolean APPLY_METADATA_FILTER = true;
    public static final boolean BYPASS_METADATA_FILTER = false;
    private static final String TAG = "MediaPlayer";
    private static final String IMEDIA_PLAYER = "android.media.IMediaPlayer";
    private long mNativeContext;
    private long mNativeSurfaceTexture;
    private int mListenerContext;
    private SurfaceHolder mSurfaceHolder;
    private EventHandler mEventHandler;
    private PowerManager.WakeLock mWakeLock = null;
    private boolean mScreenOnWhilePlaying;
    private boolean mStayAwake;
    private int mStreamType = Integer.MIN_VALUE;
    private int mUsage = -1;
    private boolean mBypassInterruptionPolicy;
    private UUID mDrmUUID;
    private final Object mDrmLock = new Object();
    private DrmInfo mDrmInfo;
    private MediaDrm mDrmObj;
    private byte[] mDrmSessionId;
    private boolean mDrmInfoResolved;
    private boolean mActiveDrmScheme;
    private boolean mDrmConfigAllowed;
    private boolean mDrmProvisioningInProgress;
    private boolean mPrepareDrmInProgress;
    private ProvisioningThread mDrmProvisioningThread;
    private static final int INVOKE_ID_GET_TRACK_INFO = 1;
    private static final int INVOKE_ID_ADD_EXTERNAL_SOURCE = 2;
    private static final int INVOKE_ID_ADD_EXTERNAL_SOURCE_FD = 3;
    private static final int INVOKE_ID_SELECT_TRACK = 4;
    private static final int INVOKE_ID_DESELECT_TRACK = 5;
    private static final int INVOKE_ID_SET_VIDEO_SCALE_MODE = 6;
    private static final int INVOKE_ID_GET_SELECTED_TRACK = 7;
    public static final int VIDEO_SCALING_MODE_SCALE_TO_FIT = 1;
    public static final int VIDEO_SCALING_MODE_SCALE_TO_FIT_WITH_CROPPING = 2;
    public static final int PLAYBACK_RATE_AUDIO_MODE_RESAMPLE = 2;
    public static final int PLAYBACK_RATE_AUDIO_MODE_STRETCH = 1;
    public static final int PLAYBACK_RATE_AUDIO_MODE_DEFAULT = 0;
    public static final int SEEK_PREVIOUS_SYNC = 0;
    public static final int SEEK_NEXT_SYNC = 1;
    public static final int SEEK_CLOSEST_SYNC = 2;
    public static final int SEEK_CLOSEST = 3;
    private static final int KEY_PARAMETER_AUDIO_ATTRIBUTES = 1400;
    private Vector<Pair<Integer, SubtitleTrack>> mIndexTrackPairs = new Vector();
    private BitSet mInbandTrackIndices = new BitSet();
    public static final String MEDIA_MIMETYPE_TEXT_SUBRIP = "application/x-subrip";
    public static final String MEDIA_MIMETYPE_TEXT_VTT = "text/vtt";
    public static final String MEDIA_MIMETYPE_TEXT_CEA_608 = "text/cea-608";
    public static final String MEDIA_MIMETYPE_TEXT_CEA_708 = "text/cea-708";
    private SubtitleController mSubtitleController;
    private int mSelectedSubtitleTrackIndex = -1;
    private Vector<InputStream> mOpenSubtitleSources;
    private OnSubtitleDataListener mSubtitleDataListener = new OnSubtitleDataListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onSubtitleData(MediaPlayer mp, SubtitleData data) {
            int index = data.getTrackIndex();
            Vector vector = MediaPlayer.this.mIndexTrackPairs;
            synchronized (vector) {
                for (Pair p : MediaPlayer.this.mIndexTrackPairs) {
                    if (p.first == null || (Integer)p.first != index || p.second == null) continue;
                    SubtitleTrack track = (SubtitleTrack)p.second;
                    track.onData(data);
                }
            }
        }
    };
    private static final int MEDIA_NOP = 0;
    private static final int MEDIA_PREPARED = 1;
    private static final int MEDIA_PLAYBACK_COMPLETE = 2;
    private static final int MEDIA_BUFFERING_UPDATE = 3;
    private static final int MEDIA_SEEK_COMPLETE = 4;
    private static final int MEDIA_SET_VIDEO_SIZE = 5;
    private static final int MEDIA_STARTED = 6;
    private static final int MEDIA_PAUSED = 7;
    private static final int MEDIA_STOPPED = 8;
    private static final int MEDIA_SKIPPED = 9;
    private static final int MEDIA_TIMED_TEXT = 99;
    private static final int MEDIA_ERROR = 100;
    private static final int MEDIA_INFO = 200;
    private static final int MEDIA_SUBTITLE_DATA = 201;
    private static final int MEDIA_META_DATA = 202;
    private static final int MEDIA_DRM_INFO = 210;
    private TimeProvider mTimeProvider;
    private OnPreparedListener mOnPreparedListener;
    private OnCompletionListener mOnCompletionListener;
    private final OnCompletionListener mOnCompletionInternalListener = new OnCompletionListener(){

        @Override
        public void onCompletion(MediaPlayer mp) {
            MediaPlayer.this.baseStop();
        }
    };
    private OnBufferingUpdateListener mOnBufferingUpdateListener;
    private OnSeekCompleteListener mOnSeekCompleteListener;
    private OnVideoSizeChangedListener mOnVideoSizeChangedListener;
    private OnTimedTextListener mOnTimedTextListener;
    private OnSubtitleDataListener mOnSubtitleDataListener;
    private OnTimedMetaDataAvailableListener mOnTimedMetaDataAvailableListener;
    public static final int MEDIA_ERROR_UNKNOWN = 1;
    public static final int MEDIA_ERROR_SERVER_DIED = 100;
    public static final int MEDIA_ERROR_NOT_VALID_FOR_PROGRESSIVE_PLAYBACK = 200;
    public static final int MEDIA_ERROR_IO = -1004;
    public static final int MEDIA_ERROR_MALFORMED = -1007;
    public static final int MEDIA_ERROR_UNSUPPORTED = -1010;
    public static final int MEDIA_ERROR_TIMED_OUT = -110;
    public static final int MEDIA_ERROR_SYSTEM = Integer.MIN_VALUE;
    private OnErrorListener mOnErrorListener;
    public static final int MEDIA_INFO_UNKNOWN = 1;
    public static final int MEDIA_INFO_STARTED_AS_NEXT = 2;
    public static final int MEDIA_INFO_VIDEO_RENDERING_START = 3;
    public static final int MEDIA_INFO_VIDEO_TRACK_LAGGING = 700;
    public static final int MEDIA_INFO_BUFFERING_START = 701;
    public static final int MEDIA_INFO_BUFFERING_END = 702;
    public static final int MEDIA_INFO_NETWORK_BANDWIDTH = 703;
    public static final int MEDIA_INFO_BAD_INTERLEAVING = 800;
    public static final int MEDIA_INFO_NOT_SEEKABLE = 801;
    public static final int MEDIA_INFO_METADATA_UPDATE = 802;
    public static final int MEDIA_INFO_EXTERNAL_METADATA_UPDATE = 803;
    public static final int MEDIA_INFO_TIMED_TEXT_ERROR = 900;
    public static final int MEDIA_INFO_UNSUPPORTED_SUBTITLE = 901;
    public static final int MEDIA_INFO_SUBTITLE_TIMED_OUT = 902;
    private OnInfoListener mOnInfoListener;
    private OnDrmConfigListener mOnDrmConfigListener;
    private OnDrmInfoHandlerDelegate mOnDrmInfoHandlerDelegate;
    private OnDrmPreparedHandlerDelegate mOnDrmPreparedHandlerDelegate;

    public MediaPlayer() {
        super(new AudioAttributes.Builder().build(), 2);
        Looper looper = Looper.myLooper();
        this.mEventHandler = looper != null ? new EventHandler(this, looper) : ((looper = Looper.getMainLooper()) != null ? new EventHandler(this, looper) : null);
        this.mTimeProvider = new TimeProvider(this);
        this.mOpenSubtitleSources = new Vector();
        this.native_setup(new WeakReference<MediaPlayer>(this));
        this.baseRegisterPlayer();
    }

    private native void _setVideoSurface(Surface var1);

    public Parcel newRequest() {
        Parcel parcel = Parcel.obtain();
        parcel.writeInterfaceToken(IMEDIA_PLAYER);
        return parcel;
    }

    public void invoke(Parcel request, Parcel reply) {
        int retcode = this.native_invoke(request, reply);
        reply.setDataPosition(0);
        if (retcode != 0) {
            throw new RuntimeException("failure code: " + retcode);
        }
    }

    public void setDisplay(SurfaceHolder sh) {
        this.mSurfaceHolder = sh;
        Surface surface = sh != null ? sh.getSurface() : null;
        this._setVideoSurface(surface);
        this.updateSurfaceScreenOn();
    }

    public void setSurface(Surface surface) {
        if (this.mScreenOnWhilePlaying && surface != null) {
            Log.w(TAG, "setScreenOnWhilePlaying(true) is ineffective for Surface");
        }
        this.mSurfaceHolder = null;
        this._setVideoSurface(surface);
        this.updateSurfaceScreenOn();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVideoScalingMode(int mode) {
        if (!this.isVideoScalingModeSupported(mode)) {
            String msg = "Scaling mode " + mode + " is not supported";
            throw new IllegalArgumentException(msg);
        }
        Parcel request = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        try {
            request.writeInterfaceToken(IMEDIA_PLAYER);
            request.writeInt(6);
            request.writeInt(mode);
            this.invoke(request, reply);
        }
        finally {
            request.recycle();
            reply.recycle();
        }
    }

    public static MediaPlayer create(Context context, Uri uri) {
        return MediaPlayer.create(context, uri, null);
    }

    public static MediaPlayer create(Context context, Uri uri, SurfaceHolder holder) {
        int s = AudioSystem.newAudioSessionId();
        return MediaPlayer.create(context, uri, holder, null, s > 0 ? s : 0);
    }

    public static MediaPlayer create(Context context, Uri uri, SurfaceHolder holder, AudioAttributes audioAttributes, int audioSessionId) {
        try {
            MediaPlayer mp = new MediaPlayer();
            AudioAttributes aa = audioAttributes != null ? audioAttributes : new AudioAttributes.Builder().build();
            mp.setAudioAttributes(aa);
            mp.setAudioSessionId(audioSessionId);
            mp.setDataSource(context, uri);
            if (holder != null) {
                mp.setDisplay(holder);
            }
            mp.prepare();
            return mp;
        }
        catch (IOException ex) {
            Log.d(TAG, "create failed:", ex);
        }
        catch (IllegalArgumentException ex) {
            Log.d(TAG, "create failed:", ex);
        }
        catch (SecurityException ex) {
            Log.d(TAG, "create failed:", ex);
        }
        return null;
    }

    public static MediaPlayer create(Context context, int resid) {
        int s = AudioSystem.newAudioSessionId();
        return MediaPlayer.create(context, resid, null, s > 0 ? s : 0);
    }

    public static MediaPlayer create(Context context, int resid, AudioAttributes audioAttributes, int audioSessionId) {
        try {
            AssetFileDescriptor afd = context.getResources().openRawResourceFd(resid);
            if (afd == null) {
                return null;
            }
            MediaPlayer mp = new MediaPlayer();
            AudioAttributes aa = audioAttributes != null ? audioAttributes : new AudioAttributes.Builder().build();
            mp.setAudioAttributes(aa);
            mp.setAudioSessionId(audioSessionId);
            mp.setDataSource(afd.getFileDescriptor(), afd.getStartOffset(), afd.getLength());
            afd.close();
            mp.prepare();
            return mp;
        }
        catch (IOException ex) {
            Log.d(TAG, "create failed:", ex);
        }
        catch (IllegalArgumentException ex) {
            Log.d(TAG, "create failed:", ex);
        }
        catch (SecurityException ex) {
            Log.d(TAG, "create failed:", ex);
        }
        return null;
    }

    public void setDataSource(Context context, Uri uri) throws IOException, IllegalArgumentException, SecurityException, IllegalStateException {
        this.setDataSource(context, uri, null, null);
    }

    public void setDataSource(Context context, Uri uri, Map<String, String> headers, List<HttpCookie> cookies) throws IOException, IllegalArgumentException, SecurityException, IllegalStateException {
        ContentResolver resolver = context.getContentResolver();
        String scheme = uri.getScheme();
        String authority = ContentProvider.getAuthorityWithoutUserId(uri.getAuthority());
        if ("file".equals(scheme)) {
            this.setDataSource(uri.getPath());
            return;
        }
        if ("content".equals(scheme) && "settings".equals(authority)) {
            int type = RingtoneManager.getDefaultType(uri);
            Uri cacheUri = RingtoneManager.getCacheForType(type, context.getUserId());
            Uri actualUri = RingtoneManager.getActualDefaultRingtoneUri(context, type);
            if (this.attemptDataSource(resolver, cacheUri)) {
                return;
            }
            if (this.attemptDataSource(resolver, actualUri)) {
                return;
            }
            this.setDataSource(uri.toString(), headers, cookies);
        } else {
            if (this.attemptDataSource(resolver, uri)) {
                return;
            }
            this.setDataSource(uri.toString(), headers, cookies);
        }
    }

    public void setDataSource(Context context, Uri uri, Map<String, String> headers) throws IOException, IllegalArgumentException, SecurityException, IllegalStateException {
        this.setDataSource(context, uri, headers, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean attemptDataSource(ContentResolver resolver, Uri uri) {
        try (AssetFileDescriptor afd = resolver.openAssetFileDescriptor(uri, "r");){
            this.setDataSource(afd);
            boolean bl = true;
            return bl;
        }
        catch (IOException | NullPointerException | SecurityException ex) {
            Log.w(TAG, "Couldn't open " + uri + ": " + ex);
            return false;
        }
    }

    public void setDataSource(String path) throws IOException, IllegalArgumentException, SecurityException, IllegalStateException {
        this.setDataSource(path, null, null);
    }

    public void setDataSource(String path, Map<String, String> headers) throws IOException, IllegalArgumentException, SecurityException, IllegalStateException {
        this.setDataSource(path, headers, null);
    }

    private void setDataSource(String path, Map<String, String> headers, List<HttpCookie> cookies) throws IOException, IllegalArgumentException, SecurityException, IllegalStateException {
        String[] keys = null;
        String[] values = null;
        if (headers != null) {
            keys = new String[headers.size()];
            values = new String[headers.size()];
            int i = 0;
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                keys[i] = entry.getKey();
                values[i] = entry.getValue();
                ++i;
            }
        }
        this.setDataSource(path, keys, values, cookies);
    }

    private void setDataSource(String path, String[] keys, String[] values, List<HttpCookie> cookies) throws IOException, IllegalArgumentException, SecurityException, IllegalStateException {
        Uri uri = Uri.parse(path);
        String scheme = uri.getScheme();
        if ("file".equals(scheme)) {
            path = uri.getPath();
        } else if (scheme != null) {
            this.nativeSetDataSource(MediaHTTPService.createHttpServiceBinderIfNecessary(path, cookies), path, keys, values);
            return;
        }
        File file = new File(path);
        if (!file.exists()) {
            throw new IOException("setDataSource failed.");
        }
        FileInputStream is = new FileInputStream(file);
        FileDescriptor fd = is.getFD();
        this.setDataSource(fd);
        is.close();
    }

    private native void nativeSetDataSource(IBinder var1, String var2, String[] var3, String[] var4) throws IOException, IllegalArgumentException, SecurityException, IllegalStateException;

    public void setDataSource(AssetFileDescriptor afd) throws IOException, IllegalArgumentException, IllegalStateException {
        Preconditions.checkNotNull(afd);
        if (afd.getDeclaredLength() < 0L) {
            this.setDataSource(afd.getFileDescriptor());
        } else {
            this.setDataSource(afd.getFileDescriptor(), afd.getStartOffset(), afd.getDeclaredLength());
        }
    }

    public void setDataSource(FileDescriptor fd) throws IOException, IllegalArgumentException, IllegalStateException {
        this.setDataSource(fd, 0L, 0x7FFFFFFFFFFFFFFL);
    }

    public void setDataSource(FileDescriptor fd, long offset, long length) throws IOException, IllegalArgumentException, IllegalStateException {
        this._setDataSource(fd, offset, length);
    }

    private native void _setDataSource(FileDescriptor var1, long var2, long var4) throws IOException, IllegalArgumentException, IllegalStateException;

    public void setDataSource(MediaDataSource dataSource) throws IllegalArgumentException, IllegalStateException {
        this._setDataSource(dataSource);
    }

    private native void _setDataSource(MediaDataSource var1) throws IllegalArgumentException, IllegalStateException;

    public void prepare() throws IOException, IllegalStateException {
        this._prepare();
        this.scanInternalSubtitleTracks();
    }

    private native void _prepare() throws IOException, IllegalStateException;

    public native void prepareAsync() throws IllegalStateException;

    public void start() throws IllegalStateException {
        final int delay = this.getStartDelayMs();
        if (delay == 0) {
            this.startImpl();
        } else {
            new Thread(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(delay);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    MediaPlayer.this.baseSetStartDelayMs(0);
                    try {
                        MediaPlayer.this.startImpl();
                    }
                    catch (IllegalStateException illegalStateException) {
                        // empty catch block
                    }
                }
            }.start();
        }
    }

    private void startImpl() {
        this.baseStart();
        this.stayAwake(true);
        this._start();
    }

    private native void _start() throws IllegalStateException;

    private int getAudioStreamType() {
        if (this.mStreamType == Integer.MIN_VALUE) {
            this.mStreamType = this._getAudioStreamType();
        }
        return this.mStreamType;
    }

    private native int _getAudioStreamType() throws IllegalStateException;

    public void stop() throws IllegalStateException {
        this.stayAwake(false);
        this._stop();
        this.baseStop();
    }

    private native void _stop() throws IllegalStateException;

    public void pause() throws IllegalStateException {
        this.stayAwake(false);
        this._pause();
        this.basePause();
    }

    private native void _pause() throws IllegalStateException;

    @Override
    void playerStart() {
        this.start();
    }

    @Override
    void playerPause() {
        this.pause();
    }

    @Override
    void playerStop() {
        this.stop();
    }

    @Override
    int playerApplyVolumeShaper(VolumeShaper.Configuration configuration, VolumeShaper.Operation operation) {
        return this.native_applyVolumeShaper(configuration, operation);
    }

    @Override
    VolumeShaper.State playerGetVolumeShaperState(int id2) {
        return this.native_getVolumeShaperState(id2);
    }

    private native int native_applyVolumeShaper(VolumeShaper.Configuration var1, VolumeShaper.Operation var2);

    private native VolumeShaper.State native_getVolumeShaperState(int var1);

    public void setWakeMode(Context context, int mode) {
        boolean washeld = false;
        if (SystemProperties.getBoolean("audio.offload.ignore_setawake", false)) {
            Log.w(TAG, "IGNORING setWakeMode " + mode);
            return;
        }
        if (this.mWakeLock != null) {
            if (this.mWakeLock.isHeld()) {
                washeld = true;
                this.mWakeLock.release();
            }
            this.mWakeLock = null;
        }
        PowerManager pm = (PowerManager)context.getSystemService("power");
        this.mWakeLock = pm.newWakeLock(mode | 0x20000000, MediaPlayer.class.getName());
        this.mWakeLock.setReferenceCounted(false);
        if (washeld) {
            this.mWakeLock.acquire();
        }
    }

    public void setScreenOnWhilePlaying(boolean screenOn) {
        if (this.mScreenOnWhilePlaying != screenOn) {
            if (screenOn && this.mSurfaceHolder == null) {
                Log.w(TAG, "setScreenOnWhilePlaying(true) is ineffective without a SurfaceHolder");
            }
            this.mScreenOnWhilePlaying = screenOn;
            this.updateSurfaceScreenOn();
        }
    }

    private void stayAwake(boolean awake) {
        if (this.mWakeLock != null) {
            if (awake && !this.mWakeLock.isHeld()) {
                this.mWakeLock.acquire();
            } else if (!awake && this.mWakeLock.isHeld()) {
                this.mWakeLock.release();
            }
        }
        this.mStayAwake = awake;
        this.updateSurfaceScreenOn();
    }

    private void updateSurfaceScreenOn() {
        if (this.mSurfaceHolder != null) {
            this.mSurfaceHolder.setKeepScreenOn(this.mScreenOnWhilePlaying && this.mStayAwake);
        }
    }

    public native int getVideoWidth();

    public native int getVideoHeight();

    public native Bundle getMetrics();

    public native boolean isPlaying();

    public native BufferingParams getDefaultBufferingParams();

    public native BufferingParams getBufferingParams();

    public native void setBufferingParams(BufferingParams var1);

    public PlaybackParams easyPlaybackParams(float rate, int audioMode) {
        PlaybackParams params = new PlaybackParams();
        params.allowDefaults();
        switch (audioMode) {
            case 0: {
                params.setSpeed(rate).setPitch(1.0f);
                break;
            }
            case 1: {
                params.setSpeed(rate).setPitch(1.0f).setAudioFallbackMode(2);
                break;
            }
            case 2: {
                params.setSpeed(rate).setPitch(rate);
                break;
            }
            default: {
                String msg = "Audio playback mode " + audioMode + " is not supported";
                throw new IllegalArgumentException(msg);
            }
        }
        return params;
    }

    public native void setPlaybackParams(PlaybackParams var1);

    public native PlaybackParams getPlaybackParams();

    public native void setSyncParams(SyncParams var1);

    public native SyncParams getSyncParams();

    private final native void _seekTo(int var1, int var2);

    public void seekTo(int msec, int mode) throws IllegalStateException {
        if (mode < 0 || mode > 3) {
            String msg = "Illegal seek mode: " + mode;
            throw new IllegalArgumentException(msg);
        }
        this._seekTo(msec, mode);
    }

    public void seekTo(int msec) throws IllegalStateException {
        this.seekTo(msec, 0);
    }

    public MediaTimestamp getTimestamp() {
        try {
            return new MediaTimestamp((long)this.getCurrentPosition() * 1000L, System.nanoTime(), this.isPlaying() ? this.getPlaybackParams().getSpeed() : 0.0f);
        }
        catch (IllegalStateException e) {
            return null;
        }
    }

    public native int getCurrentPosition();

    public native int getDuration();

    public Metadata getMetadata(boolean update_only, boolean apply_filter) {
        Parcel reply = Parcel.obtain();
        Metadata data = new Metadata();
        if (!this.native_getMetadata(update_only, apply_filter, reply)) {
            reply.recycle();
            return null;
        }
        if (!data.parse(reply)) {
            reply.recycle();
            return null;
        }
        return data;
    }

    public int setMetadataFilter(Set<Integer> allow, Set<Integer> block) {
        Parcel request = this.newRequest();
        int capacity = request.dataSize() + 4 * (1 + allow.size() + 1 + block.size());
        if (request.dataCapacity() < capacity) {
            request.setDataCapacity(capacity);
        }
        request.writeInt(allow.size());
        for (Integer t : allow) {
            request.writeInt(t);
        }
        request.writeInt(block.size());
        for (Integer t : block) {
            request.writeInt(t);
        }
        return this.native_setMetadataFilter(request);
    }

    public native void setNextMediaPlayer(MediaPlayer var1);

    public void release() {
        this.baseRelease();
        this.stayAwake(false);
        this.updateSurfaceScreenOn();
        this.mOnPreparedListener = null;
        this.mOnBufferingUpdateListener = null;
        this.mOnCompletionListener = null;
        this.mOnSeekCompleteListener = null;
        this.mOnErrorListener = null;
        this.mOnInfoListener = null;
        this.mOnVideoSizeChangedListener = null;
        this.mOnTimedTextListener = null;
        if (this.mTimeProvider != null) {
            this.mTimeProvider.close();
            this.mTimeProvider = null;
        }
        this.mOnSubtitleDataListener = null;
        this.mOnDrmConfigListener = null;
        this.mOnDrmInfoHandlerDelegate = null;
        this.mOnDrmPreparedHandlerDelegate = null;
        this.resetDrmState();
        this._release();
    }

    private native void _release();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        this.mSelectedSubtitleTrackIndex = -1;
        Vector<Object> vector = this.mOpenSubtitleSources;
        synchronized (vector) {
            for (InputStream is : this.mOpenSubtitleSources) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
            this.mOpenSubtitleSources.clear();
        }
        if (this.mSubtitleController != null) {
            this.mSubtitleController.reset();
        }
        if (this.mTimeProvider != null) {
            this.mTimeProvider.close();
            this.mTimeProvider = null;
        }
        this.stayAwake(false);
        this._reset();
        if (this.mEventHandler != null) {
            this.mEventHandler.removeCallbacksAndMessages(null);
        }
        vector = this.mIndexTrackPairs;
        synchronized (vector) {
            this.mIndexTrackPairs.clear();
            this.mInbandTrackIndices.clear();
        }
        this.resetDrmState();
    }

    private native void _reset();

    public void setAudioStreamType(int streamtype) {
        MediaPlayer.deprecateStreamTypeForPlayback(streamtype, TAG, "setAudioStreamType()");
        this.baseUpdateAudioAttributes(new AudioAttributes.Builder().setInternalLegacyStreamType(streamtype).build());
        this._setAudioStreamType(streamtype);
        this.mStreamType = streamtype;
    }

    private native void _setAudioStreamType(int var1);

    private native boolean setParameter(int var1, Parcel var2);

    public void setAudioAttributes(AudioAttributes attributes) throws IllegalArgumentException {
        if (attributes == null) {
            String msg = "Cannot set AudioAttributes to null";
            throw new IllegalArgumentException("Cannot set AudioAttributes to null");
        }
        this.baseUpdateAudioAttributes(attributes);
        this.mUsage = attributes.getUsage();
        this.mBypassInterruptionPolicy = (attributes.getAllFlags() & 0x40) != 0;
        Parcel pattributes = Parcel.obtain();
        attributes.writeToParcel(pattributes, 1);
        this.setParameter(1400, pattributes);
        pattributes.recycle();
    }

    public native void setLooping(boolean var1);

    public native boolean isLooping();

    public void setVolume(float leftVolume, float rightVolume) {
        this.baseSetVolume(leftVolume, rightVolume);
    }

    @Override
    void playerSetVolume(boolean muting, float leftVolume, float rightVolume) {
        this._setVolume(muting ? 0.0f : leftVolume, muting ? 0.0f : rightVolume);
    }

    private native void _setVolume(float var1, float var2);

    public void setVolume(float volume) {
        this.setVolume(volume, volume);
    }

    public native void setAudioSessionId(int var1) throws IllegalArgumentException, IllegalStateException;

    public native int getAudioSessionId();

    public native void attachAuxEffect(int var1);

    public void setAuxEffectSendLevel(float level) {
        this.baseSetAuxEffectSendLevel(level);
    }

    @Override
    int playerSetAuxEffectSendLevel(boolean muting, float level) {
        this._setAuxEffectSendLevel(muting ? 0.0f : level);
        return 0;
    }

    private native void _setAuxEffectSendLevel(float var1);

    private final native int native_invoke(Parcel var1, Parcel var2);

    private final native boolean native_getMetadata(boolean var1, boolean var2, Parcel var3);

    private final native int native_setMetadataFilter(Parcel var1);

    private static final native void native_init();

    private final native void native_setup(Object var1);

    private final native void native_finalize();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TrackInfo[] getTrackInfo() throws IllegalStateException {
        TrackInfo[] trackInfo = this.getInbandTrackInfo();
        Vector<Pair<Integer, SubtitleTrack>> vector = this.mIndexTrackPairs;
        synchronized (vector) {
            TrackInfo[] allTrackInfo = new TrackInfo[this.mIndexTrackPairs.size()];
            for (int i = 0; i < allTrackInfo.length; ++i) {
                Pair<Integer, SubtitleTrack> p = this.mIndexTrackPairs.get(i);
                if (p.first != null) {
                    allTrackInfo[i] = trackInfo[(Integer)p.first];
                    continue;
                }
                SubtitleTrack track = (SubtitleTrack)p.second;
                allTrackInfo[i] = new TrackInfo(track.getTrackType(), track.getFormat());
            }
            return allTrackInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TrackInfo[] getInbandTrackInfo() throws IllegalStateException {
        Parcel request = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        try {
            TrackInfo[] trackInfo;
            request.writeInterfaceToken(IMEDIA_PLAYER);
            request.writeInt(1);
            this.invoke(request, reply);
            TrackInfo[] trackInfoArray = trackInfo = reply.createTypedArray(TrackInfo.CREATOR);
            return trackInfoArray;
        }
        finally {
            request.recycle();
            reply.recycle();
        }
    }

    private static boolean availableMimeTypeForExternalSource(String mimeType) {
        return MEDIA_MIMETYPE_TEXT_SUBRIP.equals(mimeType);
    }

    public void setSubtitleAnchor(SubtitleController controller, SubtitleController.Anchor anchor) {
        this.mSubtitleController = controller;
        this.mSubtitleController.setAnchor(anchor);
    }

    private synchronized void setSubtitleAnchor() {
        if (this.mSubtitleController == null && ActivityThread.currentApplication() != null) {
            final HandlerThread thread = new HandlerThread("SetSubtitleAnchorThread");
            thread.start();
            Handler handler = new Handler(thread.getLooper());
            handler.post(new Runnable(){

                @Override
                public void run() {
                    Application context = ActivityThread.currentApplication();
                    MediaPlayer.this.mSubtitleController = new SubtitleController(context, MediaPlayer.this.mTimeProvider, MediaPlayer.this);
                    MediaPlayer.this.mSubtitleController.setAnchor(new SubtitleController.Anchor(){

                        @Override
                        public void setSubtitleWidget(SubtitleTrack.RenderingWidget subtitleWidget) {
                        }

                        @Override
                        public Looper getSubtitleLooper() {
                            return Looper.getMainLooper();
                        }
                    });
                    thread.getLooper().quitSafely();
                }
            });
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                Log.w(TAG, "failed to join SetSubtitleAnchorThread");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSubtitleTrackSelected(SubtitleTrack track) {
        if (this.mSelectedSubtitleTrackIndex >= 0) {
            try {
                this.selectOrDeselectInbandTrack(this.mSelectedSubtitleTrackIndex, false);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            this.mSelectedSubtitleTrackIndex = -1;
        }
        this.setOnSubtitleDataListener(null);
        if (track == null) {
            return;
        }
        Vector<Pair<Integer, SubtitleTrack>> vector = this.mIndexTrackPairs;
        synchronized (vector) {
            for (Pair<Integer, SubtitleTrack> p : this.mIndexTrackPairs) {
                if (p.first == null || p.second != track) continue;
                this.mSelectedSubtitleTrackIndex = (Integer)p.first;
                break;
            }
        }
        if (this.mSelectedSubtitleTrackIndex >= 0) {
            try {
                this.selectOrDeselectInbandTrack(this.mSelectedSubtitleTrackIndex, true);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            this.setOnSubtitleDataListener(this.mSubtitleDataListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSubtitleSource(InputStream is, MediaFormat format) throws IllegalStateException {
        final InputStream fIs = is;
        final MediaFormat fFormat = format;
        if (is != null) {
            Vector<InputStream> vector = this.mOpenSubtitleSources;
            synchronized (vector) {
                this.mOpenSubtitleSources.add(is);
            }
        } else {
            Log.w(TAG, "addSubtitleSource called with null InputStream");
        }
        this.getMediaTimeProvider();
        final HandlerThread thread = new HandlerThread("SubtitleReadThread", 9);
        thread.start();
        Handler handler = new Handler(thread.getLooper());
        handler.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private int addTrack() {
                if (fIs == null || MediaPlayer.this.mSubtitleController == null) {
                    return 901;
                }
                SubtitleTrack track = MediaPlayer.this.mSubtitleController.addTrack(fFormat);
                if (track == null) {
                    return 901;
                }
                Scanner scanner = new Scanner(fIs, "UTF-8");
                String contents = scanner.useDelimiter("\\A").next();
                Vector vector = MediaPlayer.this.mOpenSubtitleSources;
                synchronized (vector) {
                    MediaPlayer.this.mOpenSubtitleSources.remove(fIs);
                }
                scanner.close();
                vector = MediaPlayer.this.mIndexTrackPairs;
                synchronized (vector) {
                    MediaPlayer.this.mIndexTrackPairs.add(Pair.create(null, track));
                }
                Handler h = MediaPlayer.this.mTimeProvider.mEventHandler;
                int what = 1;
                int arg1 = 4;
                Pair<SubtitleTrack, byte[]> trackData = Pair.create(track, contents.getBytes());
                Message m = h.obtainMessage(what, arg1, 0, trackData);
                h.sendMessage(m);
                return 803;
            }

            @Override
            public void run() {
                int res = this.addTrack();
                if (MediaPlayer.this.mEventHandler != null) {
                    Message m = MediaPlayer.this.mEventHandler.obtainMessage(200, res, 0, null);
                    MediaPlayer.this.mEventHandler.sendMessage(m);
                }
                thread.getLooper().quitSafely();
            }
        });
    }

    private void scanInternalSubtitleTracks() {
        this.setSubtitleAnchor();
        this.populateInbandTracks();
        if (this.mSubtitleController != null) {
            this.mSubtitleController.selectDefaultTrack();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateInbandTracks() {
        TrackInfo[] tracks = this.getInbandTrackInfo();
        Vector<Pair<Integer, SubtitleTrack>> vector = this.mIndexTrackPairs;
        synchronized (vector) {
            for (int i = 0; i < tracks.length; ++i) {
                if (this.mInbandTrackIndices.get(i)) continue;
                this.mInbandTrackIndices.set(i);
                if (tracks[i].getTrackType() == 4) {
                    SubtitleTrack track = this.mSubtitleController.addTrack(tracks[i].getFormat());
                    this.mIndexTrackPairs.add(Pair.create(i, track));
                    continue;
                }
                this.mIndexTrackPairs.add(Pair.create(i, null));
            }
        }
    }

    public void addTimedTextSource(String path, String mimeType) throws IOException, IllegalArgumentException, IllegalStateException {
        if (!MediaPlayer.availableMimeTypeForExternalSource(mimeType)) {
            String msg = "Illegal mimeType for timed text source: " + mimeType;
            throw new IllegalArgumentException(msg);
        }
        File file = new File(path);
        if (!file.exists()) {
            throw new IOException(path);
        }
        FileInputStream is = new FileInputStream(file);
        FileDescriptor fd = is.getFD();
        this.addTimedTextSource(fd, mimeType);
        is.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTimedTextSource(Context context, Uri uri, String mimeType) throws IOException, IllegalArgumentException, IllegalStateException {
        String scheme = uri.getScheme();
        if (scheme == null || scheme.equals("file")) {
            this.addTimedTextSource(uri.getPath(), mimeType);
            return;
        }
        try (AssetFileDescriptor fd = null;){
            ContentResolver resolver = context.getContentResolver();
            fd = resolver.openAssetFileDescriptor(uri, "r");
            if (fd == null) {
                return;
            }
            this.addTimedTextSource(fd.getFileDescriptor(), mimeType);
            return;
        }
    }

    public void addTimedTextSource(FileDescriptor fd, String mimeType) throws IllegalArgumentException, IllegalStateException {
        this.addTimedTextSource(fd, 0L, 0x7FFFFFFFFFFFFFFL, mimeType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTimedTextSource(FileDescriptor fd, long offset, long length, String mime) throws IllegalArgumentException, IllegalStateException {
        FileDescriptor dupedFd;
        if (!MediaPlayer.availableMimeTypeForExternalSource(mime)) {
            throw new IllegalArgumentException("Illegal mimeType for timed text source: " + mime);
        }
        try {
            dupedFd = Libcore.os.dup(fd);
        }
        catch (ErrnoException ex) {
            Log.e(TAG, ex.getMessage(), ex);
            throw new RuntimeException(ex);
        }
        MediaFormat fFormat = new MediaFormat();
        fFormat.setString("mime", mime);
        fFormat.setInteger("is-timed-text", 1);
        if (this.mSubtitleController == null) {
            this.setSubtitleAnchor();
        }
        if (!this.mSubtitleController.hasRendererFor(fFormat)) {
            Application context = ActivityThread.currentApplication();
            this.mSubtitleController.registerRenderer(new SRTRenderer(context, this.mEventHandler));
        }
        final SubtitleTrack track = this.mSubtitleController.addTrack(fFormat);
        Vector<Pair<Integer, SubtitleTrack>> vector = this.mIndexTrackPairs;
        synchronized (vector) {
            this.mIndexTrackPairs.add(Pair.create(null, track));
        }
        this.getMediaTimeProvider();
        final long offset2 = offset;
        final long length2 = length;
        final HandlerThread thread = new HandlerThread("TimedTextReadThread", 9);
        thread.start();
        Handler handler = new Handler(thread.getLooper());
        handler.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private int addTrack() {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                try {
                    int bytesToRead;
                    int bytes;
                    Libcore.os.lseek(dupedFd, offset2, OsConstants.SEEK_SET);
                    byte[] buffer = new byte[4096];
                    for (long total = 0L; total < length2 && (bytes = IoBridge.read(dupedFd, buffer, 0, bytesToRead = (int)Math.min((long)buffer.length, length2 - total))) >= 0; total += (long)bytes) {
                        bos.write(buffer, 0, bytes);
                    }
                    Handler h = MediaPlayer.this.mTimeProvider.mEventHandler;
                    int what = 1;
                    int arg1 = 4;
                    Pair<SubtitleTrack, byte[]> trackData = Pair.create(track, bos.toByteArray());
                    Message m = h.obtainMessage(what, arg1, 0, trackData);
                    h.sendMessage(m);
                    int n = 803;
                    return n;
                }
                catch (Exception e) {
                    Log.e(MediaPlayer.TAG, e.getMessage(), e);
                    int n = 900;
                    return n;
                }
                finally {
                    try {
                        Libcore.os.close(dupedFd);
                    }
                    catch (ErrnoException e) {
                        Log.e(MediaPlayer.TAG, e.getMessage(), e);
                    }
                }
            }

            @Override
            public void run() {
                int res = this.addTrack();
                if (MediaPlayer.this.mEventHandler != null) {
                    Message m = MediaPlayer.this.mEventHandler.obtainMessage(200, res, 0, null);
                    MediaPlayer.this.mEventHandler.sendMessage(m);
                }
                thread.getLooper().quitSafely();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getSelectedTrack(int trackType) throws IllegalStateException {
        SubtitleTrack subtitleTrack;
        if (this.mSubtitleController != null && (trackType == 4 || trackType == 3) && (subtitleTrack = this.mSubtitleController.getSelectedTrack()) != null) {
            Vector<Pair<Integer, SubtitleTrack>> vector = this.mIndexTrackPairs;
            synchronized (vector) {
                for (int i = 0; i < this.mIndexTrackPairs.size(); ++i) {
                    Pair<Integer, SubtitleTrack> p = this.mIndexTrackPairs.get(i);
                    if (p.second != subtitleTrack || subtitleTrack.getTrackType() != trackType) continue;
                    return i;
                }
            }
        }
        Parcel request = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        try {
            request.writeInterfaceToken(IMEDIA_PLAYER);
            request.writeInt(7);
            request.writeInt(trackType);
            this.invoke(request, reply);
            int inbandTrackIndex = reply.readInt();
            Vector<Pair<Integer, SubtitleTrack>> vector = this.mIndexTrackPairs;
            synchronized (vector) {
                for (int i = 0; i < this.mIndexTrackPairs.size(); ++i) {
                    Pair<Integer, SubtitleTrack> p = this.mIndexTrackPairs.get(i);
                    if (p.first == null || (Integer)p.first != inbandTrackIndex) continue;
                    int n = i;
                    return n;
                }
            }
            int n = -1;
            return n;
        }
        finally {
            request.recycle();
            reply.recycle();
        }
    }

    public void selectTrack(int index) throws IllegalStateException {
        this.selectOrDeselectTrack(index, true);
    }

    public void deselectTrack(int index) throws IllegalStateException {
        this.selectOrDeselectTrack(index, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void selectOrDeselectTrack(int index, boolean select) throws IllegalStateException {
        this.populateInbandTracks();
        Pair<Integer, SubtitleTrack> p = null;
        try {
            p = this.mIndexTrackPairs.get(index);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return;
        }
        SubtitleTrack track = (SubtitleTrack)p.second;
        if (track == null) {
            this.selectOrDeselectInbandTrack((Integer)p.first, select);
            return;
        }
        if (this.mSubtitleController == null) {
            return;
        }
        if (!select) {
            if (this.mSubtitleController.getSelectedTrack() == track) {
                this.mSubtitleController.selectTrack(null);
            } else {
                Log.w(TAG, "trying to deselect track that was not selected");
            }
            return;
        }
        if (track.getTrackType() == 3) {
            int ttIndex = this.getSelectedTrack(3);
            Vector<Pair<Integer, SubtitleTrack>> vector = this.mIndexTrackPairs;
            synchronized (vector) {
                if (ttIndex >= 0 && ttIndex < this.mIndexTrackPairs.size()) {
                    Pair<Integer, SubtitleTrack> p2 = this.mIndexTrackPairs.get(ttIndex);
                    if (p2.first != null && p2.second == null) {
                        this.selectOrDeselectInbandTrack((Integer)p2.first, false);
                    }
                }
            }
        }
        this.mSubtitleController.selectTrack(track);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void selectOrDeselectInbandTrack(int index, boolean select) throws IllegalStateException {
        Parcel request = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        try {
            request.writeInterfaceToken(IMEDIA_PLAYER);
            request.writeInt(select ? 4 : 5);
            request.writeInt(index);
            this.invoke(request, reply);
        }
        finally {
            request.recycle();
            reply.recycle();
        }
    }

    public static native int native_pullBatteryData(Parcel var0);

    public void setRetransmitEndpoint(InetSocketAddress endpoint) throws IllegalStateException, IllegalArgumentException {
        int ret;
        String addrString = null;
        int port = 0;
        if (null != endpoint) {
            addrString = endpoint.getAddress().getHostAddress();
            port = endpoint.getPort();
        }
        if ((ret = this.native_setRetransmitEndpoint(addrString, port)) != 0) {
            throw new IllegalArgumentException("Illegal re-transmit endpoint; native ret " + ret);
        }
    }

    private final native int native_setRetransmitEndpoint(String var1, int var2);

    protected void finalize() {
        this.baseRelease();
        this.native_finalize();
    }

    public MediaTimeProvider getMediaTimeProvider() {
        if (this.mTimeProvider == null) {
            this.mTimeProvider = new TimeProvider(this);
        }
        return this.mTimeProvider;
    }

    private static void postEventFromNative(Object mediaplayer_ref, int what, int arg1, int arg2, Object obj) {
        MediaPlayer mp = (MediaPlayer)((WeakReference)mediaplayer_ref).get();
        if (mp == null) {
            return;
        }
        if (what == 200 && arg1 == 2) {
            mp.start();
        }
        if (mp.mEventHandler != null) {
            Message m = mp.mEventHandler.obtainMessage(what, arg1, arg2, obj);
            mp.mEventHandler.sendMessage(m);
        }
    }

    public void setOnPreparedListener(OnPreparedListener listener) {
        this.mOnPreparedListener = listener;
    }

    public void setOnCompletionListener(OnCompletionListener listener) {
        this.mOnCompletionListener = listener;
    }

    public void setOnBufferingUpdateListener(OnBufferingUpdateListener listener) {
        this.mOnBufferingUpdateListener = listener;
    }

    public void setOnSeekCompleteListener(OnSeekCompleteListener listener) {
        this.mOnSeekCompleteListener = listener;
    }

    public void setOnVideoSizeChangedListener(OnVideoSizeChangedListener listener) {
        this.mOnVideoSizeChangedListener = listener;
    }

    public void setOnTimedTextListener(OnTimedTextListener listener) {
        this.mOnTimedTextListener = listener;
    }

    public void setOnSubtitleDataListener(OnSubtitleDataListener listener) {
        this.mOnSubtitleDataListener = listener;
    }

    public void setOnTimedMetaDataAvailableListener(OnTimedMetaDataAvailableListener listener) {
        this.mOnTimedMetaDataAvailableListener = listener;
    }

    public void setOnErrorListener(OnErrorListener listener) {
        this.mOnErrorListener = listener;
    }

    public void setOnInfoListener(OnInfoListener listener) {
        this.mOnInfoListener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOnDrmConfigListener(OnDrmConfigListener listener) {
        Object object = this.mDrmLock;
        synchronized (object) {
            this.mOnDrmConfigListener = listener;
        }
    }

    public void setOnDrmInfoListener(OnDrmInfoListener listener) {
        this.setOnDrmInfoListener(listener, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOnDrmInfoListener(OnDrmInfoListener listener, Handler handler) {
        Object object = this.mDrmLock;
        synchronized (object) {
            this.mOnDrmInfoHandlerDelegate = listener != null ? new OnDrmInfoHandlerDelegate(this, listener, handler) : null;
        }
    }

    public void setOnDrmPreparedListener(OnDrmPreparedListener listener) {
        this.setOnDrmPreparedListener(listener, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOnDrmPreparedListener(OnDrmPreparedListener listener, Handler handler) {
        Object object = this.mDrmLock;
        synchronized (object) {
            this.mOnDrmPreparedHandlerDelegate = listener != null ? new OnDrmPreparedHandlerDelegate(this, listener, handler) : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DrmInfo getDrmInfo() {
        DrmInfo drmInfo = null;
        Object object = this.mDrmLock;
        synchronized (object) {
            if (!this.mDrmInfoResolved && this.mDrmInfo == null) {
                String msg = "The Player has not been prepared yet";
                Log.v(TAG, "The Player has not been prepared yet");
                throw new IllegalStateException("The Player has not been prepared yet");
            }
            if (this.mDrmInfo != null) {
                drmInfo = this.mDrmInfo.makeCopy();
            }
        }
        return drmInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepareDrm(UUID uuid) throws UnsupportedSchemeException, ResourceBusyException, ProvisioningErrorException {
        Log.v(TAG, "prepareDrm: uuid: " + uuid + " mOnDrmConfigListener: " + this.mOnDrmConfigListener);
        boolean allDoneWithoutProvisioning = false;
        OnDrmPreparedHandlerDelegate onDrmPreparedHandlerDelegate = null;
        Object object = this.mDrmLock;
        synchronized (object) {
            if (this.mDrmInfo == null) {
                String msg = "prepareDrm(): Wrong usage: The player must be prepared and DRM info be retrieved before this call.";
                Log.e(TAG, "prepareDrm(): Wrong usage: The player must be prepared and DRM info be retrieved before this call.");
                throw new IllegalStateException("prepareDrm(): Wrong usage: The player must be prepared and DRM info be retrieved before this call.");
            }
            if (this.mActiveDrmScheme) {
                String msg = "prepareDrm(): Wrong usage: There is already an active DRM scheme with " + this.mDrmUUID;
                Log.e(TAG, msg);
                throw new IllegalStateException(msg);
            }
            if (this.mPrepareDrmInProgress) {
                String msg = "prepareDrm(): Wrong usage: There is already a pending prepareDrm call.";
                Log.e(TAG, "prepareDrm(): Wrong usage: There is already a pending prepareDrm call.");
                throw new IllegalStateException("prepareDrm(): Wrong usage: There is already a pending prepareDrm call.");
            }
            if (this.mDrmProvisioningInProgress) {
                String msg = "prepareDrm(): Unexpectd: Provisioning is already in progress.";
                Log.e(TAG, "prepareDrm(): Unexpectd: Provisioning is already in progress.");
                throw new IllegalStateException("prepareDrm(): Unexpectd: Provisioning is already in progress.");
            }
            this.cleanDrmObj();
            this.mPrepareDrmInProgress = true;
            onDrmPreparedHandlerDelegate = this.mOnDrmPreparedHandlerDelegate;
            try {
                this.prepareDrm_createDrmStep(uuid);
            }
            catch (Exception e) {
                Log.w(TAG, "prepareDrm(): Exception ", e);
                this.mPrepareDrmInProgress = false;
                throw e;
            }
            this.mDrmConfigAllowed = true;
        }
        if (this.mOnDrmConfigListener != null) {
            this.mOnDrmConfigListener.onDrmConfig(this);
        }
        object = this.mDrmLock;
        synchronized (object) {
            this.mDrmConfigAllowed = false;
            boolean earlyExit = false;
            try {
                this.prepareDrm_openSessionStep(uuid);
                this.mDrmUUID = uuid;
                this.mActiveDrmScheme = true;
                allDoneWithoutProvisioning = true;
            }
            catch (IllegalStateException e) {
                String msg = "prepareDrm(): Wrong usage: The player must be in the prepared state to call prepareDrm().";
                Log.e(TAG, "prepareDrm(): Wrong usage: The player must be in the prepared state to call prepareDrm().");
                earlyExit = true;
                throw new IllegalStateException("prepareDrm(): Wrong usage: The player must be in the prepared state to call prepareDrm().");
            }
            catch (NotProvisionedException e) {
                Log.w(TAG, "prepareDrm: NotProvisionedException");
                boolean result = this.HandleProvisioninig(uuid);
                if (!result) {
                    String msg = "prepareDrm: Provisioning was required but failed.";
                    Log.e(TAG, "prepareDrm: Provisioning was required but failed.");
                    earlyExit = true;
                    throw new ProvisioningErrorException("prepareDrm: Provisioning was required but failed.");
                }
            }
            catch (Exception e) {
                Log.e(TAG, "prepareDrm: Exception " + e);
                earlyExit = true;
                throw e;
            }
            finally {
                if (!this.mDrmProvisioningInProgress) {
                    this.mPrepareDrmInProgress = false;
                }
                if (earlyExit) {
                    this.cleanDrmObj();
                }
            }
        }
        if (allDoneWithoutProvisioning && onDrmPreparedHandlerDelegate != null) {
            onDrmPreparedHandlerDelegate.notifyClient(true);
        }
    }

    private native void _releaseDrm();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseDrm() throws NoDrmSchemeException {
        Log.v(TAG, "releaseDrm:");
        Object object = this.mDrmLock;
        synchronized (object) {
            if (!this.mActiveDrmScheme) {
                Log.e(TAG, "releaseDrm(): No active DRM scheme to release.");
                throw new NoDrmSchemeException("releaseDrm: No active DRM scheme to release.");
            }
            try {
                this._releaseDrm();
                this.cleanDrmObj();
                this.mActiveDrmScheme = false;
            }
            catch (Exception e) {
                Log.w(TAG, "releaseDrm: Exception ", e);
                throw e;
            }
        }
    }

    public MediaDrm.KeyRequest getKeyRequest(byte[] scope, String mimeType, int keyType, Map<String, String> optionalParameters) throws NoDrmSchemeException {
        Log.v(TAG, "getKeyRequest:  scope: " + scope + " mimeType: " + mimeType + " keyType: " + keyType + " optionalParameters: " + optionalParameters);
        Object object = this.mDrmLock;
        synchronized (object) {
            if (!this.mActiveDrmScheme) {
                Log.e(TAG, "getKeyRequest NoDrmSchemeException");
                throw new NoDrmSchemeException("getKeyRequest: Has to set a DRM scheme first.");
            }
            try {
                byte[] scopeOut = keyType != 3 ? this.mDrmSessionId : scope;
                byte[] initData = (byte[])(keyType != 3 ? scope : null);
                HashMap<String, String> hmapOptionalParameters = optionalParameters != null ? new HashMap<String, String>(optionalParameters) : null;
                MediaDrm.KeyRequest request = this.mDrmObj.getKeyRequest(scopeOut, initData, mimeType, keyType, hmapOptionalParameters);
                Log.v(TAG, "getKeyRequest:   --> request: " + request);
                return request;
            }
            catch (NotProvisionedException e) {
                Log.w(TAG, "getKeyRequest NotProvisionedException: Unexpected. Shouldn't have reached here.");
                throw new IllegalStateException("getKeyRequest: Unexpected provisioning error.");
            }
            catch (Exception e) {
                Log.w(TAG, "getKeyRequest Exception " + e);
                throw e;
            }
        }
    }

    public byte[] provideKeyResponse(byte[] keySetId, byte[] response) throws NoDrmSchemeException, DeniedByServerException {
        Log.v(TAG, "provideKeyResponse: keySetId: " + keySetId + " response: " + response);
        Object object = this.mDrmLock;
        synchronized (object) {
            if (!this.mActiveDrmScheme) {
                Log.e(TAG, "getKeyRequest NoDrmSchemeException");
                throw new NoDrmSchemeException("getKeyRequest: Has to set a DRM scheme first.");
            }
            try {
                byte[] scope = keySetId == null ? this.mDrmSessionId : keySetId;
                byte[] keySetResult = this.mDrmObj.provideKeyResponse(scope, response);
                Log.v(TAG, "provideKeyResponse: keySetId: " + keySetId + " response: " + response + " --> " + keySetResult);
                return keySetResult;
            }
            catch (NotProvisionedException e) {
                Log.w(TAG, "provideKeyResponse NotProvisionedException: Unexpected. Shouldn't have reached here.");
                throw new IllegalStateException("provideKeyResponse: Unexpected provisioning error.");
            }
            catch (Exception e) {
                Log.w(TAG, "provideKeyResponse Exception " + e);
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restoreKeys(byte[] keySetId) throws NoDrmSchemeException {
        Log.v(TAG, "restoreKeys: keySetId: " + keySetId);
        Object object = this.mDrmLock;
        synchronized (object) {
            if (!this.mActiveDrmScheme) {
                Log.w(TAG, "restoreKeys NoDrmSchemeException");
                throw new NoDrmSchemeException("restoreKeys: Has to set a DRM scheme first.");
            }
            try {
                this.mDrmObj.restoreKeys(this.mDrmSessionId, keySetId);
            }
            catch (Exception e) {
                Log.w(TAG, "restoreKeys Exception " + e);
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDrmPropertyString(String propertyName) throws NoDrmSchemeException {
        String value;
        Log.v(TAG, "getDrmPropertyString: propertyName: " + propertyName);
        Object object = this.mDrmLock;
        synchronized (object) {
            if (!this.mActiveDrmScheme && !this.mDrmConfigAllowed) {
                Log.w(TAG, "getDrmPropertyString NoDrmSchemeException");
                throw new NoDrmSchemeException("getDrmPropertyString: Has to prepareDrm() first.");
            }
            try {
                value = this.mDrmObj.getPropertyString(propertyName);
            }
            catch (Exception e) {
                Log.w(TAG, "getDrmPropertyString Exception " + e);
                throw e;
            }
        }
        Log.v(TAG, "getDrmPropertyString: propertyName: " + propertyName + " --> value: " + value);
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDrmPropertyString(String propertyName, String value) throws NoDrmSchemeException {
        Log.v(TAG, "setDrmPropertyString: propertyName: " + propertyName + " value: " + value);
        Object object = this.mDrmLock;
        synchronized (object) {
            if (!this.mActiveDrmScheme && !this.mDrmConfigAllowed) {
                Log.w(TAG, "setDrmPropertyString NoDrmSchemeException");
                throw new NoDrmSchemeException("setDrmPropertyString: Has to prepareDrm() first.");
            }
            try {
                this.mDrmObj.setPropertyString(propertyName, value);
            }
            catch (Exception e) {
                Log.w(TAG, "setDrmPropertyString Exception " + e);
                throw e;
            }
        }
    }

    private native void _prepareDrm(byte[] var1, byte[] var2);

    private void prepareDrm_createDrmStep(UUID uuid) throws UnsupportedSchemeException {
        Log.v(TAG, "prepareDrm_createDrmStep: UUID: " + uuid);
        try {
            this.mDrmObj = new MediaDrm(uuid);
            Log.v(TAG, "prepareDrm_createDrmStep: Created mDrmObj=" + this.mDrmObj);
        }
        catch (Exception e) {
            Log.e(TAG, "prepareDrm_createDrmStep: MediaDrm failed with " + e);
            throw e;
        }
    }

    private void prepareDrm_openSessionStep(UUID uuid) throws NotProvisionedException, ResourceBusyException {
        Log.v(TAG, "prepareDrm_openSessionStep: uuid: " + uuid);
        try {
            this.mDrmSessionId = this.mDrmObj.openSession();
            Log.v(TAG, "prepareDrm_openSessionStep: mDrmSessionId=" + this.mDrmSessionId);
            this._prepareDrm(MediaPlayer.getByteArrayFromUUID(uuid), this.mDrmSessionId);
            Log.v(TAG, "prepareDrm_openSessionStep: _prepareDrm/Crypto succeeded");
        }
        catch (Exception e) {
            Log.e(TAG, "prepareDrm_openSessionStep: open/crypto failed with " + e);
            throw e;
        }
    }

    private boolean HandleProvisioninig(UUID uuid) {
        if (this.mDrmProvisioningInProgress) {
            Log.e(TAG, "HandleProvisioninig: Unexpected mDrmProvisioningInProgress");
            return false;
        }
        MediaDrm.ProvisionRequest provReq = this.mDrmObj.getProvisionRequest();
        if (provReq == null) {
            Log.e(TAG, "HandleProvisioninig: getProvisionRequest returned null.");
            return false;
        }
        Log.v(TAG, "HandleProvisioninig provReq  data: " + provReq.getData() + " url: " + provReq.getDefaultUrl());
        this.mDrmProvisioningInProgress = true;
        this.mDrmProvisioningThread = new ProvisioningThread().initialize(provReq, uuid, this);
        this.mDrmProvisioningThread.start();
        boolean result = false;
        if (this.mOnDrmPreparedHandlerDelegate != null) {
            result = true;
        } else {
            try {
                this.mDrmProvisioningThread.join();
            }
            catch (Exception e) {
                Log.w(TAG, "HandleProvisioninig: Thread.join Exception " + e);
            }
            result = this.mDrmProvisioningThread.succeeded();
            this.mDrmProvisioningThread = null;
        }
        return result;
    }

    private boolean resumePrepareDrm(UUID uuid) {
        Log.v(TAG, "resumePrepareDrm: uuid: " + uuid);
        boolean success = false;
        try {
            this.prepareDrm_openSessionStep(uuid);
            this.mDrmUUID = uuid;
            this.mActiveDrmScheme = true;
            success = true;
        }
        catch (Exception e) {
            Log.w(TAG, "HandleProvisioninig: Thread run _prepareDrm resume failed with " + e);
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetDrmState() {
        Object object = this.mDrmLock;
        synchronized (object) {
            Log.v(TAG, "resetDrmState:  mDrmInfo=" + this.mDrmInfo + " mDrmProvisioningThread=" + this.mDrmProvisioningThread + " mPrepareDrmInProgress=" + this.mPrepareDrmInProgress + " mActiveDrmScheme=" + this.mActiveDrmScheme);
            this.mDrmInfoResolved = false;
            this.mDrmInfo = null;
            if (this.mDrmProvisioningThread != null) {
                try {
                    this.mDrmProvisioningThread.join();
                }
                catch (InterruptedException e) {
                    Log.w(TAG, "resetDrmState: ProvThread.join Exception " + e);
                }
                this.mDrmProvisioningThread = null;
            }
            this.mPrepareDrmInProgress = false;
            this.mActiveDrmScheme = false;
            this.cleanDrmObj();
        }
    }

    private void cleanDrmObj() {
        Log.v(TAG, "cleanDrmObj: mDrmObj=" + this.mDrmObj + " mDrmSessionId=" + this.mDrmSessionId);
        if (this.mDrmSessionId != null) {
            this.mDrmObj.closeSession(this.mDrmSessionId);
            this.mDrmSessionId = null;
        }
        if (this.mDrmObj != null) {
            this.mDrmObj.release();
            this.mDrmObj = null;
        }
    }

    private static final byte[] getByteArrayFromUUID(UUID uuid) {
        long msb = uuid.getMostSignificantBits();
        long lsb = uuid.getLeastSignificantBits();
        byte[] uuidBytes = new byte[16];
        for (int i = 0; i < 8; ++i) {
            uuidBytes[i] = (byte)(msb >>> 8 * (7 - i));
            uuidBytes[8 + i] = (byte)(lsb >>> 8 * (7 - i));
        }
        return uuidBytes;
    }

    private boolean isVideoScalingModeSupported(int mode) {
        return mode == 1 || mode == 2;
    }

    static {
        System.loadLibrary("media_jni");
        MediaPlayer.native_init();
    }

    static class TimeProvider
    implements OnSeekCompleteListener,
    MediaTimeProvider {
        private static final String TAG = "MTP";
        private static final long MAX_NS_WITHOUT_POSITION_CHECK = 5000000000L;
        private static final long MAX_EARLY_CALLBACK_US = 1000L;
        private static final long TIME_ADJUSTMENT_RATE = 2L;
        private long mLastTimeUs = 0L;
        private MediaPlayer mPlayer;
        private boolean mPaused = true;
        private boolean mStopped = true;
        private boolean mBuffering;
        private long mLastReportedTime;
        private long mTimeAdjustment;
        private MediaTimeProvider.OnMediaTimeListener[] mListeners;
        private long[] mTimes;
        private long mLastNanoTime;
        private Handler mEventHandler;
        private boolean mRefresh = false;
        private boolean mPausing = false;
        private boolean mSeeking = false;
        private static final int NOTIFY = 1;
        private static final int NOTIFY_TIME = 0;
        private static final int REFRESH_AND_NOTIFY_TIME = 1;
        private static final int NOTIFY_STOP = 2;
        private static final int NOTIFY_SEEK = 3;
        private static final int NOTIFY_TRACK_DATA = 4;
        private HandlerThread mHandlerThread;
        public boolean DEBUG = false;

        public TimeProvider(MediaPlayer mp) {
            this.mPlayer = mp;
            try {
                this.getCurrentTimeUs(true, false);
            }
            catch (IllegalStateException e) {
                this.mRefresh = true;
            }
            Looper looper = Looper.myLooper();
            if (looper == null && (looper = Looper.getMainLooper()) == null) {
                this.mHandlerThread = new HandlerThread("MediaPlayerMTPEventThread", -2);
                this.mHandlerThread.start();
                looper = this.mHandlerThread.getLooper();
            }
            this.mEventHandler = new EventHandler(looper);
            this.mListeners = new MediaTimeProvider.OnMediaTimeListener[0];
            this.mTimes = new long[0];
            this.mLastTimeUs = 0L;
            this.mTimeAdjustment = 0L;
        }

        private void scheduleNotification(int type, long delayUs) {
            if (this.mSeeking && (type == 0 || type == 1)) {
                return;
            }
            if (this.DEBUG) {
                Log.v(TAG, "scheduleNotification " + type + " in " + delayUs);
            }
            this.mEventHandler.removeMessages(1);
            Message msg = this.mEventHandler.obtainMessage(1, type, 0);
            this.mEventHandler.sendMessageDelayed(msg, (int)(delayUs / 1000L));
        }

        public void close() {
            this.mEventHandler.removeMessages(1);
            if (this.mHandlerThread != null) {
                this.mHandlerThread.quitSafely();
                this.mHandlerThread = null;
            }
        }

        protected void finalize() {
            if (this.mHandlerThread != null) {
                this.mHandlerThread.quitSafely();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onPaused(boolean paused) {
            TimeProvider timeProvider = this;
            synchronized (timeProvider) {
                if (this.DEBUG) {
                    Log.d(TAG, "onPaused: " + paused);
                }
                if (this.mStopped) {
                    this.mStopped = false;
                    this.mSeeking = true;
                    this.scheduleNotification(3, 0L);
                } else {
                    this.mPausing = paused;
                    this.mSeeking = false;
                    this.scheduleNotification(1, 0L);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onBuffering(boolean buffering) {
            TimeProvider timeProvider = this;
            synchronized (timeProvider) {
                if (this.DEBUG) {
                    Log.d(TAG, "onBuffering: " + buffering);
                }
                this.mBuffering = buffering;
                this.scheduleNotification(1, 0L);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onStopped() {
            TimeProvider timeProvider = this;
            synchronized (timeProvider) {
                if (this.DEBUG) {
                    Log.d(TAG, "onStopped");
                }
                this.mPaused = true;
                this.mStopped = true;
                this.mSeeking = false;
                this.mBuffering = false;
                this.scheduleNotification(2, 0L);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onSeekComplete(MediaPlayer mp) {
            TimeProvider timeProvider = this;
            synchronized (timeProvider) {
                this.mStopped = false;
                this.mSeeking = true;
                this.scheduleNotification(3, 0L);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onNewPlayer() {
            if (this.mRefresh) {
                TimeProvider timeProvider = this;
                synchronized (timeProvider) {
                    this.mStopped = false;
                    this.mSeeking = true;
                    this.mBuffering = false;
                    this.scheduleNotification(3, 0L);
                }
            }
        }

        private synchronized void notifySeek() {
            this.mSeeking = false;
            try {
                long timeUs = this.getCurrentTimeUs(true, false);
                if (this.DEBUG) {
                    Log.d(TAG, "onSeekComplete at " + timeUs);
                }
                for (MediaTimeProvider.OnMediaTimeListener listener : this.mListeners) {
                    if (listener == null) break;
                    listener.onSeek(timeUs);
                }
            }
            catch (IllegalStateException e) {
                if (this.DEBUG) {
                    Log.d(TAG, "onSeekComplete but no player");
                }
                this.mPausing = true;
                this.notifyTimedEvent(false);
            }
        }

        private synchronized void notifyTrackData(Pair<SubtitleTrack, byte[]> trackData) {
            SubtitleTrack track = (SubtitleTrack)trackData.first;
            byte[] data = (byte[])trackData.second;
            track.onData(data, true, -1L);
        }

        private synchronized void notifyStop() {
            for (MediaTimeProvider.OnMediaTimeListener listener : this.mListeners) {
                if (listener == null) break;
                listener.onStop();
            }
        }

        private int registerListener(MediaTimeProvider.OnMediaTimeListener listener) {
            int i;
            for (i = 0; i < this.mListeners.length && this.mListeners[i] != listener && this.mListeners[i] != null; ++i) {
            }
            if (i >= this.mListeners.length) {
                MediaTimeProvider.OnMediaTimeListener[] newListeners = new MediaTimeProvider.OnMediaTimeListener[i + 1];
                long[] newTimes = new long[i + 1];
                System.arraycopy(this.mListeners, 0, newListeners, 0, this.mListeners.length);
                System.arraycopy((long[])this.mTimes, (int)0, (long[])newTimes, (int)0, (int)this.mTimes.length);
                this.mListeners = newListeners;
                this.mTimes = newTimes;
            }
            if (this.mListeners[i] == null) {
                this.mListeners[i] = listener;
                this.mTimes[i] = -1L;
            }
            return i;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void notifyAt(long timeUs, MediaTimeProvider.OnMediaTimeListener listener) {
            TimeProvider timeProvider = this;
            synchronized (timeProvider) {
                if (this.DEBUG) {
                    Log.d(TAG, "notifyAt " + timeUs);
                }
                this.mTimes[this.registerListener((MediaTimeProvider.OnMediaTimeListener)listener)] = timeUs;
                this.scheduleNotification(0, 0L);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void scheduleUpdate(MediaTimeProvider.OnMediaTimeListener listener) {
            TimeProvider timeProvider = this;
            synchronized (timeProvider) {
                if (this.DEBUG) {
                    Log.d(TAG, "scheduleUpdate");
                }
                int i = this.registerListener(listener);
                if (!this.mStopped) {
                    this.mTimes[i] = 0L;
                    this.scheduleNotification(0, 0L);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cancelNotifications(MediaTimeProvider.OnMediaTimeListener listener) {
            TimeProvider timeProvider = this;
            synchronized (timeProvider) {
                for (int i = 0; i < this.mListeners.length; ++i) {
                    if (this.mListeners[i] == listener) {
                        System.arraycopy(this.mListeners, i + 1, this.mListeners, i, this.mListeners.length - i - 1);
                        System.arraycopy((long[])this.mTimes, (int)(i + 1), (long[])this.mTimes, (int)i, (int)(this.mTimes.length - i - 1));
                        this.mListeners[this.mListeners.length - 1] = null;
                        this.mTimes[this.mTimes.length - 1] = -1L;
                        break;
                    }
                    if (this.mListeners[i] == null) break;
                }
                this.scheduleNotification(0, 0L);
            }
        }

        private synchronized void notifyTimedEvent(boolean refreshTime) {
            long nowUs;
            try {
                nowUs = this.getCurrentTimeUs(refreshTime, true);
            }
            catch (IllegalStateException e) {
                this.mRefresh = true;
                this.mPausing = true;
                nowUs = this.getCurrentTimeUs(refreshTime, true);
            }
            long nextTimeUs = nowUs;
            if (this.mSeeking) {
                return;
            }
            if (this.DEBUG) {
                StringBuilder sb = new StringBuilder();
                sb.append("notifyTimedEvent(").append(this.mLastTimeUs).append(" -> ").append(nowUs).append(") from {");
                boolean first = true;
                for (long time : this.mTimes) {
                    if (time == -1L) continue;
                    if (!first) {
                        sb.append(", ");
                    }
                    sb.append(time);
                    first = false;
                }
                sb.append("}");
                Log.d(TAG, sb.toString());
            }
            Vector<MediaTimeProvider.OnMediaTimeListener> activatedListeners = new Vector<MediaTimeProvider.OnMediaTimeListener>();
            for (int ix = 0; ix < this.mTimes.length && this.mListeners[ix] != null; ++ix) {
                if (this.mTimes[ix] <= -1L) continue;
                if (this.mTimes[ix] <= nowUs + 1000L) {
                    activatedListeners.add(this.mListeners[ix]);
                    if (this.DEBUG) {
                        Log.d(TAG, "removed");
                    }
                    this.mTimes[ix] = -1L;
                    continue;
                }
                if (nextTimeUs != nowUs && this.mTimes[ix] >= nextTimeUs) continue;
                nextTimeUs = this.mTimes[ix];
            }
            if (nextTimeUs > nowUs && !this.mPaused) {
                if (this.DEBUG) {
                    Log.d(TAG, "scheduling for " + nextTimeUs + " and " + nowUs);
                }
                this.scheduleNotification(0, nextTimeUs - nowUs);
            } else {
                this.mEventHandler.removeMessages(1);
            }
            for (MediaTimeProvider.OnMediaTimeListener listener : activatedListeners) {
                listener.onTimedEvent(nowUs);
            }
        }

        private long getEstimatedTime(long nanoTime, boolean monotonic) {
            if (this.mPaused) {
                this.mLastReportedTime = this.mLastTimeUs + this.mTimeAdjustment;
            } else {
                long timeSinceRead = (nanoTime - this.mLastNanoTime) / 1000L;
                this.mLastReportedTime = this.mLastTimeUs + timeSinceRead;
                if (this.mTimeAdjustment > 0L) {
                    long adjustment = this.mTimeAdjustment - timeSinceRead / 2L;
                    if (adjustment <= 0L) {
                        this.mTimeAdjustment = 0L;
                    } else {
                        this.mLastReportedTime += adjustment;
                    }
                }
            }
            return this.mLastReportedTime;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long getCurrentTimeUs(boolean refreshTime, boolean monotonic) throws IllegalStateException {
            TimeProvider timeProvider = this;
            synchronized (timeProvider) {
                if (this.mPaused && !refreshTime) {
                    return this.mLastReportedTime;
                }
                long nanoTime = System.nanoTime();
                if (refreshTime || nanoTime >= this.mLastNanoTime + 5000000000L) {
                    try {
                        this.mLastTimeUs = (long)this.mPlayer.getCurrentPosition() * 1000L;
                        boolean bl = this.mPaused = !this.mPlayer.isPlaying() || this.mBuffering;
                        if (this.DEBUG) {
                            Log.v(TAG, (this.mPaused ? "paused" : "playing") + " at " + this.mLastTimeUs);
                        }
                    }
                    catch (IllegalStateException e) {
                        if (this.mPausing) {
                            this.mPausing = false;
                            this.getEstimatedTime(nanoTime, monotonic);
                            this.mPaused = true;
                            if (this.DEBUG) {
                                Log.d(TAG, "illegal state, but pausing: estimating at " + this.mLastReportedTime);
                            }
                            return this.mLastReportedTime;
                        }
                        throw e;
                    }
                    this.mLastNanoTime = nanoTime;
                    if (monotonic && this.mLastTimeUs < this.mLastReportedTime) {
                        this.mTimeAdjustment = this.mLastReportedTime - this.mLastTimeUs;
                        if (this.mTimeAdjustment > 1000000L) {
                            this.mStopped = false;
                            this.mSeeking = true;
                            this.scheduleNotification(3, 0L);
                        }
                    } else {
                        this.mTimeAdjustment = 0L;
                    }
                }
                return this.getEstimatedTime(nanoTime, monotonic);
            }
        }

        private class EventHandler
        extends Handler {
            public EventHandler(Looper looper) {
                super(looper);
            }

            @Override
            public void handleMessage(Message msg) {
                if (msg.what == 1) {
                    switch (msg.arg1) {
                        case 0: {
                            TimeProvider.this.notifyTimedEvent(false);
                            break;
                        }
                        case 1: {
                            TimeProvider.this.notifyTimedEvent(true);
                            break;
                        }
                        case 2: {
                            TimeProvider.this.notifyStop();
                            break;
                        }
                        case 3: {
                            TimeProvider.this.notifySeek();
                            break;
                        }
                        case 4: {
                            TimeProvider.this.notifyTrackData((Pair)msg.obj);
                        }
                    }
                }
            }
        }
    }

    private class ProvisioningThread
    extends Thread {
        public static final int TIMEOUT_MS = 60000;
        private UUID uuid;
        private String urlStr;
        private byte[] response;
        private Object drmLock;
        private OnDrmPreparedHandlerDelegate onDrmPreparedHandlerDelegate;
        private MediaPlayer mediaPlayer;
        private boolean succeeded;
        private boolean finished;

        private ProvisioningThread() {
        }

        public boolean succeeded() {
            return this.succeeded;
        }

        public ProvisioningThread initialize(MediaDrm.ProvisionRequest request, UUID uuid, MediaPlayer mediaPlayer) {
            this.drmLock = mediaPlayer.mDrmLock;
            this.onDrmPreparedHandlerDelegate = mediaPlayer.mOnDrmPreparedHandlerDelegate;
            this.mediaPlayer = mediaPlayer;
            this.urlStr = request.getDefaultUrl() + "&signedRequest=" + new String(request.getData());
            this.uuid = uuid;
            Log.v(MediaPlayer.TAG, "HandleProvisioninig: Thread is initialised url: " + this.urlStr);
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean provisioningSucceeded = false;
            try {
                URL url = new URL(this.urlStr);
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                try {
                    connection.setRequestMethod("POST");
                    connection.setDoOutput(false);
                    connection.setDoInput(true);
                    connection.setConnectTimeout(60000);
                    connection.setReadTimeout(60000);
                    connection.connect();
                    this.response = Streams.readFully(connection.getInputStream());
                    Log.v(MediaPlayer.TAG, "HandleProvisioninig: Thread run: response " + this.response.length + " " + this.response);
                }
                catch (Exception e) {
                    Log.w(MediaPlayer.TAG, "HandleProvisioninig: Thread run: connect " + e + " url: " + url);
                }
                finally {
                    connection.disconnect();
                }
            }
            catch (Exception e) {
                Log.w(MediaPlayer.TAG, "HandleProvisioninig: Thread run: openConnection " + e);
            }
            if (this.response != null) {
                try {
                    MediaPlayer.this.mDrmObj.provideProvisionResponse(this.response);
                    Log.v(MediaPlayer.TAG, "HandleProvisioninig: Thread run: provideProvisionResponse SUCCEEDED!");
                    provisioningSucceeded = true;
                }
                catch (Exception e) {
                    Log.w(MediaPlayer.TAG, "HandleProvisioninig: Thread run: provideProvisionResponse " + e);
                }
            }
            if (this.onDrmPreparedHandlerDelegate != null) {
                Object object = this.drmLock;
                synchronized (object) {
                    if (provisioningSucceeded) {
                        this.succeeded = this.mediaPlayer.resumePrepareDrm(this.uuid);
                    }
                    this.mediaPlayer.mDrmProvisioningInProgress = false;
                    this.mediaPlayer.mPrepareDrmInProgress = false;
                    if (!this.succeeded) {
                        MediaPlayer.this.cleanDrmObj();
                    }
                }
                this.onDrmPreparedHandlerDelegate.notifyClient(this.succeeded);
            } else {
                if (provisioningSucceeded) {
                    this.succeeded = this.mediaPlayer.resumePrepareDrm(this.uuid);
                }
                this.mediaPlayer.mDrmProvisioningInProgress = false;
                this.mediaPlayer.mPrepareDrmInProgress = false;
                if (!this.succeeded) {
                    MediaPlayer.this.cleanDrmObj();
                }
            }
            this.finished = true;
        }
    }

    public static final class ProvisioningErrorException
    extends MediaDrmException {
        public ProvisioningErrorException(String detailMessage) {
            super(detailMessage);
        }
    }

    public static final class NoDrmSchemeException
    extends MediaDrmException {
        public NoDrmSchemeException(String detailMessage) {
            super(detailMessage);
        }
    }

    public static final class DrmInfo {
        private Map<UUID, byte[]> mapPssh;
        private UUID[] supportedSchemes;
        private String[] mimes;

        public Map<UUID, byte[]> getPssh() {
            return this.mapPssh;
        }

        public UUID[] getSupportedSchemes() {
            return this.supportedSchemes;
        }

        public String[] getMimes() {
            return this.mimes;
        }

        private DrmInfo(Map<UUID, byte[]> Pssh, UUID[] SupportedSchemes, String[] Mimes) {
            this.mapPssh = Pssh;
            this.supportedSchemes = SupportedSchemes;
            this.mimes = Mimes;
        }

        private DrmInfo(Parcel parcel) {
            Log.v(MediaPlayer.TAG, "DrmInfo(" + parcel + ") size " + parcel.dataSize());
            int psshsize = parcel.readInt();
            byte[] pssh = new byte[psshsize];
            parcel.readByteArray(pssh);
            Log.v(MediaPlayer.TAG, "DrmInfo() PSSH: " + this.arrToHex(pssh));
            this.mapPssh = this.parsePSSH(pssh, psshsize);
            Log.v(MediaPlayer.TAG, "DrmInfo() PSSH: " + this.mapPssh);
            int supportedDRMsCount = parcel.readInt();
            this.supportedSchemes = new UUID[supportedDRMsCount];
            for (int i = 0; i < supportedDRMsCount; ++i) {
                byte[] uuid = new byte[16];
                parcel.readByteArray(uuid);
                this.supportedSchemes[i] = this.bytesToUUID(uuid);
                Log.v(MediaPlayer.TAG, "DrmInfo() supportedScheme[" + i + "]: " + this.supportedSchemes[i]);
            }
            this.mimes = parcel.readStringArray();
            int mimeCount = this.mimes.length;
            Log.v(MediaPlayer.TAG, "DrmInfo() mime: " + Arrays.toString(this.mimes));
            Log.v(MediaPlayer.TAG, "DrmInfo() Parcel psshsize: " + psshsize + " supportedDRMsCount: " + supportedDRMsCount + " mimeCount: " + mimeCount);
        }

        private DrmInfo makeCopy() {
            return new DrmInfo(this.mapPssh, this.supportedSchemes, this.mimes);
        }

        private String arrToHex(byte[] bytes) {
            String out = "0x";
            for (int i = 0; i < bytes.length; ++i) {
                out = out + String.format("%02x", bytes[i]);
            }
            return out;
        }

        private UUID bytesToUUID(byte[] uuid) {
            long msb = 0L;
            long lsb = 0L;
            for (int i = 0; i < 8; ++i) {
                msb |= ((long)uuid[i] & 0xFFL) << 8 * (7 - i);
                lsb |= ((long)uuid[i + 8] & 0xFFL) << 8 * (7 - i);
            }
            return new UUID(msb, lsb);
        }

        private Map<UUID, byte[]> parsePSSH(byte[] pssh, int psshsize) {
            HashMap<UUID, byte[]> result = new HashMap<UUID, byte[]>();
            int UUID_SIZE = 16;
            int DATALEN_SIZE = 4;
            int len = psshsize;
            int numentries = 0;
            int i = 0;
            while (len > 0) {
                if (len < 16) {
                    Log.w(MediaPlayer.TAG, String.format("parsePSSH: len is too short to parse UUID: (%d < 16) pssh: %d", len, psshsize));
                    return null;
                }
                byte[] subset = Arrays.copyOfRange(pssh, i, i + 16);
                UUID uuid = this.bytesToUUID(subset);
                i += 16;
                if ((len -= 16) < 4) {
                    Log.w(MediaPlayer.TAG, String.format("parsePSSH: len is too short to parse datalen: (%d < 4) pssh: %d", len, psshsize));
                    return null;
                }
                subset = Arrays.copyOfRange(pssh, i, i + 4);
                int datalen = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN ? (subset[3] & 0xFF) << 24 | (subset[2] & 0xFF) << 16 | (subset[1] & 0xFF) << 8 | subset[0] & 0xFF : (subset[0] & 0xFF) << 24 | (subset[1] & 0xFF) << 16 | (subset[2] & 0xFF) << 8 | subset[3] & 0xFF;
                i += 4;
                if ((len -= 4) < datalen) {
                    Log.w(MediaPlayer.TAG, String.format("parsePSSH: len is too short to parse data: (%d < %d) pssh: %d", len, datalen, psshsize));
                    return null;
                }
                byte[] data = Arrays.copyOfRange(pssh, i, i + datalen);
                i += datalen;
                len -= datalen;
                Log.v(MediaPlayer.TAG, String.format("parsePSSH[%d]: <%s, %s> pssh: %d", numentries, uuid, this.arrToHex(data), psshsize));
                ++numentries;
                result.put(uuid, data);
            }
            return result;
        }
    }

    private class OnDrmPreparedHandlerDelegate {
        private MediaPlayer mMediaPlayer;
        private OnDrmPreparedListener mOnDrmPreparedListener;
        private Handler mHandler;

        OnDrmPreparedHandlerDelegate(MediaPlayer mp, OnDrmPreparedListener listener, Handler handler) {
            this.mMediaPlayer = mp;
            this.mOnDrmPreparedListener = listener;
            Looper looper = null;
            if (handler != null) {
                looper = handler.getLooper();
            }
            if (looper != null) {
                this.mHandler = new Handler(looper){

                    @Override
                    public void handleMessage(Message msg) {
                        boolean success = msg.arg1 != 0;
                        OnDrmPreparedHandlerDelegate.this.mOnDrmPreparedListener.onDrmPrepared(OnDrmPreparedHandlerDelegate.this.mMediaPlayer, success);
                    }
                };
            }
        }

        void notifyClient(boolean success) {
            if (this.mHandler != null) {
                Message msg = new Message();
                msg.arg1 = success ? 1 : 0;
                this.mHandler.sendMessage(msg);
            } else {
                this.mOnDrmPreparedListener.onDrmPrepared(this.mMediaPlayer, success);
            }
        }
    }

    private class OnDrmInfoHandlerDelegate {
        private MediaPlayer mMediaPlayer;
        private OnDrmInfoListener mOnDrmInfoListener;
        private Handler mHandler;

        OnDrmInfoHandlerDelegate(MediaPlayer mp, OnDrmInfoListener listener, Handler handler) {
            this.mMediaPlayer = mp;
            this.mOnDrmInfoListener = listener;
            Looper looper = null;
            if (handler != null) {
                looper = handler.getLooper();
            }
            if (looper != null) {
                this.mHandler = new Handler(looper){

                    @Override
                    public void handleMessage(Message msg) {
                        DrmInfo drmInfo = (DrmInfo)msg.obj;
                        OnDrmInfoHandlerDelegate.this.mOnDrmInfoListener.onDrmInfo(OnDrmInfoHandlerDelegate.this.mMediaPlayer, drmInfo);
                    }
                };
            }
        }

        void notifyClient(DrmInfo drmInfo) {
            if (this.mHandler != null) {
                Message msg = new Message();
                msg.obj = drmInfo;
                this.mHandler.sendMessage(msg);
            } else {
                this.mOnDrmInfoListener.onDrmInfo(this.mMediaPlayer, drmInfo);
            }
        }
    }

    public static interface OnDrmPreparedListener {
        public void onDrmPrepared(MediaPlayer var1, boolean var2);
    }

    public static interface OnDrmInfoListener {
        public void onDrmInfo(MediaPlayer var1, DrmInfo var2);
    }

    public static interface OnDrmConfigListener {
        public void onDrmConfig(MediaPlayer var1);
    }

    public static interface OnInfoListener {
        public boolean onInfo(MediaPlayer var1, int var2, int var3);
    }

    public static interface OnErrorListener {
        public boolean onError(MediaPlayer var1, int var2, int var3);
    }

    public static interface OnTimedMetaDataAvailableListener {
        public void onTimedMetaDataAvailable(MediaPlayer var1, TimedMetaData var2);
    }

    public static interface OnSubtitleDataListener {
        public void onSubtitleData(MediaPlayer var1, SubtitleData var2);
    }

    public static interface OnTimedTextListener {
        public void onTimedText(MediaPlayer var1, TimedText var2);
    }

    public static interface OnVideoSizeChangedListener {
        public void onVideoSizeChanged(MediaPlayer var1, int var2, int var3);
    }

    public static interface OnSeekCompleteListener {
        public void onSeekComplete(MediaPlayer var1);
    }

    public static interface OnBufferingUpdateListener {
        public void onBufferingUpdate(MediaPlayer var1, int var2);
    }

    public static interface OnCompletionListener {
        public void onCompletion(MediaPlayer var1);
    }

    public static interface OnPreparedListener {
        public void onPrepared(MediaPlayer var1);
    }

    private class EventHandler
    extends Handler {
        private MediaPlayer mMediaPlayer;

        public EventHandler(MediaPlayer mp, Looper looper) {
            super(looper);
            this.mMediaPlayer = mp;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Message msg) {
            if (this.mMediaPlayer.mNativeContext == 0L) {
                Log.w(MediaPlayer.TAG, "mediaplayer went away with unhandled events");
                return;
            }
            switch (msg.what) {
                case 1: {
                    try {
                        MediaPlayer.this.scanInternalSubtitleTracks();
                    }
                    catch (RuntimeException e) {
                        Message msg2 = this.obtainMessage(100, 1, -1010, null);
                        this.sendMessage(msg2);
                    }
                    MediaPlayer.this.mDrmInfoResolved = true;
                    OnPreparedListener onPreparedListener = MediaPlayer.this.mOnPreparedListener;
                    if (onPreparedListener != null) {
                        onPreparedListener.onPrepared(this.mMediaPlayer);
                    }
                    return;
                }
                case 210: {
                    Log.v(MediaPlayer.TAG, "MEDIA_DRM_INFO " + MediaPlayer.this.mOnDrmInfoHandlerDelegate);
                    if (msg.obj == null) {
                        Log.w(MediaPlayer.TAG, "MEDIA_DRM_INFO msg.obj=NULL");
                    } else if (msg.obj instanceof Parcel) {
                        OnDrmInfoHandlerDelegate onDrmInfoHandlerDelegate;
                        Parcel parcel = (Parcel)msg.obj;
                        DrmInfo drmInfo = new DrmInfo(parcel);
                        Object object = MediaPlayer.this.mDrmLock;
                        synchronized (object) {
                            MediaPlayer.this.mDrmInfo = drmInfo.makeCopy();
                            onDrmInfoHandlerDelegate = MediaPlayer.this.mOnDrmInfoHandlerDelegate;
                        }
                        if (onDrmInfoHandlerDelegate != null) {
                            onDrmInfoHandlerDelegate.notifyClient(drmInfo);
                        }
                    } else {
                        Log.w(MediaPlayer.TAG, "MEDIA_DRM_INFO msg.obj of unexpected type " + msg.obj);
                    }
                    return;
                }
                case 2: {
                    MediaPlayer.this.mOnCompletionInternalListener.onCompletion(this.mMediaPlayer);
                    OnCompletionListener onCompletionListener = MediaPlayer.this.mOnCompletionListener;
                    if (onCompletionListener != null) {
                        onCompletionListener.onCompletion(this.mMediaPlayer);
                    }
                    MediaPlayer.this.stayAwake(false);
                    return;
                }
                case 8: {
                    TimeProvider timeProvider = MediaPlayer.this.mTimeProvider;
                    if (timeProvider == null) break;
                    timeProvider.onStopped();
                    break;
                }
                case 6: 
                case 7: {
                    TimeProvider timeProvider = MediaPlayer.this.mTimeProvider;
                    if (timeProvider == null) break;
                    timeProvider.onPaused(msg.what == 7);
                    break;
                }
                case 3: {
                    OnBufferingUpdateListener onBufferingUpdateListener = MediaPlayer.this.mOnBufferingUpdateListener;
                    if (onBufferingUpdateListener != null) {
                        onBufferingUpdateListener.onBufferingUpdate(this.mMediaPlayer, msg.arg1);
                    }
                    return;
                }
                case 4: {
                    OnSeekCompleteListener onSeekCompleteListener = MediaPlayer.this.mOnSeekCompleteListener;
                    if (onSeekCompleteListener != null) {
                        onSeekCompleteListener.onSeekComplete(this.mMediaPlayer);
                    }
                }
                case 9: {
                    TimeProvider timeProvider = MediaPlayer.this.mTimeProvider;
                    if (timeProvider != null) {
                        timeProvider.onSeekComplete(this.mMediaPlayer);
                    }
                    return;
                }
                case 5: {
                    OnVideoSizeChangedListener onVideoSizeChangedListener = MediaPlayer.this.mOnVideoSizeChangedListener;
                    if (onVideoSizeChangedListener != null) {
                        onVideoSizeChangedListener.onVideoSizeChanged(this.mMediaPlayer, msg.arg1, msg.arg2);
                    }
                    return;
                }
                case 100: {
                    Log.e(MediaPlayer.TAG, "Error (" + msg.arg1 + "," + msg.arg2 + ")");
                    boolean error_was_handled = false;
                    OnErrorListener onErrorListener = MediaPlayer.this.mOnErrorListener;
                    if (onErrorListener != null) {
                        error_was_handled = onErrorListener.onError(this.mMediaPlayer, msg.arg1, msg.arg2);
                    }
                    MediaPlayer.this.mOnCompletionInternalListener.onCompletion(this.mMediaPlayer);
                    OnCompletionListener onCompletionListener = MediaPlayer.this.mOnCompletionListener;
                    if (onCompletionListener != null && !error_was_handled) {
                        onCompletionListener.onCompletion(this.mMediaPlayer);
                    }
                    MediaPlayer.this.stayAwake(false);
                    return;
                }
                case 200: {
                    switch (msg.arg1) {
                        case 700: {
                            Log.i(MediaPlayer.TAG, "Info (" + msg.arg1 + "," + msg.arg2 + ")");
                            break;
                        }
                        case 802: {
                            try {
                                MediaPlayer.this.scanInternalSubtitleTracks();
                            }
                            catch (RuntimeException e) {
                                Message msg2 = this.obtainMessage(100, 1, -1010, null);
                                this.sendMessage(msg2);
                            }
                        }
                        case 803: {
                            msg.arg1 = 802;
                            if (MediaPlayer.this.mSubtitleController == null) break;
                            MediaPlayer.this.mSubtitleController.selectDefaultTrack();
                            break;
                        }
                        case 701: 
                        case 702: {
                            TimeProvider timeProvider = MediaPlayer.this.mTimeProvider;
                            if (timeProvider == null) break;
                            timeProvider.onBuffering(msg.arg1 == 701);
                        }
                    }
                    OnInfoListener onInfoListener = MediaPlayer.this.mOnInfoListener;
                    if (onInfoListener != null) {
                        onInfoListener.onInfo(this.mMediaPlayer, msg.arg1, msg.arg2);
                    }
                    return;
                }
                case 99: {
                    OnTimedTextListener onTimedTextListener = MediaPlayer.this.mOnTimedTextListener;
                    if (onTimedTextListener == null) {
                        return;
                    }
                    if (msg.obj == null) {
                        onTimedTextListener.onTimedText(this.mMediaPlayer, null);
                    } else if (msg.obj instanceof Parcel) {
                        Parcel parcel = (Parcel)msg.obj;
                        TimedText text = new TimedText(parcel);
                        parcel.recycle();
                        onTimedTextListener.onTimedText(this.mMediaPlayer, text);
                    }
                    return;
                }
                case 201: {
                    OnSubtitleDataListener onSubtitleDataListener = MediaPlayer.this.mOnSubtitleDataListener;
                    if (onSubtitleDataListener == null) {
                        return;
                    }
                    if (msg.obj instanceof Parcel) {
                        Parcel parcel = (Parcel)msg.obj;
                        SubtitleData data = new SubtitleData(parcel);
                        parcel.recycle();
                        onSubtitleDataListener.onSubtitleData(this.mMediaPlayer, data);
                    }
                    return;
                }
                case 202: {
                    OnTimedMetaDataAvailableListener onTimedMetaDataAvailableListener = MediaPlayer.this.mOnTimedMetaDataAvailableListener;
                    if (onTimedMetaDataAvailableListener == null) {
                        return;
                    }
                    if (msg.obj instanceof Parcel) {
                        Parcel parcel = (Parcel)msg.obj;
                        TimedMetaData data = TimedMetaData.createTimedMetaDataFromParcel(parcel);
                        parcel.recycle();
                        onTimedMetaDataAvailableListener.onTimedMetaDataAvailable(this.mMediaPlayer, data);
                    }
                    return;
                }
                case 0: {
                    break;
                }
                default: {
                    Log.e(MediaPlayer.TAG, "Unknown message type " + msg.what);
                    return;
                }
            }
        }
    }

    public static class TrackInfo
    implements Parcelable {
        public static final int MEDIA_TRACK_TYPE_UNKNOWN = 0;
        public static final int MEDIA_TRACK_TYPE_VIDEO = 1;
        public static final int MEDIA_TRACK_TYPE_AUDIO = 2;
        public static final int MEDIA_TRACK_TYPE_TIMEDTEXT = 3;
        public static final int MEDIA_TRACK_TYPE_SUBTITLE = 4;
        public static final int MEDIA_TRACK_TYPE_METADATA = 5;
        final int mTrackType;
        final MediaFormat mFormat;
        static final Parcelable.Creator<TrackInfo> CREATOR = new Parcelable.Creator<TrackInfo>(){

            @Override
            public TrackInfo createFromParcel(Parcel in) {
                return new TrackInfo(in);
            }

            public TrackInfo[] newArray(int size) {
                return new TrackInfo[size];
            }
        };

        public int getTrackType() {
            return this.mTrackType;
        }

        public String getLanguage() {
            String language = this.mFormat.getString("language");
            return language == null ? "und" : language;
        }

        public MediaFormat getFormat() {
            if (this.mTrackType == 3 || this.mTrackType == 4) {
                return this.mFormat;
            }
            return null;
        }

        TrackInfo(Parcel in) {
            this.mTrackType = in.readInt();
            String mime = in.readString();
            String language = in.readString();
            this.mFormat = MediaFormat.createSubtitleFormat(mime, language);
            if (this.mTrackType == 4) {
                this.mFormat.setInteger("is-autoselect", in.readInt());
                this.mFormat.setInteger("is-default", in.readInt());
                this.mFormat.setInteger("is-forced-subtitle", in.readInt());
            }
        }

        TrackInfo(int type, MediaFormat format) {
            this.mTrackType = type;
            this.mFormat = format;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.mTrackType);
            dest.writeString(this.getLanguage());
            if (this.mTrackType == 4) {
                dest.writeString(this.mFormat.getString("mime"));
                dest.writeInt(this.mFormat.getInteger("is-autoselect"));
                dest.writeInt(this.mFormat.getInteger("is-default"));
                dest.writeInt(this.mFormat.getInteger("is-forced-subtitle"));
            }
        }

        public String toString() {
            StringBuilder out = new StringBuilder(128);
            out.append(this.getClass().getName());
            out.append('{');
            switch (this.mTrackType) {
                case 1: {
                    out.append("VIDEO");
                    break;
                }
                case 2: {
                    out.append("AUDIO");
                    break;
                }
                case 3: {
                    out.append("TIMEDTEXT");
                    break;
                }
                case 4: {
                    out.append("SUBTITLE");
                    break;
                }
                default: {
                    out.append("UNKNOWN");
                }
            }
            out.append(", " + this.mFormat.toString());
            out.append("}");
            return out.toString();
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @IntDef(value={0L, 1L, 2L, 3L})
    public static @interface SeekMode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @IntDef(value={0L, 1L, 2L})
    public static @interface PlaybackRateAudioMode {
    }
}

